# Logging - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Logging**

## CapabilityStatement: Logging 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/CapabilityStatement/Logging | *Version*:1.22.0 |
| Draft as of 2023-09-04 | *Computable Name*:Logging |
| **Copyright/Legal**: CC0 | |

 
Deze CapabilityStatement beschrijft de minimale requirements voor het Logging Bouwblok. 

Zie voor details van het log bericht: [StructureDefinition-AuditEvent](StructureDefinition-AuditEvent.md).

N.B. De focus ligt op wettelijk benodigde logging volgens NEN 7513, uiteraard zal er meer gedetaileere technische logging nodig zijn.

 [Raw OpenAPI-Swagger Definition file](Logging.openapi.json) | [Download](Logging.openapi.json) 



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "Logging",
  "url" : "http://fhir.hl7.nl/zorgviewer/CapabilityStatement/Logging",
  "version" : "1.22.0",
  "name" : "Logging",
  "title" : "Logging",
  "status" : "draft",
  "date" : "2023-09-04",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Deze CapabilityStatement beschrijft de minimale requirements voor het Logging Bouwblok.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "copyright" : "CC0",
  "kind" : "requirements",
  "fhirVersion" : "3.0.2",
  "acceptUnknown" : "both",
  "format" : ["xml", "json"],
  "profile" : [
    {
      "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/AuditEvent",
      "display" : "AuditEvent"
    }
  ],
  "rest" : [
    {
      "mode" : "server",
      "resource" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "AuditEvent",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/AuditEvent"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ]
        }
      ]
    }
  ]
}

```
