# European Patient Summary (Bundle) - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **European Patient Summary (Bundle)**

## Bundle: European Patient Summary (Bundle)



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "eps-bundle-example",
  "meta" : {
    "profile" : ["http://hl7.eu/fhir/eps/StructureDefinition/bundle-eu-eps"]
  },
  "identifier" : {
    "system" : "urn:oid:2.16.840.1.113883.2.51.999",
    "value" : "8aaf5bf1-30c3-45ab-88fb-48c552ec308e",
    "assigner" : {
      "display" : "HL7 Europe"
    }
  },
  "type" : "document",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:17b6fb33-7dbf-4fae-a24e-aa772cba4cfc",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "17b6fb33-7dbf-4fae-a24e-aa772cba4cfc",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/eps/StructureDefinition/composition-eu-eps"
          ],
          "security" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
              "code" : "HTEST"
            },
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
              "code" : "TRAIN"
            }
          ],
          "tag" : [
            {
              "system" : "https://synderai.net/fhir/CodeSystem/tags",
              "code" : "synthetic",
              "display" : "SYNDERAI Synthetic data"
            }
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Composition_17b6fb33-7dbf-4fae-a24e-aa772cba4cfc\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Composition 17b6fb33-7dbf-4fae-a24e-aa772cba4cfc</b></p><a name=\"17b6fb33-7dbf-4fae-a24e-aa772cba4cfc\"> </a><a name=\"hc17b6fb33-7dbf-4fae-a24e-aa772cba4cfc\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&amp;canonical=http://hl7.eu/fhir/eps/StructureDefinition/composition-eu-eps\">http://hl7.eu/fhir/eps/StructureDefinition/composition-eu-eps</a></p><p style=\"margin-bottom: 0px\">Tag: SYNDERAI Synthetic data (Details: tags code synthetic = 'SYNDERAI Synthetic data')</p><p style=\"margin-bottom: 0px\">Security Labels: test health data (Details: ActReason code HTEST = 'test health data'), training (Details: ActReason code TRAIN = 'training')</p></div><p><b>identifier</b>: <code>urn:oid:2.16.840.1.113883.2.51.999</code>/a952fdbf-3617-45e5-ae05-64f541f7e007</p><p><b>status</b>: Final</p><p><b>type</b>: <span title=\"Codes:{http://loinc.org 60591-5}\">Patient summary Document</span></p><p><b>date</b>: 2022-10-30</p><p><b>author</b>: <a href=\"Bundle-eps-bundle-example.html#urn-uuid-85d7a127-6afc-4156-b3da-574235d429d0\">PractitionerRole</a></p><p><b>title</b>: European Patient Summary</p><p><b>confidentiality</b>: normal</p><p><b>custodian</b>: <a href=\"Bundle-eps-bundle-example.html#urn-uuid-87ed10a6-0891-46b6-8b7b-a3c3002eafe2\">Organization ADRZ</a></p></div>"
        },
        "identifier" : {
          "system" : "urn:oid:2.16.840.1.113883.2.51.999",
          "value" : "a952fdbf-3617-45e5-ae05-64f541f7e007",
          "assigner" : {
            "display" : "HL7 Europe"
          }
        },
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "60591-5",
              "display" : "Patient summary Document"
            }
          ],
          "text" : "Patient summary Document"
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "date" : "2022-10-30",
        "author" : [
          {
            "reference" : "urn:uuid:85d7a127-6afc-4156-b3da-574235d429d0"
          }
        ],
        "title" : "European Patient Summary",
        "confidentiality" : "N",
        "custodian" : {
          "reference" : "urn:uuid:87ed10a6-0891-46b6-8b7b-a3c3002eafe2"
        },
        "section" : [
          {
            "title" : "Problem list",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "11450-4",
                  "display" : "Problem list - Reported"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><table class=\"hl7__ips\"><tr><th>Condition</th><th>Onset Date</th><th>Status</th></tr><tr><td>Osteoarthritis of knee</td><td><span class=\"nb\">21-Jan-2020</span></td><td>active</td></tr><tr><td>Fibromyalgia</td><td><span class=\"nb\">04-Feb-2014</span></td><td>active</td></tr><tr><td>Chronic sinusitis</td><td><span class=\"nb\">29-Jan-2002</span></td><td>active</td></tr></table></div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:b4ceb5d5-a33a-4c0a-89c1-3216dee13693"
              }
            ]
          },
          {
            "title" : "Medication list",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "10160-0",
                  "display" : "History of Medication use Narrative"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><table class=\"hl7__ips\"><tr><td>No known medications</td></tr></table></div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:b4f5357d-126e-43c1-9b96-be41d1cd3173"
              }
            ]
          },
          {
            "title" : "Immunizations list",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "11369-6",
                  "display" : "History of Immunization note"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><table class=\"hl7__ips\"><tr><th>Vaccine</th><th>Date</th></tr><tr><td>Influenza virus antigen only vaccine product</td><td><span class=\"nb\">10-Nov-2024</span></td></tr><tr><td>SARS-CoV-2 mRNA vaccine</td><td><span class=\"nb\">28-Mar-2021</span></td></tr><tr><td>Hepatitis A virus antigen only vaccine product</td><td><span class=\"nb\">01-Oct-2017</span></td></tr><tr><td>Clostridium tetani toxoid antigen adsorbed only vaccine product</td><td><span class=\"nb\">01-Oct-2017</span></td></tr></table></div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:d0d756e6-f23e-4a8d-952a-84f84f1fc8bb"
              }
            ]
          },
          {
            "title" : "Procedure History list",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "47519-4",
                  "display" : "History of Procedures Document"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><table class=\"hl7__ips\"><tr><th>Procedure</th><th>Date</th><th>Reason</th></tr><tr><td>Epidural anesthesia</td><td><span class=\"nb\">27-Jan-2019</span></td><td>Normal pregnancy</td></tr><tr><td>Parturition</td><td><span class=\"nb\">27-Jan-2019</span></td><td>Normal pregnancy</td></tr></table></div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:eb50e1a1-3ef4-4bc1-9a77-2a4ea6f5304c"
              }
            ]
          },
          {
            "title" : "Allergies and Intolerances",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48765-2",
                  "display" : "Allergies and adverse reactions Document"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><table class=\"hl7__ips\"><tr><th>Allergy/Intolerance</th><th>Onset Date</th><th>Status</th><th>Type</th><th>Reaction</th></tr><tr><td>Allergy to substance</td><td><span class=\"nb\">1977-08-09</span></td><td>active</td><td>environment</td><td/></tr><tr><td>Shellfish</td><td><span class=\"nb\">1977-08-09</span></td><td>active</td><td>food</td><td>Anaphylaxis (disorder)&lt;br&gt; &lt;/br&gt;Eruption of skin (disorder)</td></tr></table></div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:d60580bd-c956-4b7c-9305-940df95ac4e7"
              }
            ]
          },
          {
            "title" : "Care Plan",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "18776-5",
                  "display" : "Plan of care note"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><table class=\"hl7__ips\"><tr><th>Active Planned Care / Goals</th><th>Start Date</th><th>Reason</th></tr><tr><td>Musculoskeletal care</td><td><span class=\"nb\">21-Jan-2020</span></td><td>Osteoarthritis of knee</td></tr><tr><td><ul><li>Reduce knee pain severity to a tolerable level to improve function and quality of life.</li><li>Increase ability to perform daily activities such as walking and climbing stairs.</li><li>Complete prescribed knee strengthening and flexibility exercises as recommended.</li></ul></td><td/><td/></tr><tr><td>Self-care interventions</td><td><span class=\"nb\">24-Jul-1977</span></td><td>-</td></tr></table></div>"
            }
          },
          {
            "title" : "Vital Signs",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "8716-3",
                  "display" : "Vital signs note"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><table class=\"hl7__ips\"><tr><th>Vital Signs</th><th>2024-11-10</th><th>2023-11-05</th></tr><tr><td>Body Height</td><td>168.1 cm</td><td>168.1 cm</td></tr><tr><td>Pain severity - 0-10 verbal numeric rating [Score] - Reported</td><td>3 {score}</td><td>1 {score}</td></tr><tr><td>Body Weight</td><td>85.5 kg</td><td>84.4 kg</td></tr><tr><td>Body mass index (BMI) [Ratio]</td><td>30.3 kg/m2</td><td>29.9 kg/m2</td></tr><tr><td>Diastolic Blood Pressure</td><td>92 mm[Hg]</td><td>88 mm[Hg]</td></tr><tr><td>Systolic Blood Pressure</td><td>113 mm[Hg]</td><td>121 mm[Hg]</td></tr><tr><td>Heart rate</td><td>90 /min</td><td>96 /min</td></tr><tr><td>Respiratory rate</td><td>14 /min</td><td>15 /min</td></tr></table></div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:46a8cedd-8e71-4b71-8ff7-6e8f0b5915e4"
              }
            ]
          },
          {
            "title" : "Pregnancy History",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "10162-6",
                  "display" : "History of pregnancies Narrative"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><table class=\"hl7__ips\">$<tr><td>[#] Births total</td><td>1</td></tr></table></div>"
            }
          },
          {
            "title" : "Relevant diagnostic tests/laboratory data",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "30954-2",
                  "display" : "Relevant diagnostic tests/laboratory data note"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><table class=\"hl7__ips\"><table class=\"hl7__ips\"><thead><tr><th>Recent Lab Observations</th><th>30-OCT-2022</th><th>Reference Range</th><th>Unit</th></tr></thead><tbody><tr><td>Cholesterol [Mass/volume] in Serum or Plasma</td><td><strong>122.5 L</strong></td><td>125 - 200</td><td>mg/dL</td></tr><tr><td>Triglyceride [Mass/volume] in Serum or Plasma</td><td>125.3</td><td>35 - 150</td><td>mg/dL</td></tr><tr><td>Cholesterol in LDL [Mass/volume] in Serum or Plasma by Direct assay</td><td>42.0</td><td>0 - 130</td><td>mg/dL</td></tr><tr><td>Cholesterol in HDL [Mass/volume] in Serum or Plasma</td><td>55.5</td><td>45 - 95</td><td>mg/dL</td></tr></tbody></table></table></div>"
            }
          },
          {
            "title" : "Device Use",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "46264-8",
                  "display" : "History of medical device use"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><table class=\"hl7__ips\"><tr><th>Device</th><th>Date (since)</th></tr><tr><td>Walker (physical object)</td><td><span class=\"nb\">21-Jan-2020</span></td></tr><tr><td>Home nebulizer (physical object)</td><td><span class=\"nb\">29-Jan-2002</span></td></tr></table></div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:82851773-8257-4aea-bd64-ea2fa18fe562"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
        "meta" : {
          "profile" : ["http://hl7.eu/fhir/eps/StructureDefinition/patient-eu-eps"],
          "security" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
              "code" : "HTEST"
            },
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
              "code" : "TRAIN"
            }
          ],
          "tag" : [
            {
              "system" : "https://synderai.net/fhir/CodeSystem/tags",
              "code" : "synthetic",
              "display" : "SYNDERAI Synthetic data"
            }
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_4e6bfcf4-42f1-416b-994d-26f1ac0c0677\"> </a><table class=\"hl7__ips\"><tr><td>Lily van 't Houteveen</td><td>female</td><td>07-Feb-1978</td></tr></table></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/patient-nationality",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/ValueSet/country",
                  "code" : "NL"
                }
              ]
            }
          }
        ],
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "PT"
                }
              ]
            },
            "system" : "http://ec.europa.eu/identifier/eci",
            "value" : "8559-816880-6"
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "MR"
                }
              ]
            },
            "system" : "http://local.setting.eu/identifier",
            "value" : "bcedb829-513e-0284-957a-2468ff516349"
          }
        ],
        "name" : [
          {
            "text" : "Lily van &#039;t Houteveen",
            "family" : "van &#039;t Houteveen",
            "given" : ["Lily"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+31(0)374 127288"
          }
        ],
        "gender" : "female",
        "birthDate" : "1978-02-07",
        "address" : [
          {
            "use" : "home",
            "type" : "physical",
            "line" : ["Evidreef 275"],
            "city" : "Oost-Souburg",
            "postalCode" : "4388",
            "country" : "Netherlands"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:85d7a127-6afc-4156-b3da-574235d429d0",
      "resource" : {
        "resourceType" : "PractitionerRole",
        "id" : "85d7a127-6afc-4156-b3da-574235d429d0",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/base/StructureDefinition/practitionerRole-eu"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"PractitionerRole_85d7a127-6afc-4156-b3da-574235d429d0\"> </a><table class=\"hl7__ips\">Provider Role Id 85d7a127-6afc-4156-b3da-574235d429d0</table></div>"
        },
        "practitioner" : {
          "reference" : "urn:uuid:b1f77d95-ce1f-422e-a588-2ec17ae9ee87"
        },
        "organization" : {
          "reference" : "urn:uuid:87ed10a6-0891-46b6-8b7b-a3c3002eafe2"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:87ed10a6-0891-46b6-8b7b-a3c3002eafe2",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "87ed10a6-0891-46b6-8b7b-a3c3002eafe2",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/base/StructureDefinition/organization-eu"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_87ed10a6-0891-46b6-8b7b-a3c3002eafe2\"> </a><table class=\"hl7__ips\">ADRZ</table></div>"
        },
        "identifier" : [
          {
            "system" : "urn:oid:2.16.840.1.113883.2.51.999",
            "value" : "2dd2e18e-5aa8-48b8-aba0-1474f9dfc387",
            "assigner" : {
              "display" : "HL7 Europe"
            }
          }
        ],
        "name" : "ADRZ",
        "address" : [
          {
            "country" : "Netherlands"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:b1f77d95-ce1f-422e-a588-2ec17ae9ee87",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "b1f77d95-ce1f-422e-a588-2ec17ae9ee87",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/base/StructureDefinition/practitioner-eu"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_b1f77d95-ce1f-422e-a588-2ec17ae9ee87\"> </a><table class=\"hl7__ips\">Dr. Hel Ping</table></div>"
        },
        "name" : [
          {
            "family" : "Ping",
            "given" : ["Hel"],
            "prefix" : ["Dr."]
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:b4ceb5d5-a33a-4c0a-89c1-3216dee13693",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "b4ceb5d5-a33a-4c0a-89c1-3216dee13693",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_b4ceb5d5-a33a-4c0a-89c1-3216dee13693\"> </a><table class=\"hl7__ips\"><tr><td>Osteoarthritis of knee</td><td><span class=\"nb\">21-Jan-2020</span></td><td>active</td></tr></table></div>"
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "problem-list-item",
                "display" : "Problem List Item"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "239873007",
              "display" : "Osteoarthritis of knee (disorder)"
            }
          ],
          "text" : "Osteoarthritis of knee"
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "onsetDateTime" : "2020-01-21",
        "asserter" : {
          "reference" : "urn:uuid:85d7a127-6afc-4156-b3da-574235d429d0",
          "display" : "ADRZ"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:6b41dc68-4cb9-4c8a-ba1f-f59064912885",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "6b41dc68-4cb9-4c8a-ba1f-f59064912885",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_6b41dc68-4cb9-4c8a-ba1f-f59064912885\"> </a><table class=\"hl7__ips\"><tr><td>Fibromyalgia</td><td><span class=\"nb\">04-Feb-2014</span></td><td>active</td></tr></table></div>"
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "problem-list-item",
                "display" : "Problem List Item"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "203082005",
              "display" : "Fibromyalgia (disorder)"
            }
          ],
          "text" : "Fibromyalgia"
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "onsetDateTime" : "2014-02-04",
        "asserter" : {
          "reference" : "urn:uuid:85d7a127-6afc-4156-b3da-574235d429d0",
          "display" : "ADRZ"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:129eb868-226b-4560-bb8e-a5eaf0ea68f4",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "129eb868-226b-4560-bb8e-a5eaf0ea68f4",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_129eb868-226b-4560-bb8e-a5eaf0ea68f4\"> </a><table class=\"hl7__ips\"><tr><td>Chronic sinusitis</td><td><span class=\"nb\">29-Jan-2002</span></td><td>active</td></tr></table></div>"
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "problem-list-item",
                "display" : "Problem List Item"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "40055000",
              "display" : "Chronic sinusitis (disorder)"
            }
          ],
          "text" : "Chronic sinusitis"
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "onsetDateTime" : "2002-01-29",
        "asserter" : {
          "reference" : "urn:uuid:85d7a127-6afc-4156-b3da-574235d429d0",
          "display" : "ADRZ"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:0466fab5-a881-4c54-85f1-c7c2276973b5",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "0466fab5-a881-4c54-85f1-c7c2276973b5",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_0466fab5-a881-4c54-85f1-c7c2276973b5\"> </a><table class=\"hl7__ips\"><tr><td><span class=\"grayedout\">Acute viral pharyngitis</span></td><td><span class=\"nb\">20-Apr-2022 - 27-Apr-2022</span></td><td><span class=\"grayedout\">inactive</span></td></tr></table></div>"
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "problem-list-item",
                "display" : "Problem List Item"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "195662009",
              "display" : "Acute viral pharyngitis (disorder)"
            }
          ],
          "text" : "Acute viral pharyngitis"
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "onsetDateTime" : "2022-04-20",
        "abatementDateTime" : "2022-04-27",
        "asserter" : {
          "reference" : "urn:uuid:85d7a127-6afc-4156-b3da-574235d429d0",
          "display" : "ADRZ"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:84ef301f-8d44-4e0d-a7be-0e5f9d871db5",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "84ef301f-8d44-4e0d-a7be-0e5f9d871db5",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_84ef301f-8d44-4e0d-a7be-0e5f9d871db5\"> </a><table class=\"hl7__ips\"><tr><td><span class=\"grayedout\">Viral sinusitis</span></td><td><span class=\"nb\">21-Feb-2020 - 16-Mar-2020</span></td><td><span class=\"grayedout\">inactive</span></td></tr></table></div>"
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "problem-list-item",
                "display" : "Problem List Item"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "444814009",
              "display" : "Viral sinusitis (disorder)"
            }
          ],
          "text" : "Viral sinusitis"
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "onsetDateTime" : "2020-02-21",
        "abatementDateTime" : "2020-03-16",
        "asserter" : {
          "reference" : "urn:uuid:85d7a127-6afc-4156-b3da-574235d429d0",
          "display" : "ADRZ"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:466dc3e8-12b1-44f1-ae77-445df2b585b4",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "466dc3e8-12b1-44f1-ae77-445df2b585b4",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_466dc3e8-12b1-44f1-ae77-445df2b585b4\"> </a><table class=\"hl7__ips\"><tr><td><span class=\"grayedout\">Miscarriage in first trimester</span></td><td><span class=\"nb\">09-Jun-2019 - 24-Jun-2019</span></td><td><span class=\"grayedout\">inactive</span></td></tr></table></div>"
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "problem-list-item",
                "display" : "Problem List Item"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "19169002",
              "display" : "Miscarriage in first trimester (disorder)"
            }
          ],
          "text" : "Miscarriage in first trimester"
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "onsetDateTime" : "2019-06-09",
        "abatementDateTime" : "2019-06-24",
        "asserter" : {
          "reference" : "urn:uuid:85d7a127-6afc-4156-b3da-574235d429d0",
          "display" : "ADRZ"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:a41c03f3-9366-45b7-bcc2-7f54edcd2989",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "a41c03f3-9366-45b7-bcc2-7f54edcd2989",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_a41c03f3-9366-45b7-bcc2-7f54edcd2989\"> </a><table class=\"hl7__ips\"><tr><td><span class=\"grayedout\">Complete miscarriage</span></td><td><span class=\"nb\">09-Jun-2019 - 24-Jun-2019</span></td><td><span class=\"grayedout\">inactive</span></td></tr></table></div>"
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "problem-list-item",
                "display" : "Problem List Item"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "156073000",
              "display" : "Complete miscarriage (disorder)"
            }
          ],
          "text" : "Complete miscarriage"
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "onsetDateTime" : "2019-06-09",
        "abatementDateTime" : "2019-06-24",
        "asserter" : {
          "reference" : "urn:uuid:85d7a127-6afc-4156-b3da-574235d429d0",
          "display" : "ADRZ"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:b4f5357d-126e-43c1-9b96-be41d1cd3173",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "b4f5357d-126e-43c1-9b96-be41d1cd3173",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/eps/StructureDefinition/MedicationStatement-eu-eps"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_b4f5357d-126e-43c1-9b96-be41d1cd3173\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement b4f5357d-126e-43c1-9b96-be41d1cd3173</b></p><a name=\"b4f5357d-126e-43c1-9b96-be41d1cd3173\"> </a><a name=\"hcb4f5357d-126e-43c1-9b96-be41d1cd3173\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&amp;canonical=http://hl7.eu/fhir/eps/StructureDefinition/MedicationStatement-eu-eps\">http://hl7.eu/fhir/eps/StructureDefinition/MedicationStatement-eu-eps</a></p></div><p><b>status</b>: Active</p><p><b>medication</b>: <span title=\"Codes:{http://snomed.info/sct 787481004}\">No known medications (situation)</span></p><p><b>effective</b>: ?? --&gt; (ongoing)</p><p><b>subject</b>: <a href=\"Bundle-eps-bundle-example.html#urn-uuid-4e6bfcf4-42f1-416b-994d-26f1ac0c0677\">Lily van &amp;#039;t Houteveen</a></p></div>"
        },
        "status" : "active",
        "medicationCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "787481004",
              "display" : "No known medications (situation)"
            }
          ]
        },
        "effectivePeriod" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
              "valueCode" : "unknown"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:d0d756e6-f23e-4a8d-952a-84f84f1fc8bb",
      "resource" : {
        "resourceType" : "Immunization",
        "id" : "d0d756e6-f23e-4a8d-952a-84f84f1fc8bb",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Immunization-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Immunization_d0d756e6-f23e-4a8d-952a-84f84f1fc8bb\"> </a><table class=\"hl7__ips\"><tr><td>Influenza virus antigen only vaccine product</td><td><span class=\"nb\">10-Nov-2024</span></td></tr></table></div>"
        },
        "status" : "completed",
        "vaccineCode" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1181000221105",
              "display" : "Vaccine product containing Influenza virus antigen"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "J07BB02",
              "display" : "Influenza, inactivated, split virus"
            }
          ],
          "text" : "Influenza virus antigen only vaccine product"
        },
        "patient" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "lotNumber" : "UA-D3WWeK76a",
        "expirationDate" : "2025-07-26",
        "site" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "244979005",
              "display" : "Entire muscle of upper arm"
            }
          ],
          "text" : "Entire muscle of upper arm"
        },
        "route" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "78421000",
              "display" : "Intramuscular route"
            }
          ],
          "text" : "Intramuscular route"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:b2167f4a-0ee5-4170-8a94-6372787cc469",
      "resource" : {
        "resourceType" : "Immunization",
        "id" : "b2167f4a-0ee5-4170-8a94-6372787cc469",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Immunization-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Immunization_b2167f4a-0ee5-4170-8a94-6372787cc469\"> </a><table class=\"hl7__ips\"><tr><td>SARS-CoV-2 mRNA vaccine</td><td><span class=\"nb\">28-Mar-2021</span></td></tr></table></div>"
        },
        "status" : "completed",
        "vaccineCode" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1119349007",
              "display" : "Vaccine product containing SARS-CoV-2 mRNA"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "J07BX03",
              "display" : "COVID-19 mRNA vaccines"
            }
          ],
          "text" : "SARS-CoV-2 mRNA vaccine"
        },
        "patient" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "lotNumber" : "DV-n7q4UuSnh",
        "expirationDate" : "2022-01-29",
        "site" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "244979005",
              "display" : "Entire muscle of upper arm"
            }
          ],
          "text" : "Entire muscle of upper arm"
        },
        "route" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "78421000",
              "display" : "Intramuscular route"
            }
          ],
          "text" : "Intramuscular route"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:d82ca099-f151-42ac-bfc4-aa905967e50a",
      "resource" : {
        "resourceType" : "Immunization",
        "id" : "d82ca099-f151-42ac-bfc4-aa905967e50a",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Immunization-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Immunization_d82ca099-f151-42ac-bfc4-aa905967e50a\"> </a><table class=\"hl7__ips\"><tr><td>Hepatitis A virus antigen only vaccine product</td><td><span class=\"nb\">01-Oct-2017</span></td></tr></table></div>"
        },
        "status" : "completed",
        "vaccineCode" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "871751006",
              "display" : "Vaccine product containing Hepatitis A virus antigen"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "J07BC02",
              "display" : "Hepatitis A vaccines"
            }
          ],
          "text" : "Hepatitis A virus antigen only vaccine product"
        },
        "patient" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "lotNumber" : "TZ-nuAqM",
        "expirationDate" : "2017-11-14",
        "site" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "244979005",
              "display" : "Entire muscle of upper arm"
            }
          ],
          "text" : "Entire muscle of upper arm"
        },
        "route" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "78421000",
              "display" : "Intramuscular route"
            }
          ],
          "text" : "Intramuscular route"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:525e79ad-d97d-4de9-8e82-15d83ec28db2",
      "resource" : {
        "resourceType" : "Immunization",
        "id" : "525e79ad-d97d-4de9-8e82-15d83ec28db2",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Immunization-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Immunization_525e79ad-d97d-4de9-8e82-15d83ec28db2\"> </a><table class=\"hl7__ips\"><tr><td>Clostridium tetani toxoid antigen adsorbed only vaccine product</td><td><span class=\"nb\">01-Oct-2017</span></td></tr></table></div>"
        },
        "status" : "completed",
        "vaccineCode" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "777725002",
              "display" : "Vaccine product containing only Clostridium tetani toxoid antigen adsorbed"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "J07AM51",
              "display" : "Diphtheria-tetanus vaccines, adult type"
            }
          ],
          "text" : "Clostridium tetani toxoid antigen adsorbed only vaccine product"
        },
        "patient" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "lotNumber" : "ZK-MyeFgs",
        "expirationDate" : "2018-02-18",
        "site" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "244979005",
              "display" : "Entire muscle of upper arm"
            }
          ],
          "text" : "Entire muscle of upper arm"
        },
        "route" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "78421000",
              "display" : "Intramuscular route"
            }
          ],
          "text" : "Intramuscular route"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:eb50e1a1-3ef4-4bc1-9a77-2a4ea6f5304c",
      "resource" : {
        "resourceType" : "Procedure",
        "id" : "eb50e1a1-3ef4-4bc1-9a77-2a4ea6f5304c",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Procedure-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Procedure_eb50e1a1-3ef4-4bc1-9a77-2a4ea6f5304c\"> </a><table class=\"hl7__ips\"><tr><td>Epidural anesthesia</td><td><span class=\"nb\">27-Jan-2019</span></td><td>Normal pregnancy</td></tr></table></div>"
        },
        "status" : "completed",
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "18946005",
              "display" : "Epidural anesthesia"
            }
          ],
          "text" : "Epidural anesthesia"
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "performedDateTime" : "2019-01-27",
        "reasonCode" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "72892002",
                "display" : "Normal pregnancy"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:267550aa-5343-43b7-985a-8910654577de",
      "resource" : {
        "resourceType" : "Procedure",
        "id" : "267550aa-5343-43b7-985a-8910654577de",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Procedure-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Procedure_267550aa-5343-43b7-985a-8910654577de\"> </a><table class=\"hl7__ips\"><tr><td>Parturition</td><td><span class=\"nb\">27-Jan-2019</span></td><td>Normal pregnancy</td></tr></table></div>"
        },
        "status" : "completed",
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "66348005",
              "display" : "Childbirth"
            }
          ],
          "text" : "Parturition"
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "performedDateTime" : "2019-01-27",
        "reasonCode" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "72892002",
                "display" : "Normal pregnancy"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:d60580bd-c956-4b7c-9305-940df95ac4e7",
      "resource" : {
        "resourceType" : "AllergyIntolerance",
        "id" : "d60580bd-c956-4b7c-9305-940df95ac4e7",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/base/StructureDefinition/allergyIntolerance-eu-core"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"AllergyIntolerance_d60580bd-c956-4b7c-9305-940df95ac4e7\"> </a><table class=\"hl7__ips\"><tr><th>Allergy/Intolerance</th><th>Onset Date</th><th>Status</th><th>Type</th><th>Reaction</th></tr><tr><td>Allergy to substance</td><td><span class=\"nb\">1977-08-09</span></td><td>active</td><td>environment</td><td/></tr></table></div>"
        },
        "type" : "allergy",
        "category" : ["environment"],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "419199007",
              "display" : "Allergy to substance (finding)"
            }
          ],
          "text" : "Allergy to substance"
        },
        "patient" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "onsetDateTime" : "1977-08-09"
      }
    },
    {
      "fullUrl" : "urn:uuid:c417538e-c6ad-474a-96c7-5a807ee2204e",
      "resource" : {
        "resourceType" : "AllergyIntolerance",
        "id" : "c417538e-c6ad-474a-96c7-5a807ee2204e",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/base/StructureDefinition/allergyIntolerance-eu-core"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"AllergyIntolerance_c417538e-c6ad-474a-96c7-5a807ee2204e\"> </a><table class=\"hl7__ips\"><tr><th>Allergy/Intolerance</th><th>Onset Date</th><th>Status</th><th>Type</th><th>Reaction</th></tr><tr><td>Shellfish</td><td><span class=\"nb\">1977-08-09</span></td><td>active</td><td>food</td><td>Anaphylaxis (disorder)&lt;br&gt; &lt;/br&gt;Eruption of skin (disorder)</td></tr></table></div>"
        },
        "type" : "allergy",
        "category" : ["food"],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "735029006",
              "display" : "Shellfish (substance)"
            }
          ],
          "text" : "Shellfish"
        },
        "patient" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "onsetDateTime" : "1977-08-09",
        "reaction" : [
          {
            "manifestation" : [
              {
                "coding" : [
                  {
                    "system" : "http://snomed.info/sct",
                    "code" : "39579001",
                    "display" : "Anaphylaxis (disorder)"
                  }
                ]
              }
            ],
            "severity" : "severe"
          },
          {
            "manifestation" : [
              {
                "coding" : [
                  {
                    "system" : "http://snomed.info/sct",
                    "code" : "271807003",
                    "display" : "Eruption of skin (disorder)"
                  }
                ]
              }
            ],
            "severity" : "moderate"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:38cc86e4-e384-4627-8b21-5da894d0a41d",
      "resource" : {
        "resourceType" : "CarePlan",
        "id" : "38cc86e4-e384-4627-8b21-5da894d0a41d",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"CarePlan_38cc86e4-e384-4627-8b21-5da894d0a41d\"> </a><table class=\"hl7__ips first25\"><tr><th>Active Planned Care / Goals</th><th>Start Date</th><th>Reason</th></tr><tr><td>Musculoskeletal care</td><td><span class=\"nb\">21-Jan-2020</span></td><td>Osteoarthritis of knee</td></tr><tr><td><ul><li>Reduce knee pain severity to a tolerable level to improve function and quality of life.</li><li>Increase ability to perform daily activities such as walking and climbing stairs.</li><li>Complete prescribed knee strengthening and flexibility exercises as recommended.</li></ul></td><td/><td/></tr></table></div>"
        },
        "status" : "active",
        "intent" : "plan",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/care-plan-category",
                "code" : "assess-plan",
                "display" : "Assessment and Plan"
              }
            ]
          }
        ],
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "period" : {
          "start" : "2020-01-21"
        },
        "goal" : [
          {
            "reference" : "urn:uuid:68636948-f2d5-44f7-a8a7-b9a6ad00e7aa"
          },
          {
            "reference" : "urn:uuid:481dd5f0-d70b-4674-b215-7ca13e5d8a2d"
          },
          {
            "reference" : "urn:uuid:d93b4747-bcd0-4641-b9ad-6d35c5cb58fc"
          }
        ],
        "activity" : [
          {
            "detail" : {
              "code" : {
                "coding" : [
                  {
                    "system" : "http://snomed.info/sct",
                    "code" : "408869004",
                    "display" : "Musculoskeletal care (regime/therapy)"
                  }
                ]
              },
              "reasonCode" : [
                {
                  "coding" : [
                    {
                      "system" : "http://snomed.info/sct",
                      "code" : "239873007",
                      "display" : "Osteoarthritis of knee"
                    }
                  ]
                }
              ],
              "status" : "unknown",
              "description" : "Musculoskeletal care"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:d3801f47-fb06-4c61-a031-7aacf514446f",
      "resource" : {
        "resourceType" : "CarePlan",
        "id" : "d3801f47-fb06-4c61-a031-7aacf514446f",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"CarePlan_d3801f47-fb06-4c61-a031-7aacf514446f\"> </a><table class=\"hl7__ips first25\"><tr><th>Active Planned Care / Goals</th><th>Start Date</th><th>Reason</th></tr><tr><td>Self-care interventions</td><td><span class=\"nb\">24-Jul-1977</span></td><td>-</td></tr></table></div>"
        },
        "status" : "active",
        "intent" : "plan",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/care-plan-category",
                "code" : "assess-plan",
                "display" : "Assessment and Plan"
              }
            ]
          }
        ],
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "period" : {
          "start" : "1977-07-24"
        },
        "activity" : [
          {
            "detail" : {
              "code" : {
                "coding" : [
                  {
                    "system" : "http://snomed.info/sct",
                    "code" : "384758001",
                    "display" : "Self-care interventions (procedure)"
                  }
                ]
              },
              "status" : "unknown",
              "description" : "Self-care interventions"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:46a8cedd-8e71-4b71-8ff7-6e8f0b5915e4",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "46a8cedd-8e71-4b71-8ff7-6e8f0b5915e4",
        "meta" : {
          "profile" : ["http://hl7.org/fhir/StructureDefinition/vitalsigns"]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_46a8cedd-8e71-4b71-8ff7-6e8f0b5915e4\"> </a><table class=\"hl7__ips\"><tr><th>Vital Sign</th><th>Date</th><th>Measurement</th></tr><tr><td>Body Height</td><td>10-Nov-2024</td><td>168.1 cm</td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs",
                "display" : "Vital Signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8302-2",
              "display" : "Body Height"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "effectiveDateTime" : "2024-11-10",
        "valueQuantity" : {
          "value" : 168.1,
          "unit" : "cm",
          "code" : "cm"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:328c7df6-7f1e-4b20-aa6f-98dfa7e6581d",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "328c7df6-7f1e-4b20-aa6f-98dfa7e6581d",
        "meta" : {
          "profile" : ["http://hl7.org/fhir/StructureDefinition/vitalsigns"]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_328c7df6-7f1e-4b20-aa6f-98dfa7e6581d\"> </a><table class=\"hl7__ips\"><tr><th>Vital Sign</th><th>Date</th><th>Measurement</th></tr><tr><td>Pain severity - 0-10 verbal numeric rating [Score] - Reported</td><td>10-Nov-2024</td><td>3 {score}</td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs",
                "display" : "Vital Signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "72514-3",
              "display" : "Pain severity - 0-10 verbal numeric rating [Score] - Reported"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "effectiveDateTime" : "2024-11-10",
        "valueQuantity" : {
          "value" : 3,
          "unit" : "{score}",
          "code" : "{score}"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:fc5881c9-cda9-4e49-a24d-8a4e647c254e",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "fc5881c9-cda9-4e49-a24d-8a4e647c254e",
        "meta" : {
          "profile" : ["http://hl7.org/fhir/StructureDefinition/vitalsigns"]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_fc5881c9-cda9-4e49-a24d-8a4e647c254e\"> </a><table class=\"hl7__ips\"><tr><th>Vital Sign</th><th>Date</th><th>Measurement</th></tr><tr><td>Body Weight</td><td>10-Nov-2024</td><td>85.5 kg</td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs",
                "display" : "Vital Signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "29463-7",
              "display" : "Body Weight"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "effectiveDateTime" : "2024-11-10",
        "valueQuantity" : {
          "value" : 85.5,
          "unit" : "kg",
          "code" : "kg"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:8cd3529b-4a50-4293-a087-2c3bd7a7edb8",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "8cd3529b-4a50-4293-a087-2c3bd7a7edb8",
        "meta" : {
          "profile" : ["http://hl7.org/fhir/StructureDefinition/vitalsigns"]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_8cd3529b-4a50-4293-a087-2c3bd7a7edb8\"> </a><table class=\"hl7__ips\"><tr><th>Vital Sign</th><th>Date</th><th>Measurement</th></tr><tr><td>Body mass index (BMI) [Ratio]</td><td>10-Nov-2024</td><td>30.3 kg/m2</td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs",
                "display" : "Vital Signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "39156-5",
              "display" : "Body mass index (BMI) [Ratio]"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "effectiveDateTime" : "2024-11-10",
        "valueQuantity" : {
          "value" : 30.3,
          "unit" : "kg/m2",
          "code" : "kg/m2"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:024d8c5a-2d69-4656-a01f-e62bfdf13312",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "024d8c5a-2d69-4656-a01f-e62bfdf13312",
        "meta" : {
          "profile" : ["http://hl7.org/fhir/StructureDefinition/vitalsigns"]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_024d8c5a-2d69-4656-a01f-e62bfdf13312\"> </a><table class=\"hl7__ips\"><tr><th>Vital Sign</th><th>Date</th><th>Measurement</th></tr><tr><td>Diastolic Blood Pressure</td><td>10-Nov-2024</td><td>92 mm[Hg]</td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs",
                "display" : "Vital Signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8462-4",
              "display" : "Diastolic Blood Pressure"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "effectiveDateTime" : "2024-11-10",
        "valueQuantity" : {
          "value" : 92,
          "unit" : "mm[Hg]",
          "code" : "mm[Hg]"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:a3a41314-f4a7-46c4-966e-89b3cbe71757",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "a3a41314-f4a7-46c4-966e-89b3cbe71757",
        "meta" : {
          "profile" : ["http://hl7.org/fhir/StructureDefinition/vitalsigns"]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_a3a41314-f4a7-46c4-966e-89b3cbe71757\"> </a><table class=\"hl7__ips\"><tr><th>Vital Sign</th><th>Date</th><th>Measurement</th></tr><tr><td>Systolic Blood Pressure</td><td>10-Nov-2024</td><td>113 mm[Hg]</td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs",
                "display" : "Vital Signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8480-6",
              "display" : "Systolic Blood Pressure"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "effectiveDateTime" : "2024-11-10",
        "valueQuantity" : {
          "value" : 113,
          "unit" : "mm[Hg]",
          "code" : "mm[Hg]"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:1568aa25-3c00-4f90-8818-bcbd13932209",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "1568aa25-3c00-4f90-8818-bcbd13932209",
        "meta" : {
          "profile" : ["http://hl7.org/fhir/StructureDefinition/vitalsigns"]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_1568aa25-3c00-4f90-8818-bcbd13932209\"> </a><table class=\"hl7__ips\"><tr><th>Vital Sign</th><th>Date</th><th>Measurement</th></tr><tr><td>Heart rate</td><td>10-Nov-2024</td><td>90 /min</td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs",
                "display" : "Vital Signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8867-4",
              "display" : "Heart rate"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "effectiveDateTime" : "2024-11-10",
        "valueQuantity" : {
          "value" : 90,
          "unit" : "/min",
          "code" : "/min"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:d4e15888-1d2a-4730-9a8e-53afe9a5e85f",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "d4e15888-1d2a-4730-9a8e-53afe9a5e85f",
        "meta" : {
          "profile" : ["http://hl7.org/fhir/StructureDefinition/vitalsigns"]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_d4e15888-1d2a-4730-9a8e-53afe9a5e85f\"> </a><table class=\"hl7__ips\"><tr><th>Vital Sign</th><th>Date</th><th>Measurement</th></tr><tr><td>Respiratory rate</td><td>10-Nov-2024</td><td>14 /min</td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs",
                "display" : "Vital Signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "9279-1",
              "display" : "Respiratory rate"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "effectiveDateTime" : "2024-11-10",
        "valueQuantity" : {
          "value" : 14,
          "unit" : "/min",
          "code" : "/min"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:39e876db-8c95-4863-a21f-23e81f0f9d86",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "39e876db-8c95-4863-a21f-23e81f0f9d86",
        "meta" : {
          "profile" : ["http://hl7.org/fhir/StructureDefinition/vitalsigns"]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_39e876db-8c95-4863-a21f-23e81f0f9d86\"> </a><table class=\"hl7__ips\"><tr><th>Vital Sign</th><th>Date</th><th>Measurement</th></tr><tr><td>Body Height</td><td>05-Nov-2023</td><td>168.1 cm</td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs",
                "display" : "Vital Signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8302-2",
              "display" : "Body Height"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "effectiveDateTime" : "2023-11-05",
        "valueQuantity" : {
          "value" : 168.1,
          "unit" : "cm",
          "code" : "cm"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:d468c255-d47a-4305-b039-f9eaad4cb44e",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "d468c255-d47a-4305-b039-f9eaad4cb44e",
        "meta" : {
          "profile" : ["http://hl7.org/fhir/StructureDefinition/vitalsigns"]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_d468c255-d47a-4305-b039-f9eaad4cb44e\"> </a><table class=\"hl7__ips\"><tr><th>Vital Sign</th><th>Date</th><th>Measurement</th></tr><tr><td>Pain severity - 0-10 verbal numeric rating [Score] - Reported</td><td>05-Nov-2023</td><td>1 {score}</td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs",
                "display" : "Vital Signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "72514-3",
              "display" : "Pain severity - 0-10 verbal numeric rating [Score] - Reported"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "effectiveDateTime" : "2023-11-05",
        "valueQuantity" : {
          "value" : 1,
          "unit" : "{score}",
          "code" : "{score}"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:51d24796-6ce3-408d-ae26-331246616c65",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "51d24796-6ce3-408d-ae26-331246616c65",
        "meta" : {
          "profile" : ["http://hl7.org/fhir/StructureDefinition/vitalsigns"]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_51d24796-6ce3-408d-ae26-331246616c65\"> </a><table class=\"hl7__ips\"><tr><th>Vital Sign</th><th>Date</th><th>Measurement</th></tr><tr><td>Body Weight</td><td>05-Nov-2023</td><td>84.4 kg</td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs",
                "display" : "Vital Signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "29463-7",
              "display" : "Body Weight"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "effectiveDateTime" : "2023-11-05",
        "valueQuantity" : {
          "value" : 84.4,
          "unit" : "kg",
          "code" : "kg"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:22dd6799-71d8-414d-bf55-cd65d3ea998c",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "22dd6799-71d8-414d-bf55-cd65d3ea998c",
        "meta" : {
          "profile" : ["http://hl7.org/fhir/StructureDefinition/vitalsigns"]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_22dd6799-71d8-414d-bf55-cd65d3ea998c\"> </a><table class=\"hl7__ips\"><tr><th>Vital Sign</th><th>Date</th><th>Measurement</th></tr><tr><td>Body mass index (BMI) [Ratio]</td><td>05-Nov-2023</td><td>29.9 kg/m2</td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs",
                "display" : "Vital Signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "39156-5",
              "display" : "Body mass index (BMI) [Ratio]"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "effectiveDateTime" : "2023-11-05",
        "valueQuantity" : {
          "value" : 29.9,
          "unit" : "kg/m2",
          "code" : "kg/m2"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:1efe2316-cdee-48fa-8fb3-11ea53684a2d",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "1efe2316-cdee-48fa-8fb3-11ea53684a2d",
        "meta" : {
          "profile" : ["http://hl7.org/fhir/StructureDefinition/vitalsigns"]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_1efe2316-cdee-48fa-8fb3-11ea53684a2d\"> </a><table class=\"hl7__ips\"><tr><th>Vital Sign</th><th>Date</th><th>Measurement</th></tr><tr><td>Diastolic Blood Pressure</td><td>05-Nov-2023</td><td>88 mm[Hg]</td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs",
                "display" : "Vital Signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8462-4",
              "display" : "Diastolic Blood Pressure"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "effectiveDateTime" : "2023-11-05",
        "valueQuantity" : {
          "value" : 88,
          "unit" : "mm[Hg]",
          "code" : "mm[Hg]"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:790f5408-44a3-4425-bb64-1b3c0819e847",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "790f5408-44a3-4425-bb64-1b3c0819e847",
        "meta" : {
          "profile" : ["http://hl7.org/fhir/StructureDefinition/vitalsigns"]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_790f5408-44a3-4425-bb64-1b3c0819e847\"> </a><table class=\"hl7__ips\"><tr><th>Vital Sign</th><th>Date</th><th>Measurement</th></tr><tr><td>Systolic Blood Pressure</td><td>05-Nov-2023</td><td>121 mm[Hg]</td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs",
                "display" : "Vital Signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8480-6",
              "display" : "Systolic Blood Pressure"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "effectiveDateTime" : "2023-11-05",
        "valueQuantity" : {
          "value" : 121,
          "unit" : "mm[Hg]",
          "code" : "mm[Hg]"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:95001555-a2ee-4d75-8968-9eeb1ecbdb9c",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "95001555-a2ee-4d75-8968-9eeb1ecbdb9c",
        "meta" : {
          "profile" : ["http://hl7.org/fhir/StructureDefinition/vitalsigns"]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_95001555-a2ee-4d75-8968-9eeb1ecbdb9c\"> </a><table class=\"hl7__ips\"><tr><th>Vital Sign</th><th>Date</th><th>Measurement</th></tr><tr><td>Heart rate</td><td>05-Nov-2023</td><td>96 /min</td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs",
                "display" : "Vital Signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8867-4",
              "display" : "Heart rate"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "effectiveDateTime" : "2023-11-05",
        "valueQuantity" : {
          "value" : 96,
          "unit" : "/min",
          "code" : "/min"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:f25d7ac0-c367-4ec9-805e-c7a5f3af9106",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "f25d7ac0-c367-4ec9-805e-c7a5f3af9106",
        "meta" : {
          "profile" : ["http://hl7.org/fhir/StructureDefinition/vitalsigns"]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_f25d7ac0-c367-4ec9-805e-c7a5f3af9106\"> </a><table class=\"hl7__ips\"><tr><th>Vital Sign</th><th>Date</th><th>Measurement</th></tr><tr><td>Respiratory rate</td><td>05-Nov-2023</td><td>15 /min</td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs",
                "display" : "Vital Signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "9279-1",
              "display" : "Respiratory rate"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "effectiveDateTime" : "2023-11-05",
        "valueQuantity" : {
          "value" : 15,
          "unit" : "/min",
          "code" : "/min"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:2705c0f6-549a-44cf-a199-b334030bc6f8",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "2705c0f6-549a-44cf-a199-b334030bc6f8",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/laboratory/StructureDefinition/Observation-resultslab-eu-lab"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_2705c0f6-549a-44cf-a199-b334030bc6f8\"> </a><table class=\"hl7__eu__lab__report\"><tr><th>Test</th><th>30-Oct-2022</th><th>Reference Range</th><th>Unit</th></tr><tr><td>Cholesterol [Mass/volume] in Serum or Plasma</td><td>122.5</td><td>125 - 200</td><td>L</td><td>mg/dL</td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "2093-3",
              "display" : "Cholesterol [Mass/volume] in Serum or Plasma"
            }
          ],
          "text" : "Cholesterol [Mass/volume] in Serum or Plasma"
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "effectiveDateTime" : "2022-10-30T00:57:23Z",
        "performer" : [
          {
            "display" : "The Central European Lab"
          }
        ],
        "valueQuantity" : {
          "value" : 122.5,
          "unit" : "mg/dL",
          "system" : "http://unitsofmeasure.org",
          "code" : "mg/dL"
        },
        "referenceRange" : [
          {
            "low" : {
              "value" : 125,
              "system" : "http://unitsofmeasure.org",
              "code" : "mg/dL"
            }
          },
          {
            "high" : {
              "value" : 200,
              "system" : "http://unitsofmeasure.org",
              "code" : "mg/dL"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:4577d16f-e187-4044-afa0-4ea0d17d86d0",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "4577d16f-e187-4044-afa0-4ea0d17d86d0",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/laboratory/StructureDefinition/Observation-resultslab-eu-lab"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_4577d16f-e187-4044-afa0-4ea0d17d86d0\"> </a><table class=\"hl7__eu__lab__report\"><tr><th>Test</th><th>30-Oct-2022</th><th>Reference Range</th><th>Unit</th></tr><tr><td>Triglyceride [Mass/volume] in Serum or Plasma</td><td>125.3</td><td>35 - 150</td><td/><td>mg/dL</td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "2571-8",
              "display" : "Triglyceride [Mass/volume] in Serum or Plasma"
            }
          ],
          "text" : "Triglyceride [Mass/volume] in Serum or Plasma"
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "effectiveDateTime" : "2022-10-30T00:57:23Z",
        "performer" : [
          {
            "display" : "The Central European Lab"
          }
        ],
        "valueQuantity" : {
          "value" : 125.3,
          "unit" : "mg/dL",
          "system" : "http://unitsofmeasure.org",
          "code" : "mg/dL"
        },
        "referenceRange" : [
          {
            "low" : {
              "value" : 35,
              "system" : "http://unitsofmeasure.org",
              "code" : "mg/dL"
            }
          },
          {
            "high" : {
              "value" : 150,
              "system" : "http://unitsofmeasure.org",
              "code" : "mg/dL"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:cda76d4b-dc0d-4663-9b8a-2c5356b726a4",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "cda76d4b-dc0d-4663-9b8a-2c5356b726a4",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/laboratory/StructureDefinition/Observation-resultslab-eu-lab"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_cda76d4b-dc0d-4663-9b8a-2c5356b726a4\"> </a><table class=\"hl7__eu__lab__report\"><tr><th>Test</th><th>30-Oct-2022</th><th>Reference Range</th><th>Unit</th></tr><tr><td>Cholesterol in LDL [Mass/volume] in Serum or Plasma by Direct assay</td><td>42.0</td><td>0 - 130</td><td/><td>mg/dL</td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "18262-6",
              "display" : "Cholesterol in LDL [Mass/volume] in Serum or Plasma by Direct assay"
            }
          ],
          "text" : "Cholesterol in LDL [Mass/volume] in Serum or Plasma by Direct assay"
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "effectiveDateTime" : "2022-10-30T00:57:23Z",
        "performer" : [
          {
            "display" : "The Central European Lab"
          }
        ],
        "valueQuantity" : {
          "value" : 42,
          "unit" : "mg/dL",
          "system" : "http://unitsofmeasure.org",
          "code" : "mg/dL"
        },
        "referenceRange" : [
          {
            "low" : {
              "value" : 0,
              "system" : "http://unitsofmeasure.org",
              "code" : "mg/dL"
            }
          },
          {
            "high" : {
              "value" : 130,
              "system" : "http://unitsofmeasure.org",
              "code" : "mg/dL"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:6aa206a8-d0b1-4a37-be9f-1fe74f432839",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "6aa206a8-d0b1-4a37-be9f-1fe74f432839",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/laboratory/StructureDefinition/Observation-resultslab-eu-lab"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_6aa206a8-d0b1-4a37-be9f-1fe74f432839\"> </a><table class=\"hl7__eu__lab__report\"><tr><th>Test</th><th>30-Oct-2022</th><th>Reference Range</th><th>Unit</th></tr><tr><td>Cholesterol in HDL [Mass/volume] in Serum or Plasma</td><td>55.5</td><td>45 - 95</td><td/><td>mg/dL</td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "2085-9",
              "display" : "Cholesterol in HDL [Mass/volume] in Serum or Plasma"
            }
          ],
          "text" : "Cholesterol in HDL [Mass/volume] in Serum or Plasma"
        },
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "effectiveDateTime" : "2022-10-30T00:57:23Z",
        "performer" : [
          {
            "display" : "The Central European Lab"
          }
        ],
        "valueQuantity" : {
          "value" : 55.5,
          "unit" : "mg/dL",
          "system" : "http://unitsofmeasure.org",
          "code" : "mg/dL"
        },
        "referenceRange" : [
          {
            "low" : {
              "value" : 45,
              "system" : "http://unitsofmeasure.org",
              "code" : "mg/dL"
            }
          },
          {
            "high" : {
              "value" : 95,
              "system" : "http://unitsofmeasure.org",
              "code" : "mg/dL"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:82851773-8257-4aea-bd64-ea2fa18fe562",
      "resource" : {
        "resourceType" : "DeviceUseStatement",
        "id" : "82851773-8257-4aea-bd64-ea2fa18fe562",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/eps/StructureDefinition/deviceUseStatement-eu-eps"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"DeviceUseStatement_82851773-8257-4aea-bd64-ea2fa18fe562\"> </a><table class=\"hl7__ips\"><tr><td>Walker (physical object)</td><td><span class=\"nb\">21-Jan-2020</span></td></tr></table></div>"
        },
        "status" : "active",
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "timingPeriod" : {
          "start" : "2020-01-21"
        },
        "device" : {
          "reference" : "urn:uuid:1d6bbfe1-271e-4690-b75e-ed859a3dbbfa",
          "display" : "Walker (physical object)"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:1d6bbfe1-271e-4690-b75e-ed859a3dbbfa",
      "resource" : {
        "resourceType" : "Device",
        "id" : "1d6bbfe1-271e-4690-b75e-ed859a3dbbfa",
        "meta" : {
          "profile" : ["http://hl7.eu/fhir/eps/StructureDefinition/device-eu-eps"]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Device_1d6bbfe1-271e-4690-b75e-ed859a3dbbfa\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Device 1d6bbfe1-271e-4690-b75e-ed859a3dbbfa</b></p><a name=\"1d6bbfe1-271e-4690-b75e-ed859a3dbbfa\"> </a><a name=\"hc1d6bbfe1-271e-4690-b75e-ed859a3dbbfa\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&amp;canonical=http://hl7.eu/fhir/eps/StructureDefinition/device-eu-eps\">http://hl7.eu/fhir/eps/StructureDefinition/device-eu-eps</a></p></div><p><b>status</b>: Active</p><p><b>type</b>: <span title=\"Codes:{http://snomed.info/sct 705406009}\">Walker (physical object)</span></p><p><b>patient</b>: <a href=\"Bundle-eps-bundle-example.html#urn-uuid-4e6bfcf4-42f1-416b-994d-26f1ac0c0677\">Lily van &amp;#039;t Houteveen</a></p></div>"
        },
        "status" : "active",
        "type" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "705406009",
              "display" : "Walker (physical object)"
            }
          ]
        },
        "patient" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:3471f2b1-0f88-415c-8a65-bd368064d65b",
      "resource" : {
        "resourceType" : "DeviceUseStatement",
        "id" : "3471f2b1-0f88-415c-8a65-bd368064d65b",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/eps/StructureDefinition/deviceUseStatement-eu-eps"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"DeviceUseStatement_3471f2b1-0f88-415c-8a65-bd368064d65b\"> </a><table class=\"hl7__ips\"><tr><td>Home nebulizer (physical object)</td><td><span class=\"nb\">29-Jan-2002</span></td></tr></table></div>"
        },
        "status" : "active",
        "subject" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        },
        "timingPeriod" : {
          "start" : "2002-01-29"
        },
        "device" : {
          "reference" : "urn:uuid:8fce8fb4-e974-4785-a1a5-965ce972c0c9",
          "display" : "Home nebulizer (physical object)"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:8fce8fb4-e974-4785-a1a5-965ce972c0c9",
      "resource" : {
        "resourceType" : "Device",
        "id" : "8fce8fb4-e974-4785-a1a5-965ce972c0c9",
        "meta" : {
          "profile" : ["http://hl7.eu/fhir/eps/StructureDefinition/device-eu-eps"]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Device_8fce8fb4-e974-4785-a1a5-965ce972c0c9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Device 8fce8fb4-e974-4785-a1a5-965ce972c0c9</b></p><a name=\"8fce8fb4-e974-4785-a1a5-965ce972c0c9\"> </a><a name=\"hc8fce8fb4-e974-4785-a1a5-965ce972c0c9\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&amp;canonical=http://hl7.eu/fhir/eps/StructureDefinition/device-eu-eps\">http://hl7.eu/fhir/eps/StructureDefinition/device-eu-eps</a></p></div><p><b>status</b>: Active</p><p><b>type</b>: <span title=\"Codes:{http://snomed.info/sct 170615005}\">Home nebulizer (physical object)</span></p><p><b>patient</b>: <a href=\"Bundle-eps-bundle-example.html#urn-uuid-4e6bfcf4-42f1-416b-994d-26f1ac0c0677\">Lily van &amp;#039;t Houteveen</a></p></div>"
        },
        "status" : "active",
        "type" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "170615005",
              "display" : "Home nebulizer (physical object)"
            }
          ]
        },
        "patient" : {
          "reference" : "urn:uuid:4e6bfcf4-42f1-416b-994d-26f1ac0c0677",
          "display" : "Lily van &#039;t Houteveen"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:13a5303b-15bc-49ac-b4f0-14ff002c4757",
      "resource" : {
        "resourceType" : "Device",
        "id" : "13a5303b-15bc-49ac-b4f0-14ff002c4757",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Device_13a5303b-15bc-49ac-b4f0-14ff002c4757\"> </a>SYNDERAI Synthetic Generator v5.0</div>"
        },
        "status" : "active",
        "manufacturer" : "SYNDERAI Project"
      }
    },
    {
      "fullUrl" : "urn:uuid:17e7ebe1-26ca-4ce1-9233-33b906e5089f",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "17e7ebe1-26ca-4ce1-9233-33b906e5089f",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_17e7ebe1-26ca-4ce1-9233-33b906e5089f\"> </a>Provenance for SYNDERAI Synthetic Example Data Resource</div>"
        },
        "target" : [
          {
            "reference" : "Patient/4e6bfcf4-42f1-416b-994d-26f1ac0c0677"
          },
          {
            "reference" : "Bundle/1885d146-a8de-4dcf-b405-9f568ab2625c"
          },
          {
            "reference" : "Composition/17b6fb33-7dbf-4fae-a24e-aa772cba4cfc"
          },
          {
            "reference" : "PractitionerRole/85d7a127-6afc-4156-b3da-574235d429d0"
          },
          {
            "reference" : "Organization/87ed10a6-0891-46b6-8b7b-a3c3002eafe2"
          },
          {
            "reference" : "Practitioner/b1f77d95-ce1f-422e-a588-2ec17ae9ee87"
          }
        ],
        "recorded" : "2022-10-30T00:57:23Z",
        "policy" : ["https://synderai.net/synderai-synthetic-data-policy"],
        "reason" : [null],
        "agent" : [null]
      }
    }
  ]
}

```
