# Epic AllergyIntolerance Example - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Epic AllergyIntolerance Example**

## Example AllergyIntolerance: Epic AllergyIntolerance Example

Profile: [HCIM AllergyIntolerance](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.zib2017@2.3.1&canonical=http://nictiz.nl/fhir/StructureDefinition/zib-AllergyIntolerance)

**clinicalStatus**: Active

**verificationStatus**: Confirmed

**category**: Food

**code**: PINDA

**patient**: [Fictief, Jan](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&canonical=https://example.org/Patient/e52TXUJRLVxP2kvdXvNgS7euM1.HY8bVBMNNhsLwftTo3)

**onset**: 2017-12-03 --> (ongoing)

**assertedDate**: 2017-12-03 10:23:22+0000

### Reactions

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Manifestation** | **Description** | **Severity** |
| * | Erythrodermie | Erythrodermie | Moderate |



## Resource Content

```json
{
  "resourceType" : "AllergyIntolerance",
  "id" : "eot677ioPb4frLYJYyuabIg3",
  "meta" : {
    "profile" : [
      "http://nictiz.nl/fhir/StructureDefinition/zib-AllergyIntolerance"
    ]
  },
  "clinicalStatus" : "active",
  "verificationStatus" : "confirmed",
  "category" : ["food"],
  "code" : {
    "text" : "PINDA"
  },
  "patient" : {
    "reference" : "https://example.org/Patient/e52TXUJRLVxP2kvdXvNgS7euM1.HY8bVBMNNhsLwftTo3",
    "display" : "Fictief, Jan"
  },
  "onsetPeriod" : {
    "start" : "2017-12-03"
  },
  "assertedDate" : "2017-12-03T10:23:22Z",
  "reaction" : [
    {
      "manifestation" : [
        {
          "text" : "Erythrodermie"
        }
      ],
      "description" : "Erythrodermie",
      "severity" : "moderate"
    }
  ]
}

```
