<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile eAfspraakAppointment
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:Appointment</sch:title>
    <sch:rule context="f:Appointment">
      <sch:assert test="count(f:extension[@url = 'http://nictiz.nl/fhir/StructureDefinition/eAfspraak-Appointment-OnlineEditable']) &lt;= 1">extension with URL = 'http://nictiz.nl/fhir/StructureDefinition/eAfspraak-Appointment-OnlineEditable': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Appointment/f:extension</sch:title>
    <sch:rule context="f:Appointment/f:extension">
      <sch:assert test="count(f:extension[@url = 'Indicator']) &lt;= 1">extension with URL = 'Indicator': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'OnlineEditableUntil']) &lt;= 1">extension with URL = 'OnlineEditableUntil': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Appointment/f:status</sch:title>
    <sch:rule context="f:Appointment/f:status">
      <sch:assert test="count(f:extension[@url = 'http://nictiz.nl/fhir/StructureDefinition/code-specification']) &lt;= 1">extension with URL = 'http://nictiz.nl/fhir/StructureDefinition/code-specification': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Appointment/f:participant/f:actor</sch:title>
    <sch:rule context="f:Appointment/f:participant/f:actor">
      <sch:assert test="count(f:extension[@url = 'http://nictiz.nl/fhir/StructureDefinition/practitionerrole-reference']) &lt;= 1">extension with URL = 'http://nictiz.nl/fhir/StructureDefinition/practitionerrole-reference': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
