# hl7.fhir.nl.zorgviewer#1.21.0: RIVO-Noord Zorgviewer Implementation Guide

## Pages

* [Home Page](index.md)
* [Checklists & Aansluiten](checklists.md)
* [Must Support](must-support.md)
* [Design (WIP)](design2.md)
* [EGIZ NEN Normen Conformiteit](nen-normen.md)
* [Copyrights](copyrights.md)
* [Requirements](0requirements.md)
* [Testing](testing.md)
* [Uitgangspunten en Requirements](requirements.md)
* [Zorgviewer Test Cases](testcases.md)
* [Zorgnetwerk](zorgnetwerk.md)
* [Security Design](design-security.md)
* [Useful Downloads](downloads.md)
* [Zorgviewer Services](zorgviewer-services.md)
* [RAO](0rao.md)
* [Non Functional Requirements](requirements-non-functional.md)
* [Artifacts Summary](artifacts.md)
* [Logging Bouwblok Design](design-logging.md)
* [Checklists & Aansluiten](0checklists.md)
* [Authenticatie Bouwblok Design](design-authenticatie.md)
* [Toestemming Bouwblok Design](design-toestemming.md)
* [Design Achtergrond](design-background.md)
* [Datasets](datasets.md)
* [Design](design.md)
* [EViews (experimental)](eviews.md)
* [Zorgplan](zorgplan.md)
* [Regionaal Architectuur Overleg](rao.md)
* [IG Change History](changes.md)
* [Design](0design.md)

## Resources

### ValueSets

* [ACP behandelingen waardelijst](ValueSet-ACPTreatmentCodelist.md)
* [CodeSysteem Labels](ValueSet-CodeSystems.md)
* [Document Class & Type waardelijst](ValueSet-DocumentLOINCCodelist.md)
* [Zorgviewer probleem naam waardelijst](ValueSet-ProbleemNaamCodelist.md)
* [ProbleemStatus Labels](ValueSet-ProbleemStatus.md)
* [Subject rol (beroepen) waardelijst](ValueSet-SubjectRoleCodelist.md)
* [Zorgviewer verrichting type waardelijst](ValueSet-VerrichtingTypeCodelist.md)
* [Bronsysteem Zorgaanbieder](ValueSet-bronsysteem-zorgaanbieder.md)

### Resource Profiles

* [AdvanceDirective](StructureDefinition-AdvanceDirective.md)
* [AllergyIntolerance](StructureDefinition-AllergyIntolerance.md)
* [Appointment](StructureDefinition-Appointment.md)
* [AuditEvent](StructureDefinition-AuditEvent.md)
* [Condition](StructureDefinition-Condition.md)
* [DocumentReference](StructureDefinition-DocumentReference.md)
* [Encounter](StructureDefinition-Encounter.md)
* [Endpoint](StructureDefinition-Endpoint.md)
* [EpisodeOfCare](StructureDefinition-EpisodeOfCare.md)
* [Alert](StructureDefinition-Flag.md)
* [Vaccination](StructureDefinition-Immunization.md)
* [LaboratoryTestResult](StructureDefinition-LaboratoryTestResult.md)
* [Medicatiegegevens](StructureDefinition-Medicatiegegevens.md)
* [Medication](StructureDefinition-Medication.md)
* [MedicationAgreement](StructureDefinition-MedicationRequest.md)
* [MedicationUse](StructureDefinition-MedicationStatement.md)
* [Organization](StructureDefinition-Organization.md)
* [Patient](StructureDefinition-Patient.md)
* [PlanDefinition](StructureDefinition-PlanDefinition.md)
* [Practitioner](StructureDefinition-Practitioner.md)
* [PractitionerRole](StructureDefinition-PractitionerRole.md)
* [Probleemlijst](StructureDefinition-Probleemlijst.md)
* [Procedure](StructureDefinition-Procedure.md)
* [Specimen](StructureDefinition-Specimen.md)
* [ToestemmingConsent](StructureDefinition-ToestemmingConsent.md)
* [TreatmentDirective](StructureDefinition-TreatmentDirective.md)
* [VitalSign](StructureDefinition-VitalSign.md)

### Extensions

* [extension-Meta.source](StructureDefinition-extension-Meta.source.md)

### Appointments

* [2.16.840.1.113883.2.4.3.124.7.46240.80000006680](Appointment-2.16.840.1.113883.2.4.3.124.7.46240.80000006680.md)
* [euUwgaknEL2dCH5-hqEvSVp5BhPTmqDJUdEhZHe5uI-w3](Appointment-euUwgaknEL2dCH5-hqEvSVp5BhPTmqDJUdEhZHe5uI-w3.md)

### Bundles

* [19c74840-1ae3-4d6a-9585-802ea27e31d2](Bundle-19c74840-1ae3-4d6a-9585-802ea27e31d2.md)
* [69ecfed3-f811-45be-969c-6fb1f32fcf19](Bundle-69ecfed3-f811-45be-969c-6fb1f32fcf19.md)
* [d9c8899b-210f-46ae-b336-e6e58fb73647](Bundle-d9c8899b-210f-46ae-b336-e6e58fb73647.md)

### CapabilityStatements

* [Adressering](CapabilityStatement-Adressering.md)
* [Behandelplan](CapabilityStatement-Behandelplan.md)
* [Logging](CapabilityStatement-Logging.md)
* [Ontsluiten Bronsysteem](CapabilityStatement-OntsluitenBronsysteem.md)
* [Terminologie](CapabilityStatement-Terminologie.md)
* [Toestemming](CapabilityStatement-Toestemming.md)
* [Zorgverlener Directory](CapabilityStatement-ZorgverlenerDirectory.md)
* [Zorgviewer Host](CapabilityStatement-ZorgviewerHost.md)

### ConceptMaps

* [Behandelaanwijzing 2017 BehandelingAanwijzing2 2020 Mapping](ConceptMap-behandelaanwijzing-2017-2020.md)
* [Epic Provider Type naar SNOMED-CT Mapping](ConceptMap-epic-rolcode.md)
* [Patient Toestemming Mapping](ConceptMap-patient-toestemming.md)
* [RolCodeNL naar SNOMED-CT Mapping](ConceptMap-rolcodenl.md)
* [Vitale Gegevens Groep Mapping](ConceptMap-vital-signs-groups.md)

### Encounters

* [2.16.840.1.113883.2.4.3.124.7.46240.81230000070144](Encounter-2.16.840.1.113883.2.4.3.124.7.46240.81230000070144.md)
* [307375](Encounter-307375.md)
* [evQjXbVOcndOjvpXB-f.z8A3](Encounter-evQjXbVOcndOjvpXB-f.z8A3.md)

### Endpoints

* [UMCG](Endpoint-UMCG.md)

### ImplementationGuides

* [ZorgviewerIG](index.md)

### Organizations

* [MCL](Organization-MCL.md)
* [Ommelander Ziekenhuis Groep locatie Delfzicht](Organization-OZGDelfzicht.md)
* [Tjongerschans](Organization-Tjongerschans.md)
* [UMCG](Organization-UMCG.md)
* [VIPLive](Organization-VIPLive.md)

### Parameters

* [exp-params](Parameters-exp-params.md)

### Patients

* [B211BE58-949E-4950-9FE7-410B4D944E6F](Patient-B211BE58-949E-4950-9FE7-410B4D944E6F.md)

### Examples

* [2.16.840.1.113883.2.4.3.124.7.48765.212340000000820 (AllergyIntolerance)](AllergyIntolerance-2.16.840.1.113883.2.4.3.124.7.48765.212340000000820.md)
* [41 (AllergyIntolerance)](AllergyIntolerance-41.md)
* [eot677ioPb4frLYJYyuabIg3 (AllergyIntolerance)](AllergyIntolerance-eot677ioPb4frLYJYyuabIg3.md)
* [example-auditevent-zorgviewer (AuditEvent)](AuditEvent-example-auditevent-zorgviewer.md)
* [771 (Condition)](Condition-771.md)
* [a20d2048-e1b7-467d-8bb5-28142af195d6 (Condition)](Condition-a20d2048-e1b7-467d-8bb5-28142af195d6.md)
* [e-ZZJzEApAU6z8DStznS9pQ3 (Condition)](Condition-e-ZZJzEApAU6z8DStznS9pQ3.md)
* [eod0yZoGGXEapUI7nJwX4tA3 (Condition)](Condition-eod0yZoGGXEapUI7nJwX4tA3.md)
* [162 (Consent)](Consent-162.md)
* [190c12af-49d4-4553-8009-c816ab622a3e (Consent)](Consent-190c12af-49d4-4553-8009-c816ab622a3e.md)
* [2.16.840.1.113883.2.4.3.124.7.42348.3.21230000026449 (Consent)](Consent-2.16.840.1.113883.2.4.3.124.7.42348.3.21230000026449.md)
* [21 (Consent)](Consent-21.md)
* [81eacbcf-6d60-436a-a78f-e2962839a42f (Consent)](Consent-81eacbcf-6d60-436a-a78f-e2962839a42f.md)
* [eCSfaTk2.C2TeVxgQk.zOgw3 (Consent)](Consent-eCSfaTk2.C2TeVxgQk.zOgw3.md)
* [eGuoY.m8DiRaUvsn.5w5Etg3 (Consent)](Consent-eGuoY.m8DiRaUvsn.5w5Etg3.md)
* [ehLhIC8xuXjiZDVRntQauPyXlKehTcmaSh3Ozrs3nMfw3 (Consent)](Consent-ehLhIC8xuXjiZDVRntQauPyXlKehTcmaSh3Ozrs3nMfw3.md)
* [22aa9e3e-f72f-4f76-97c7-0f66c8f691f5 (DocumentReference)](DocumentReference-22aa9e3e-f72f-4f76-97c7-0f66c8f691f5.md)
* [esCkfE4Gs407F39oUa3nrshNutfUhGSpc-H0LDMIXXub1sTx6eyOBq4OITaxvXRi (DocumentReference)](DocumentReference-esCkfE4Gs407F39oUa3nrshNutfUhGSpc-H0LDMIXXub1sTx6eyOBq4OITaxvXRi.md)
* [354CD8791FE7BB1CF7AAC44891171ECB671D9E91 (Flag)](Flag-354CD8791FE7BB1CF7AAC44891171ECB671D9E91.md)
* [ac907bbc-89bd-45db-ab23-fdb11dd01a78 (Flag)](Flag-ac907bbc-89bd-45db-ab23-fdb11dd01a78.md)
* [fp4NreWdKGl71zKtuqY7biisS3I-b61-FLM1FcdiDNPU4 (Flag)](Flag-fp4NreWdKGl71zKtuqY7biisS3I-b61-FLM1FcdiDNPU4.md)
* [873 (Immunization)](Immunization-873.md)
* [b0a09112-1141-41a5-ab3e-277dd7cf34c4 (Immunization)](Immunization-b0a09112-1141-41a5-ab3e-277dd7cf34c4.md)
* [e6-GYWpe6tA541IbVTqmL.KQ0y3yguI2FH9XCaDsG8gI3 (Immunization)](Immunization-e6-GYWpe6tA541IbVTqmL.KQ0y3yguI2FH9XCaDsG8gI3.md)
* [ekk06V5y.aLipR7luJJbtWUCJul8emhI5g29CotXmMDE3 (Immunization)](Immunization-ekk06V5y.aLipR7luJJbtWUCJul8emhI5g29CotXmMDE3.md)
* [emmoWnHUUdm1G2gaviFakSiHIeAZOAsB1DSFw4OCaA9Y3 (Immunization)](Immunization-emmoWnHUUdm1G2gaviFakSiHIeAZOAsB1DSFw4OCaA9Y3.md)
* [fHER-7BKK9hfH62XmqNj5a68SZ5WRjfaiTJvXJfeJM1s4 (Medication)](Medication-fHER-7BKK9hfH62XmqNj5a68SZ5WRjfaiTJvXJfeJM1s4.md)
* [2.16.840.1.113883.2.4.3.124.7.10160.01230000013923 (MedicationRequest)](MedicationRequest-2.16.840.1.113883.2.4.3.124.7.10160.01230000013923.md)
* [MedicationRequest-Nexus (MedicationRequest)](MedicationRequest-MedicationRequest-Nexus.md)
* [eMds53eQTsCHDM2Kq35hbKnUMUW7FngCWXMhKdQvVRgs3 (MedicationRequest)](MedicationRequest-eMds53eQTsCHDM2Kq35hbKnUMUW7FngCWXMhKdQvVRgs3.md)
* [e2qDW3csWlKhFLAFtLX.hWRVnai3zNOL7mFdTBSalQqk3 (MedicationStatement)](MedicationStatement-e2qDW3csWlKhFLAFtLX.hWRVnai3zNOL7mFdTBSalQqk3.md)
* [2a35354e-9624-454c-a083-edabf7930c5a (Observation)](Observation-2a35354e-9624-454c-a083-edabf7930c5a.md)
* [3009316 (Observation)](Observation-3009316.md)
* [39E0E479029134429CCEFEE59BB98E661DE26A675AB08E9F4A1817EBC687A98C (Observation)](Observation-39E0E479029134429CCEFEE59BB98E661DE26A675AB08E9F4A1817EBC687A98C.md)
* [8130f2fc-1fc9-4304-875e-2e5630625cee (Observation)](Observation-8130f2fc-1fc9-4304-875e-2e5630625cee.md)
* [eLkztXF4frEa7ZOBv9MSS9vp.TIkR.7MqI5KrsX.3m1H2WoeIQnswnT44yGd6ybl.3 (Observation)](Observation-eLkztXF4frEa7ZOBv9MSS9vp.TIkR.7MqI5KrsX.3m1H2WoeIQnswnT44yGd6ybl.3.md)
* [f8UmImiPIOsQ.5po1S7e9DkjuNqOXpuSeUU-S.g-EF2c4 (Observation)](Observation-f8UmImiPIOsQ.5po1S7e9DkjuNqOXpuSeUU-S.g-EF2c4.md)
* [fAJm9U4NmonFyK656Yp6SRakMJ2FBBPqYFHzRYVFMdkg4 (Observation)](Observation-fAJm9U4NmonFyK656Yp6SRakMJ2FBBPqYFHzRYVFMdkg4.md)
* [fnOT.DhAM3rvu5Q8YAm3-LZHYD--XzzBJiZgxXDXElkw4 (Observation)](Observation-fnOT.DhAM3rvu5Q8YAm3-LZHYD--XzzBJiZgxXDXElkw4.md)
* [UMCG (Organization)](Organization-eXovwVA3zYl3U3fBH8mdkxw3.md)
* [330073 (Patient)](Patient-330073.md)
* [9819C39260647B5DE61609CDF1FA1C434552D65014AFDEA2EB877A576B055DF1 (Patient)](Patient-9819C39260647B5DE61609CDF1FA1C434552D65014AFDEA2EB877A576B055DF1.md)
* [eXxP1o8ZlOz21F6HXS9puLA3 (Patient)](Patient-eXxP1o8ZlOz21F6HXS9puLA3.md)
* [BgZ 2017 (PlanDefinition)](PlanDefinition-BgZ2017.md)
* [67d36d4c-bc18-4c5d-8fb5-609f6a17451e (Practitioner)](Practitioner-67d36d4c-bc18-4c5d-8fb5-609f6a17451e.md)
* [b5160776-43dc-43e1-9bb7-a6e3edf8e63d (Practitioner)](Practitioner-b5160776-43dc-43e1-9bb7-a6e3edf8e63d.md)
* [e-fLnBq-lBzq8jPEBkxuqjA3-SCT (Practitioner)](Practitioner-e-fLnBq-lBzq8jPEBkxuqjA3-SCT.md)
* [e-fLnBq-lBzq8jPEBkxuqjA3 (Practitioner)](Practitioner-e-fLnBq-lBzq8jPEBkxuqjA3.md)
* [ewlllWqLbsFaKN.d3pMMnmf2FdzTdX0132jvZktW2LP43 (PractitionerRole)](PractitionerRole-ewlllWqLbsFaKN.d3pMMnmf2FdzTdX0132jvZktW2LP43.md)
* [2.16.840.1.113883.2.4.3.124.7.47519.41230000001716 (Procedure)](Procedure-2.16.840.1.113883.2.4.3.124.7.47519.41230000001716.md)
* [25102292 (Procedure)](Procedure-25102292.md)
* [VPwS1rhM16bYvo-c52ce7kwRKeEaUOJaDIeHsOSNJzFTQLcTN5Lcg7N50uR5v1Z4 (Procedure)](Procedure-VPwS1rhM16bYvo-c52ce7kwRKeEaUOJaDIeHsOSNJzFTQLcTN5Lcg7N50uR5v1Z4.md)
* [flS.UT.hs.t2UZUFBGcd05sj4obBlLB.TD3qdy07DasQ4 (Procedure)](Procedure-flS.UT.hs.t2UZUFBGcd05sj4obBlLB.TD3qdy07DasQ4.md)
* [291f7eb1-c4ff-49fb-94a8-0500c19b7635 (Specimen)](Specimen-291f7eb1-c4ff-49fb-94a8-0500c19b7635.md)
* [35648ae9-a74d-4800-9f15-4e436ebd12c8 (Specimen)](Specimen-35648ae9-a74d-4800-9f15-4e436ebd12c8.md)
* [edAE6aGl0-InKRnWJAWRiChE4AhLNTRTlNIiljUcUA-I3 (Specimen)](Specimen-edAE6aGl0-InKRnWJAWRiChE4AhLNTRTlNIiljUcUA-I3.md)
* [exZSk-b3OlcTzGCgPiLC7vWfuWK61KNrcmTO8gYKthmA3 (Specimen)](Specimen-exZSk-b3OlcTzGCgPiLC7vWfuWK61KNrcmTO8gYKthmA3.md)
