# Bronsysteem Zorgaanbieder - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Bronsysteem Zorgaanbieder**

## ValueSet: Bronsysteem Zorgaanbieder 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/ValueSet/bronsysteem-zorgaanbieder | *Version*:1.21.0 |
| Active as of 2025-10-28 | *Computable Name*:bronsysteem-zorgaanbieder |

 
Bronsysteem Zorgaanbieder AGB-Z, OID and displays. De OID wordt gebruikt als uri in Meta.source 

 **References** 

* [extension-Meta.source](StructureDefinition-extension-Meta.source.md)

**Changes since version 1.20.0:**

* No changes

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on codesystem unknown version n/a

This value set contains 9 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/STU3/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "bronsysteem-zorgaanbieder",
  "meta" : {
    "profile" : ["http://hl7.org/fhir/StructureDefinition/shareablevalueset"]
  },
  "url" : "http://fhir.hl7.nl/zorgviewer/ValueSet/bronsysteem-zorgaanbieder",
  "version" : "1.21.0",
  "name" : "bronsysteem-zorgaanbieder",
  "title" : "Bronsysteem Zorgaanbieder",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-28T13:36:22+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Bronsysteem Zorgaanbieder AGB-Z, OID and displays. De OID wordt gebruikt als uri in Meta.source",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "urn:ietf:rfc:3986",
        "concept" : [
          {
            "code" : "urn:oid:2.16.840.1.113883.2.4.3.98",
            "display" : "Ommelander Ziekenhuis Groep locatie Delfzicht OID"
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.4.3.8",
            "display" : "UMCG OID"
          },
          {
            "code" : "http://fhir.nl/fhir/NamingSystem/agb-z/06020101",
            "display" : "UMCG AGB-Z"
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.4.3.75",
            "display" : "MCL OID"
          },
          {
            "code" : "http://fhir.nl/fhir/NamingSystem/agb-z/06010210",
            "display" : "MCL AGB-Z"
          },
          {
            "code" : "urn:oid:2.16.528.1.1007.3.3.15123",
            "display" : "Tjongerschans OID"
          },
          {
            "code" : "http://fhir.nl/fhir/NamingSystem/agb-z/06010205",
            "display" : "Tjongerschans AGB-Z"
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.4.3.95",
            "display" : "Martini OID"
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.4.3.213",
            "display" : "RIVO-Noord OID"
          }
        ]
      }
    ]
  }
}

```
