# ProbleemStatus Labels - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ProbleemStatus Labels**

## ValueSet: ProbleemStatus Labels 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/ValueSet/ProbleemStatus | *Version*:1.21.0 |
| Active as of 2025-10-28 | *Computable Name*:ProbleemStatus |

 
Deze waardelijst bevat de labels voor de Probleem (clinical)status 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

**Changes since version 1.20.0:**

* New Content

### Logical Definition (CLD)

 

### Expansion

This value set contains 7 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/STU3/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "ProbleemStatus",
  "meta" : {
    "profile" : ["http://hl7.org/fhir/StructureDefinition/shareablevalueset"]
  },
  "url" : "http://fhir.hl7.nl/zorgviewer/ValueSet/ProbleemStatus",
  "version" : "1.21.0",
  "name" : "ProbleemStatus",
  "title" : "ProbleemStatus Labels",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-28T13:36:22+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Deze waardelijst bevat de labels voor de Probleem (clinical)status",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://hl7.org/fhir/condition-clinical",
        "concept" : [
          {
            "code" : "active",
            "display" : "Actueel"
          },
          {
            "code" : "recurrence",
            "display" : "Actueel"
          },
          {
            "code" : "inactive",
            "display" : "Niet actueel"
          },
          {
            "code" : "remission",
            "display" : "Niet actueel"
          },
          {
            "code" : "resolved",
            "display" : "Niet actueel"
          }
        ]
      },
      {
        "system" : "http://hl7.org/fhir/episode-of-care-status",
        "concept" : [
          {
            "code" : "active",
            "display" : "Actueel"
          },
          {
            "code" : "finished",
            "display" : "Niet actueel"
          }
        ]
      }
    ]
  }
}

```
