# Specimen - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Specimen**

## Resource Profile: Specimen 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/StructureDefinition/Specimen | *Version*:1.21.0 |
| Active as of 2025-10-28 | *Computable Name*:Specimen |

 
Monster Materiaal 

Zie [LaboratoriumTestResult](StructureDefinition-LaboratoryTestResult.md) voor User Interface guidance en Request.

**Usages:**

* Refer to this Profile: [LaboratoryTestResult](StructureDefinition-LaboratoryTestResult.md)
* CapabilityStatements using this Profile: [Ontsluiten Bronsysteem](CapabilityStatement-OntsluitenBronsysteem.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.zorgviewer|current/StructureDefinition/Specimen)

**Changes since version 1.20.0:**

* No changes

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Specimen.csv), [Excel](StructureDefinition-Specimen.xlsx), [Schematron](StructureDefinition-Specimen.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Specimen",
  "url" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Specimen",
  "version" : "1.21.0",
  "name" : "Specimen",
  "title" : "Specimen",
  "status" : "active",
  "date" : "2025-10-28T13:36:22+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Monster Materiaal",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "fhirVersion" : "3.0.2",
  "mapping" : [
    {
      "identity" : "hcim-laboratorytestresult-v4.4-2019EN",
      "uri" : "https://zibs.nl/wiki/LaboratoriumUitslag-v4.4(2019NL)",
      "name" : "HCIM LaboratoryTestResult-v4.4(2019EN)"
    },
    {
      "identity" : "hcim-laboratorytestresult-v4.1-2017EN",
      "uri" : "https://zibs.nl/wiki/LaboratoryTestResult-v4.1(2017EN)",
      "name" : "HCIM LaboratoryTestResult-v4.1(2017EN)"
    },
    {
      "identity" : "hcim-laboratorytestresultfortransfer-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/LaboratoryTestResultForTransfer-v3.0(2016EN)",
      "name" : "HCIM LaboratoryTestResultForTransfer-v3.0(2016EN)"
    },
    {
      "identity" : "hcim-laboratorytestresultfortransfer-v1.2.2-2015EN",
      "uri" : "https://zibs.nl/wiki/LaboratoryTestResultForTransfer-v1.2.2(2015EN)",
      "name" : "HCIM LaboratoryTestResultForTransfer-v1.2.2(2015EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Specimen",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/zib-LaboratoryTestResult-Specimen",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Specimen",
        "path" : "Specimen"
      },
      {
        "id" : "Specimen.type",
        "path" : "Specimen.type"
      },
      {
        "id" : "Specimen.type.text",
        "path" : "Specimen.type.text",
        "mustSupport" : true
      },
      {
        "id" : "Specimen.note",
        "path" : "Specimen.note"
      },
      {
        "id" : "Specimen.note.text",
        "path" : "Specimen.note.text",
        "mustSupport" : true
      }
    ]
  }
}

```
