# MedicationUse - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationUse**

## Resource Profile: MedicationUse 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/StructureDefinition/MedicationStatement | *Version*:1.21.0 |
| Active as of 2025-10-28 | *Computable Name*:MedicationUse |

 
Medicatie Gebruik 

> Dit Profiel is het resultaat van de vergelijking tussen de zib2017 FHIR Profiel en de implementaties in Epic, Chipsoft, Topicus en Nexus. De elementen die in ieder geval in alle output beschikbaar zullen zijn. Voornamelijk bedoeld voor houvast van een client en voor validatie van output.

### Zorginformatiebouwsteen

[ZIB Medicatie Gebruik2](https://zibs.nl/wiki/MedicatieGebruik2-v1.0.1(2017NL))

### View Definition

[ViewDefinition voor MedicationStatement](ViewDefinition-MedicationStatement.json)

### UI Wireframe

**Medicatie Gebruik**

* ><: +
  * Bron: Epic
  * Start: 
  * Eind: 
  * Medicatie: simvastatine 20mg tablet
  * Dosering & instructies: innemen. s Avonds innemen; Bij dit middel GEEN grapefruit(sap) gebruiken
  * Toedieningsweg: Oraal
* ><: 
  * Bron: **Registratiedatum**15-3-2018

### Kolom Definities

* UITKLAPVELD: Bron
  * ?: `meta.extension('http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source').valueUri`
  * ?: `string`
  * ?: nvt
  * ?: Lookup adhv uri (AGB-Z of OID)`<adressering-base>/Organization?identifier=<.meta.tag.code>`en gebruik dan`Organization.name`
* UITKLAPVELD: Start
  * ?: `effectivePeriod.start`
  * ?: `dateTime`
  * ?: Gebruiksperiode::TijdsInterval/startDatumTijd
  * ?: 
* UITKLAPVELD: Eind
  * ?: `effectivePeriod.end`
  * ?: `dateTime`
  * ?: Gebruiksperiode::TijdsInterval/eindDatumTijd
  * ?: 
* UITKLAPVELD: Medicatie
  * ?: `medication.display`
  * ?: `string`
  * ?: Gebruiksproduct::FarmaceutischProduct
  * ?: 
* UITKLAPVELD: Dosering & instructies
  * ?: `dosage.text`
  * ?: `string`
  * ?: Gebruiksinstructie/Omschrijving, Gebruiksinstructie/AanvullendeInstructie
  * ?: N.B. Als text niet beschikbaar dan samenstellen uit discrete informatie en markeren met een icoontje ⓘ
* UITKLAPVELD: Toedieningsweg
  * ?: `dosage.route.text`
  * ?: `string`
  * ?: Gebruiksinstructie/Toedieningsweg
  * ?: 
* UITKLAPVELD: +Medicatie vorm
  * ?: `medication.resolve().form.coding.display`
  * ?: `string`
  * ?: Gebruiksproduct::FarmaceutischProduct/FarmaceutischeVorm
  * ?: 
* UITKLAPVELD: +Registratiedatum
  * ?: `dateAsserted`
  * ?: `dateTime`
  * ?: MedicatieGebruikDatumTijd
  * ?: 
* UITKLAPVELD: +Voorschrijver
  * ?: `extension('http://nictiz.nl/fhir/StructureDefinition/zib-MedicationUse-Prescriber').valueReference.display`
  * ?: `string`
  * ?: Voorschrijver::Zorgverlener
  * ?: 

### Request

1. Opvragen (search) definities`GET <ontsluiten-bronsysteem-base>/MedicationStatement?category=urn:oid:2.16.840.1.113883.2.4.3.11.60.20.77.5.3|6&_include=MedicationStatement:medication&patient=<fhir_patient_id>`

### Bronsysteem herkennen

De **Zorgviewer-backend** of **Ontsluiten bronsysteem** **MOET** na bevragen van het bronsysteem aan elk resultaat resource een meta-tag toevoegen met de AGB, OID of URA identifier van de zorgaanbieder (zie [Organization](StructureDefinition-Organization.md) voor voorbeelden). Dit wordt vervolgens gebruikt in de "Bron" kolom in de Zorgviewer-frontend. N.B. We gebruiken hier een **pre-adopt** van de FHIR R4 [Meta.source](StructureDefinition-extension-Meta.source.md).

Toevoegen aan elke response, dus per resource (bij een read) of per Bundle (bij een search):

```
"meta": {
    "extension": [ {
        "url": "http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source",
        "valueUri": "urn:oid:2.16.840.1.113883.2.4.3.8"
    } ]
}

```

**Alternatief:** Elke entry van een search response Bundle bevat een referentie naar de bijbehorende Patient (`<resource>.subject|patient`). Elke patient heeft een `Patient.managingOrganization` en in de gerefereerde `Organization.identifier` staat vervolgens o.a. de OID van het bronsysyeem. Of je gebruikt de identifiers om een volledige Organization op te zoeken in het [adresboek](zorgviewer-services.md#adressering) en zie inhoud [hier](artifacts.md#zorgviewer-services-content).

**Usages:**

* Use this Profile: [Medicatiegegevens](StructureDefinition-Medicatiegegevens.md)
* CapabilityStatements using this Profile: [Ontsluiten Bronsysteem](CapabilityStatement-OntsluitenBronsysteem.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.zorgviewer|current/StructureDefinition/MedicationStatement)

**Changes since version 1.20.0:**

* New Content

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-MedicationStatement.csv), [Excel](StructureDefinition-MedicationStatement.xlsx), [Schematron](StructureDefinition-MedicationStatement.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "MedicationStatement",
  "url" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/MedicationStatement",
  "version" : "1.21.0",
  "name" : "MedicationUse",
  "title" : "MedicationUse",
  "status" : "active",
  "date" : "2025-10-28T13:36:22+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Medicatie Gebruik",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "fhirVersion" : "3.0.2",
  "mapping" : [
    {
      "identity" : "hcim-medicationuse2-v1.0.1-2017EN",
      "uri" : "https://zibs.nl/wiki/MedicationUse2-v1.0.1(2017EN)",
      "name" : "HCIM MedicationUse2-v1.0.1(2017EN)"
    },
    {
      "identity" : "hcim-timeinterval-v1.0-2017EN",
      "uri" : "https://zibs.nl/wiki/TimeInterval-v1.0(2017EN)",
      "name" : "HCIM TimeInterval-v1.0(2017EN)"
    },
    {
      "identity" : "hcim-instructionsforuse-v1.1-2017EN",
      "uri" : "https://zibs.nl/wiki/InstructionsForUse-v1.1(2017EN)",
      "name" : "HCIM InstructionsForUse-v1.1(2017EN)"
    },
    {
      "identity" : "hcim-basicelements-v1.0-2017EN",
      "uri" : "https://zibs.nl/wiki/BasicElements-v1.0(2017EN)",
      "name" : "HCIM BasicElements-v1.0(2017EN)"
    },
    {
      "identity" : "Medication-Process-v09",
      "uri" : "https://decor.nictiz.nl/medicatieproces/mp-html-20181220T121121/ds-2.16.840.1.113883.2.4.3.11.60.20.77.1.3-2016-06-01T000000.html",
      "name" : "Medication Process v09",
      "comment" : "Language of Medication Process is Dutch."
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationStatement",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/zib-MedicationUse",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationStatement.extension:prescriber",
        "path" : "MedicationStatement.extension",
        "sliceName" : "prescriber",
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.category.text",
        "path" : "MedicationStatement.category.text",
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.medicationReference",
        "path" : "MedicationStatement.medicationReference",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Medication"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.medicationReference.display",
        "path" : "MedicationStatement.medicationReference.display",
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.effectivePeriod",
        "path" : "MedicationStatement.effectivePeriod",
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.effectivePeriod.start",
        "path" : "MedicationStatement.effectivePeriod.start",
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.effectivePeriod.end",
        "path" : "MedicationStatement.effectivePeriod.end",
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.dateAsserted",
        "path" : "MedicationStatement.dateAsserted",
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.dosage.text",
        "path" : "MedicationStatement.dosage.text",
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.dosage.route.text",
        "path" : "MedicationStatement.dosage.route.text",
        "mustSupport" : true
      }
    ]
  }
}

```
