# LaboratoryTestResult - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **LaboratoryTestResult**

## Resource Profile: LaboratoryTestResult 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/StructureDefinition/LaboratoryTestResult | *Version*:1.21.0 |
| Active as of 2025-10-28 | *Computable Name*:LaboratoryTestResult |

 
Laboratorium Test Uitslag 

> Dit Profiel is het resultaat van de vergelijking tussen de zib2017 FHIR Profiel en de implementaties in Epic, Chipsoft, Topicus en Nexus. De elementen die in ieder geval in alle output beschikbaar zullen zijn. Voornamelijk bedoeld voor houvast van een client en voor validatie van output.

### Zorginformatiebouwsteen

[ZIB Laboratorium uitslag](https://zibs.nl/wiki/LaboratoriumUitslag-v4.1(2017NL))

### View Definition

[ViewDefinition voor labuitslagen](ViewDefinition-Labuitslagen.json)

### UI Wireframe

**Laboratoriumuitslagen**

* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 4-2-2025
  * Test: Substantie
  * Testuitslag: faeces
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: 
  * Status: final
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 4-2-2025
  * Test: Rapport
  * Testuitslag: faeces
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: 
  * Status: final
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 4-2-2025
  * Test: Schistosoma microscopie
  * Testuitslag: Negatief
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: 
  * Status: final
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 4-2-2025
  * Test: Materiaal
  * Testuitslag: faeces
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: 
  * Status: final
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: Glucose
  * Testuitslag: 7.2 mmol/L
  * Interpretatie: Boven referentiewaarde
  * Onder- en bovengrens: 4.5 - 6.1 mmol/L
  * Materiaal: Bloed
  * Status: final
* ><: 
  * Bron: **Commentaar**Toelichting: Test order voor Zorgplatform en XDS ;
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: Ureum
  * Testuitslag: 6.3 mmol/L
  * Interpretatie: 
  * Onder- en bovengrens: 3 - 7.5 mmol/L
  * Materiaal: Bloed
  * Status: final
* ><: 
  * Bron: **Commentaar**Toelichting: Test order voor Zorgplatform en XDS ;
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: Creatinine
  * Testuitslag: 65 µmol/L
  * Interpretatie: 
  * Onder- en bovengrens: 49 - 90 µmol/L
  * Materiaal: Bloed
  * Status: final
* ><: 
  * Bron: **Commentaar**Toelichting: Test order voor Zorgplatform en XDS ;
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: eGFR (creat)
  * Testuitslag: 81 mL/min/1.73m2
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: Bloed
  * Status: final
* ><: 
  * Bron: **Commentaar**Toelichting: Test order voor Zorgplatform en XDS ;
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: Kalium
  * Testuitslag: 3.8 mmol/L
  * Interpretatie: 
  * Onder- en bovengrens: 3.8 - 5 mmol/L
  * Materiaal: Bloed
  * Status: final
* ><: 
  * Bron: **Commentaar**Toelichting: Test order voor Zorgplatform en XDS ;
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: Natrium
  * Testuitslag: 142 mmol/L
  * Interpretatie: 
  * Onder- en bovengrens: 136 - 146 mmol/L
  * Materiaal: Bloed
  * Status: final
* ><: 
  * Bron: **Commentaar**Toelichting: Test order voor Zorgplatform en XDS ;
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: AKI alert
  * Testuitslag: <Memo>
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: Bloed
  * Status: final
* ><: 
  * Bron: **Commentaar**Toelichting: Niet te beoordelen.Volgens KDIGO-richtlijn niet te berekenenwant ...
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: Magnesium
  * Testuitslag: 0.98 mmol/L
  * Interpretatie: 
  * Onder- en bovengrens: 0.7 - 1 mmol/L
  * Materiaal: Bloed
  * Status: final
* ><: 
  * Bron: **Commentaar**Toelichting: Test order voor Zorgplatform en XDS ;
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: Cytomegalovirus IgM (ELFA)
  * Testuitslag: 0.72/Grens
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: 
  * Status: final
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: Hepatitis B virus core IgG (CMIA)
  * Testuitslag: 0.09/Neg
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: 
  * Status: final
* ><: 
  * Bron: **Commentaar**Toelichting: Serologisch GEEN aanwijzingen voor infectie met Hepatitis B virus ;
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: Materiaal
  * Testuitslag: Stolbloed (r
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: 
  * Status: final
* ><: 
  * Bron: **Commentaar**Toelichting: Stolbloed (rood) 10 ml (Substantie=bloed, Rapport=Serum) ;
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: Cytomegalovirus IgG (ELFK)
  * Testuitslag: 30/Pos
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: 
  * Status: final
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: HSV-2 IgG (VirClia)
  * Testuitslag: 0.613/Neg
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: 
  * Status: final
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: HSV-2 IgM (VirClia)
  * Testuitslag: 0.652/Neg
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: 
  * Status: final
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: HSV-1 IgG (VirClia)
  * Testuitslag: 0.261/Neg
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: 
  * Status: final
* ><: 
  * Bron: **Commentaar**Toelichting: Serologisch GEEN aanwijzingen voor een in het verleden opgedane inf...
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: HSV-1 IgM (VirClia)
  * Testuitslag: 0.260/Neg
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: 
  * Status: final
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: Amylase
  * Testuitslag: <20
  * Interpretatie: Onder referentiewaarde
  * Onder- en bovengrens: 30 - 640 U/L
  * Materiaal: Urine portie
  * Status: final
* ><: 
  * Bron: **Commentaar**Toelichting: Test order voor Zorgplatform en XDS ;
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: Creatinine
  * Testuitslag: 9.5 mmol/L
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: Urine portie
  * Status: final
* ><: 
  * Bron: **Commentaar**Toelichting: Test order voor Zorgplatform en XDS ;
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: Kalium
  * Testuitslag: 38 mmol/L
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: Urine portie
  * Status: final
* ><: 
  * Bron: **Commentaar**Toelichting: Test order voor Zorgplatform en XDS ;
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: Ureum
  * Testuitslag: 86 mmol/L
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: Urine portie
  * Status: final
* ><: 
  * Bron: **Commentaar**Toelichting: Test order voor Zorgplatform en XDS ;
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: Natrium
  * Testuitslag: 127 mmol/L
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: Urine portie
  * Status: final
* ><: 
  * Bron: **Commentaar**Toelichting: Test order voor Zorgplatform en XDS ;
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: Cortisol
  * Testuitslag: 0.39 µmol/L
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: Bloed
  * Status: final
* ><: 
  * Bron: **Commentaar**Toelichting: Ochtend 0.25 - 0.83 µmol/LMiddag ...
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: Engels raaigras
  * Testuitslag: <0.35
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: Bloed
  * Status: final
* ><: 
  * Bron: **Commentaar**Toelichting: Test order voor Zorgplatform en XDS ;
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: Berk
  * Testuitslag: 40 kU/L
  * Interpretatie: Boven referentiewaarde
  * Onder- en bovengrens: 
  * Materiaal: Bloed
  * Status: final
* ><: 
  * Bron: **Commentaar**Toelichting: Test order voor Zorgplatform en XDS ;
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: Bijvoet
  * Testuitslag: <0.35
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: Bloed
  * Status: final
* ><: 
  * Bron: **Commentaar**Toelichting: Test order voor Zorgplatform en XDS ;
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: Huismijt
  * Testuitslag: <0.35
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: Bloed
  * Status: final
* ><: 
  * Bron: **Commentaar**Toelichting: Test order voor Zorgplatform en XDS ;
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: Schildklier (anti-TPO)
  * Testuitslag: 37 U/mL
  * Interpretatie: Boven referentiewaarde
  * Onder- en bovengrens: 
  * Materiaal: Bloed
  * Status: final
* ><: 
  * Bron: **Commentaar**Toelichting: Test order voor Zorgplatform en XDS ;
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: Timotheegras
  * Testuitslag: <0.35
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: Bloed
  * Status: final
* ><: 
  * Bron: **Commentaar**Toelichting: Test order voor Zorgplatform en XDS ;
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: Huisstofmijt
  * Testuitslag: <0.35
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: Bloed
  * Status: final
* ><: 
  * Bron: **Commentaar**Toelichting: Test order voor Zorgplatform en XDS ;
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: Kopramijt
  * Testuitslag: 1.6 kU/L
  * Interpretatie: Boven referentiewaarde
  * Onder- en bovengrens: 
  * Materiaal: Bloed
  * Status: final
* ><: 
  * Bron: **Commentaar**Toelichting: Test order voor Zorgplatform en XDS ;
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: Hemoglobine
  * Testuitslag: 8.9 mmol/L
  * Interpretatie: 
  * Onder- en bovengrens: 7.4 - 9.6 mmol/L
  * Materiaal: Bloed
  * Status: final
* ><: 
  * Bron: **Commentaar**Toelichting: Test order voor Zorgplatform en XDS ;
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: Hematocriet
  * Testuitslag: 0.41 L/L
  * Interpretatie: 
  * Onder- en bovengrens: 0.36 - 0.46 L/L
  * Materiaal: Bloed
  * Status: final
* ><: 
  * Bron: **Commentaar**Toelichting: Test order voor Zorgplatform en XDS ;
* ><: +
  * Bron: Chipsoft-Bundle2
  * Afnamedatum: 17-10-2022
  * Test: TSH
  * Testuitslag: 4.2
  * Interpretatie: 
  * Onder- en bovengrens: 0.35 - 5
  * Materiaal: Bloed
  * Status: final
* ><: 
  * Bron: **Commentaar**Toelichting: Test order voor Zorgplatform en XDS ;
* ><: +
  * Bron: Chipsoft
  * Afnamedatum: 30-9-2022
  * Test: Chloride
  * Testuitslag: 109
  * Interpretatie: Boven referentiewaarde
  * Onder- en bovengrens: 99 - 108
  * Materiaal: Serum
  * Status: final
* ><: 
  * Bron: 
* ><: +
  * Bron: Epic-Bundle
  * Afnamedatum: 20-2-2024
  * Test: INR
  * Testuitslag: 1
  * Interpretatie: 
  * Onder- en bovengrens: 0.9 - 1.1
  * Materiaal: Bloed
  * Status: final
* ><: 
  * Bron: 
* ><: +
  * Bron: Epic-Bundle
  * Afnamedatum: 20-2-2024
  * Test: INR
  * Testuitslag: 10
  * Interpretatie: Hoog
  * Onder- en bovengrens: 0.9 - 1.1
  * Materiaal: Bloed
  * Status: final
* ><: 
  * Bron: 
* ><: +
  * Bron: Epic-Bundle
  * Afnamedatum: 18-12-2023
  * Test: Kalium
  * Testuitslag: 60 mmol/L
  * Interpretatie: Kritiek
  * Onder- en bovengrens: 3.5 - 5 mmol/L
  * Materiaal: Bloed
  * Status: final
* ><: 
  * Bron: 
* ><: +
  * Bron: Epic-Bundle
  * Afnamedatum: 20-2-2024
  * Test: Sirolimus (Volbloed)
  * Testuitslag: 6 ug/L
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: Bloed
  * Status: final
* ><: 
  * Bron: 
* ><: +
  * Bron: Epic-Bundle
  * Afnamedatum: 20-2-2024
  * Test: Sirolimus (Volbloed)
  * Testuitslag: Volgt
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: Bloed
  * Status: unknown
* ><: 
  * Bron: 
* ><: +
  * Bron: Epic
  * Afnamedatum: 31-3-2022
  * Test: Chloride
  * Testuitslag: 109 mmol/L
  * Interpretatie: 
  * Onder- en bovengrens: 99 - 108 mmol/L
  * Materiaal: 
  * Status: final
* ><: 
  * Bron: 
* ><: +
  * Bron: Nexus
  * Afnamedatum: 13-3-2023
  * Test: 
  * Testuitslag: 
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: 
  * Status: final
* ><: 
  * Bron: **Toelichting materiaal**Monster bij LaboratoriumUitslag (LaboratoryTestResult) [bgz-patA-labresult2]
* ><: +
  * Bron: Sanday
  * Afnamedatum: 27-8-2025
  * Test: glucose niet nuchter, veneus (lab)
  * Testuitslag: 1 mmol/l
  * Interpretatie: 
  * Onder- en bovengrens: 3.5 - 7.8 mmol/l
  * Materiaal: 
  * Status: final
* ><: 
  * Bron: 
* ><: +
  * Bron: Sanday
  * Afnamedatum: 27-8-2025
  * Test: glucose nuchter, veneus (lab)
  * Testuitslag: 4 mmol/l
  * Interpretatie: 
  * Onder- en bovengrens: 4 - 6.1 mmol/l
  * Materiaal: 
  * Status: final
* ><: 
  * Bron: 
* ><: +
  * Bron: Sanday
  * Afnamedatum: 27-8-2025
  * Test: schildklier cytoplasma antistoffen
  * Testuitslag: 12
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: 
  * Status: final
* ><: 
  * Bron: 
* ><: +
  * Bron: Sanday
  * Afnamedatum: 27-8-2025
  * Test: vitamine D
  * Testuitslag: 23.443.00
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: 
  * Status: final
* ><: 
  * Bron: 
* ><: +
  * Bron: Sanday
  * Afnamedatum: 27-8-2025
  * Test: HbA1c (glycohemoglobine) IFCC
  * Testuitslag: 0 mmol/mol
  * Interpretatie: 
  * Onder- en bovengrens: 
  * Materiaal: 
  * Status: final
* ><: 
  * Bron: 
* ><: +
  * Bron: Epic
  * Afnamedatum: 1-7-2021
  * Test: Kalium
  * Testuitslag: 8 mmol/L
  * Interpretatie: Kritiek
  * Onder- en bovengrens: 3.5 - 5 mmol/L
  * Materiaal: 
  * Status: final
* ><: 
  * Bron: 

### Kolom Definities

* UITKLAPVELD: Bron
  * ?: `meta.extension('http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source').valueUri`
  * ?: `string`
  * ?: nvt
  * ?: Lookup adhv uri (AGB-Z of OID)`<adressering-base>/Organization?identifier=<.meta.tag.code>`en gebruik dan`Organization.name`
* UITKLAPVELD: Afnamedatum
  * ?: `specimen.resolve().collection.collectedDateTime | effectiveDateTime`
  * ?: `dateTime`
  * ?: Monster/ AfnameDatumTijd, LaboratoriumTest/ TestDatumTijd
  * ?: 
* UITKLAPVELD: Test
  * ?: `code.text | code.coding[0].display`
  * ?: `string`
  * ?: LaboratoriumTest/ TestCode
  * ?: 
* UITKLAPVELD: Testuitslag
  * ?: `valueString | valueQuantity.value.toString() + iif(valueQuantity.unit.exists(),' ' + valueQuantity.unit,'')`
  * ?: `string`
  * ?: LaboratoriumTest/ TestUitslag
  * ?: **Epic:**Indien lab-order geannuleerd, dan krijgt dit alsnog de status`Definitief`met een Testuitslag van`GEANNULEERD`. Dit is voor nu akkoord bevonden door stuurgroep Zorgviewer.
* UITKLAPVELD: Interpretatie
  * ?: `interpretation.text`
  * ?: `string`
  * ?: LaboratoriumTest/ InterpretatieVlaggen
  * ?: `AA`: uitroepteken icon, kritiek`281302008`of`H`: pijl omhoog, boven de bovengrens`281300000`of`L`: pijl naar beneden, onder de ondergrensN.B.`Resistent`,`Intermediar`en`Sensitief`vanuit de standaard zijn niet van toepassing op de klinische chemie.
* UITKLAPVELD: Onder- en bovengrens
  * ?: `referenceRange.low.value.toString() + ' - ' + referenceRange.high.value.toString() + iif(referenceRange.high.unit.exists(),' ' + referenceRange.high.unit,'')`
  * ?: `string`
  * ?: LaboratoriumTest/ReferentieOndergrens, LaboratoriumTest/ ReferentieBovengrens
  * ?: Indien`low.unit`en`high.unit`niet gelijk zijn aan elkaar toon dan`unit`bij beide.
* UITKLAPVELD: Materiaal
  * ?: `specimen.resolve().type.text`
  * ?: `string`
  * ?: Monster/ Monstermateriaal
  * ?: 
* UITKLAPVELD: Status
  * ?: `status`
  * ?: `string`
  * ?: ResultaatStatus
  * ?: **Epic:**Indien lab-order geannuleerd, dan krijgt dit alsnog de status`Definitief`met een Testuitslag van`GEANNULEERD`. Dit is voor nu akkoord bevonden door stuurgroep Zorgviewer.
* UITKLAPVELD: +Commentaar
  * ?: `comment`
  * ?: `string`
  * ?: Toelichting
  * ?: 
* UITKLAPVELD: +Toelichting materiaal
  * ?: `specimen.resolve().note.text`
  * ?: `string`
  * ?: Monster/ Toelichting
  * ?: 

### Zoeken naar codes

* [LOINC lab-uitslagen](https://terminologie.nictiz.nl/art-decor/loinc) - `system=http://loinc.org`
* [NHG Tabel 45 Diagnostische Bepalingen Labcodes](https://bepalingen.nhg.org/labcodes/determinations?q%5Bapplication_kind_cont%5D=L) `system=https://referentiemodel.nhg.org/tabellen/nhg-tabel-45-diagnostische-bepalingen`

### Request

1. Opvragen (search) laatst bekende labuitslag per type (inclusief materiaalsoort) voor een patient`GET <ontsluiten-bronsysteem-base>/Observation/$lastn?patient=<fhir_patient_id>&category=http://snomed.info/sct|275711006&_include=Observation:specimen`
1. **Sanday:**Opvragen (search) labuitslagen per type voor een patient`GET <ontsluiten-bronsysteem-base>/Observation?patient=<fhir_patient_id>&category=http://hl7.org/fhir/observation-category|laboratory`
> N.B. Alleen klinische chemie resultaten zijn op dit moment beschikbaar.

### Bronsysteem herkennen

De **Zorgviewer-backend** of **Ontsluiten bronsysteem** **MOET** na bevragen van het bronsysteem aan elk resultaat resource een meta-tag toevoegen met de AGB, OID of URA identifier van de zorgaanbieder (zie [Organization](StructureDefinition-Organization.md) voor voorbeelden). Dit wordt vervolgens gebruikt in de "Bron" kolom in de Zorgviewer-frontend. N.B. We gebruiken hier een **pre-adopt** van de FHIR R4 [Meta.source](StructureDefinition-extension-Meta.source.md).

Toevoegen aan elke response, dus per resource (bij een read) of per Bundle (bij een search):

```
"meta": {
    "extension": [ {
        "url": "http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source",
        "valueUri": "urn:oid:2.16.840.1.113883.2.4.3.8"
    } ]
}

```

**Alternatief:** Elke entry van een search response Bundle bevat een referentie naar de bijbehorende Patient (`<resource>.subject|patient`). Elke patient heeft een `Patient.managingOrganization` en in de gerefereerde `Organization.identifier` staat vervolgens o.a. de OID van het bronsysyeem. Of je gebruikt de identifiers om een volledige Organization op te zoeken in het [adresboek](zorgviewer-services.md#adressering) en zie inhoud [hier](artifacts.md#zorgviewer-services-content).

**Usages:**

* CapabilityStatements using this Profile: [Ontsluiten Bronsysteem](CapabilityStatement-OntsluitenBronsysteem.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.zorgviewer|current/StructureDefinition/LaboratoryTestResult)

**Changes since version 1.20.0:**

* The data elements list has changed

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LaboratoryTestResult.csv), [Excel](StructureDefinition-LaboratoryTestResult.xlsx), [Schematron](StructureDefinition-LaboratoryTestResult.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LaboratoryTestResult",
  "url" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/LaboratoryTestResult",
  "version" : "1.21.0",
  "name" : "LaboratoryTestResult",
  "title" : "LaboratoryTestResult",
  "status" : "active",
  "date" : "2025-10-28T13:36:22+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Laboratorium Test Uitslag",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "fhirVersion" : "3.0.2",
  "mapping" : [
    {
      "identity" : "hcim-laboratorytestresult-v4.1-2017EN",
      "uri" : "https://zibs.nl/wiki/LaboratoryTestResult-v4.1(2017EN)",
      "name" : "HCIM LaboratoryTestResult-v4.1(2017EN)"
    },
    {
      "identity" : "hcim-basicelements-v1.0-2017EN",
      "uri" : "https://zibs.nl/wiki/BasicElements-v1.0(2017EN)",
      "name" : "HCIM BasicElements-v1.0(2017EN)"
    },
    {
      "identity" : "hcim-laboratorytestresultfortransfer-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/LaboratoryTestResultForTransfer-v3.0(2016EN)",
      "name" : "HCIM LaboratoryTestResultForTransfer-v3.0(2016EN)"
    },
    {
      "identity" : "hcim-laboratorytestresultfortransfer-v1.2.2-2015EN",
      "uri" : "https://zibs.nl/wiki/LaboratoryTestResultForTransfer-v1.2.2(2015EN)",
      "name" : "HCIM LaboratoryTestResultForTransfer-v1.2.2(2015EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/zib-LaboratoryTestResult-Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation"
      },
      {
        "id" : "Observation.status",
        "path" : "Observation.status",
        "mustSupport" : true
      },
      {
        "id" : "Observation.code.coding.display",
        "path" : "Observation.code.coding.display",
        "mustSupport" : true
      },
      {
        "id" : "Observation.code.text",
        "path" : "Observation.code.text",
        "mustSupport" : true
      },
      {
        "id" : "Observation.effectiveDateTime",
        "path" : "Observation.effectiveDateTime",
        "mustSupport" : true
      },
      {
        "id" : "Observation.valueQuantity",
        "path" : "Observation.valueQuantity",
        "mustSupport" : true
      },
      {
        "id" : "Observation.valueQuantity.value",
        "path" : "Observation.valueQuantity.value",
        "mustSupport" : true
      },
      {
        "id" : "Observation.valueQuantity.unit",
        "path" : "Observation.valueQuantity.unit",
        "mustSupport" : true
      },
      {
        "id" : "Observation.interpretation.coding.code",
        "path" : "Observation.interpretation.coding.code",
        "mustSupport" : true
      },
      {
        "id" : "Observation.interpretation.text",
        "path" : "Observation.interpretation.text",
        "mustSupport" : true
      },
      {
        "id" : "Observation.specimen",
        "path" : "Observation.specimen",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Specimen"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.referenceRange.low.value",
        "path" : "Observation.referenceRange.low.value",
        "mustSupport" : true
      },
      {
        "id" : "Observation.referenceRange.low.unit",
        "path" : "Observation.referenceRange.low.unit",
        "mustSupport" : true
      },
      {
        "id" : "Observation.referenceRange.high.value",
        "path" : "Observation.referenceRange.high.value",
        "mustSupport" : true
      },
      {
        "id" : "Observation.referenceRange.high.unit",
        "path" : "Observation.referenceRange.high.unit",
        "mustSupport" : true
      }
    ]
  }
}

```
