# Encounter - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Encounter**

## Resource Profile: Encounter 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/StructureDefinition/Encounter | *Version*:1.21.0 |
| Draft as of 2025-10-28 | *Computable Name*:Encounter |

 
Contact 

> Dit Profiel is het resultaat van de vergelijking tussen de zib2017 FHIR Profiel en de implementaties in Epic, Chipsoft, Topicus en Nexus. De elementen die in ieder geval in alle output beschikbaar zullen zijn. Voornamelijk bedoeld voor houvast van een client en voor validatie van output.

### Zorginformatiebouwsteen

[ZIB Contact](https://zibs.nl/wiki/Contact-v3.1(2017NL))

### View Definition

[ViewDefinition voor Encounter](ViewDefinition-Encounter.json)

### UI Wireframe

**Contacten**

* ><: +
  * Bron: Chipsoft
  * Begin: 14-8-2012
  * Eind: 15-8-2012
  * Met: J.H.R Peters
  * Rol: Onbekende functiecode.
  * Locatie: 
  * Status: finished
  * Type: inpatient
* ><: 
  * Bron: 
* ><: +
  * Bron: Epic
  * Begin: 27-3-2025
  * Eind: 27-3-2025
  * Met: E. Sieders, Chirurg
  * Rol: 
  * Locatie: UMCG HC
  * Status: unknown
  * Type: Inpatient Encounter
* ><: 
  * Bron: 
* ><: +
  * Bron: Nexus
  * Begin: 16-8-2012
  * Eind: 19-8-2012
  * Met: Wit
  * Rol: Orthopedie
  * Locatie: 
  * Status: finished
  * Type: Klinisch
* ><: 
  * Bron: 

### Kolom Definities

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| Bron | `meta.extension('http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source').valueUri` | `string` | nvt | Lookup adhv uri (AGB-Z of OID)`<adressering-base>/Organization?identifier=<.meta.tag.code>`en gebruik dan`Organization.name` |
| Begin | `period.start` | `dateTime` | BeginDatumTijd |  |
| Eind | `period.end` | `dateTime` | EindDatumTijd |  |
| Met | `participant.individual.display` | `string` | ContactMet::Zorgverlener |  |
| Rol | `participant.individual.extension('http://nictiz.nl/fhir/StructureDefinition/practitionerrole-reference').valueReference.display` | `string` | nvt |  |
| Locatie | `location.location.display` | `string` | Locatie::Zorgaanbieder |  |
| Status | `status` | `code` | nvt |  |
| Type | `class.display` | `code` | ContactType |  |

### Request

1. Opvragen (search) contacten inclusief ziekenhuis opnames`GET <ontsluiten-bronsysteem-base>/Encounter?class=http://hl7.org/fhir/v3/ActCode|IMP,http://hl7.org/fhir/v3/ActCode|ACUTE,http://hl7.org/fhir/v3/ActCode|NONAC`

### Bronsysteem herkennen

De **Zorgviewer-backend** of **Ontsluiten bronsysteem** **MOET** na bevragen van het bronsysteem aan elk resultaat resource een meta-tag toevoegen met de AGB, OID of URA identifier van de zorgaanbieder (zie [Organization](StructureDefinition-Organization.md) voor voorbeelden). Dit wordt vervolgens gebruikt in de "Bron" kolom in de Zorgviewer-frontend. N.B. We gebruiken hier een **pre-adopt** van de FHIR R4 [Meta.source](StructureDefinition-extension-Meta.source.md).

Toevoegen aan elke response, dus per resource (bij een read) of per Bundle (bij een search):

```
"meta": {
    "extension": [ {
        "url": "http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source",
        "valueUri": "urn:oid:2.16.840.1.113883.2.4.3.8"
    } ]
}

```

**Alternatief:** Elke entry van een search response Bundle bevat een referentie naar de bijbehorende Patient (`<resource>.subject|patient`). Elke patient heeft een `Patient.managingOrganization` en in de gerefereerde `Organization.identifier` staat vervolgens o.a. de OID van het bronsysyeem. Of je gebruikt de identifiers om een volledige Organization op te zoeken in het [adresboek](zorgviewer-services.md#adressering) en zie inhoud [hier](artifacts.md#zorgviewer-services-content).

**Usages:**

* CapabilityStatements using this Profile: [Ontsluiten Bronsysteem](CapabilityStatement-OntsluitenBronsysteem.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.zorgviewer|current/StructureDefinition/Encounter)

**Changes since version 1.20.0:**

* No changes

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Encounter.csv), [Excel](StructureDefinition-Encounter.xlsx), [Schematron](StructureDefinition-Encounter.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Encounter",
  "url" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Encounter",
  "version" : "1.21.0",
  "name" : "Encounter",
  "title" : "Encounter",
  "status" : "draft",
  "date" : "2025-10-28T13:36:22+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Contact",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "fhirVersion" : "3.0.2",
  "mapping" : [
    {
      "identity" : "hcim-encounter-v3.1-2017EN",
      "uri" : "https://zibs.nl/wiki/Encounter-v3.1(2017EN)",
      "name" : "HCIM Encounter-v3.1(2017EN)"
    },
    {
      "identity" : "hcim-healthprofessional-v3.2-2017EN",
      "uri" : "https://zibs.nl/wiki/HealthProfessional-v3.2(2017EN)",
      "name" : "HCIM HealthProfessional-v3.2(2017EN)"
    },
    {
      "identity" : "hcim-basicelements-v1.0-2017EN",
      "uri" : "https://zibs.nl/wiki/BasicElements-v1.0(2017EN)",
      "name" : "HCIM BasicElements-v1.0(2017EN)"
    },
    {
      "identity" : "hcim-encounter-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/Encounter-v3.0(2016EN)",
      "name" : "HCIM Encounter-v3.0(2016EN)"
    },
    {
      "identity" : "hcim-healthprofessional-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/HealthProfessional-v3.0(2016EN)",
      "name" : "HCIM HealthProfessional-v3.0(2016EN)"
    },
    {
      "identity" : "hcim-encounter-v1.2-2015EN",
      "uri" : "https://zibs.nl/wiki/Encounter-v1.2(2015EN)",
      "name" : "HCIM Encounter-v1.2(2015EN)"
    },
    {
      "identity" : "hcim-healthprofessional-v1.2.1-2015EN",
      "uri" : "https://zibs.nl/wiki/HealthProfessional-v1.2.1(2015EN)",
      "name" : "HCIM HealthProfessional-v1.2.1(2015EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Encounter",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/zib-Encounter",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Encounter",
        "path" : "Encounter"
      }
    ]
  }
}

```
