# Appointment - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Appointment**

## Resource Profile: Appointment 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/StructureDefinition/Appointment | *Version*:1.21.0 |
| Draft as of 2025-10-28 | *Computable Name*:Appointment |

 
Afspraak 

> Dit Profiel is het resultaat van de vergelijking tussen de zib2017 FHIR Profiel en de implementaties in Epic, Chipsoft, Topicus en Nexus. De elementen die in ieder geval in alle output beschikbaar zullen zijn. Voornamelijk bedoeld voor houvast van een client en voor validatie van output.

### Zorginformatiebouwsteen

[ZIB Contact](https://zibs.nl/wiki/Contact-v3.1(2017NL))

### View Definition

[ViewDefinition voor Appointment](ViewDefinition-Appointment.json)

### UI Wireframe

**Afspraken**

* ><: +
  * Bron: Chipsoft
  * Begin: 12-10-2022
  * Eind: 12-10-2022
  * Met: 
  * Locatie: Ziekenhuis Apotheek
  * Status: pending
  * Type: Ambulatory
* ><: 
  * Bron: 
* ><: +
  * Bron: Epic
  * Begin: 20-4-2018
  * Eind: 20-4-2018
  * Met: G. Dijkstra, MDL arts
  * Locatie: Maag- Darm- Leverziekten
  * Status: pending
  * Type: Ambulatory
* ><: 
  * Bron: 

### Kolom Definities

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| Bron | `meta.extension('http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source').valueUri` | `string` | nvt | Lookup adhv uri (AGB-Z of OID)`<adressering-base>/Organization?identifier=<.meta.tag.code>`en gebruik dan`Organization.name` |
| Begin | `start` | `dateTime` | BeginDatumTijd |  |
| Eind | `end` | `dateTime` | EindDatumTijd |  |
| Met | `participant.where(actor.reference.contains('Practitioner/'))[0].actor.display` | `string` | ContactMet::Zorgverlener |  |
| Locatie | `participant.where(actor.reference.contains('Location/'))[0].actor.display` | `string` | Locatie::Zorgaanbieder |  |
| Status | `status` | `code` | nvt |  |
| Type | `appointmentType.coding.display` | `code` | ContactType |  |

### Request

1. Opvragen (search) afspraken`GET <ontsluiten-bronsysteem-base>/Appointment?status=booked,pending,proposed`

### Bronsysteem herkennen

De **Zorgviewer-backend** of **Ontsluiten bronsysteem** **MOET** na bevragen van het bronsysteem aan elk resultaat resource een meta-tag toevoegen met de AGB, OID of URA identifier van de zorgaanbieder (zie [Organization](StructureDefinition-Organization.md) voor voorbeelden). Dit wordt vervolgens gebruikt in de "Bron" kolom in de Zorgviewer-frontend. N.B. We gebruiken hier een **pre-adopt** van de FHIR R4 [Meta.source](StructureDefinition-extension-Meta.source.md).

Toevoegen aan elke response, dus per resource (bij een read) of per Bundle (bij een search):

```
"meta": {
    "extension": [ {
        "url": "http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source",
        "valueUri": "urn:oid:2.16.840.1.113883.2.4.3.8"
    } ]
}

```

**Alternatief:** Elke entry van een search response Bundle bevat een referentie naar de bijbehorende Patient (`<resource>.subject|patient`). Elke patient heeft een `Patient.managingOrganization` en in de gerefereerde `Organization.identifier` staat vervolgens o.a. de OID van het bronsysyeem. Of je gebruikt de identifiers om een volledige Organization op te zoeken in het [adresboek](zorgviewer-services.md#adressering) en zie inhoud [hier](artifacts.md#zorgviewer-services-content).

**Usages:**

* CapabilityStatements using this Profile: [Ontsluiten Bronsysteem](CapabilityStatement-OntsluitenBronsysteem.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.zorgviewer|current/StructureDefinition/Appointment)

**Changes since version 1.20.0:**

* No changes

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Appointment.csv), [Excel](StructureDefinition-Appointment.xlsx), [Schematron](StructureDefinition-Appointment.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Appointment",
  "url" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Appointment",
  "version" : "1.21.0",
  "name" : "Appointment",
  "title" : "Appointment",
  "status" : "draft",
  "date" : "2025-10-28T13:36:22+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Afspraak",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "fhirVersion" : "3.0.2",
  "mapping" : [
    {
      "identity" : "art-decor-eafspraak",
      "uri" : "https://decor.nictiz.nl/art-decor/decor-datasets--eafspraken-?id=2.16.840.1.113883.2.4.3.11.60.61.1.1&effectiveDate=2017-08-01T00:00:00&language=nl-NL",
      "name" : "ART-DECOR Dataset eAfspraak"
    },
    {
      "identity" : "hcim-plannedcareactivityfortransfer-v1.2.1-2015EN",
      "uri" : "https://zibs.nl/wiki/PlannedCareActivityForTransfer-v1.2.1(2015EN)",
      "name" : "HCIM PlannedCareActivityForTransfer-v1.2.1(2015EN)"
    },
    {
      "identity" : "hcim-plannedcareactivityfortransfer-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/PlannedCareActivityForTransfer-v3.0(2016EN)",
      "name" : "HCIM PlannedCareActivityForTransfer-v3.0(2016EN)"
    },
    {
      "identity" : "hcim-plannedcareactivityfortransfer-v3.1-2017EN",
      "uri" : "https://zibs.nl/wiki/PlannedCareActivityForTransfer-v3.1(2017EN)",
      "name" : "HCIM PlannedCareActivityForTransfer-v3.1(2017EN)"
    },
    {
      "identity" : "hcim-healthprofessional-v1.2.1-2015EN",
      "uri" : "https://zibs.nl/wiki/HealthProfessional-v1.2.1(2015EN)",
      "name" : "HCIM HealthProfessional-v1.2.1(2015EN)"
    },
    {
      "identity" : "hcim-healthprofessional-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/HealthProfessional-v3.0(2016EN)",
      "name" : "HCIM HealthProfessional-v3.0(2016EN)"
    },
    {
      "identity" : "hcim-healthprofessional-v3.2-2017EN",
      "uri" : "https://zibs.nl/wiki/HealthProfessional-v3.2(2017EN)",
      "name" : "HCIM HealthProfessional-v3.2(2017EN)"
    },
    {
      "identity" : "hcim-basicelements-v1.0-2017EN",
      "uri" : "https://zibs.nl/wiki/BasicElements-v1.0(2017EN)",
      "name" : "HCIM BasicElements-v1.0(2017EN)"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "ical",
      "uri" : "http://www.ietf.org/rfc/rfc2445.txt",
      "name" : "iCalendar"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/w5",
      "name" : "W5 Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Appointment",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/eAfspraak-Appointment",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Appointment",
        "path" : "Appointment"
      }
    ]
  }
}

```
