# AdvanceDirective - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AdvanceDirective**

## Resource Profile: AdvanceDirective 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/StructureDefinition/AdvanceDirective | *Version*:1.21.0 |
| Active as of 2025-10-28 | *Computable Name*:AdvanceDirective |

 
Wilsverklaring (Consent) 

> Dit Profiel is het resultaat van de vergelijking tussen de zib2017 FHIR Profiel en de implementaties in Epic, Chipsoft, Topicus en Nexus. De elementen die in ieder geval in alle output beschikbaar zullen zijn. Voornamelijk bedoeld voor houvast van een client en voor validatie van output.

### Zorginformatiebouwsteen

[ZIB Wilsverklaring](https://zibs.nl/wiki/Wilsverklaring-v3.1(2017NL))

### View Definition

[ViewDefinition voor Wilsbeschikkingen](ViewDefinition-Wilsbeschikkingen.json)

### UI Wireframe

**Wilsbeschikkingen**

* ><: +
  * Bron: Chipsoft-Bundle
  * Datum: 28-6-2019
  * Type: Patiëntinformatie - Wilsbeschikkingen
  * Toelichting: 
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft
  * Datum: 9-4-2018
  * Type: Patiëntinformatie - Wilsbeschikkingen
  * Toelichting: Niet-reanimerenpenning
* ><: 
  * Bron: 
* ><: +
  * Bron: Epic
  * Datum: 30-6-2022
  * Type: Niet reanimeren verklaring
  * Toelichting: Wilsverklaring
* ><: 
  * Bron: 
* ><: +
  * Bron: Nexus
  * Datum: 9-4-2018
  * Type: volmacht
  * Toelichting: Niet-reanimerenpenning
* ><: 
  * Bron: 
* ><: +
  * Bron: Epic
  * Datum: 12-10-2021
  * Type: Niet reanimeren verklaring
  * Toelichting: Definitieve versie handreiking rechtmatigheidscontroles MSZ 2014 versie 2.0.pdf
* ><: 
  * Bron: 

### Kolom Definities

* UITKLAPVELD: Bron
  * ?: `meta.extension('http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source').valueUri`
  * ?: `string`
  * ?: nvt
  * ?: Lookup adhv uri (AGB-Z of OID)`<adressering-base>/Organization?identifier=<.meta.tag.code>`en gebruik dan`Organization.name`
* UITKLAPVELD: Datum
  * ?: `dateTime`
  * ?: `dateTime`
  * ?: WilsverklaringDatum
  * ?: Kunnen vage datums zijn
* UITKLAPVELD: Type
  * ?: `category[1].text | category[1].coding.display`
  * ?: `string`
  * ?: WilsverklaringType
  * ?: 
* UITKLAPVELD: Toelichting
  * ?: `extension('http://nictiz.nl/fhir/StructureDefinition/Comment').valueString`
  * ?: `string`
  * ?: Toelichting
  * ?: 
* UITKLAPVELD: +Document
  * ?: `sourceAttachement.data`
  * ?: `base64Binary`
  * ?: WilsverklaringDocument
  * ?: 

### Request

1. Opvragen (search) wilsbeschikkingen`GET <ontsluiten-bronsysteem-base>/Consent?patient=<fhir_patient_id>&category=http://snomed.info/sct|11341000146107`

### Bronsysteem herkennen

De **Zorgviewer-backend** of **Ontsluiten bronsysteem** **MOET** na bevragen van het bronsysteem aan elk resultaat resource een meta-tag toevoegen met de AGB, OID of URA identifier van de zorgaanbieder (zie [Organization](StructureDefinition-Organization.md) voor voorbeelden). Dit wordt vervolgens gebruikt in de "Bron" kolom in de Zorgviewer-frontend. N.B. We gebruiken hier een **pre-adopt** van de FHIR R4 [Meta.source](StructureDefinition-extension-Meta.source.md).

Toevoegen aan elke response, dus per resource (bij een read) of per Bundle (bij een search):

```
"meta": {
    "extension": [ {
        "url": "http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source",
        "valueUri": "urn:oid:2.16.840.1.113883.2.4.3.8"
    } ]
}

```

**Alternatief:** Elke entry van een search response Bundle bevat een referentie naar de bijbehorende Patient (`<resource>.subject|patient`). Elke patient heeft een `Patient.managingOrganization` en in de gerefereerde `Organization.identifier` staat vervolgens o.a. de OID van het bronsysyeem. Of je gebruikt de identifiers om een volledige Organization op te zoeken in het [adresboek](zorgviewer-services.md#adressering) en zie inhoud [hier](artifacts.md#zorgviewer-services-content).

**Usages:**

* CapabilityStatements using this Profile: [Ontsluiten Bronsysteem](CapabilityStatement-OntsluitenBronsysteem.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.zorgviewer|current/StructureDefinition/AdvanceDirective)

**Changes since version 1.20.0:**

* New Content

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-AdvanceDirective.csv), [Excel](StructureDefinition-AdvanceDirective.xlsx), [Schematron](StructureDefinition-AdvanceDirective.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "AdvanceDirective",
  "url" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/AdvanceDirective",
  "version" : "1.21.0",
  "name" : "AdvanceDirective",
  "title" : "AdvanceDirective",
  "status" : "active",
  "date" : "2025-10-28T13:36:22+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Wilsverklaring (Consent)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "fhirVersion" : "3.0.2",
  "mapping" : [
    {
      "identity" : "hcim-advancedirective-v3.1-2017EN",
      "uri" : "https://zibs.nl/wiki/AdvanceDirective-v3.1(2017EN)",
      "name" : "HCIM AdvanceDirective-v3.1(2017EN)"
    },
    {
      "identity" : "hcim-basicelements-v1.0-2017EN",
      "uri" : "https://zibs.nl/wiki/BasicElements-v1.0(2017EN)",
      "name" : "HCIM BasicElements-v1.0(2017EN)"
    },
    {
      "identity" : "hcim-advancedirective-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/AdvanceDirective-v3.0(2016EN)",
      "name" : "HCIM AdvanceDirective-v3.0(2016EN)"
    },
    {
      "identity" : "hcim-advancedirective-v1.0-2015EN",
      "uri" : "https://zibs.nl/wiki/AdvanceDirective-v1.0(2015EN)",
      "name" : "HCIM AdvanceDirective-v1.0(2015EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Consent",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/zib-AdvanceDirective",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Consent",
        "path" : "Consent"
      },
      {
        "id" : "Consent.extension:comment",
        "path" : "Consent.extension",
        "sliceName" : "comment",
        "mustSupport" : true
      },
      {
        "id" : "Consent.category:typeOfLivingWill",
        "path" : "Consent.category",
        "sliceName" : "typeOfLivingWill",
        "mustSupport" : true
      },
      {
        "id" : "Consent.dateTime",
        "path" : "Consent.dateTime",
        "mustSupport" : true
      },
      {
        "id" : "Consent.sourceAttachment",
        "path" : "Consent.sourceAttachment",
        "mustSupport" : true
      },
      {
        "id" : "Consent.sourceAttachment.data",
        "path" : "Consent.sourceAttachment.data",
        "mustSupport" : true
      }
    ]
  }
}

```
