# Chipsoft Procedure Example - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Chipsoft Procedure Example**

## Example Procedure: Chipsoft Procedure Example

Profile: [HCIM Procedure](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.zib2017@2.3.1&canonical=http://nictiz.nl/fhir/StructureDefinition/zib-Procedure)

**identifier**: `urn:oid:2.16.840.1.113883.2.4.3.124.7.47519.4`/1230000001716

**status**: Unknown

**category**: Surgical procedure

**code**: implantatie van totale knieprothese

**subject**: [Johan XXX_Helleman_Afblijven](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&canonical=http://example.org/Patient/9819C39260647B5DE61609CDF1FA1C434552D65014AFDEA2EB877A576B055DF1)

**performed**: 2012-06-05 --> 2012-06-05

### Performers

| | |
| :--- | :--- |
| - | **Actor** |
| * | [Lisette van Cruijningen de Winter](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&canonical=http://example.org/Practitioner/571250c2-7121-479a-827d-59f6d7b55532) |

**location**: [Drachten](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&canonical=http://example.org/Location/2.16.528.1.1007.3.300002729)

**bodySite**: Knee region structure (body structure)

**note**: 

> 

Implantant, Gen 2 Tibia Insert 5/6-9mm


### FocalDevices

| | |
| :--- | :--- |
| - | **Manipulated** |
| * | [1101010000000505047453079901](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&canonical=http://example.org/Device/14acb649-b79e-4568-b31f-629eada91c9e) |



## Resource Content

```json
{
  "resourceType" : "Procedure",
  "id" : "2.16.840.1.113883.2.4.3.124.7.47519.41230000001716",
  "meta" : {
    "profile" : ["http://nictiz.nl/fhir/StructureDefinition/zib-Procedure"]
  },
  "identifier" : [
    {
      "system" : "urn:oid:2.16.840.1.113883.2.4.3.124.7.47519.4",
      "value" : "1230000001716"
    }
  ],
  "status" : "unknown",
  "category" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "387713003",
        "display" : "Surgical procedure"
      }
    ]
  },
  "code" : {
    "coding" : [
      {
        "system" : "urn:oid:2.16.840.1.113883.2.4.3.120.5.3",
        "code" : "00090991",
        "display" : "implantatie van totale knieprothese"
      }
    ],
    "text" : "implantatie van totale knieprothese"
  },
  "subject" : {
    "reference" : "http://example.org/Patient/9819C39260647B5DE61609CDF1FA1C434552D65014AFDEA2EB877A576B055DF1",
    "display" : "Johan XXX_Helleman_Afblijven"
  },
  "performedPeriod" : {
    "start" : "2012-06-05",
    "end" : "2012-06-05"
  },
  "performer" : [
    {
      "actor" : {
        "extension" : [
          {
            "url" : "http://nictiz.nl/fhir/StructureDefinition/practitionerrole-reference",
            "valueReference" : {
              "reference" : "http://example.org/PractitionerRole/A5F5EBBAA991DCD91820C4392F9C21F478703FEFC0AFB9CFF5DFF60CC05FDE70",
              "display" : "Onbekende functiecode."
            }
          }
        ],
        "reference" : "http://example.org/Practitioner/571250c2-7121-479a-827d-59f6d7b55532",
        "display" : "Lisette van Cruijningen de Winter"
      }
    }
  ],
  "location" : {
    "reference" : "http://example.org/Location/2.16.528.1.1007.3.300002729",
    "display" : "Drachten"
  },
  "bodySite" : [
    {
      "extension" : [
        {
          "url" : "http://nictiz.nl/fhir/StructureDefinition/BodySite-Qualifier",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "7771000",
                "display" : "Left"
              }
            ],
            "text" : "Links"
          }
        }
      ],
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "72696002",
          "display" : "Knee region structure (body structure)"
        }
      ],
      "text" : "Knee region structure (body structure)"
    }
  ],
  "note" : [
    {
      "text" : "Implantant, Gen 2 Tibia Insert 5/6-9mm"
    }
  ],
  "focalDevice" : [
    {
      "manipulated" : {
        "reference" : "http://example.org/Device/14acb649-b79e-4568-b31f-629eada91c9e",
        "display" : "1101010000000505047453079901"
      }
    }
  ]
}

```
