# Chipsoft Practitioner Example - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Chipsoft Practitioner Example**

## Example Practitioner: Chipsoft Practitioner Example

### Practitioner resource:

* **Identification:** ' 2.16.840.1.113883.2.4.6.1, 03123456'
* **Name:** 'Lisette (L.) van Cruijningen de Winter'
* **Phone number:** '+3120'
* **Address** 'Tt.Melissaweg 1033SP Amsterdam (AMSTERDAM)'



## Resource Content

```json
{
  "resourceType" : "Practitioner",
  "id" : "b5160776-43dc-43e1-9bb7-a6e3edf8e63d",
  "meta" : {
    "profile" : [
      "http://fhir.nl/fhir/StructureDefinition/nl-core-practitioner"
    ]
  },
  "identifier" : [
    {
      "system" : "http://fhir.nl/fhir/NamingSystem/agb-z",
      "value" : "03123456"
    }
  ],
  "name" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/humanname-assembly-order",
          "valueCode" : "NL4"
        }
      ],
      "family" : "van Cruijningen de Winter",
      "_family" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/humanname-own-prefix",
            "valueString" : "van"
          },
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/humanname-own-name",
            "valueString" : "Cruijningen"
          },
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/humanname-partner-prefix",
            "valueString" : "de"
          },
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/humanname-partner-name",
            "valueString" : "Winter"
          }
        ]
      },
      "given" : ["Lisette", "L."],
      "_given" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-EN-qualifier",
              "valueCode" : "CL"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-EN-qualifier",
              "valueCode" : "IN"
            }
          ]
        }
      ]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+3120",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "extension" : [
        {
          "url" : "http://nictiz.nl/fhir/StructureDefinition/zib-AddressInformation-AddressType",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/v3/AddressUse",
                "code" : "DIR",
                "display" : "Work Place"
              }
            ],
            "text" : "Work Place"
          }
        }
      ],
      "use" : "work",
      "line" : ["Tt.Melissaweg"],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "Tt.Melissaweg"
            }
          ]
        }
      ],
      "city" : "Amsterdam",
      "district" : "AMSTERDAM",
      "postalCode" : "1033SP"
    }
  ]
}

```
