# Epic DocumentReference Example - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Epic DocumentReference Example**

## Example DocumentReference: Epic DocumentReference Example

**masterIdentifier**: `urn:oid:1.2.840.114350.1.13.485.2.7.6.698084.19749`/Z1384252^55437.99^A0

**identifier**: `urn:oid:1.2.840.114350.1.13.485.2.7.2.727879`/269312157

**status**: Current

**docStatus**: Final

**type**: Patiëntenbrief

**class**: Correspondence

**subject**: [Fictief, Jan](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&canonical=https:///example.org/Patient/e52TXUJRLVxP2kvdXvNgS7euM1.HY8bVBMNNhsLwftTo3)

**created**: 2021-12-15 09:42:11+0000

**indexed**: 2021-12-15 09:42:11+0000

**author**: [G Boer](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&canonical=https://example.org/Practitioner/ec6Rbm68P1PUCdhJhmzP0Jg-DOxJbgJDmPpildGhow943)

**description**: Patiëntenbrief

> **content**

### Attachments

| | | |
| :--- | :--- | :--- |
| - | **ContentType** | **Url** |
| * | application/pdf | [https://example.org/Binary/H6MxvY5-Q6bvzVSBsmNKpOld.Wwpzbc3P0Wj3zdD-lGov.W-bA1q9NpIp1RSdgAg](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&canonical=https://example.org/Binary/H6MxvY5-Q6bvzVSBsmNKpOld.Wwpzbc3P0Wj3zdD-lGov.W-bA1q9NpIp1RSdgAg) |


### Contexts

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Encounter** | **Period** | **PracticeSetting** |
| * | Brief (uit) (Identifier:`urn:oid:1.2.840.114350.1.13.485.2.7.3.698084.8`/1043087869 (use: usual, )) | 2021-12-15 09:36:00+0000 --> (ongoing) | KGA - Genetica |



## Resource Content

```json
{
  "resourceType" : "DocumentReference",
  "id" : "esCkfE4Gs407F39oUa3nrshNutfUhGSpc-H0LDMIXXub1sTx6eyOBq4OITaxvXRi",
  "masterIdentifier" : {
    "system" : "urn:oid:1.2.840.114350.1.13.485.2.7.6.698084.19749",
    "value" : "Z1384252^55437.99^A0"
  },
  "identifier" : [
    {
      "system" : "urn:oid:1.2.840.114350.1.13.485.2.7.2.727879",
      "value" : "269312157"
    }
  ],
  "status" : "current",
  "docStatus" : "final",
  "type" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "56444-3",
        "display" : "Healthcare communication Document"
      },
      {
        "system" : "urn:oid:1.2.840.114350.1.13.485.2.7.10.698084.20208",
        "code" : "2101200003",
        "display" : "Patiëntenbrief"
      }
    ],
    "text" : "Patiëntenbrief"
  },
  "class" : {
    "coding" : [
      {
        "system" : "http://open.epic.com/FHIR/StructureDefinition/document-reference-class",
        "code" : "correspondence",
        "display" : "Correspondence"
      }
    ],
    "text" : "Correspondence"
  },
  "subject" : {
    "reference" : "https:///example.org/Patient/e52TXUJRLVxP2kvdXvNgS7euM1.HY8bVBMNNhsLwftTo3",
    "display" : "Fictief, Jan"
  },
  "created" : "2021-12-15T09:42:11Z",
  "indexed" : "2021-12-15T09:42:11Z",
  "author" : [
    {
      "reference" : "https://example.org/Practitioner/ec6Rbm68P1PUCdhJhmzP0Jg-DOxJbgJDmPpildGhow943",
      "display" : "G Boer"
    }
  ],
  "description" : "Patiëntenbrief",
  "content" : [
    {
      "attachment" : {
        "contentType" : "application/pdf",
        "url" : "https://example.org/Binary/H6MxvY5-Q6bvzVSBsmNKpOld.Wwpzbc3P0Wj3zdD-lGov.W-bA1q9NpIp1RSdgAg"
      }
    }
  ],
  "context" : {
    "encounter" : {
      "identifier" : {
        "use" : "usual",
        "system" : "urn:oid:1.2.840.114350.1.13.485.2.7.3.698084.8",
        "value" : "1043087869"
      },
      "display" : "Brief (uit)"
    },
    "period" : {
      "start" : "2021-12-15T09:36:00Z"
    },
    "practiceSetting" : {
      "coding" : [
        {
          "system" : "urn:oid:1.2.840.114350.1.13.485.2.7.10.727879.59",
          "code" : "039000",
          "display" : "KGA - Genetica"
        }
      ],
      "text" : "KGA - Genetica"
    }
  }
}

```
