# Nexus TreatmentDirective Example - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Nexus TreatmentDirective Example**

## Example Consent: Nexus TreatmentDirective Example

* Consent Period: testje
* Consent Period: Created
  * FromNoTo 5 May 2023: 11:40:11, 9 April 2018
* Consent Period: Verified
  * FromNoTo 5 May 2023: boolean-true - 5 May 2023 -Gevolmachtigde
* Consent Period: Kunstmatige beademing
  * FromNoTo 5 May 2023: Behandeling niet toegestaan en/of wenselijk



## Resource Content

```json
{
  "resourceType" : "Consent",
  "id" : "21",
  "meta" : {
    "lastUpdated" : "2024-04-17T10:04:24.612+02:00",
    "profile" : [
      "http://nictiz.nl/fhir/StructureDefinition/zib-TreatmentDirective"
    ]
  },
  "extension" : [
    {
      "extension" : [
        {
          "url" : "Verified",
          "valueBoolean" : true
        },
        {
          "url" : "VerifiedWith",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "8601000146109",
                "display" : "Gevolmachtigde"
              }
            ]
          }
        },
        {
          "url" : "VerificationDate",
          "valueDateTime" : "2023-05-05"
        }
      ],
      "url" : "http://nictiz.nl/fhir/StructureDefinition/zib-TreatmentDirective-Verification"
    },
    {
      "url" : "http://nictiz.nl/fhir/StructureDefinition/Comment",
      "valueString" : "testje"
    },
    {
      "url" : "http://nictiz.nl/fhir/StructureDefinition/zib-TreatmentDirective-Treatment",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "40617009",
            "display" : "Kunstmatige beademing"
          }
        ]
      }
    }
  ],
  "modifierExtension" : [
    {
      "url" : "http://nictiz.nl/fhir/StructureDefinition/zib-TreatmentDirective-TreatmentPermitted",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:oid:2.16.840.1.113883.2.4.3.11.60.40.4",
            "code" : "NEE",
            "display" : "Behandeling niet toegestaan en/of wenselijk"
          }
        ]
      }
    }
  ],
  "identifier" : {
    "system" : "urn:ietf:rfc:3986",
    "value" : "urn:oid:2.16.840.1.113883.2.4.3.148.1.1.6.6.21"
  },
  "status" : "active",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "11291000146105",
          "display" : "Behandelingsinstructies (artefact opnemen)"
        }
      ]
    }
  ],
  "patient" : {
    "reference" : "Patient/330073",
    "display" : "Xxx-Helleman, J (M)"
  },
  "period" : {
    "start" : "2023-05-05"
  },
  "dateTime" : "2018-04-09T11:40:11+02:00",
  "policy" : [
    {
      "uri" : "http://wetten.overheid.nl/"
    }
  ]
}

```
