# Toestemming - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Toestemming**

## CapabilityStatement: Toestemming 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/CapabilityStatement/Toestemming | *Version*:1.21.0 |
| Active as of 2023-09-04 | *Computable Name*:Toestemming |
| **Copyright/Legal**: CC0 | |

 
Deze CapabilityStatement beschrijft de minimale requirements voor het Toestemming en Adressering Bouwblok. 

 [Raw OpenAPI-Swagger Definition file](Toestemming.openapi.json) | [Download](Toestemming.openapi.json) 

## Toestemming

* Implementation Guide Version: 1.21.0 
* FHIR Version: 3.0.2 
* Supported Formats: `xml`, `json`
* Published on: 2023-09-04 
* Published by: RIVO-NN HL7NL 

> **Note to Implementers: FHIR Capabilities**Any FHIR capability may be 'allowed' by the system unless explicitly marked as 'SHALL NOT'. A few items are marked as MAY in the Implementation Guide to highlight their potential relevance to the use case.

## FHIR RESTful Capabilities

### Mode: server

### Capabilities by Resource/Profile

#### Summary

The summary table lists the resources that are part of this configuration, and for each resource it lists:

* The relevant profiles (if any)
* The interactions supported by each resource (**R**ead, **S**earch, **U**pdate, and **C**reate, are always shown, while **VR**ead, **P**atch, **D**elete, **H**istory on **I**nstance, or **H**istory on **T**ype are only present if at least one of the resources has support for them.
* The required, recommended, and some optional search parameters (if any).
* The linked resources enabled for `_include`
* The other resources enabled for `_revinclude`
* The operations on the resource (if any)

| | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [Consent](#Consent1-1) | [http://fhir.hl7.nl/zorgviewer/StructureDefinition/ToestemmingConsent](StructureDefinition-ToestemmingConsent.md) |  | **Y** |  |  |  |  |  |  |
| [Organization](#Organization1-2) | [http://fhir.hl7.nl/zorgviewer/StructureDefinition/Organization](StructureDefinition-Organization.md) | **Y** |  |  |  |  |  |  |  |
| [Endpoint](#Endpoint1-3) | [http://fhir.hl7.nl/zorgviewer/StructureDefinition/Endpoint](StructureDefinition-Endpoint.md) | **Y** |  |  |  |  |  |  |  |

-------

#### Resource Conformance: SHALL Consent

Base System Profile

[ToestemmingConsent](StructureDefinition-ToestemmingConsent.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* **SHALL** support `search-type`.

#### Resource Conformance: SHALL Organization

Base System Profile

[Organization](StructureDefinition-Organization.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* **SHALL** support `read`.

#### Resource Conformance: SHALL Endpoint

Base System Profile

[Endpoint](StructureDefinition-Endpoint.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* **SHALL** support `read`.



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "Toestemming",
  "url" : "http://fhir.hl7.nl/zorgviewer/CapabilityStatement/Toestemming",
  "version" : "1.21.0",
  "name" : "Toestemming",
  "title" : "Toestemming",
  "status" : "active",
  "date" : "2023-09-04",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Deze CapabilityStatement beschrijft de minimale requirements voor het Toestemming en Adressering Bouwblok.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "copyright" : "CC0",
  "kind" : "requirements",
  "fhirVersion" : "3.0.2",
  "acceptUnknown" : "both",
  "format" : ["xml", "json"],
  "profile" : [
    {
      "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/ToestemmingConsent",
      "display" : "ToestemmingConsent"
    },
    {
      "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Organization",
      "display" : "Organization"
    },
    {
      "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Endpoint",
      "display" : "Endpoint"
    }
  ],
  "rest" : [
    {
      "mode" : "server",
      "resource" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Consent",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/ToestemmingConsent"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Organization",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Organization"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Endpoint",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Endpoint"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        }
      ]
    }
  ]
}

```
