# Ontsluiten Bronsysteem - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Ontsluiten Bronsysteem**

## CapabilityStatement: Ontsluiten Bronsysteem 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/CapabilityStatement/OntsluitenBronsysteem | *Version*:1.21.0 |
| Active as of 2023-09-04 | *Computable Name*:OntsluitenBronsysteem |
| **Copyright/Legal**: CC0 | |

 
Deze CapabilityStatement beschrijft de minimale requirements voor het Ontsluiten Bronsysteem Bouwblok. 

Benodigde SMART-on-FHIR [scopes](http://hl7.org/fhir/smart-app-launch/1.0.0/scopes-and-launch-context/index.html):

1. user/Patient.search
1. user/Patient.read
1. user/DocumentReference.search
1. user/Binary.read
1. user/Condition.search
1. user/Practitioner.read
1. user/PractitionerRole.search
1. user/Procedure.search
1. user/Observation.search
1. user/Specimen.read
1. user/Consent.search
1. user/Flag.search
1. user/MedicationRequest.search
1. user/MedicationStatement.search
1. user/Immunization.search
1. user/Appointment.search
1. user/Encounter.search

 [Raw OpenAPI-Swagger Definition file](OntsluitenBronsysteem.openapi.json) | [Download](OntsluitenBronsysteem.openapi.json) 

## Ontsluiten Bronsysteem

* Implementation Guide Version: 1.21.0 
* FHIR Version: 3.0.2 
* Supported Formats: `xml`, `json`
* Published on: 2023-09-04 
* Published by: RIVO-NN HL7NL 

> **Note to Implementers: FHIR Capabilities**Any FHIR capability may be 'allowed' by the system unless explicitly marked as 'SHALL NOT'. A few items are marked as MAY in the Implementation Guide to highlight their potential relevance to the use case.

## FHIR RESTful Capabilities

### Mode: server

**Security**

Enable CORS: no

Security services supported:
`SMART-on-FHIR`

### Capabilities by Resource/Profile

#### Summary

The summary table lists the resources that are part of this configuration, and for each resource it lists:

* The relevant profiles (if any)
* The interactions supported by each resource (**R**ead, **S**earch, **U**pdate, and **C**reate, are always shown, while **VR**ead, **P**atch, **D**elete, **H**istory on **I**nstance, or **H**istory on **T**ype are only present if at least one of the resources has support for them.
* The required, recommended, and some optional search parameters (if any).
* The linked resources enabled for `_include`
* The other resources enabled for `_revinclude`
* The operations on the resource (if any)

| | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [Patient](#Patient1-1) | [http://fhir.hl7.nl/zorgviewer/StructureDefinition/Patient](StructureDefinition-Patient.md) | **Y** | **Y** |  |  | identifier |  |  |  |
| [Condition](#Condition1-2) | [http://fhir.hl7.nl/zorgviewer/StructureDefinition/Condition](StructureDefinition-Condition.md) |  | **Y** |  |  |  |  |  |  |
| [DocumentReference](#DocumentReference1-3) | [http://fhir.hl7.nl/zorgviewer/StructureDefinition/DocumentReference](StructureDefinition-DocumentReference.md) |  | **Y** |  |  |  |  |  |  |
| [Binary](#Binary1-4) | [http://hl7.org/fhir/StructureDefinition/Binary](http://hl7.org/fhir/STU3/binary.html) | **Y** |  |  |  |  |  |  |  |
| [Practitioner](#Practitioner1-5) | [http://fhir.hl7.nl/zorgviewer/StructureDefinition/Practitioner](StructureDefinition-Practitioner.md) | Y |  |  |  |  |  |  |  |
| [PractitionerRole](#PractitionerRole1-6) | [http://fhir.hl7.nl/zorgviewer/StructureDefinition/PractitionerRole](StructureDefinition-PractitionerRole.md) |  | Y |  |  |  |  |  |  |
| [Procedure](#Procedure1-7) | [http://fhir.hl7.nl/zorgviewer/StructureDefinition/Procedure](StructureDefinition-Procedure.md) |  | **Y** |  |  |  |  |  |  |
| [Consent](#Consent1-8) | [http://fhir.hl7.nl/zorgviewer/StructureDefinition/AdvanceDirective](StructureDefinition-AdvanceDirective.md) |  | **Y** |  |  | category |  |  |  |
| [Consent](#Consent1-9) | [http://fhir.hl7.nl/zorgviewer/StructureDefinition/TreatmentDirective](StructureDefinition-TreatmentDirective.md) |  | **Y** |  |  | category |  |  |  |
| [Flag](#Flag1-10) | [http://fhir.hl7.nl/zorgviewer/StructureDefinition/Flag](StructureDefinition-Flag.md) |  | **Y** |  |  |  |  |  |  |
| [AllergyIntolerance](#AllergyIntolerance1-11) | [http://fhir.hl7.nl/zorgviewer/StructureDefinition/AllergyIntolerance](StructureDefinition-AllergyIntolerance.md) |  | **Y** |  |  |  |  |  |  |
| [Observation](#Observation1-12) | [http://fhir.hl7.nl/zorgviewer/StructureDefinition/LaboratoryTestResult](StructureDefinition-LaboratoryTestResult.md) |  | **Y** |  |  |  | `Observation:specimen` |  |  |
| [Specimen](#Specimen1-13) | [http://fhir.hl7.nl/zorgviewer/StructureDefinition/Specimen](StructureDefinition-Specimen.md) | **Y** |  |  |  |  |  |  |  |
| [MedicationRequest](#MedicationRequest1-14) | [http://fhir.hl7.nl/zorgviewer/StructureDefinition/MedicationRequest](StructureDefinition-MedicationRequest.md) | **Y** |  |  |  |  |  |  |  |
| [MedicationStatement](#MedicationStatement1-15) | [http://fhir.hl7.nl/zorgviewer/StructureDefinition/MedicationStatement](StructureDefinition-MedicationStatement.md) | **Y** |  |  |  |  |  |  |  |
| [Immunization](#Immunization1-16) | [http://fhir.hl7.nl/zorgviewer/StructureDefinition/Immunization](StructureDefinition-Immunization.md) | **Y** |  |  |  |  |  |  |  |
| [Appointment](#Appointment1-17) | [http://fhir.hl7.nl/zorgviewer/StructureDefinition/Appointment](StructureDefinition-Appointment.md) | **Y** |  |  |  |  |  |  |  |
| [Encounter](#Encounter1-18) | [http://fhir.hl7.nl/zorgviewer/StructureDefinition/Encounter](StructureDefinition-Encounter.md) | **Y** |  |  |  |  |  |  |  |

-------

#### Resource Conformance: SHALL Patient

Base System Profile

[Patient](StructureDefinition-Patient.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* **SHALL** support `read`, `search-type`.

Search Parameters


 

#### Resource Conformance: SHALL Condition

Base System Profile

[Condition](StructureDefinition-Condition.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* **SHALL** support `search-type`.

#### Resource Conformance: SHALL DocumentReference

Base System Profile

[DocumentReference](StructureDefinition-DocumentReference.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* **SHALL** support `search-type`.

#### Resource Conformance: SHALL Binary

Base System Profile

[Binary](http://hl7.org/fhir/STU3/binary.html)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* **SHALL** support `read`.

#### Resource Conformance: SHOULD Practitioner

Base System Profile

[Practitioner](StructureDefinition-Practitioner.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* **SHOULD** support `read`.

#### Resource Conformance: SHOULD PractitionerRole

Base System Profile

[PractitionerRole](StructureDefinition-PractitionerRole.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* **SHOULD** support `search-type`.

#### Resource Conformance: SHALL Procedure

Base System Profile

[Procedure](StructureDefinition-Procedure.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* **SHALL** support `search-type`.

#### Resource Conformance: SHALL Consent

Base System Profile

[AdvanceDirective](StructureDefinition-AdvanceDirective.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* **SHALL** support `search-type`.

Search Parameters


 

#### Resource Conformance: SHALL Consent

Base System Profile

[TreatmentDirective](StructureDefinition-TreatmentDirective.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* **SHALL** support `search-type`.

Search Parameters


 

#### Resource Conformance: SHALL Flag

Base System Profile

[Alert](StructureDefinition-Flag.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* **SHALL** support `search-type`.

#### Resource Conformance: SHALL AllergyIntolerance

Base System Profile

[AllergyIntolerance](StructureDefinition-AllergyIntolerance.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* **SHALL** support `search-type`.

#### Resource Conformance: SHALL Observation

Base System Profile

[LaboratoryTestResult](StructureDefinition-LaboratoryTestResult.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* **SHALL** support `search-type`.

#### Resource Conformance: SHALL Specimen

Base System Profile

[Specimen](StructureDefinition-Specimen.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* **SHALL** support `read`.

#### Resource Conformance: SHALL MedicationRequest

Base System Profile

[MedicationAgreement](StructureDefinition-MedicationRequest.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* **SHALL** support `read`.

#### Resource Conformance: SHALL MedicationStatement

Base System Profile

[MedicationUse](StructureDefinition-MedicationStatement.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* **SHALL** support `read`.

#### Resource Conformance: SHALL Immunization

Base System Profile

[Vaccination](StructureDefinition-Immunization.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* **SHALL** support `read`.

#### Resource Conformance: SHALL Appointment

Base System Profile

[Appointment](StructureDefinition-Appointment.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* **SHALL** support `read`.

#### Resource Conformance: SHALL Encounter

Base System Profile

[Encounter](StructureDefinition-Encounter.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* **SHALL** support `read`.



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "OntsluitenBronsysteem",
  "url" : "http://fhir.hl7.nl/zorgviewer/CapabilityStatement/OntsluitenBronsysteem",
  "version" : "1.21.0",
  "name" : "OntsluitenBronsysteem",
  "title" : "Ontsluiten Bronsysteem",
  "status" : "active",
  "date" : "2023-09-04",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Deze CapabilityStatement beschrijft de minimale requirements voor het Ontsluiten Bronsysteem Bouwblok.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "copyright" : "CC0",
  "kind" : "requirements",
  "fhirVersion" : "3.0.2",
  "acceptUnknown" : "both",
  "format" : ["xml", "json"],
  "profile" : [
    {
      "reference" : "http://fhir.nl/fhir/StructureDefinition/nl-core-patient",
      "display" : "nl-core-patient"
    },
    {
      "reference" : "http://fhir.nl/fhir/StructureDefinition/nl-core-organization",
      "display" : "nl-core-organization"
    },
    {
      "reference" : "http://fhir.nl/fhir/StructureDefinition/nl-core-practitioner",
      "display" : "nl-core-practitioner"
    },
    {
      "reference" : "http://fhir.nl/fhir/StructureDefinition/nl-core-practitionerrole",
      "display" : "nl-core-practitionerrole"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/zib-Problem",
      "display" : "zib-Probleem"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/zib-Procedure",
      "display" : "zib-Verrichting"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/zib-AdvanceDirective",
      "display" : "zib-AdvanceDirective"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/zib-TreatmentDirective",
      "display" : "zib-TreatmentDirective"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/zib-Alert",
      "display" : "zib-Alert"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/zib-AllergyIntolerance",
      "display" : "zib-AllergyIntolerance"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/zib-LaboratoryTestResult-Observation",
      "display" : "zib-LaboratoryTestResult-Observation"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/zib-LaboratoryTestResult-Specimen",
      "display" : "zib-LaboratoryTestResult-Specimen"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/zib-MedicationAgreement",
      "display" : "zib-MedicationAgreement"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/zib-MedicationUse",
      "display" : "zib-MedicationUse"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/zib-Vaccination",
      "display" : "zib-Vaccination"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/eAfspraak-Appointment",
      "display" : "eAfspraak-Appointment"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/zib-Encouner",
      "display" : "zib-Encouner"
    }
  ],
  "rest" : [
    {
      "mode" : "server",
      "security" : {
        "service" : [
          {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/restful-security-service",
                "code" : "SMART-on-FHIR"
              }
            ],
            "text" : "OAuth2 using SMART-on-FHIR profile (see http://docs.smarthealthit.org)"
          }
        ]
      },
      "resource" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Patient",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Patient"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/Patient-identifier",
              "type" : "token",
              "documentation" : "The server **SHALL** support search based on BSN, system=http://fhir.nl/fhir/NamingSystem/bsn"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Condition",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Condition"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "DocumentReference",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/DocumentReference"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Binary",
          "profile" : {
            "reference" : "http://hl7.org/fhir/StructureDefinition/Binary"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHOULD"
            }
          ],
          "type" : "Practitioner",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Practitioner"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHOULD"
            }
          ],
          "type" : "PractitionerRole",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/PractitionerRole"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Procedure",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Procedure"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Consent",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/AdvanceDirective"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "category",
              "definition" : "http://hl7.org/fhir/SearchParameter/Consent-category",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Consent",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/TreatmentDirective"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "category",
              "definition" : "http://hl7.org/fhir/SearchParameter/Consent-category",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Flag",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Flag"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "AllergyIntolerance",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/AllergyIntolerance"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Observation",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/LaboratoryTestResult"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchInclude" : ["Observation:specimen"]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Specimen",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Specimen"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "MedicationRequest",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/MedicationRequest"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "MedicationStatement",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/MedicationStatement"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Immunization",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Immunization"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Appointment",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Appointment"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Encounter",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Encounter"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        }
      ]
    }
  ]
}

```
