# Logging - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Logging**

## CapabilityStatement: Logging 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/CapabilityStatement/Logging | *Version*:1.21.0 |
| Active as of 2023-09-04 | *Computable Name*:Logging |
| **Copyright/Legal**: CC0 | |

 
Deze CapabilityStatement beschrijft de minimale requirements voor het Logging Bouwblok. 

Zie voor details van het log bericht: [StructureDefinition-AuditEvent](StructureDefinition-AuditEvent.md).

N.B. De focus ligt op wettelijk benodigde logging volgens NEN 7513, uiteraard zal er meer gedetaileere technische logging nodig zijn.

 [Raw OpenAPI-Swagger Definition file](Logging.openapi.json) | [Download](Logging.openapi.json) 

## Logging

* Implementation Guide Version: 1.21.0 
* FHIR Version: 3.0.2 
* Supported Formats: `xml`, `json`
* Published on: 2023-09-04 
* Published by: RIVO-NN HL7NL 

> **Note to Implementers: FHIR Capabilities**Any FHIR capability may be 'allowed' by the system unless explicitly marked as 'SHALL NOT'. A few items are marked as MAY in the Implementation Guide to highlight their potential relevance to the use case.

## FHIR RESTful Capabilities

### Mode: server

### Capabilities by Resource/Profile

#### Summary

The summary table lists the resources that are part of this configuration, and for each resource it lists:

* The relevant profiles (if any)
* The interactions supported by each resource (**R**ead, **S**earch, **U**pdate, and **C**reate, are always shown, while **VR**ead, **P**atch, **D**elete, **H**istory on **I**nstance, or **H**istory on **T**ype are only present if at least one of the resources has support for them.
* The required, recommended, and some optional search parameters (if any).
* The linked resources enabled for `_include`
* The other resources enabled for `_revinclude`
* The operations on the resource (if any)

| | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [AuditEvent](#AuditEvent1-1) | [http://fhir.hl7.nl/zorgviewer/StructureDefinition/AuditEvent](StructureDefinition-AuditEvent.md) |  | **Y** |  | **Y** |  |  |  |  |

-------

#### Resource Conformance: SHALL AuditEvent

Base System Profile

[AuditEvent](StructureDefinition-AuditEvent.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* **SHALL** support `create`, `search-type`.



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "Logging",
  "url" : "http://fhir.hl7.nl/zorgviewer/CapabilityStatement/Logging",
  "version" : "1.21.0",
  "name" : "Logging",
  "title" : "Logging",
  "status" : "active",
  "date" : "2023-09-04",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Deze CapabilityStatement beschrijft de minimale requirements voor het Logging Bouwblok.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "copyright" : "CC0",
  "kind" : "requirements",
  "fhirVersion" : "3.0.2",
  "acceptUnknown" : "both",
  "format" : ["xml", "json"],
  "profile" : [
    {
      "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/AuditEvent",
      "display" : "AuditEvent"
    }
  ],
  "rest" : [
    {
      "mode" : "server",
      "resource" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "AuditEvent",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/AuditEvent"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ]
        }
      ]
    }
  ]
}

```
