# Zorgviewer verrichting type waardelijst - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Zorgviewer verrichting type waardelijst**

## ValueSet: Zorgviewer verrichting type waardelijst 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/ValueSet/VerrichtingTypeCodelist | *Version*:1.21.0 |
| Active as of 2025-10-28 | *Computable Name*:VerrichtingTypeCodelist |
| **Copyright/Legal**: This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement | |

 
De Zorgviewer verrichting type waardelijst 

 **References** 

* [Procedure](StructureDefinition-Procedure.md)

**Changes since version 1.20.0:**

* No changes

### Logical Definition (CLD)

Profile: [Shareable ValueSet](http://hl7.org/fhir/STU3/shareablevalueset.html)

This value set includes codes based on the following rules:

* Include all codes defined in [`http://snomed.info/sct`](http://www.snomed.org/)version Not Stated (use latest from terminology server)
* Include all codes defined in `urn:oid:2.16.840.1.113883.2.4.3.120.5.2`version Not Stated (use latest from terminology server)
* Include all codes defined in `urn:oid:2.16.840.1.113883.2.4.3.120.5.3`version Not Stated (use latest from terminology server)
* Include all codes defined in `urn:oid:2.16.840.1.113883.2.4.3.27.15.5`version Not Stated (use latest from terminology server)

 

### Expansion

This value set cannot be expanded because the terminology server(s) deemed it too costly to do so

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/STU3/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "VerrichtingTypeCodelist",
  "meta" : {
    "profile" : ["http://hl7.org/fhir/StructureDefinition/shareablevalueset"]
  },
  "url" : "http://fhir.hl7.nl/zorgviewer/ValueSet/VerrichtingTypeCodelist",
  "version" : "1.21.0",
  "name" : "VerrichtingTypeCodelist",
  "title" : "Zorgviewer verrichting type waardelijst",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-28T13:36:22+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "De Zorgviewer verrichting type waardelijst",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "copyright" : "This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement",
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct"
      },
      {
        "system" : "urn:oid:2.16.840.1.113883.2.4.3.120.5.2"
      },
      {
        "system" : "urn:oid:2.16.840.1.113883.2.4.3.120.5.3"
      },
      {
        "system" : "urn:oid:2.16.840.1.113883.2.4.3.27.15.5"
      }
    ]
  }
}

```
