# Document Class & Type waardelijst - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Document Class & Type waardelijst**

## ValueSet: Document Class & Type waardelijst 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/ValueSet/DocumentLOINCCodelist | *Version*:1.21.0 |
| Active as of 2025-10-28 | *Computable Name*:DocumentLOINCCodelist |
| **Copyright/Legal**: This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc | |

 
Docuemnt Class en Type LOINC codes die we vinden zonder display, zodat we wel een display in Nederlands kunnen tonen 

 **References** 

* [DocumentReference](StructureDefinition-DocumentReference.md)

**Changes since version 1.20.0:**

* No changes

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on Loinc v2.81

This value set contains 4 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/STU3/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "DocumentLOINCCodelist",
  "meta" : {
    "profile" : ["http://hl7.org/fhir/StructureDefinition/shareablevalueset"]
  },
  "url" : "http://fhir.hl7.nl/zorgviewer/ValueSet/DocumentLOINCCodelist",
  "version" : "1.21.0",
  "name" : "DocumentLOINCCodelist",
  "title" : "Document Class & Type waardelijst",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-28T13:36:22+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Docuemnt Class en Type LOINC codes die we vinden zonder display, zodat we wel een display in Nederlands kunnen tonen",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "copyright" : "This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc",
  "compose" : {
    "include" : [
      {
        "system" : "http://loinc.org",
        "concept" : [
          {
            "code" : "51852-2",
            "display" : "Letter",
            "designation" : [
              {
                "language" : "nl-NL",
                "value" : "brief"
              }
            ]
          },
          {
            "code" : "68609-7",
            "display" : "Hospital Letter",
            "designation" : [
              {
                "language" : "nl-NL",
                "value" : "brief"
              }
            ]
          },
          {
            "code" : "56444-3",
            "display" : "Healthcare communication Document",
            "designation" : [
              {
                "language" : "nl-NL",
                "value" : "patiëntenbrief"
              }
            ]
          },
          {
            "code" : "28570-0",
            "display" : "Procedure note",
            "designation" : [
              {
                "language" : "nl-NL",
                "value" : "verslag ingreep"
              }
            ]
          }
        ]
      }
    ]
  }
}

```
