# ACP behandelingen waardelijst - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ACP behandelingen waardelijst**

## ValueSet: ACP behandelingen waardelijst 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/ValueSet/ACPTreatmentCodelist | *Version*:1.21.0 |
| Active as of 2025-10-28 | *Computable Name*:ACPTreatmentCodelist |
| **Copyright/Legal**: This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement | |

 
Active Care Planning (ACP) behandelingen waardelijst 

 **References** 

* [TreatmentDirective](StructureDefinition-TreatmentDirective.md)

**Changes since version 1.20.0:**

* No changes

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on:

* [codesystem v3 Code System NullFlavor v2016-11-11 (CodeSystem)](http://hl7.org/fhir/STU3/v3/NullFlavor/cs.html)
* SNOMED CT Dutch edition 30-Sep 2024
* [valueset BehandelingCodelijst v2017-12-31T00:00:00 (ValueSet)](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&canonical=http://decor.nictiz.nl/fhir/ValueSet/2.16.840.1.113883.2.4.3.11.60.40.2.2.1.1--20171231000000)

This value set contains 9 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/STU3/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "ACPTreatmentCodelist",
  "meta" : {
    "profile" : ["http://hl7.org/fhir/StructureDefinition/shareablevalueset"]
  },
  "url" : "http://fhir.hl7.nl/zorgviewer/ValueSet/ACPTreatmentCodelist",
  "version" : "1.21.0",
  "name" : "ACPTreatmentCodelist",
  "title" : "ACP behandelingen waardelijst",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-28T13:36:22+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Active Care Planning (ACP) behandelingen waardelijst",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "copyright" : "This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement",
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "183452005",
            "display" : "Emergency hospital admission (procedure)",
            "designation" : [
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "spoedopname in ziekenhuis"
              }
            ]
          },
          {
            "code" : "32485007",
            "display" : "Hospital admission (procedure)",
            "designation" : [
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "opname in ziekenhuis"
              }
            ]
          },
          {
            "code" : "281789004",
            "display" : "Antibiotic therapy (procedure)",
            "designation" : [
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "antibiotische therapie"
              }
            ]
          },
          {
            "code" : "431415002",
            "display" : "Management of internal defibrillation (procedure)",
            "designation" : [
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "management van interne defibrillatie"
              }
            ]
          }
        ]
      },
      {
        "valueSet" : [
          "http://decor.nictiz.nl/fhir/ValueSet/2.16.840.1.113883.2.4.3.11.60.40.2.2.1.1--20171231000000"
        ]
      }
    ]
  }
}

```
