# Procedure - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Procedure**

## Resource Profile: Procedure 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/StructureDefinition/Procedure | *Version*:1.21.0 |
| Active as of 2025-10-28 | *Computable Name*:Procedure |

 
Verrichtingen 

> Dit Profiel is het resultaat van de vergelijking tussen de zib2017 FHIR Profiel en de implementaties in Epic, Chipsoft, Topicus en Nexus. De elementen die in ieder geval in alle output beschikbaar zullen zijn. Voornamelijk bedoeld voor houvast van een client en voor validatie van output.

### Zorginformatiebouwsteen

[ZIB Verrichting](https://zibs.nl/wiki/Verrichting-v4.1(2017NL))

### View Definition

* [ViewDefinition voor Verrichtingen](ViewDefinition-Procedure.json)

### UI Wireframe

**Verrichtingen**

* ><: +
  * Bron: Chipsoft
  * Datum: 5-6-2012
  * Verrichting: implantatie van totale knieprothese
  * Locatie: Drachten
  * Uitgevoerd door: Lisette van Cruijningen de Winter
* ><: 
  * Bron: **Verrichtingcode**CBV#00090991 implantatie van totale knieprothese**Lateraliteit**Links
* ><: +
  * Bron: Epic
  * Datum: 7-11-2021
  * Verrichting: Gesloten repositie supra- of transcondylaire femur fractuur.
  * Locatie: UMCG
  * Uitgevoerd door: MedMij Orthopedie, MD
* ><: 
  * Bron: **Verrichtingcode**SNOMED CT#46866001 Gesloten repositie supra- of transcondylaire femur fractuur.**Lateraliteit**Rechts
* ><: +
  * Bron: Nexus
  * Datum: 6-5-2012
  * Verrichting: Prothese implantatie kniegewricht.
  * Locatie: 
  * Uitgevoerd door: BoonstraVIPP NEXUS Ziekenhuis
* ><: 
  * Bron: **Verrichtingcode**NZa#038663 Prothese implantatie kniegewricht.
* ><: +
  * Bron: VG-Epic
  * Datum: 1-1-2001
  * Verrichting: SELECTIEVE FASCIECTOMIE
  * Locatie: 
  * Uitgevoerd door: 
* ><: 
  * Bron: 

### Kolom Definities

* UITKLAPVELD: Bron
  * ?: `meta.extension('http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source').valueUri`
  * ?: `string`
  * ?: nvt
  * ?: Lookup adhv uri (AGB-Z of OID)`<adressering-base>/Organization?identifier=<.meta.tag.code>`en gebruik dan`Organization.name`
* UITKLAPVELD: Datum
  * ?: `performedPeriod.start`
  * ?: `dateTime`
  * ?: VerrichtingBeginDatum
  * ?: ​Kunnen vage datums zijn.
* UITKLAPVELD: Verrichting
  * ?: `code.text | code.coding[0].display`
  * ?: `string`
  * ?: VerrichtingType
  * ?: 
* UITKLAPVELD: Locatie
  * ?: `location.display`
  * ?: `string`
  * ?: Locatie::Zorgaanbieder
  * ?: Zie discussie hier:[BITS ticket MM-5002](https://bits.nictiz.nl/browse/MM-5002)
* UITKLAPVELD: Uitgevoerd door
  * ?: `performer.actor.display.join(' ')`
  * ?: `string`
  * ?: Uitvoerder
  * ?: Meestal alleen specialisme
* UITKLAPVELD: +Verrichtingcode
  * ?: `code.coding[0].select(system.lookup('CodeSystems').display+'#' + code + ' ' + iif(exists(display),display,''))`
  * ?: `string`
  * ?: VerrichtingType
  * ?: Meerdere codes mogelijk.Ignore NullFlavor.​Lookup system label middels`<terminologie-base>/CodeSystem?url=<.system>`en gebruik dan`CodeSystem.title`
* UITKLAPVELD: +Lateraliteit
  * ?: `bodySite.extension('http://nictiz.nl/fhir/StructureDefinition/BodySite-Qualifier').valueCodeableConcept.text`
  * ?: `string`
  * ?: ProbleemLateraliteit
  * ?: 

### Codesystemen

* [DHD Verrichtingenthesaurus, CBV en Zorgactiviteiten](https://trex.dhd.nl/) 
* SNOMED CT - http://snomed.info/sct
* DHD VT - urn:oid:2.16.840.1.113883.2.4.3.120.5.2
* CBV - urn:oid:2.16.840.1.113883.2.4.3.120.5.3
* NZa - urn:oid:2.16.840.1.113883.2.4.3.27.15.5
 
* [NHG Ingrepenviewer tabel 49](https://viewers.nhg.org/ingrepenviewer/)

### Request

1. Opvragen (search) verrichtingen`GET <ontsluiten-bronsysteem-base>/Procedure?patient=<fhir_patient_id>`**N.B. Deze request is breder dan de BgZ request, waar alleen de chirugische verrichtingen worden opgevraagd.**

### Bronsysteem herkennen

De **Zorgviewer-backend** of **Ontsluiten bronsysteem** **MOET** na bevragen van het bronsysteem aan elk resultaat resource een meta-tag toevoegen met de AGB, OID of URA identifier van de zorgaanbieder (zie [Organization](StructureDefinition-Organization.md) voor voorbeelden). Dit wordt vervolgens gebruikt in de "Bron" kolom in de Zorgviewer-frontend. N.B. We gebruiken hier een **pre-adopt** van de FHIR R4 [Meta.source](StructureDefinition-extension-Meta.source.md).

Toevoegen aan elke response, dus per resource (bij een read) of per Bundle (bij een search):

```
"meta": {
    "extension": [ {
        "url": "http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source",
        "valueUri": "urn:oid:2.16.840.1.113883.2.4.3.8"
    } ]
}

```

**Alternatief:** Elke entry van een search response Bundle bevat een referentie naar de bijbehorende Patient (`<resource>.subject|patient`). Elke patient heeft een `Patient.managingOrganization` en in de gerefereerde `Organization.identifier` staat vervolgens o.a. de OID van het bronsysyeem. Of je gebruikt de identifiers om een volledige Organization op te zoeken in het [adresboek](zorgviewer-services.md#adressering) en zie inhoud [hier](artifacts.md#zorgviewer-services-content).

**Usages:**

* CapabilityStatements using this Profile: [Ontsluiten Bronsysteem](CapabilityStatement-OntsluitenBronsysteem.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.zorgviewer|current/StructureDefinition/Procedure)

**Changes since version 1.20.0:**

* New Content

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Procedure.csv), [Excel](StructureDefinition-Procedure.xlsx), [Schematron](StructureDefinition-Procedure.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Procedure",
  "url" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Procedure",
  "version" : "1.21.0",
  "name" : "Procedure",
  "title" : "Procedure",
  "status" : "active",
  "date" : "2025-10-28T13:36:22+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Verrichtingen",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "fhirVersion" : "3.0.2",
  "mapping" : [
    {
      "identity" : "hcim-procedure-v4.1-2017EN",
      "uri" : "https://zibs.nl/wiki/Procedure-v4.1(2017EN)",
      "name" : "HCIM Procedure-v4.1(2017EN)"
    },
    {
      "identity" : "hcim-textresult-v4.1-2017EN",
      "uri" : "https://zibs.nl/wiki/TextResult-v4.1(2017EN)",
      "name" : "HCIM TextResult-v4.1(2017EN)"
    },
    {
      "identity" : "hcim-healthprofessional-v3.2-2017EN",
      "uri" : "https://zibs.nl/wiki/HealthProfessional-v3.2(2017EN)",
      "name" : "HCIM HealthProfessional-v3.2(2017EN)"
    },
    {
      "identity" : "hcim-basicelements-v1.0-2017EN",
      "uri" : "https://zibs.nl/wiki/BasicElements-v1.0(2017EN)",
      "name" : "HCIM BasicElements-v1.0(2017EN)"
    },
    {
      "identity" : "hcim-procedurefortransfer-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/ProcedureForTransfer-v3.0(2016EN)",
      "name" : "HCIM ProcedureForTransfer-v3.0(2016EN)"
    },
    {
      "identity" : "hcim-textresultfortransfer-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/TextResultForTransfer-v3.0(2016EN)",
      "name" : "HCIM TextResultForTransfer-v3.0(2016EN)"
    },
    {
      "identity" : "hcim-healthprofessional-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/HealthProfessional-v3.0(2016EN)",
      "name" : "HCIM HealthProfessional-v3.0(2016EN)"
    },
    {
      "identity" : "hcim-procedurefortransfer-v1.2-2015EN",
      "uri" : "https://zibs.nl/wiki/ProcedureForTransfer-v1.2(2015EN)",
      "name" : "HCIM ProcedureForTransfer-v1.2(2015EN)"
    },
    {
      "identity" : "hcim-textresultfortransfer-v1.2-2015EN",
      "uri" : "https://zibs.nl/wiki/TextResultForTransfer-v1.2.2(2015EN)",
      "name" : "HCIM TextResultForTransfer-v1.2.2(2015EN)"
    },
    {
      "identity" : "hcim-healthprofessional-v1.2.1-2015EN",
      "uri" : "https://zibs.nl/wiki/HealthProfessional-v1.2.1(2015EN)",
      "name" : "HCIM HealthProfessional-v1.2.1(2015EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Procedure",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/zib-Procedure",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Procedure",
        "path" : "Procedure"
      },
      {
        "id" : "Procedure.code",
        "path" : "Procedure.code",
        "mustSupport" : true
      },
      {
        "id" : "Procedure.code.coding:VerrichtingTypeCodelijst",
        "path" : "Procedure.code.coding",
        "sliceName" : "VerrichtingTypeCodelijst",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSetReference" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/ValueSet/VerrichtingTypeCodelist"
          }
        }
      },
      {
        "id" : "Procedure.code.text",
        "path" : "Procedure.code.text",
        "mustSupport" : true
      },
      {
        "id" : "Procedure.performedPeriod",
        "path" : "Procedure.performedPeriod",
        "mustSupport" : true
      },
      {
        "id" : "Procedure.performer",
        "path" : "Procedure.performer"
      },
      {
        "id" : "Procedure.performer.actor",
        "path" : "Procedure.performer.actor"
      },
      {
        "id" : "Procedure.performer.actor.display",
        "path" : "Procedure.performer.actor.display",
        "mustSupport" : true
      },
      {
        "id" : "Procedure.location",
        "path" : "Procedure.location"
      },
      {
        "id" : "Procedure.location.display",
        "path" : "Procedure.location.display",
        "mustSupport" : true
      },
      {
        "id" : "Procedure.bodySite",
        "path" : "Procedure.bodySite"
      },
      {
        "id" : "Procedure.bodySite.extension:ProcedureLaterality",
        "path" : "Procedure.bodySite.extension",
        "sliceName" : "ProcedureLaterality",
        "mustSupport" : true
      }
    ]
  }
}

```
