# Organization - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization**

## Resource Profile: Organization 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/StructureDefinition/Organization | *Version*:1.21.0 |
| Active as of 2025-10-28 | *Computable Name*:Organization |

 
Instelling of Organisatie 

> Dit Profiel is het resultaat van de vergelijking tussen de zib2017 FHIR Profiel en de implementaties in Epic, Chipsoft, Topicus en Nexus. De elementen die in ieder geval in alle output beschikbaar zullen zijn. Voornamelijk bedoeld voor houvast van een client en voor validatie van output.

### Zorginformatiebouwsteen

[ZIB Zorgaanbieder](https://zibs.nl/wiki/Zorgaanbieder-v3.1.1(2017NL))

### Zoeken naar identifiers

* [Vektiz AGB Register zoeken](https://www.vektis.nl/agb-register/zoeken) @system = http://fhir.nl/fhir/NamingSystem/agb-z
* [HL7 NL OID Register](https://hl7.nl/actuele-hl7-nl-oid-register.html) @system = urn:oid:2.16.840.1.113883.2.4.3
* [URA UZI Register Abonneenummer](https://www.zorgcsp.nl/zoeken/UitgegevenServerCertificatenUzi) @system = http://fhir.nl/fhir/NamingSystem/ura
* Voorbeeld: 
* [Vektiz AGB Register UMCG](https://www.vektis.nl/agb-register/onderneming-06020101)
 

### Requests

1. Opvragen (search) naar organisatie op basis van de organisatie AGB, OID of URA`GET <bronsysteem-ontsluiting-base/Organization?identifier=<URA|AGB|OID>`

### Bronsysteem herkennen

De **Zorgviewer-backend** of **Ontsluiten bronsysteem** **MOET** na bevragen van het bronsysteem aan elk resultaat resource een meta-tag toevoegen met de AGB, OID of URA identifier van de zorgaanbieder (zie [Organization](StructureDefinition-Organization.md) voor voorbeelden). Dit wordt vervolgens gebruikt in de "Bron" kolom in de Zorgviewer-frontend. N.B. We gebruiken hier een **pre-adopt** van de FHIR R4 [Meta.source](StructureDefinition-extension-Meta.source.md).

Toevoegen aan elke response, dus per resource (bij een read) of per Bundle (bij een search):

```
"meta": {
    "extension": [ {
        "url": "http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source",
        "valueUri": "urn:oid:2.16.840.1.113883.2.4.3.8"
    } ]
}

```

**Alternatief:** Elke entry van een search response Bundle bevat een referentie naar de bijbehorende Patient (`<resource>.subject|patient`). Elke patient heeft een `Patient.managingOrganization` en in de gerefereerde `Organization.identifier` staat vervolgens o.a. de OID van het bronsysyeem. Of je gebruikt de identifiers om een volledige Organization op te zoeken in het [adresboek](zorgviewer-services.md#adressering) en zie inhoud [hier](artifacts.md#zorgviewer-services-content).

**Usages:**

* Refer to this Profile: [ToestemmingConsent](StructureDefinition-ToestemmingConsent.md)
* Examples for this Profile: [MCL](Organization-MCL.md), [Ommelander Ziekenhuis Groep locatie Delfzicht](Organization-OZGDelfzicht.md), [Tjongerschans](Organization-Tjongerschans.md), [UMCG](Organization-UMCG.md) and [VIPLive](Organization-VIPLive.md)
* CapabilityStatements using this Profile: [Adressering](CapabilityStatement-Adressering.md) and [Toestemming](CapabilityStatement-Toestemming.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.zorgviewer|current/StructureDefinition/Organization)

**Changes since version 1.20.0:**

* New Content

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Organization.csv), [Excel](StructureDefinition-Organization.xlsx), [Schematron](StructureDefinition-Organization.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Organization",
  "url" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Organization",
  "version" : "1.21.0",
  "name" : "Organization",
  "title" : "Organization",
  "status" : "active",
  "date" : "2025-10-28T13:36:22+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Instelling of Organisatie",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "fhirVersion" : "3.0.2",
  "mapping" : [
    {
      "identity" : "hcim-healthcareprovider-v3.1.1-2017EN",
      "uri" : "https://zibs.nl/wiki/HealthcareProvider-v3.1.1(2017EN)",
      "name" : "HCIM HealthcareProvider-v3.1.1(2017EN)"
    },
    {
      "identity" : "hcim-contactinformation-v1.0-2017EN",
      "uri" : "https://zibs.nl/wiki/ContactInformation-v1.0(2017EN)",
      "name" : "HCIM ContactInformation-v1.0(2017EN)",
      "comment" : "ContactInformation has become an independent information model as of release 2017 of the HCIMs."
    },
    {
      "identity" : "hcim-payer-v3.1-2017EN",
      "uri" : "https://zibs.nl/wiki/Payer-v3.1(2017EN)",
      "name" : "HCIM Payer-v3.1(2017EN)"
    },
    {
      "identity" : "hcim-basicelements-v1.0-2017EN",
      "uri" : "https://zibs.nl/wiki/BasicElements-v1.0(2017EN)",
      "name" : "HCIM BasicElements-v1.0(2017EN)"
    },
    {
      "identity" : "hcim-healthcareprovider-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/HealthcareProvider-v3.0(2016EN)",
      "name" : "HCIM HealthcareProvider-v3.0(2016EN)"
    },
    {
      "identity" : "hcim-contactinformation-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/Patient-v3.0(2016EN)",
      "name" : "HCIM Patient-v3.0(2016EN)",
      "comment" : "ContactInformation has become an independent information model as of release 2017 of the HCIMs"
    },
    {
      "identity" : "hcim-healthcareprovider-v1.2-2015EN",
      "uri" : "https://zibs.nl/wiki/HealthcareProvider-v1.2(2015EN)",
      "name" : "HCIM HealthcareProvider-v1.2(2015EN)"
    },
    {
      "identity" : "hcim-contactinformation-v2.0.1-2015EN",
      "uri" : "https://zibs.nl/wiki/Patient-v2.0.1(2015EN)",
      "name" : "HCIM Patient-v2.0.1(2015EN)",
      "comment" : "ContactInformation has become an independent information model as of release 2017 of the HCIMs"
    },
    {
      "identity" : "hcim-payer-v1.2-2015EN",
      "uri" : "https://zibs.nl/wiki/Payer-v1.2(2015EN)",
      "name" : "HCIM Payer-v1.2(2015EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "http://fhir.nl/fhir/StructureDefinition/nl-core-organization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization",
        "constraint" : [
          {
            "key" : "zv-org-1",
            "severity" : "error",
            "human" : "Organization AGB SHALL be present.",
            "expression" : "identifier.where(system='http://fhir.nl/fhir/NamingSystem/agb-z')",
            "xpath" : "/f:identifier/f:system='http://fhir.nl/fhir/NamingSystem/agb-z'"
          }
        ]
      },
      {
        "id" : "Organization.identifier:URA",
        "path" : "Organization.identifier",
        "sliceName" : "URA",
        "mustSupport" : true
      },
      {
        "id" : "Organization.identifier:URA.system",
        "path" : "Organization.identifier.system",
        "min" : 1,
        "fixedUri" : "http://fhir.nl/fhir/NamingSystem/ura"
      },
      {
        "id" : "Organization.identifier:AGB",
        "path" : "Organization.identifier",
        "sliceName" : "AGB",
        "mustSupport" : true
      },
      {
        "id" : "Organization.identifier:AGB.system",
        "path" : "Organization.identifier.system",
        "min" : 1,
        "fixedUri" : "http://fhir.nl/fhir/NamingSystem/agb-z"
      },
      {
        "id" : "Organization.identifier:HL7NL",
        "path" : "Organization.identifier",
        "sliceName" : "HL7NL",
        "mustSupport" : true
      },
      {
        "id" : "Organization.identifier:HL7NL.system",
        "path" : "Organization.identifier.system",
        "min" : 1,
        "fixedUri" : "urn:oid:2.16.840.1.113883.2.4.3"
      }
    ]
  }
}

```
