# Medicatiegegevens - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Medicatiegegevens**

## Resource Profile: Medicatiegegevens ( Abstract ) 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/StructureDefinition/Medicatiegegevens | *Version*:1.21.0 |
| Active as of 2025-10-28 | *Computable Name*:Medicatiegegevens |

 
Medicatiegegevens abstract samenstelling voor het documenteren van de combinatie van Medicatieafspraak en Medicatie Gebruik 

> Dit Profiel is het resultaat van de vergelijking tussen de zib2017 FHIR Profiel en de implementaties in Epic, Chipsoft, Topicus en Nexus. De elementen die in ieder geval in alle output beschikbaar zullen zijn. Voornamelijk bedoeld voor houvast van een client en voor validatie van output.

### Zorginformatiebouwsteen

* [ZIB Medicatieafspraak](StructureDefinition-MedicationRequest.md#zorginformatiebouwsteen)
* [ZIB Medicatie Gebruik2](StructureDefinition-MedicationStatement.md#zorginformatiebouwsteen)

### View Definition

[ViewDefinition voor Medicatiegegevens](ViewDefinition-Medicatiegegevens.json)

### UI Wireframe

**Medicatiegebruik en -afspraken**

* ><: +
  * Bron: Chipsoft
  * Start: 15-8-2016
  * Eind: 14-9-2016
  * Medicatie: METOCLOPRAMIDE ZETPIL 10MG
  * Dosering & instructies: 1x elke 1 dag, indien nodig (Zo nodig)Aanvullende instructie 1: Pas op met alc...
  * Toedieningsweg: RECTAAL
  * Stop type: Definitief
* ><: 
  * Bron: **Afspraakdatum**30-9-2022**Voorschrijver**Peter van Pulver
* ><: +
  * Bron: Epic
  * Start: 27-11-2020
  * Eind: 
  * Medicatie: metoPROLOL 50mg tablet
  * Dosering & instructies: 1x per dag 50 mg innemen.
  * Toedieningsweg: Oraal
  * Stop type: 
* ><: 
  * Bron: **Medicatie vorm**tablet**Afspraakdatum**27-11-2020**Voorschrijver**M Crop
* ><: +
  * Bron: Nexus
  * Start: 3-10-2023
  * Eind: 
  * Medicatie: GLYCEROFOSFORZ. INFCONC 1MMOL/ML(FOSFAAT) AMP 20ML
  * Dosering & instructies: 1x elke 1 dag om 08:00:00 ⓘ
  * Toedieningsweg: INTRAVENEUS
  * Stop type: 
* ><: 
  * Bron: **Afspraakdatum**3-10-2023**Voorschrijver**Aalders, JCA (CAR)
* ><: +
  * Bron: Sanday
  * Start: 
  * Eind: 
  * Medicatie: PANTOPRAZOL TABLET MSR 40MG
  * Dosering & instructies: 2 maal per dag 1 tablet;1 TABLET 1 UUR VOOR DE MAALTIJD
  * Toedieningsweg: 
  * Stop type: 
* ><: 
  * Bron: **Afspraakdatum**6-8-2025**Voorschrijver**Jenneke van der Vecht
* ><: ><
  * Bron: Bron
  * Start: Start
  * Eind: Eind
  * Medicatie: Medicatie
  * Dosering & instructies: Dosering & instructies
  * Toedieningsweg: Toedieningsweg
  * Stop type: Stop type
* ><: +
  * Bron: Epic
  * Start: 
  * Eind: 
  * Medicatie: simvastatine 20mg tablet
  * Dosering & instructies: innemen. s Avonds innemen; Bij dit middel GEEN grapefruit(sap) gebruiken
  * Toedieningsweg: Oraal
  * Stop type: 
* ><: 
  * Bron: **Registratiedatum**15-3-2018**Type**huidig

### Kolom Definities

* UITKLAPVELD: *MedicationRequest*
* UITKLAPVELD: Bron
  * ?: `meta.extension('http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source').valueUri`
  * ?: `string`
  * ?: nvt
  * ?: Lookup adhv uri (AGB-Z of OID)`<adressering-base>/Organization?identifier=<.meta.tag.code>`en gebruik dan`Organization.name`
* UITKLAPVELD: Start
  * ?: `extension('http://nictiz.nl/fhir/StructureDefinition/zib-Medication-PeriodOfUse').valuePeriod.start`
  * ?: `dateTime`
  * ?: Gebruiksperiode::TijdsInterval/startDatumTijd
  * ?: 
* UITKLAPVELD: Eind
  * ?: `extension('http://nictiz.nl/fhir/StructureDefinition/zib-Medication-PeriodOfUse').valuePeriod.end`
  * ?: `dateTime`
  * ?: Gebruiksperiode::TijdsInterval/eindDatumTijd
  * ?: 
* UITKLAPVELD: Medicatie
  * ?: `medication.display`
  * ?: `string`
  * ?: Afgesprokengeneesmiddel::Product
  * ?: 
* UITKLAPVELD: Dosering & instructies
  * ?: `dosageInstruction.text | extension('http://nictiz.nl/fhir/StructureDefinition/ext-RenderedDosageInstruction').valueString`
  * ?: `string`
  * ?: Gebruiksinstructie/Omschrijving, Gebruiksinstructie/AanvullendeInstructie
  * ?: N.B. Als text niet beschikbaar dan samenstellen uit discrete informatie en markeren met een icoontje ⓘ
* UITKLAPVELD: Toedieningsweg
  * ?: `iif(exists(dosageInstruction.route.text), dosageInstruction.route.text, dosageInstruction.route.coding.display)`
  * ?: `string`
  * ?: Gebruiksinstructie/Toedieningsweg
  * ?: 
* UITKLAPVELD: Stop type
  * ?: `modifierExtension.where(url='http://nictiz.nl/fhir/StructureDefinition/zib-Medication-StopType').valueCodeableConcept.coding.display`
  * ?: `string`
  * ?: StopType
  * ?: 
* UITKLAPVELD: +Medicatie vorm
  * ?: `medication.resolve().form.coding.display`
  * ?: `string`
  * ?: Afgesprokengeneesmiddel::FarmaceutischProduct/FarmaceutischeVorm
  * ?: 
* UITKLAPVELD: +Afspraakdatum
  * ?: `authoredOn`
  * ?: `dateTime`
  * ?: MedicatieafspraakDatumTijd
  * ?: 
* UITKLAPVELD: +Voorschrijver
  * ?: `requester.agent.display | requester.display`
  * ?: `string`
  * ?: Voorschrijver::Zorgverlener
  * ?: **LET OP:**`requester.display`is een FHIR R4 veld
* UITKLAPVELD: *MedicationStatement*
* UITKLAPVELD: Bron
  * ?: `meta.extension('http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source').valueUri`
  * ?: `string`
  * ?: nvt
  * ?: Lookup adhv uri (AGB-Z of OID)`<adressering-base>/Organization?identifier=<.meta.tag.code>`en gebruik dan`Organization.name`
* UITKLAPVELD: Start
  * ?: `effectivePeriod.start`
  * ?: `dateTime`
  * ?: Gebruiksperiode::TijdsInterval/startDatumTijd
  * ?: 
* UITKLAPVELD: Eind
  * ?: `effectivePeriod.end`
  * ?: `dateTime`
  * ?: Gebruiksperiode::TijdsInterval/eindDatumTijd
  * ?: 
* UITKLAPVELD: Medicatie
  * ?: `medication.display`
  * ?: `string`
  * ?: Gebruiksproduct
  * ?: 
* UITKLAPVELD: Dosering & instructies
  * ?: `dosage.text`
  * ?: `string`
  * ?: Gebruiksinstructie/Omschrijving, Gebruiksinstructie/AanvullendeInstructie
  * ?: N.B. Als gegenereerd uit discrete informatie dan wordt deze gemarkeerd met een icoontje ⓘ
* UITKLAPVELD: Toedieningsweg
  * ?: `dosage.route.text`
  * ?: `string`
  * ?: Gebruiksinstructie/Toedieningsweg
  * ?: 
* UITKLAPVELD: Stop type
  * ?: `''`
  * ?: `string`
  * ?: *nvt*
  * ?: Niet van toepassing bij MedicationStatement
* UITKLAPVELD: UITKLAPVELD
* UITKLAPVELD: +Medicatie vorm
  * ?: `medication.resolve().form.coding.display`
  * ?: `string`
  * ?: Gebruiksproduct::FarmaceutischProduct/FarmaceutischeVorm
  * ?: 
* UITKLAPVELD: +Registratiedatum
  * ?: `dateAsserted`
  * ?: `dateTime`
  * ?: MedicatieGebruikDatumTijd
  * ?: 
* UITKLAPVELD: +Voorschrijver
  * ?: `extension('http://nictiz.nl/fhir/StructureDefinition/zib-MedicationUse-Prescriber').valueReference.display`
  * ?: `string`
  * ?: Voorschrijver::Zorgverlener
  * ?: 
* UITKLAPVELD: +Type
  * ?: `'huidig'`
  * ?: `string`
  * ?: *nvt*
  * ?: 

### Requests

Er is geen request waarmee je beide resources in 1 keer kan opvragen. Je moet hiervoor dus een request doen per resource.

* Zie [MedicationRequest](StructureDefinition-MedicationRequest.md#request) en [MedicationStatement](StructureDefinition-MedicationStatement.md#request)

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.zorgviewer|current/StructureDefinition/Medicatiegegevens)

**Changes since version 1.20.0:**

* No changes

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Medicatiegegevens.csv), [Excel](StructureDefinition-Medicatiegegevens.xlsx), [Schematron](StructureDefinition-Medicatiegegevens.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Medicatiegegevens",
  "url" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Medicatiegegevens",
  "version" : "1.21.0",
  "name" : "Medicatiegegevens",
  "title" : "Medicatiegegevens",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-28T13:36:22+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Medicatiegegevens abstract samenstelling voor het documenteren van de combinatie van Medicatieafspraak en Medicatie Gebruik",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "fhirVersion" : "3.0.2",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/w5",
      "name" : "W5 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : true,
  "type" : "Bundle",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Bundle",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Bundle",
        "path" : "Bundle"
      },
      {
        "id" : "Bundle.type",
        "path" : "Bundle.type",
        "short" : "searchset",
        "fixedCode" : "searchset"
      },
      {
        "id" : "Bundle.entry",
        "path" : "Bundle.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resource"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Bundle.entry:MedicationRequest",
        "path" : "Bundle.entry",
        "sliceName" : "MedicationRequest",
        "short" : "MedicationRequest"
      },
      {
        "id" : "Bundle.entry:MedicationRequest.fullUrl",
        "path" : "Bundle.entry.fullUrl",
        "min" : 1
      },
      {
        "id" : "Bundle.entry:MedicationRequest.resource",
        "path" : "Bundle.entry.resource",
        "comment" : "Medicationafspraak",
        "min" : 1,
        "type" : [
          {
            "code" : "MedicationRequest",
            "profile" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/MedicationRequest"
          }
        ]
      },
      {
        "id" : "Bundle.entry:MedicationStatement",
        "path" : "Bundle.entry",
        "sliceName" : "MedicationStatement",
        "short" : "MedicationStatement"
      },
      {
        "id" : "Bundle.entry:MedicationStatement.fullUrl",
        "path" : "Bundle.entry.fullUrl",
        "min" : 1
      },
      {
        "id" : "Bundle.entry:MedicationStatement.resource",
        "path" : "Bundle.entry.resource",
        "comment" : "Medicationgebruik",
        "min" : 1,
        "type" : [
          {
            "code" : "MedicationStatement",
            "profile" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/MedicationStatement"
          }
        ]
      }
    ]
  }
}

```
