# Nexus Procedure (Surgical History) Example - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Nexus Procedure (Surgical History) Example**

## Example Procedure: Nexus Procedure (Surgical History) Example

* Based On: Prothese implantatie kniegewricht.
  * ProcedureRequest: Performed: FromNoTo 6 May 2012
* Based On: Body Site
  * ProcedureRequest: structuur van kniegewricht (lichaamsstructuur)links
* Based On: typeCode-RSON
  * ProcedureRequest: artropathie



## Resource Content

```json
{
  "resourceType" : "Procedure",
  "id" : "25102292",
  "meta" : {
    "lastUpdated" : "2024-04-17T11:49:15.508+02:00",
    "profile" : ["http://nictiz.nl/fhir/StructureDefinition/zib-Procedure"]
  },
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.2.4.3.148.1.1.6.31.25102292"
    }
  ],
  "basedOn" : [
    {
      "reference" : "http://example.org/ProcedureRequest/45d3945c-dcbd-4587-90f9-fa30245adced",
      "display" : "ProcedureRequest"
    }
  ],
  "status" : "completed",
  "category" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "387713003",
        "display" : "Surgical procedure"
      }
    ]
  },
  "code" : {
    "coding" : [
      {
        "system" : "urn:oid:2.16.840.1.113883.2.4.3.27.15.5",
        "code" : "038663",
        "display" : "Prothese implantatie kniegewricht."
      }
    ]
  },
  "subject" : {
    "reference" : "http://example.org/Patient/330073",
    "display" : "Xxx-Helleman, J (M)"
  },
  "performedPeriod" : {
    "start" : "2012-05-06"
  },
  "performer" : [
    {
      "actor" : {
        "extension" : [
          {
            "url" : "http://nictiz.nl/fhir/StructureDefinition/practitionerrole-reference",
            "valueReference" : {
              "reference" : "http://example.org/PractitionerRole/406",
              "display" : "Boonstra"
            }
          }
        ],
        "reference" : "http://example.org/Practitioner/406",
        "display" : "Boonstra"
      }
    },
    {
      "actor" : {
        "reference" : "http://example.org/Organization/4107EC15F3AA846EA912B85ABBA115644166D760",
        "display" : "VIPP NEXUS Ziekenhuis"
      }
    }
  ],
  "reasonReference" : [
    {
      "reference" : "http://example.org/Condition/830",
      "display" : "artropathie"
    }
  ],
  "bodySite" : [
    {
      "extension" : [
        {
          "url" : "http://nictiz.nl/fhir/StructureDefinition/BodySite-Qualifier",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "7771000",
                "display" : "links"
              }
            ]
          }
        }
      ],
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "49076000",
          "display" : "structuur van kniegewricht (lichaamsstructuur)"
        }
      ]
    }
  ]
}

```
