# Sanday VitalSign Example - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Sanday VitalSign Example**

## Example Observation: Sanday VitalSign Example

Profile: [Observation](http://hl7.org/fhir/STU3/observation.html)

**status**: Final

**category**: vital-signs

**code**: hartfrequentie (thuismeting)

**subject**: [Patient/6F872FD1-BC0A-4A4C-A48E-D2B7C17142BE](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&canonical=https://simplifier.net/packages/nictiz.fhir.nl.stu3.eafspraak/1.0.6/Patient/6F872FD1-BC0A-4A4C-A48E-D2B7C17142BE)

**effective**: 2024-03-21 15:31:00+0000

**issued**: 2024-03-21 15:31:00+0000

**performer**: [Practitioner/b80608b1-851d-47e4-a0ef-c52b30e5aa2d](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&canonical=https://simplifier.net/packages/nictiz.fhir.nl.stu3.eafspraak/1.0.6/Practitioner/b80608b1-851d-47e4-a0ef-c52b30e5aa2d)

**value**: 80 aantal/min

### ReferenceRanges

| | | |
| :--- | :--- | :--- |
| - | **Low** | **High** |
| * | 60.0 aantal/min(Details: UCUM codeaantal/min = 'aantal/min') | 100.0 aantal/min(Details: UCUM codeaantal/min = 'aantal/min') |



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "2a35354e-9624-454c-a083-edabf7930c5a",
  "meta" : {
    "profile" : ["http://hl7.org/fhir/StructureDefinition/Observation"]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/observation-category",
          "code" : "vital-signs",
          "display" : "vital-signs"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "https://referentiemodel.nhg.org/tabellen/nhg-tabel-45-diagnostische-bepalingen",
        "code" : "3963",
        "display" : "hartfrequentie (thuismeting)"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/6F872FD1-BC0A-4A4C-A48E-D2B7C17142BE",
    "identifier" : {
      "value" : "6F872FD1-BC0A-4A4C-A48E-D2B7C17142BE"
    }
  },
  "effectiveDateTime" : "2024-03-21T15:31:00+00:00",
  "issued" : "2024-03-21T15:31:00.000+00:00",
  "performer" : [
    {
      "reference" : "Practitioner/b80608b1-851d-47e4-a0ef-c52b30e5aa2d",
      "identifier" : {
        "value" : "b80608b1-851d-47e4-a0ef-c52b30e5aa2d"
      }
    }
  ],
  "valueString" : "80 aantal/min",
  "referenceRange" : [
    {
      "low" : {
        "value" : 60.0,
        "unit" : "aantal/min",
        "system" : "http://unitsofmeasure.org",
        "code" : "aantal/min"
      },
      "high" : {
        "value" : 100.0,
        "unit" : "aantal/min",
        "system" : "http://unitsofmeasure.org",
        "code" : "aantal/min"
      }
    }
  ]
}

```
