# Epic TreatmentDirective Example - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Epic TreatmentDirective Example**

## Example Consent: Epic TreatmentDirective Example

Profile: [HCIM TreatmentDirective](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.zib2017@2.3.1&canonical=http://nictiz.nl/fhir/StructureDefinition/zib-TreatmentDirective)

> **HCIM TreatmentDirective Verification**
* Verified: true
* VerifiedWith: patiënt (persoon)

**HCIM TreatmentDirective Treatment**: kunstmatige beademing (verrichting)

**HCIM TreatmentDirective TreatmentPermitted**: Ja, maar met beperkingen

**identifier**: `urn:oid:1.2.840.114350.1.13.485.3.7.2.798268`/20381675 (use: usual, )

**status**: Active

**category**: Advance Directive

**patient**: [XXX-Helleman, Johan](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&canonical=https:///example.org/TST-OAUTH2/api/FHIR/STU3/Patient/eXxP1o8ZlOz21F6HXS9puLA3)

**period**: 2022-03-22 12:45:21+0000 --> (ongoing)

**dateTime**: 2022-03-22 12:45:21+0000

### Policies

| | |
| :--- | :--- |
| - | **Extension** |
| * |  |

### Excepts

| | | |
| :--- | :--- | :--- |
| - | **Extension** | **Type** |
| * |  | Opt Out |



## Resource Content

```json
{
  "resourceType" : "Consent",
  "id" : "ehLhIC8xuXjiZDVRntQauPyXlKehTcmaSh3Ozrs3nMfw3",
  "meta" : {
    "profile" : [
      "http://nictiz.nl/fhir/StructureDefinition/zib-TreatmentDirective"
    ]
  },
  "extension" : [
    {
      "extension" : [
        {
          "url" : "Verified",
          "valueBoolean" : true
        },
        {
          "url" : "VerifiedWith",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "116154003",
                "display" : "patiënt (persoon)"
              },
              {
                "system" : "urn:oid:1.2.840.114350.1.13.485.3.7.4.696784.72007",
                "code" : "1",
                "display" : "Patiënt"
              }
            ],
            "text" : "patiënt (persoon)"
          }
        }
      ],
      "url" : "http://nictiz.nl/fhir/StructureDefinition/zib-TreatmentDirective-Verification"
    },
    {
      "url" : "http://nictiz.nl/fhir/StructureDefinition/zib-TreatmentDirective-Treatment",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "40617009",
            "display" : "kunstmatige beademing (verrichting)"
          },
          {
            "system" : "urn:oid:1.2.840.114350.1.13.485.3.7.4.696784.72009",
            "code" : "3",
            "display" : "Kunstmatige beademing"
          }
        ],
        "text" : "kunstmatige beademing (verrichting)"
      }
    }
  ],
  "modifierExtension" : [
    {
      "url" : "http://nictiz.nl/fhir/StructureDefinition/zib-TreatmentDirective-TreatmentPermitted",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:oid:2.16.840.1.113883.2.4.3.11.60.40.4",
            "code" : "JA_MAAR",
            "display" : "Ja, maar met beperkingen"
          }
        ]
      }
    }
  ],
  "identifier" : {
    "use" : "usual",
    "system" : "urn:oid:1.2.840.114350.1.13.485.3.7.2.798268",
    "value" : "20381675"
  },
  "status" : "active",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/consentcategorycodes",
          "code" : "acd",
          "display" : "Advance Directive"
        },
        {
          "system" : "urn:oid:1.2.840.114350.1.13.485.3.7.4.796783.100",
          "code" : "3042102",
          "display" : "Vastgelegd"
        },
        {
          "system" : "http://snomed.info/sct",
          "code" : "11291000146105"
        }
      ]
    }
  ],
  "patient" : {
    "reference" : "https:///example.org/TST-OAUTH2/api/FHIR/STU3/Patient/eXxP1o8ZlOz21F6HXS9puLA3",
    "display" : "XXX-Helleman, Johan"
  },
  "period" : {
    "start" : "2022-03-22T12:45:21Z"
  },
  "dateTime" : "2022-03-22T12:45:21Z",
  "policy" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
          "valueCode" : "unknown"
        }
      ]
    }
  ],
  "except" : [
    {
      "extension" : [
        {
          "url" : "http://nictiz.nl/fhir/StructureDefinition/zib-TreatmentDirective-Restrictions",
          "valueString" : "Eerst overleg met echtgenote"
        }
      ],
      "type" : "deny"
    }
  ]
}

```
