# Vitale Gegevens Groep Mapping - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Vitale Gegevens Groep Mapping**

## ConceptMap: Vitale Gegevens Groep Mapping 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/ConceptMap/vital-signs-groups | *Version*:1.21.0 |
| Active as of 2025-10-28 | *Computable Name*:vitalsignsgroups |

 
Deze ConceptMap representeert de mappings van de vitale gegevens codes van LOINC en NHG tabel 45 naar LOINC 'groep' codes. 

Deze ConceptMap mappings worden gebruikt om vitale gegevens te groeperen. Groep ( LOINC code) opzoeken door `wider` mapping te volgen van NHG tabel 45 en LOINC. Zie ook [Mapping NHG en LOINC](https://stichtinglegio.nl/wp-content/uploads/2021/11/20211124-zelfmetingen-OPEN-en-vrije-tekst.xlsx) op de pagina van [VIPP OPEN](https://stichtinglegio.nl/projecten/vipp-open/).

Mapping from Bronsysteem to [http://loinc.org](http://terminology.hl7.org/5.3.0/CodeSystem-v3-loinc.html)

**Group 1**Mapping from [Logical Observation Identifiers, Names and Codes (LOINC)](http://terminology.hl7.org/5.3.0/CodeSystem-v3-loinc.html) to [Logical Observation Identifiers, Names and Codes (LOINC)](http://terminology.hl7.org/5.3.0/CodeSystem-v3-loinc.html)

* **Source Code**: 55284-4 (Blood pressure systolic and diastolic)
  * **Relationship**: [maps to wider concept](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#wider)
  * **Target Code**: 35094-2 (Bloeddruk)
* **Source Code**: 85354-9 (RR)
  * **Relationship**: [maps to wider concept](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#wider)
  * **Target Code**: 35094-2 (Bloeddruk)
* **Source Code**: 8480-6 (Systolic)
  * **Relationship**: [maps to wider concept](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#wider)
  * **Target Code**: 35094-2 (Bloeddruk)
* **Source Code**: 8462-4 (Diastolic)
  * **Relationship**: [maps to wider concept](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#wider)
  * **Target Code**: 35094-2 (Bloeddruk)
* **Source Code**: 8478-0 (MAP)
  * **Relationship**: [maps to wider concept](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#wider)
  * **Target Code**: 35094-2 (Bloeddruk)
* **Source Code**: 9279-1 (Respiratory rate)
  * **Relationship**: [maps to wider concept](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#wider)
  * **Target Code**: 9279-1 (Ademhaling)
* **Source Code**: 2708-6 (Oxygen saturation in Arterial blood)
  * **Relationship**: [maps to wider concept](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#wider)
  * **Target Code**: 9279-1 (Ademhaling)
* **Source Code**: 59408-5 (Oxygen saturation in Arterial blood by Pulse oximetry)
  * **Relationship**: [maps to wider concept](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#wider)
  * **Target Code**: 9279-1 (Ademhaling)
* **Source Code**: 8867-4 (Heart rate)
  * **Relationship**: [maps to wider concept](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#wider)
  * **Target Code**: LG33055-1 (Hartslag)
* **Source Code**: 8893-0 (Heart rate Peripheral artery by Palpation)
  * **Relationship**: [maps to wider concept](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#wider)
  * **Target Code**: LG33055-1 (Hartslag)
* **Source Code**: 8302-2 (Body height)
  * **Relationship**: [maps to wider concept](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#wider)
  * **Target Code**: LG70-5 (Lichaamsmaten)
* **Source Code**: 29463-7 (Body weight)
  * **Relationship**: [maps to wider concept](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#wider)
  * **Target Code**: LG70-5 (Lichaamsmaten)
* **Source Code**: 8310-5 (Body temperature)
  * **Relationship**: [maps to wider concept](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#wider)
  * **Target Code**: LG33052-8 (Temperatuur)

-------

**Group 2**Mapping from `https://referentiemodel.nhg.org/tabellen/nhg-tabel-45-diagnostische-bepalingen` to [Logical Observation Identifiers, Names and Codes (LOINC)](http://terminology.hl7.org/5.3.0/CodeSystem-v3-loinc.html)

* **Source Code**: 1744 (systolische bloeddruk)
  * **Relationship**: [maps to wider concept](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#wider)
  * **Target Code**: 35094-2 (Bloeddruk)
* **Source Code**: 1740 (diastolische bloeddruk)
  * **Relationship**: [maps to wider concept](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#wider)
  * **Target Code**: 35094-2 (Bloeddruk)
* **Source Code**: 2055 (systolic)
  * **Relationship**: [maps to wider concept](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#wider)
  * **Target Code**: 35094-2 (Bloeddruk)
* **Source Code**: 2056 (diastolic)
  * **Relationship**: [maps to wider concept](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#wider)
  * **Target Code**: 35094-2 (Bloeddruk)
* **Source Code**: 2680 (zuurstofsaturatie (pulsoximeter))
  * **Relationship**: [maps to wider concept](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#wider)
  * **Target Code**: 9279-1 (Ademhaling)
* **Source Code**: 3963 (hartfrequentie)
  * **Relationship**: [maps to wider concept](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#wider)
  * **Target Code**: LG33055-1 (Hartslag)
* **Source Code**: 1875 (polsfrequentie)
  * **Relationship**: [maps to wider concept](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#wider)
  * **Target Code**: LG33055-1 (Hartslag)
* **Source Code**: 357 (gewicht patiënt)
  * **Relationship**: [maps to wider concept](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#wider)
  * **Target Code**: LG70-5 (Lichaamsmaten)
* **Source Code**: 560 (lengte patiënt)
  * **Relationship**: [maps to wider concept](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#wider)
  * **Target Code**: LG70-5 (Lichaamsmaten)
* **Source Code**: 1272 (Quetelet-index (BMI) patiënt)
  * **Relationship**: [maps to wider concept](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#wider)
  * **Target Code**: LG70-5 (Lichaamsmaten)
* **Source Code**: 3017 (lichaamsoppervlakte)
  * **Relationship**: [maps to wider concept](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#wider)
  * **Target Code**: LG70-5 (Lichaamsmaten)
* **Source Code**: 1357 (temperatuur patiënt)
  * **Relationship**: [maps to wider concept](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#wider)
  * **Target Code**: LG33052-8 (Temperatuur)
* **Source Code**: 3963 (hartfrequentie)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: 8867-4 (Hartfrequentie)
* **Source Code**: 1357 (temperatuur)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: 8310-5 (Temperatuur)
* **Source Code**: 560 (lengte patiënt)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: 8302-2 (Lengte)
* **Source Code**: 2408 (gewicht patiënt)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: 29463-7 (Gewicht)
* **Source Code**: 2680 (zuurstofsaturatie (pulsoximeter))
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: 59408-5 (Zuurstofsaturatie)
* **Source Code**: 1740 (diastolische bloeddruk)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: 8462-4 (Diastolic)
* **Source Code**: 1744 (systolische bloeddruk)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: 8480-6 (Systolic)
* **Source Code**: 2055 (systolic)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: 8480-6 (Systolic)
* **Source Code**: 2056 (diastolic)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: 8462-4 (Diastolic)



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "vital-signs-groups",
  "url" : "http://fhir.hl7.nl/zorgviewer/ConceptMap/vital-signs-groups",
  "version" : "1.21.0",
  "name" : "vitalsignsgroups",
  "title" : "Vitale Gegevens Groep Mapping",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-28T13:36:22+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Deze ConceptMap representeert de mappings van de vitale gegevens codes van LOINC en NHG tabel 45 naar LOINC 'groep' codes.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "sourceUri" : "Bronsysteem",
  "targetUri" : "http://loinc.org",
  "group" : [
    {
      "source" : "http://loinc.org",
      "target" : "http://loinc.org",
      "element" : [
        {
          "code" : "55284-4",
          "display" : "Blood pressure systolic and diastolic",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "35094-2",
              "display" : "Bloeddruk",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "85354-9",
          "display" : "RR",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "35094-2",
              "display" : "Bloeddruk",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "8480-6",
          "display" : "Systolic",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "35094-2",
              "display" : "Bloeddruk",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "8462-4",
          "display" : "Diastolic",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "35094-2",
              "display" : "Bloeddruk",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "8478-0",
          "display" : "MAP",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "35094-2",
              "display" : "Bloeddruk",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "9279-1",
          "display" : "Respiratory rate",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "9279-1",
              "display" : "Ademhaling",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "2708-6",
          "display" : "Oxygen saturation in Arterial blood",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "9279-1",
              "display" : "Ademhaling",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "59408-5",
          "display" : "Oxygen saturation in Arterial blood by Pulse oximetry",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "9279-1",
              "display" : "Ademhaling",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "8867-4",
          "display" : "Heart rate",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "LG33055-1",
              "display" : "Hartslag",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "8893-0",
          "display" : "Heart rate Peripheral artery by Palpation",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "LG33055-1",
              "display" : "Hartslag",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "8302-2",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "LG70-5",
              "display" : "Lichaamsmaten",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "29463-7",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "LG70-5",
              "display" : "Lichaamsmaten",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "8310-5",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "LG33052-8",
              "display" : "Temperatuur",
              "equivalence" : "wider"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://referentiemodel.nhg.org/tabellen/nhg-tabel-45-diagnostische-bepalingen",
      "target" : "http://loinc.org",
      "element" : [
        {
          "code" : "1744",
          "display" : "systolische bloeddruk",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "35094-2",
              "display" : "Bloeddruk",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "1740",
          "display" : "diastolische bloeddruk",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "35094-2",
              "display" : "Bloeddruk",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "2055",
          "display" : "systolic",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "35094-2",
              "display" : "Bloeddruk",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "2056",
          "display" : "diastolic",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "35094-2",
              "display" : "Bloeddruk",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "2680",
          "display" : "zuurstofsaturatie (pulsoximeter)",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "9279-1",
              "display" : "Ademhaling",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "3963",
          "display" : "hartfrequentie",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "LG33055-1",
              "display" : "Hartslag",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "1875",
          "display" : "polsfrequentie",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "LG33055-1",
              "display" : "Hartslag",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "357",
          "display" : "gewicht patiënt",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "LG70-5",
              "display" : "Lichaamsmaten",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "560",
          "display" : "lengte patiënt",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "LG70-5",
              "display" : "Lichaamsmaten",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "1272",
          "display" : "Quetelet-index (BMI) patiënt",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "LG70-5",
              "display" : "Lichaamsmaten",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "3017",
          "display" : "lichaamsoppervlakte",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "LG70-5",
              "display" : "Lichaamsmaten",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "1357",
          "display" : "temperatuur patiënt",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "LG33052-8",
              "display" : "Temperatuur",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "3963",
          "display" : "hartfrequentie",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "8867-4",
              "display" : "Hartfrequentie",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "1357",
          "display" : "temperatuur",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "8310-5",
              "display" : "Temperatuur",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "560",
          "display" : "lengte patiënt",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "8302-2",
              "display" : "Lengte",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "2408",
          "display" : "gewicht patiënt",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "29463-7",
              "display" : "Gewicht",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "2680",
          "display" : "zuurstofsaturatie (pulsoximeter)",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "59408-5",
              "display" : "Zuurstofsaturatie",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "1740",
          "display" : "diastolische bloeddruk",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "8462-4",
              "display" : "Diastolic",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "1744",
          "display" : "systolische bloeddruk",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "8480-6",
              "display" : "Systolic",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "2055",
          "display" : "systolic",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "8480-6",
              "display" : "Systolic",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "2056",
          "display" : "diastolic",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "8462-4",
              "display" : "Diastolic",
              "equivalence" : "equal"
            }
          ]
        }
      ]
    }
  ]
}

```
