# RolCodeNL naar SNOMED-CT Mapping - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **RolCodeNL naar SNOMED-CT Mapping**

## ConceptMap: RolCodeNL naar SNOMED-CT Mapping 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/ConceptMap/rolcodenl | *Version*:1.21.0 |
| Active as of 2025-10-28 | *Computable Name*:rolcodenl |

 
Deze ConceptMap representeert de mapping tussen RolCodeNL naar een SNOMED-CT code. N.B. hier betekent een '*' in de code een wildcard. 

### Source

* **Naam**: RoleCodeNLZorgverlenertypen
* **Canonical**: http://fhir.nl/fhir/NamingSystem/uzi-rolcode
* **Alternatief OID**: urn:oid:2.16.840.1.113883.2.4.15.111

De lijst [https://simplifier.net/nictiz-r4-zib2020/uzi-rolcode](https://simplifier.net/nictiz-r4-zib2020/uzi-rolcode)

### Target

SNOMED CT beroepen.

Mapping from (not specified) to (not specified)

**Group 1**Mapping from `urn:oid:2.16.840.1.113883.2.4.15.111|RolCodeNL` to [SNOMED CT (all versions)](http://hl7.org/fhir/STU3/codesystem-snomedct.html)

* **Source Code**: 01.* (Arts)
  * **Relationship**: [narrower](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#narrower)
  * **Target Code**: 309343006 (Medical doctor)
  * **Comment**: Allemaal artsen
* **Source Code**: 02.054 (Kaakchirurg)
  * **Relationship**: [narrower](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#narrower)
  * **Target Code**: 309343006 (Medical doctor)
  * **Comment**: Een kaakchirurg is een arts



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "rolcodenl",
  "url" : "http://fhir.hl7.nl/zorgviewer/ConceptMap/rolcodenl",
  "version" : "1.21.0",
  "name" : "rolcodenl",
  "title" : "RolCodeNL naar SNOMED-CT Mapping",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-28T13:36:22+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Deze ConceptMap representeert de mapping tussen RolCodeNL naar een SNOMED-CT code. N.B. hier betekent een '*' in de code een wildcard.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "urn:oid:2.16.840.1.113883.2.4.15.111",
      "sourceVersion" : "RolCodeNL",
      "target" : "http://snomed.info/sct",
      "element" : [
        {
          "code" : "01.*",
          "display" : "Arts",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "narrower"
                }
              ],
              "code" : "309343006",
              "display" : "Medical doctor",
              "equivalence" : "narrower",
              "comment" : "Allemaal artsen"
            }
          ]
        },
        {
          "code" : "02.054",
          "display" : "Kaakchirurg",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "narrower"
                }
              ],
              "code" : "309343006",
              "display" : "Medical doctor",
              "equivalence" : "narrower",
              "comment" : "Een kaakchirurg is een arts"
            }
          ]
        }
      ]
    }
  ]
}

```
