# Patient Toestemming Mapping - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient Toestemming Mapping**

## ConceptMap: Patient Toestemming Mapping 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/ConceptMap/patient-toestemming | *Version*:1.21.0 |
| Active as of 2025-10-28 | *Computable Name*:PatientToestemmingMapping |

 
Deze ConceptMap representeert de mapping van een patient-toestemming HL7 v2 bericht (PID en CON segmenten) naar FHIR Concent Resource. 

**De specificatie op deze pagina is work-in-progress.**

Akkoord voorbeeld HL7 v2 relevante bericht segmenten:

```
PID|1||7765853^^^UMCG^PI~012345678^^^NLMINBIZA^NNNLD||...
...
CON|1|Doss. delen?|||||||||AKKOORD||20230620000503||20430614235959||||||||||
...

```

Geweigerd voorbeeld HL7 v2 relevante bericht segmenten:

```
PID|1||7765853^^^UMCG^PI~012345678^^^NLMINBIZA^NNNLD||...
...
CON|1|Doss. delen?|||||||||GEWEIGERD||20230517121415||20430511235959||||||||||
...

```

Mapping from HL7v2 to [ToestemmingConsent](StructureDefinition-ToestemmingConsent.md)

**Group 1**Mapping from `unspecified code system` to `unspecified code system`

* **Source Code**: PID-2 (Patient BSN (NLMINBIZA^NNNLD))
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: patient.identifier (system=BSN)
* **Source Code**: CON-2 (Doss. delen?)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: category ('Doss. delen?')
* **Source Code**: CON-11 (Status)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: status ('AKKOORD' of 'TIJDELIJK' > active, 'GEWEIGERD' > rejected))
* **Source Code**: CON-13 (Startdatum)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: period.start
* **Source Code**: CON-15 (Einddatum)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: period.end



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "patient-toestemming",
  "url" : "http://fhir.hl7.nl/zorgviewer/ConceptMap/patient-toestemming",
  "version" : "1.21.0",
  "name" : "PatientToestemmingMapping",
  "title" : "Patient Toestemming Mapping",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-28T13:36:22+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Deze ConceptMap representeert de mapping van een patient-toestemming HL7 v2 bericht (PID en CON segmenten) naar FHIR Concent Resource.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "sourceUri" : "HL7v2",
  "targetUri" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/ToestemmingConsent",
  "group" : [
    {
      "element" : [
        {
          "code" : "PID-2",
          "display" : "Patient BSN (NLMINBIZA^NNNLD)",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equivalent"
                }
              ],
              "code" : "patient.identifier",
              "display" : "system=BSN",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "CON-2",
          "display" : "Doss. delen?",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equivalent"
                }
              ],
              "code" : "category",
              "display" : "'Doss. delen?'",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "CON-11",
          "display" : "Status",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equivalent"
                }
              ],
              "code" : "status",
              "display" : "'AKKOORD' of 'TIJDELIJK' > active, 'GEWEIGERD' > rejected)",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "CON-13",
          "display" : "Startdatum",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equivalent"
                }
              ],
              "code" : "period.start",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "CON-15",
          "display" : "Einddatum",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equivalent"
                }
              ],
              "code" : "period.end",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    }
  ]
}

```
