# Zorgviewer AuditEvent Example - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Zorgviewer AuditEvent Example**

## Example AuditEvent: Zorgviewer AuditEvent Example

**type**: [DICOM 110110](http://hl7.org/fhir/STU3/codesystem-dicom-dcim.html#dicom-dcim-110110): Patient Record

**action**: Read/View/Print

**recorded**: 2023-04-25 22:04:27+1100

> **agent****role**:Directly involved healthcare professional**userId**: Vektis AGB-z zorgverlener tabel/06020101**name**: Schroder, CP, Arts**requestor**: false**policy**:[https://rivo-noord.nl/zorgviewer/toestemming](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&canonical=https://rivo-noord.nl/zorgviewer/toestemming)

### Networks

| | |
| :--- | :--- |
| - | **Address** |
| * | w3zkh3348.intra.umcg.nl |


### Sources

| | |
| :--- | :--- |
| - | **Identifier** |
| * | Zorgviewer RIVO-Noord |

> **entity****identifier**: Burgerservicenummer (BSN)/999911120**type**:[AuditEventEntityType 1](http://hl7.org/fhir/STU3/codesystem-audit-entity-type.html#audit-entity-type-1): Person**name**: J. XXX-Helleman

### Details

| | | |
| :--- | :--- | :--- |
| - | **Type** | **Value** |
| * | X-Request-Id | `MDFkZWFhOWMtMzU5Ny00NmU2LTk2MTItNTAwMzgwOTdmMjg0Cg==` |




## Resource Content

```json
{
  "resourceType" : "AuditEvent",
  "id" : "example-auditevent-zorgviewer",
  "type" : {
    "system" : "http://dicom.nema.org/resources/ontology/DCM",
    "code" : "110110",
    "display" : "Patient Record"
  },
  "action" : "R",
  "recorded" : "2023-04-25T22:04:27+11:00",
  "agent" : [
    {
      "role" : [
        {
          "coding" : [
            {
              "code" : "05",
              "display" : "Directly involved healthcare professional"
            }
          ]
        }
      ],
      "userId" : {
        "system" : "http://fhir.nl/fhir/NamingSystem/agb-z",
        "value" : "06020101"
      },
      "name" : "Schroder, CP, Arts",
      "requestor" : false,
      "policy" : ["https://rivo-noord.nl/zorgviewer/toestemming"],
      "network" : {
        "address" : "w3zkh3348.intra.umcg.nl"
      }
    }
  ],
  "source" : {
    "identifier" : {
      "value" : "Zorgviewer RIVO-Noord"
    }
  },
  "entity" : [
    {
      "identifier" : {
        "system" : "http://fhir.nl/fhir/NamingSystem/bsn",
        "value" : "999911120"
      },
      "type" : {
        "system" : "http://hl7.org/fhir/audit-entity-type",
        "code" : "1"
      },
      "name" : "J. XXX-Helleman",
      "detail" : [
        {
          "type" : "X-Request-Id",
          "value" : "MDFkZWFhOWMtMzU5Ny00NmU2LTk2MTItNTAwMzgwOTdmMjg0Cg=="
        }
      ]
    }
  ]
}

```
