# Chipsoft AllergyIntolerance Example - RIVO-Noord Zorgviewer Implementation Guide v1.21.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Chipsoft AllergyIntolerance Example**

## Example AllergyIntolerance: Chipsoft AllergyIntolerance Example

### Allergy resource:

* **Patient:** 'Test Gestructureerd Vipp'
* **Clinical status:** 'Active'
* **Verification status:** 'Unconfirmed'
* **Onset:** '12-11-2019 14:02+0100'
* **Category:** 'Propensity to adverse reactions to drug'
* **Criticality:** 'Mild'
* **Code:** 'ALLE NSAID'S (INCL. SALICYLATEN)'
* 

| | |
| :--- | :--- |
| Reaction 1 | Other; |




## Resource Content

```json
{
  "resourceType" : "AllergyIntolerance",
  "id" : "2.16.840.1.113883.2.4.3.124.7.48765.212340000000820",
  "meta" : {
    "profile" : [
      "http://nictiz.nl/fhir/StructureDefinition/zib-AllergyIntolerance"
    ]
  },
  "identifier" : [
    {
      "system" : "urn:oid:2.16.840.1.113883.2.4.3.124.7.48765.2",
      "value" : "12340000000820"
    }
  ],
  "clinicalStatus" : "active",
  "_clinicalStatus" : {
    "extension" : [
      {
        "url" : "http://nictiz.nl/fhir/StructureDefinition/code-specification",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/v3/ActStatus",
              "code" : "active",
              "display" : "Active"
            }
          ],
          "text" : "Actief"
        }
      }
    ]
  },
  "verificationStatus" : "unconfirmed",
  "category" : ["medication"],
  "_category" : [
    {
      "extension" : [
        {
          "url" : "http://nictiz.nl/fhir/StructureDefinition/code-specification",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "419511003",
                "display" : "Propensity to adverse reactions to drug"
              }
            ],
            "text" : "Medicijn"
          }
        }
      ]
    }
  ],
  "criticality" : "low",
  "_criticality" : {
    "extension" : [
      {
        "url" : "http://nictiz.nl/fhir/StructureDefinition/code-specification",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "255604002",
              "display" : "Mild"
            }
          ],
          "text" : "Licht"
        }
      }
    ]
  },
  "code" : {
    "coding" : [
      {
        "system" : "urn:oid:2.16.840.1.113883.2.4.4.1.902.122",
        "code" : "000039",
        "display" : "ALLE NSAID'S (INCL. SALICYLATEN)"
      }
    ],
    "text" : "ALLE NSAID'S (INCL. SALICYLATEN)"
  },
  "patient" : {
    "reference" : "https://example.org/Patient/12A188A91ED05B87A4335425414F9FBAA6F4462C378D533A8F019C0F20712D36",
    "display" : "Test Gestructureerd Vipp"
  },
  "onsetDateTime" : "2019-11-12",
  "reaction" : [
    {
      "manifestation" : [
        {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/v3/NullFlavor",
              "code" : "OTH",
              "display" : "other"
            }
          ],
          "text" : "Huiduitslag"
        }
      ]
    }
  ]
}

```
