# hl7.fhir.cl.minsal.r2bo#0.1.1-draft: Repositorio de Reportes de Biopsias Oncológicas

## Pages

* [del Ministerio de Salud](index.md)
* [Historial de Cambios](changes.md)
* [Consideraciones de Diseño](design-consideration.md)
* [Uso de Sistemas Terminológicos](SistemasTerminologicos.md)
* [Descargas](Downloads.md)
* [Recurso Guía de Implementación del Repositorio Interoperable de Anatomías](ImplementationGuide-hl7.fhir.cl.minsal.r2bo.md)
* [Interacciones con el Repositorio Interoperable de Anatomías Patológicas](InteraccionesConServidor.md)
* [Artifacts Summary](artifacts.md)
* [Contribuidores](contributors.md)

## Resources

### CodeSystems

* [Sistema de Codificación del Grado de Diferenciación](CodeSystem-r2bo-grado-diferenciacion-CS.md)

### ValueSets

* [Set de Valores de Caracteristicas del Margen Quirurgico](ValueSet-r2bo-caracteristicas-margen-quirurgico-VS.md)
* [Set de Valores de la Categoría Reportes de Biopsia](ValueSet-r2bo-categoria-reporte-biopsia-vs.md)
* [Set de Valores para Categorias pTNM](ValueSet-r2bo-categorias-pTNM-VS.md)
* [Especialistas Autorizados](ValueSet-r2bo-especialistas-autorizado-VS.md)
* [Set de Valores Para los Sitios del Cuerpo](ValueSet-r2bo-estructuras-anatomicas-VS.md)
* [Set de Valores Para Grado de Diferenciación](ValueSet-r2bo-grado-diferenciacion-vs.md)
* [Set de Valores para Invasión Linfática, Vascular, Tumoral](ValueSet-r2bo-invasion-linfatica-VS.md)
* [Set de Valores de la Medida de Margen Quirúrgico](ValueSet-r2bo-medida-margen-quirurgico-VS.md)
* [Set de Valores de los Metodos de Medición del Tumor](ValueSet-r2bo-metodos-medicion-VS.md)
* [Set de Valores Morfología](ValueSet-r2bo-morfologicosct-cieo-VS.md)
* [Set de Valores de Resultados de Observación Post Neoadyuvancia](ValueSet-r2bo-observaciones-NeoAdyuvancia-VS.md)
* [Set de Valores para Observaciones Biopsia](ValueSet-r2bo-observaciones-biopsia-VS.md)
* [Set de Valores Para Procedimientos](ValueSet-r2bo-procedimientos-biopsias-VS.md)
* [Profesionales Autorizados](ValueSet-r2bo-profesional-autorizado-VS.md)
* [Set de Valores de los Reportes de Biopsia](ValueSet-r2bo-reporte-biopsia-vs.md)
* [Set de Valores Para Hallazgos de Infiltración Perineural](ValueSet-r2bo-respuestas-infiltracion-perineural-vs.md)
* [Set de Valores Para Hallazgos de Infiltración Peritumoral](ValueSet-r2bo-respuestas-infiltracion-peritumoral-vs.md)
* [ValueSet Para Hallazgos Clínicos](ValueSet-r2bo-snomed-hallazgos-clinicos-cie10-VS.md)
* [Set de Valores de los Tipos de Especimen](ValueSet-r2bo-tipo-especimen-vs.md)
* [Set de Valores Para Tipo de Procedimientos](ValueSet-r2bo-tipo-procedimientos-biopsias-VS.md)
* [Set de Valores Categoría TNM Patológico Metastásico Distante](ValueSet-r2bo-tnm-categoria-metastasis-distante-patologico-vs.md)
* [Set de Valores Categoría TNM Patológico Nodos Regional](ValueSet-r2bo-tnm-categoria-nodo-regional-patologico-vs.md)
* [Set de Valores Categoría TNM Patológico Tumor Primario](ValueSet-r2bo-tnm-categoria-tumor-primario-patologico-vs.md)
* [Set de Valores para Topografía](ValueSet-r2bo-topografica-cieo-VS.md)

### Logicals

* [Modelo Lógico de Informe Patológico del R2BO](StructureDefinition-ModeloLogicoInformePatologicoR2BO.md)
* [Modelo Logico De un Paciente del R2BO](StructureDefinition-ModeloLogicoPacienteR2BO.md)

### Resource Profiles

* [Perfil de Bundle del Documento](StructureDefinition-r2bo-bundle-documento.md)
* [Perfil de Bundle para Generar Informe](StructureDefinition-r2bo-bundle-generar-informe.md)
* [Perfil de Origen para las Categorías T, N,  M (Abstracto)](StructureDefinition-r2bo-categoria-tnm.md)
* [Perfil del Documento de Biopsía](StructureDefinition-r2bo-composition-biopsia.md)
* [Perfil de Grupo Estadificación TNM](StructureDefinition-r2bo-estadificacion-tnm.md)
* [Perfil del Reporte de Anatomía Patológica](StructureDefinition-r2bo-informe-biopsia.md)
* [Perfil de Muestra](StructureDefinition-r2bo-muestra-biopsia.md)
* [Perfil de Observación Focalidad](StructureDefinition-r2bo-observacion-focalidad.md)
* [Perfil de Observación Ganglios Linfáticos](StructureDefinition-r2bo-observacion-ganglios-linfaticos.md)
* [Perfil de Observación Infiltración Perineural](StructureDefinition-r2bo-observacion-infiltracion-perineural.md)
* [Perfil de Observación Infiltración Peritumoral](StructureDefinition-r2bo-observacion-infiltracion-peritumoral.md)
* [Perfil de Observación Invasión Linfatica](StructureDefinition-r2bo-observacion-invasion-linfatica.md)
* [Perfil de Observación Invasión Tumoral](StructureDefinition-r2bo-observacion-invasion-tumoral.md)
* [Perfil de Observación Invasión Vascular](StructureDefinition-r2bo-observacion-invasion-vascular.md)
* [Perfil de Observación Macroscópica](StructureDefinition-r2bo-observacion-macroscopica.md)
* [Perfil de Observación Margen Quirúrgico](StructureDefinition-r2bo-observacion-margen-quirurgico.md)
* [Perfil de Observación Microscópica](StructureDefinition-r2bo-observacion-microscopica.md)
* [Perfil de Observación Multicentricidad](StructureDefinition-r2bo-observacion-multicentricidad.md)
* [Perfil de Observación Porcentaje Necrosis](StructureDefinition-r2bo-observacion-porcentaje-necrosis.md)
* [Perfil de Observación Evaluación Post Neoadyuvancia](StructureDefinition-r2bo-observacion-post-tratamiento-neoadjuvancia.md)
* [Perfil de Observacion Tejido No Tumoral Adyacente](StructureDefinition-r2bo-observacion-tejido-no-tumor-adyacente.md)
* [Perfil de Origen de Todos Los Resultados](StructureDefinition-r2bo-resultados-reporte-biopsia.md)
* [Perfil de Rol Profesional](StructureDefinition-r2bo-rol-profesional-minsal.md)
* [Servicio Solicitante del Informe](StructureDefinition-r2bo-servicio-solicitante.md)
* [Perfil de Solicitud de Informe de Anatomía Patológica](StructureDefinition-r2bo-solicitud-informe-apa.md)
* [Perfil de Tamaño del Tumor](StructureDefinition-r2bo-tamano-tumor.md)
* [Perfil de Categoria TNM de Metástasis Distante](StructureDefinition-r2bo-tnm-categoria-metastasis-distante.md)
* [Perfil de Categoria TNM Nodos Regional](StructureDefinition-r2bo-tnm-categoria-nodo-regional.md)
* [Perfil de Categoria TNM Tumor Primario](StructureDefinition-r2bo-tnm-categoria-tumor-primario.md)
* [Perfil de la Morfología y Topología del Tumor](StructureDefinition-r2bo-tumor.md)

### Extensions

* [Extensión del Grado de Diferenciación](StructureDefinition-r2bo-extension-grado-diferenciacion.md)
* [Extensión De Referencia al Composition](StructureDefinition-r2bo-extension-referencia-composition.md)
* [Extensión De Referencia al Reporte](StructureDefinition-r2bo-extension-referencia-diagnosticReport.md)
* [Extensión Tipo de Procedimiento de Biopsia](StructureDefinition-r2bo-extension-tipo-procedimientos-biopsias.md)

### CapabilityStatements

* [CapabilityStatement del Cliente Analista del Repositorio de Biopsia del Ministerio de Salud](CapabilityStatement-r2bo-minsal-analisis.md)
* [CapabilityStatement Cliente de Origen de Informes del Repositorio de Biopsia del Ministerio de Salud](CapabilityStatement-r2bo-minsal-cliente-informe.md)
* [CapabilityStatement Consumidor del Repositorio de Biopsia del Ministerio de Salud](CapabilityStatement-r2bo-minsal-consumidor.md)
* [CapabilityStatement Servidor del Repositorio de Biopsia del Ministerio de Salud](CapabilityStatement-r2bo-minsal-server.md)

### ImplementationGuides

* [Repositorio de Reportes de Biopsias Oncológicas](index.md)

### Examples

* [r2bo-tumor-ex (BodyStructure)](BodyStructure-r2bo-tumor-ex.md)
* [r2bo-documento-informe-bundle-ejemplo (Bundle)](Bundle-r2bo-documento-informe-bundle-ejemplo.md)
* [r2bo-generar-informe-bundle-ejemplo (Bundle)](Bundle-r2bo-generar-informe-bundle-ejemplo.md)
* [Informe de Biopsia de Mama (Composition)](Composition-r2bo-documento-biopsia-ex.md)
* [r2bo-informe-biopsia-ex (DiagnosticReport)](DiagnosticReport-r2bo-informe-biopsia-ex.md)
* [Medicina General (Location)](Location-r2bo-localizacion-MedicinaGeneral.md)
* [r2bo-estadificacion-tnm-ex (Observation)](Observation-r2bo-estadificacion-tnm-ex.md)
* [r2bo-observacion-centricidad-ex (Observation)](Observation-r2bo-observacion-centricidad-ex.md)
* [r2bo-observacion-ganglios-linfaticos-ex (Observation)](Observation-r2bo-observacion-ganglios-linfaticos-ex.md)
* [r2bo-observacion-infiltracion-perineural-ex (Observation)](Observation-r2bo-observacion-infiltracion-perineural-ex.md)
* [r2bo-observacion-infiltracion-peritumoral-ex (Observation)](Observation-r2bo-observacion-infiltracion-peritumoral-ex.md)
* [r2bo-observacion-invasion-linfatica-ex (Observation)](Observation-r2bo-observacion-invasion-linfatica-ex.md)
* [r2bo-observacion-invasion-vascular-ex (Observation)](Observation-r2bo-observacion-invasion-vascular-ex.md)
* [r2bo-observacion-macroscopica-ex (Observation)](Observation-r2bo-observacion-macroscopica-ex.md)
* [r2bo-observacion-margen-quirurgico-ex (Observation)](Observation-r2bo-observacion-margen-quirurgico-ex.md)
* [r2bo-observacion-microscopica-ex (Observation)](Observation-r2bo-observacion-microscopica-ex.md)
* [r2bo-observacion-multifocalidad-ex (Observation)](Observation-r2bo-observacion-multifocalidad-ex.md)
* [r2bo-observacion-porcentaje-necrosis-ex (Observation)](Observation-r2bo-observacion-porcentaje-necrosis-ex.md)
* [r2bo-observacion-post-tratamiento-neoadjuvancia-ex (Observation)](Observation-r2bo-observacion-post-tratamiento-neoadjuvancia-ex.md)
* [r2bo-observacion-tejido-tumor-adjacente-ex (Observation)](Observation-r2bo-observacion-tejido-tumor-adjacente-ex.md)
* [r2bo-tamano-tumor-ex (Observation)](Observation-r2bo-tamano-tumor-ex.md)
* [r2bo-tnm-categoria-metastasis-distantel-ex (Observation)](Observation-r2bo-tnm-categoria-metastasis-distantel-ex.md)
* [r2bo-tnm-categoria-nodo-regional-ex (Observation)](Observation-r2bo-tnm-categoria-nodo-regional-ex.md)
* [r2bo-tnm-categoria-tumor-primario-ex (Observation)](Observation-r2bo-tnm-categoria-tumor-primario-ex.md)
* [Hospital Dr. Hernán Henríquez Aravena (Temuco) (Organization)](Organization-hospital-collector.md)
* [paciente-requiere-examen (Patient)](Patient-paciente-requiere-examen.md)
* [profesional-hospital-anatopatologo (Practitioner)](Practitioner-profesional-hospital-anatopatologo.md)
* [profesional-hospital-collector (Practitioner)](Practitioner-profesional-hospital-collector.md)
* [ProfesionalHospital (PractitionerRole)](PractitionerRole-ProfesionalHospital.md)
* [r2bo-anatopatologo-hospital (PractitionerRole)](PractitionerRole-r2bo-anatopatologo-hospital.md)
* [r2bo-solicitud-informe-apa-ej (ServiceRequest)](ServiceRequest-r2bo-solicitud-informe-apa-ej.md)
* [r2bo-specimen-example (Specimen)](Specimen-r2bo-specimen-example.md)
