# Recurso Guía de Implementación del Repositorio Interoperable de Anatomías - Repositorio de Reportes de Biopsias Oncológicas v0.1.1-draft

* [**Table of Contents**](toc.md)
* **Recurso Guía de Implementación del Repositorio Interoperable de Anatomías**

## Recurso Guía de Implementación del Repositorio Interoperable de Anatomías

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

| | |
| :--- | :--- |
| **Official URL**: https://interoperabilidad.minsal.cl/fhir/ig/r2bo/ImplementationGuide/hl7.fhir.cl.minsal.r2bo | **Version**: 0.1.0 |
| **NPM package name**: hl7.fhir.cl.minsal.r2bo | **ComputableName**: RepositorioInteroperableAnatomiaPatologicaMinsal |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License |   |

* [XML](ImplementationGuide-hl7.fhir.cl.minsal.r2bo.xml)
* [JSON](ImplementationGuide-hl7.fhir.cl.minsal.r2bo.json)

### Perfiles Globales

*There are no Global profiles defined*

### Dependencias

















### Analisis de versiones cruzadas

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.cl.minsal.r2bo.r4)](package.r4.tgz) and [R4B (hl7.fhir.cl.minsal.r2bo.r4b)](package.r4b.tgz) are available.

### Declaracion de propiedad intelectual

This publication includes IP covered under the following statements.

* All content on ISO Online is copyright protected. The copyright is owned by ISO. Any use of the content, including copying of it in whole or in part, for example to another Internet site, is prohibited and would require written permission from ISO.

* [Códigos de Países](https://hl7chile.cl/fhir/ig/clcore/1.9.2/CodeSystem-CodPais.html): [Bundle/r2bo-documento-informe-bundle-ejemplo](Bundle-r2bo-documento-informe-bundle-ejemplo.md), [Bundle/r2bo-generar-informe-bundle-ejemplo](Bundle-r2bo-generar-informe-bundle-ejemplo.md) and [Patient/paciente-requiere-examen](Patient-paciente-requiere-examen.md)


* Copyright HL7. Licensed under creative commons public domain

* [diagnosticServiceSectionId](http://terminology.hl7.org/5.3.0/CodeSystem-v2-0074.html): [Bundle/r2bo-documento-informe-bundle-ejemplo](Bundle-r2bo-documento-informe-bundle-ejemplo.md), [Bundle/r2bo-generar-informe-bundle-ejemplo](Bundle-r2bo-generar-informe-bundle-ejemplo.md)...Show 5 more,[CategoriaReporteBiopsiaVS](ValueSet-r2bo-categoria-reporte-biopsia-vs.md),[Composition/r2bo-documento-biopsia-ex](Composition-r2bo-documento-biopsia-ex.md),[DiagnosticReport/r2bo-informe-biopsia-ex](DiagnosticReport-r2bo-informe-biopsia-ex.md),[R2BOCompositionBiopsia](StructureDefinition-r2bo-composition-biopsia.md)and[R2BOInformeBiopsia](StructureDefinition-r2bo-informe-biopsia.md)
* [specimenType](http://terminology.hl7.org/5.3.0/CodeSystem-v2-0487.html): [Bundle/r2bo-documento-informe-bundle-ejemplo](Bundle-r2bo-documento-informe-bundle-ejemplo.md), [Bundle/r2bo-generar-informe-bundle-ejemplo](Bundle-r2bo-generar-informe-bundle-ejemplo.md) and [Specimen/r2bo-specimen-example](Specimen-r2bo-specimen-example.md)
* [relevantClincialInformation](http://terminology.hl7.org/5.3.0/CodeSystem-v2-0916.html): [MuestraR2BO](StructureDefinition-r2bo-muestra-biopsia.md)


* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [BundleGenerarInforme](StructureDefinition-r2bo-bundle-generar-informe.md), [CaracteristicasMargenQuirurgicoVS](ValueSet-r2bo-caracteristicas-margen-quirurgico-VS.md)...Show 64 more,[CategoriaReporteBiopsiaVS](ValueSet-r2bo-categoria-reporte-biopsia-vs.md),[CategoriaTNM](StructureDefinition-r2bo-categoria-tnm.md),[CategoriaspTNMVS](ValueSet-r2bo-categorias-pTNM-VS.md),[EspecialistasAutorizadosR2BO](ValueSet-r2bo-especialistas-autorizado-VS.md),[EstadificacionTNM](StructureDefinition-r2bo-estadificacion-tnm.md),[EstructuraAnatomicaVS](ValueSet-r2bo-estructuras-anatomicas-VS.md),[ExtensionComposition](StructureDefinition-r2bo-extension-referencia-composition.md),[ExtensionGradoDiferenciacion](StructureDefinition-r2bo-extension-grado-diferenciacion.md),[ExtensionReporteDiagnostico](StructureDefinition-r2bo-extension-referencia-diagnosticReport.md),[ExtensionTipoProcedimientoBiopsia](StructureDefinition-r2bo-extension-tipo-procedimientos-biopsias.md),[GradoDiferenciacionCS](CodeSystem-r2bo-grado-diferenciacion-CS.md),[GradoDiferenciacionVS](ValueSet-r2bo-grado-diferenciacion-vs.md),[InformePatologicoR2BOLogico](StructureDefinition-ModeloLogicoInformePatologicoR2BO.md),[InvasionLinfaticaVascularVS](ValueSet-r2bo-invasion-linfatica-VS.md),[MedidaMargenQuirurgicoVS](ValueSet-r2bo-medida-margen-quirurgico-VS.md),[MetodosMedicionTumorVS](ValueSet-r2bo-metodos-medicion-VS.md),[MorfologicoSnomedCIEOVS](ValueSet-r2bo-morfologicosct-cieo-VS.md),[MuestraR2BO](StructureDefinition-r2bo-muestra-biopsia.md),[ObservacionFocalidad](StructureDefinition-r2bo-observacion-focalidad.md),[ObservacionGangliosLinfaticos](StructureDefinition-r2bo-observacion-ganglios-linfaticos.md),[ObservacionInfiltracionPerineuralR2BO](StructureDefinition-r2bo-observacion-infiltracion-perineural.md),[ObservacionInfiltradoPeritumoralR2BO](StructureDefinition-r2bo-observacion-infiltracion-peritumoral.md),[ObservacionInvasionLinfaticaR2BO](StructureDefinition-r2bo-observacion-invasion-linfatica.md),[ObservacionInvasionTumoralR2BO](StructureDefinition-r2bo-observacion-invasion-tumoral.md),[ObservacionInvasionVascularR2BO](StructureDefinition-r2bo-observacion-invasion-vascular.md),[ObservacionMacroscopicaR2BO](StructureDefinition-r2bo-observacion-macroscopica.md),[ObservacionMargenQuirugico](StructureDefinition-r2bo-observacion-margen-quirurgico.md),[ObservacionMicroscopicaR2BO](StructureDefinition-r2bo-observacion-microscopica.md),[ObservacionMulticentricidad](StructureDefinition-r2bo-observacion-multicentricidad.md),[ObservacionNeoAdyuvanciaVS](ValueSet-r2bo-observaciones-NeoAdyuvancia-VS.md),[ObservacionPorcentajeNecrosisR2BO](StructureDefinition-r2bo-observacion-porcentaje-necrosis.md),[ObservacionPostNeoadjudancia](StructureDefinition-r2bo-observacion-post-tratamiento-neoadjuvancia.md),[ObservacionTejidoNoTumoralAdyacente](StructureDefinition-r2bo-observacion-tejido-no-tumor-adyacente.md),[ObservacionesBiopsiaVS](ValueSet-r2bo-observaciones-biopsia-VS.md),[PacienteR2BOLogico](StructureDefinition-ModeloLogicoPacienteR2BO.md),[ProcedimientosBiopsiaVS](ValueSet-r2bo-procedimientos-biopsias-VS.md),[ProfesionalesAutorizadosR2BO](ValueSet-r2bo-profesional-autorizado-VS.md),[R2BOBundleDocumento](StructureDefinition-r2bo-bundle-documento.md),[R2BOCompositionBiopsia](StructureDefinition-r2bo-composition-biopsia.md),[R2BOInformeBiopsia](StructureDefinition-r2bo-informe-biopsia.md),[R2BOMinsalAnalistaCapabilityStatement](CapabilityStatement-r2bo-minsal-analisis.md),[R2BOMinsalConsumidorCapabilityStatement](CapabilityStatement-r2bo-minsal-consumidor.md),[R2BOMinsalServerCapabilityStatement](CapabilityStatement-r2bo-minsal-server.md),[R2BOMinsalSourceInformeCapabilityStatement](CapabilityStatement-r2bo-minsal-cliente-informe.md),[R2BOServicioSolicitante](StructureDefinition-r2bo-servicio-solicitante.md),[R2BOTumor](StructureDefinition-r2bo-tumor.md),[ReporteBiopsiaVS](ValueSet-r2bo-reporte-biopsia-vs.md),[RepositorioReportesBiopsiasOncologicas](index.md),[RespuestaInfiltracionPeritumoralVS](ValueSet-r2bo-respuestas-infiltracion-peritumoral-vs.md),[RespuestasInfiltracionPerineuralVS](ValueSet-r2bo-respuestas-infiltracion-perineural-vs.md),[ResultadosReporteBiopsia](StructureDefinition-r2bo-resultados-reporte-biopsia.md),[RolProfesionalR2BO](StructureDefinition-r2bo-rol-profesional-minsal.md),[SnomedCTHallazgosClinicosCIE10VS](ValueSet-r2bo-snomed-hallazgos-clinicos-cie10-VS.md),[SolicitudInformeAPA](StructureDefinition-r2bo-solicitud-informe-apa.md),[TNMCategoriaMetastasisDistante](StructureDefinition-r2bo-tnm-categoria-metastasis-distante.md),[TNMCategoriaMetastasisDistantePatologicoVS](ValueSet-r2bo-tnm-categoria-metastasis-distante-patologico-vs.md),[TNMCategoriaNodoRegional](StructureDefinition-r2bo-tnm-categoria-nodo-regional.md),[TNMCategoriaPatologicoNodosRegionalVS](ValueSet-r2bo-tnm-categoria-nodo-regional-patologico-vs.md),[TNMCategoriaTumorPrimario](StructureDefinition-r2bo-tnm-categoria-tumor-primario.md),[TNMCategoriaTumorPrimarioPatologicoVS](ValueSet-r2bo-tnm-categoria-tumor-primario-patologico-vs.md),[TamanoTumorR2BO](StructureDefinition-r2bo-tamano-tumor.md),[TipoEspecimenVS](ValueSet-r2bo-tipo-especimen-vs.md),[TipoProcedimientosBiopsiaVS](ValueSet-r2bo-tipo-procedimientos-biopsias-VS.md)and[TopograficaSnomedCIEOVS](ValueSet-r2bo-topografica-cieo-VS.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ucum.html): [Bundle/r2bo-documento-informe-bundle-ejemplo](Bundle-r2bo-documento-informe-bundle-ejemplo.md), [Bundle/r2bo-generar-informe-bundle-ejemplo](Bundle-r2bo-generar-informe-bundle-ejemplo.md)...Show 6 more,[MedidaMargenQuirurgicoVS](ValueSet-r2bo-medida-margen-quirurgico-VS.md),[ObservacionMargenQuirugico](StructureDefinition-r2bo-observacion-margen-quirurgico.md),[Observation/r2bo-observacion-margen-quirurgico-ex](Observation-r2bo-observacion-margen-quirurgico-ex.md),[Observation/r2bo-observacion-porcentaje-necrosis-ex](Observation-r2bo-observacion-porcentaje-necrosis-ex.md),[Observation/r2bo-tamano-tumor-ex](Observation-r2bo-tamano-tumor-ex.md)and[TamanoTumorR2BO](StructureDefinition-r2bo-tamano-tumor.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [Bundle/r2bo-documento-informe-bundle-ejemplo](Bundle-r2bo-documento-informe-bundle-ejemplo.md), [Bundle/r2bo-generar-informe-bundle-ejemplo](Bundle-r2bo-generar-informe-bundle-ejemplo.md)...Show 28 more,[Composition/r2bo-documento-biopsia-ex](Composition-r2bo-documento-biopsia-ex.md),[DiagnosticReport/r2bo-informe-biopsia-ex](DiagnosticReport-r2bo-informe-biopsia-ex.md),[ObservacionGangliosLinfaticos](StructureDefinition-r2bo-observacion-ganglios-linfaticos.md),[ObservacionInvasionLinfaticaR2BO](StructureDefinition-r2bo-observacion-invasion-linfatica.md),[ObservacionInvasionVascularR2BO](StructureDefinition-r2bo-observacion-invasion-vascular.md),[ObservacionMacroscopicaR2BO](StructureDefinition-r2bo-observacion-macroscopica.md),[ObservacionMargenQuirugico](StructureDefinition-r2bo-observacion-margen-quirurgico.md),[ObservacionMicroscopicaR2BO](StructureDefinition-r2bo-observacion-microscopica.md),[ObservacionMulticentricidad](StructureDefinition-r2bo-observacion-multicentricidad.md),[ObservacionNeoAdyuvanciaVS](ValueSet-r2bo-observaciones-NeoAdyuvancia-VS.md),[ObservacionPostNeoadjudancia](StructureDefinition-r2bo-observacion-post-tratamiento-neoadjuvancia.md),[ObservacionTejidoNoTumoralAdyacente](StructureDefinition-r2bo-observacion-tejido-no-tumor-adyacente.md),[ObservacionesBiopsiaVS](ValueSet-r2bo-observaciones-biopsia-VS.md),[Observation/r2bo-observacion-centricidad-ex](Observation-r2bo-observacion-centricidad-ex.md),[Observation/r2bo-observacion-ganglios-linfaticos-ex](Observation-r2bo-observacion-ganglios-linfaticos-ex.md),[Observation/r2bo-observacion-invasion-linfatica-ex](Observation-r2bo-observacion-invasion-linfatica-ex.md),[Observation/r2bo-observacion-invasion-vascular-ex](Observation-r2bo-observacion-invasion-vascular-ex.md),[Observation/r2bo-observacion-macroscopica-ex](Observation-r2bo-observacion-macroscopica-ex.md),[Observation/r2bo-observacion-margen-quirurgico-ex](Observation-r2bo-observacion-margen-quirurgico-ex.md),[Observation/r2bo-observacion-microscopica-ex](Observation-r2bo-observacion-microscopica-ex.md),[Observation/r2bo-observacion-post-tratamiento-neoadjuvancia-ex](Observation-r2bo-observacion-post-tratamiento-neoadjuvancia-ex.md),[Observation/r2bo-observacion-tejido-tumor-adjacente-ex](Observation-r2bo-observacion-tejido-tumor-adjacente-ex.md),[Observation/r2bo-tamano-tumor-ex](Observation-r2bo-tamano-tumor-ex.md),[R2BOCompositionBiopsia](StructureDefinition-r2bo-composition-biopsia.md),[R2BOInformeBiopsia](StructureDefinition-r2bo-informe-biopsia.md),[ReporteBiopsiaVS](ValueSet-r2bo-reporte-biopsia-vs.md),[ResultadosReporteBiopsia](StructureDefinition-r2bo-resultados-reporte-biopsia.md)and[TamanoTumorR2BO](StructureDefinition-r2bo-tamano-tumor.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [BodyStructure/r2bo-tumor-ex](BodyStructure-r2bo-tumor-ex.md), [Bundle/r2bo-documento-informe-bundle-ejemplo](Bundle-r2bo-documento-informe-bundle-ejemplo.md)...Show 58 more,[Bundle/r2bo-generar-informe-bundle-ejemplo](Bundle-r2bo-generar-informe-bundle-ejemplo.md),[CaracteristicasMargenQuirurgicoVS](ValueSet-r2bo-caracteristicas-margen-quirurgico-VS.md),[CategoriaTNM](StructureDefinition-r2bo-categoria-tnm.md),[CategoriaspTNMVS](ValueSet-r2bo-categorias-pTNM-VS.md),[DiagnosticReport/r2bo-informe-biopsia-ex](DiagnosticReport-r2bo-informe-biopsia-ex.md),[EstadificacionTNM](StructureDefinition-r2bo-estadificacion-tnm.md),[EstructuraAnatomicaVS](ValueSet-r2bo-estructuras-anatomicas-VS.md),[ExtensionTipoProcedimientoBiopsia](StructureDefinition-r2bo-extension-tipo-procedimientos-biopsias.md),[InvasionLinfaticaVascularVS](ValueSet-r2bo-invasion-linfatica-VS.md),[MetodosMedicionTumorVS](ValueSet-r2bo-metodos-medicion-VS.md),[MorfologicoSnomedCIEOVS](ValueSet-r2bo-morfologicosct-cieo-VS.md),[MuestraR2BO](StructureDefinition-r2bo-muestra-biopsia.md),[ObservacionFocalidad](StructureDefinition-r2bo-observacion-focalidad.md),[ObservacionGangliosLinfaticos](StructureDefinition-r2bo-observacion-ganglios-linfaticos.md),[ObservacionInfiltracionPerineuralR2BO](StructureDefinition-r2bo-observacion-infiltracion-perineural.md),[ObservacionInfiltradoPeritumoralR2BO](StructureDefinition-r2bo-observacion-infiltracion-peritumoral.md),[ObservacionInvasionLinfaticaR2BO](StructureDefinition-r2bo-observacion-invasion-linfatica.md),[ObservacionInvasionTumoralR2BO](StructureDefinition-r2bo-observacion-invasion-tumoral.md),[ObservacionInvasionVascularR2BO](StructureDefinition-r2bo-observacion-invasion-vascular.md),[ObservacionMargenQuirugico](StructureDefinition-r2bo-observacion-margen-quirurgico.md),[ObservacionMulticentricidad](StructureDefinition-r2bo-observacion-multicentricidad.md),[ObservacionPorcentajeNecrosisR2BO](StructureDefinition-r2bo-observacion-porcentaje-necrosis.md),[ObservacionesBiopsiaVS](ValueSet-r2bo-observaciones-biopsia-VS.md),[Observation/r2bo-estadificacion-tnm-ex](Observation-r2bo-estadificacion-tnm-ex.md),[Observation/r2bo-observacion-centricidad-ex](Observation-r2bo-observacion-centricidad-ex.md),[Observation/r2bo-observacion-ganglios-linfaticos-ex](Observation-r2bo-observacion-ganglios-linfaticos-ex.md),[Observation/r2bo-observacion-infiltracion-perineural-ex](Observation-r2bo-observacion-infiltracion-perineural-ex.md),[Observation/r2bo-observacion-infiltracion-peritumoral-ex](Observation-r2bo-observacion-infiltracion-peritumoral-ex.md),[Observation/r2bo-observacion-invasion-linfatica-ex](Observation-r2bo-observacion-invasion-linfatica-ex.md),[Observation/r2bo-observacion-invasion-vascular-ex](Observation-r2bo-observacion-invasion-vascular-ex.md),[Observation/r2bo-observacion-margen-quirurgico-ex](Observation-r2bo-observacion-margen-quirurgico-ex.md),[Observation/r2bo-observacion-multifocalidad-ex](Observation-r2bo-observacion-multifocalidad-ex.md),[Observation/r2bo-observacion-porcentaje-necrosis-ex](Observation-r2bo-observacion-porcentaje-necrosis-ex.md),[Observation/r2bo-tnm-categoria-metastasis-distantel-ex](Observation-r2bo-tnm-categoria-metastasis-distantel-ex.md),[Observation/r2bo-tnm-categoria-nodo-regional-ex](Observation-r2bo-tnm-categoria-nodo-regional-ex.md),[Observation/r2bo-tnm-categoria-tumor-primario-ex](Observation-r2bo-tnm-categoria-tumor-primario-ex.md),[ProcedimientosBiopsiaVS](ValueSet-r2bo-procedimientos-biopsias-VS.md),[R2BOCompositionBiopsia](StructureDefinition-r2bo-composition-biopsia.md),[R2BOInformeBiopsia](StructureDefinition-r2bo-informe-biopsia.md),[R2BOTumor](StructureDefinition-r2bo-tumor.md),[ReporteBiopsiaVS](ValueSet-r2bo-reporte-biopsia-vs.md),[RespuestaInfiltracionPeritumoralVS](ValueSet-r2bo-respuestas-infiltracion-peritumoral-vs.md),[RespuestasInfiltracionPerineuralVS](ValueSet-r2bo-respuestas-infiltracion-perineural-vs.md),[ResultadosReporteBiopsia](StructureDefinition-r2bo-resultados-reporte-biopsia.md),[ServiceRequest/r2bo-solicitud-informe-apa-ej](ServiceRequest-r2bo-solicitud-informe-apa-ej.md),[SnomedCTHallazgosClinicosCIE10VS](ValueSet-r2bo-snomed-hallazgos-clinicos-cie10-VS.md),[SolicitudInformeAPA](StructureDefinition-r2bo-solicitud-informe-apa.md),[Specimen/r2bo-specimen-example](Specimen-r2bo-specimen-example.md),[TNMCategoriaMetastasisDistante](StructureDefinition-r2bo-tnm-categoria-metastasis-distante.md),[TNMCategoriaMetastasisDistantePatologicoVS](ValueSet-r2bo-tnm-categoria-metastasis-distante-patologico-vs.md),[TNMCategoriaNodoRegional](StructureDefinition-r2bo-tnm-categoria-nodo-regional.md),[TNMCategoriaPatologicoNodosRegionalVS](ValueSet-r2bo-tnm-categoria-nodo-regional-patologico-vs.md),[TNMCategoriaTumorPrimario](StructureDefinition-r2bo-tnm-categoria-tumor-primario.md),[TNMCategoriaTumorPrimarioPatologicoVS](ValueSet-r2bo-tnm-categoria-tumor-primario-patologico-vs.md),[TamanoTumorR2BO](StructureDefinition-r2bo-tamano-tumor.md),[TipoEspecimenVS](ValueSet-r2bo-tipo-especimen-vs.md),[TipoProcedimientosBiopsiaVS](ValueSet-r2bo-tipo-procedimientos-biopsias-VS.md)and[TopograficaSnomedCIEOVS](ValueSet-r2bo-topografica-cieo-VS.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Observation Category Codes](http://terminology.hl7.org/6.5.0/CodeSystem-observation-category.html): [Bundle/r2bo-documento-informe-bundle-ejemplo](Bundle-r2bo-documento-informe-bundle-ejemplo.md), [Bundle/r2bo-generar-informe-bundle-ejemplo](Bundle-r2bo-generar-informe-bundle-ejemplo.md)...Show 35 more,[EstadificacionTNM](StructureDefinition-r2bo-estadificacion-tnm.md),[ObservacionFocalidad](StructureDefinition-r2bo-observacion-focalidad.md),[ObservacionGangliosLinfaticos](StructureDefinition-r2bo-observacion-ganglios-linfaticos.md),[ObservacionInfiltracionPerineuralR2BO](StructureDefinition-r2bo-observacion-infiltracion-perineural.md),[ObservacionInfiltradoPeritumoralR2BO](StructureDefinition-r2bo-observacion-infiltracion-peritumoral.md),[ObservacionInvasionLinfaticaR2BO](StructureDefinition-r2bo-observacion-invasion-linfatica.md),[ObservacionInvasionTumoralR2BO](StructureDefinition-r2bo-observacion-invasion-tumoral.md),[ObservacionInvasionVascularR2BO](StructureDefinition-r2bo-observacion-invasion-vascular.md),[ObservacionMacroscopicaR2BO](StructureDefinition-r2bo-observacion-macroscopica.md),[ObservacionMargenQuirugico](StructureDefinition-r2bo-observacion-margen-quirurgico.md),[ObservacionMicroscopicaR2BO](StructureDefinition-r2bo-observacion-microscopica.md),[ObservacionMulticentricidad](StructureDefinition-r2bo-observacion-multicentricidad.md),[ObservacionPorcentajeNecrosisR2BO](StructureDefinition-r2bo-observacion-porcentaje-necrosis.md),[ObservacionPostNeoadjudancia](StructureDefinition-r2bo-observacion-post-tratamiento-neoadjuvancia.md),[ObservacionTejidoNoTumoralAdyacente](StructureDefinition-r2bo-observacion-tejido-no-tumor-adyacente.md),[Observation/r2bo-estadificacion-tnm-ex](Observation-r2bo-estadificacion-tnm-ex.md),[Observation/r2bo-observacion-centricidad-ex](Observation-r2bo-observacion-centricidad-ex.md),[Observation/r2bo-observacion-ganglios-linfaticos-ex](Observation-r2bo-observacion-ganglios-linfaticos-ex.md),[Observation/r2bo-observacion-infiltracion-perineural-ex](Observation-r2bo-observacion-infiltracion-perineural-ex.md),[Observation/r2bo-observacion-infiltracion-peritumoral-ex](Observation-r2bo-observacion-infiltracion-peritumoral-ex.md),[Observation/r2bo-observacion-invasion-linfatica-ex](Observation-r2bo-observacion-invasion-linfatica-ex.md),[Observation/r2bo-observacion-invasion-vascular-ex](Observation-r2bo-observacion-invasion-vascular-ex.md),[Observation/r2bo-observacion-macroscopica-ex](Observation-r2bo-observacion-macroscopica-ex.md),[Observation/r2bo-observacion-margen-quirurgico-ex](Observation-r2bo-observacion-margen-quirurgico-ex.md),[Observation/r2bo-observacion-microscopica-ex](Observation-r2bo-observacion-microscopica-ex.md),[Observation/r2bo-observacion-multifocalidad-ex](Observation-r2bo-observacion-multifocalidad-ex.md),[Observation/r2bo-observacion-porcentaje-necrosis-ex](Observation-r2bo-observacion-porcentaje-necrosis-ex.md),[Observation/r2bo-observacion-post-tratamiento-neoadjuvancia-ex](Observation-r2bo-observacion-post-tratamiento-neoadjuvancia-ex.md),[Observation/r2bo-observacion-tejido-tumor-adjacente-ex](Observation-r2bo-observacion-tejido-tumor-adjacente-ex.md),[Observation/r2bo-tamano-tumor-ex](Observation-r2bo-tamano-tumor-ex.md),[Observation/r2bo-tnm-categoria-metastasis-distantel-ex](Observation-r2bo-tnm-categoria-metastasis-distantel-ex.md),[Observation/r2bo-tnm-categoria-nodo-regional-ex](Observation-r2bo-tnm-categoria-nodo-regional-ex.md),[Observation/r2bo-tnm-categoria-tumor-primario-ex](Observation-r2bo-tnm-categoria-tumor-primario-ex.md),[ResultadosReporteBiopsia](StructureDefinition-r2bo-resultados-reporte-biopsia.md)and[TamanoTumorR2BO](StructureDefinition-r2bo-tamano-tumor.md)
* [RoleCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-RoleCode.html): [Bundle/r2bo-documento-informe-bundle-ejemplo](Bundle-r2bo-documento-informe-bundle-ejemplo.md), [Bundle/r2bo-generar-informe-bundle-ejemplo](Bundle-r2bo-generar-informe-bundle-ejemplo.md) and [ServiceRequest/r2bo-solicitud-informe-apa-ej](ServiceRequest-r2bo-solicitud-informe-apa-ej.md)


* Usado con el permiso de HL7 International, todos los derechos resevados en los Licencias de HL7 Internacional.

* [Códigos de Comunas en Chile](https://hl7chile.cl/fhir/ig/clcore/1.9.4/CodeSystem-CSCodComunasCL.html): [Bundle/r2bo-documento-informe-bundle-ejemplo](Bundle-r2bo-documento-informe-bundle-ejemplo.md), [Bundle/r2bo-generar-informe-bundle-ejemplo](Bundle-r2bo-generar-informe-bundle-ejemplo.md) and [Patient/paciente-requiere-examen](Patient-paciente-requiere-examen.md)
* [Códigos de Provincias en Chile](https://hl7chile.cl/fhir/ig/clcore/1.9.4/CodeSystem-CSCodProvinciasCL.html): [Bundle/r2bo-documento-informe-bundle-ejemplo](Bundle-r2bo-documento-informe-bundle-ejemplo.md), [Bundle/r2bo-generar-informe-bundle-ejemplo](Bundle-r2bo-generar-informe-bundle-ejemplo.md) and [Patient/paciente-requiere-examen](Patient-paciente-requiere-examen.md)
* [Códigos de Regiones en Chile](https://hl7chile.cl/fhir/ig/clcore/1.9.4/CodeSystem-CSCodRegionCL.html): [Bundle/r2bo-documento-informe-bundle-ejemplo](Bundle-r2bo-documento-informe-bundle-ejemplo.md), [Bundle/r2bo-generar-informe-bundle-ejemplo](Bundle-r2bo-generar-informe-bundle-ejemplo.md) and [Patient/paciente-requiere-examen](Patient-paciente-requiere-examen.md)
* [Identidad de Genero](https://hl7chile.cl/fhir/ig/clcore/1.9.4/CodeSystem-CSIdentidaddeGenero.html): [Bundle/r2bo-documento-informe-bundle-ejemplo](Bundle-r2bo-documento-informe-bundle-ejemplo.md), [Bundle/r2bo-generar-informe-bundle-ejemplo](Bundle-r2bo-generar-informe-bundle-ejemplo.md) and [Patient/paciente-requiere-examen](Patient-paciente-requiere-examen.md)
* [Tipo Identificador](https://hl7chile.cl/fhir/ig/clcore/1.9.4/CodeSystem-CSTipoIdentificador.html): [Bundle/r2bo-documento-informe-bundle-ejemplo](Bundle-r2bo-documento-informe-bundle-ejemplo.md), [Bundle/r2bo-generar-informe-bundle-ejemplo](Bundle-r2bo-generar-informe-bundle-ejemplo.md), [Patient/paciente-requiere-examen](Patient-paciente-requiere-examen.md), [Practitioner/profesional-hospital-anatopatologo](Practitioner-profesional-hospital-anatopatologo.md) and [Practitioner/profesional-hospital-collector](Practitioner-profesional-hospital-collector.md)


### Parametros de Expansión

* Parameter: system-version
  * Value: SNOMED CT[Intl rel. null 0000]

### Parametros de Configuración

* code: copyrightyear 
value: 2025+
* code: releaselabel 
value: ci-build
* code: path-tx-cache 
value: input/txcache
* code: path-expansion-params 
value: ../../input/_resources/exp-params.json

