# CapabilityStatement Servidor del Repositorio de Biopsia del Ministerio de Salud - Repositorio de Reportes de Biopsias Oncológicas v0.1.1-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CapabilityStatement Servidor del Repositorio de Biopsia del Ministerio de Salud**

## CapabilityStatement: CapabilityStatement Servidor del Repositorio de Biopsia del Ministerio de Salud (Experimental) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://interoperabilidad.minsal.cl/fhir/ig/r2bo/CapabilityStatement/r2bo-minsal-server | *Version*:0.1.1-draft | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:R2BOMinsalServerCapabilityStatement |

 
CapabilityStatement para definir las caracteristicas mínimas del servidor para ver las interacciones posibles 

 [Raw OpenAPI-Swagger Definition file](r2bo-minsal-server.openapi.json) | [Download](r2bo-minsal-server.openapi.json) 

## CapabilityStatement Servidor del Repositorio de Biopsia del Ministerio de Salud

* Implementation Guide Version: 0.1.1-draft 
* FHIR Version: 4.0.1 
* Supported Formats: `json`, `xml`, `application/fhir+json`, `application/fhir+xml`
* Published on: 2025-03-05 15:30:00-0300 
* Published by: Unidad de Interoperabilidad - MINSAL 

> **Note to Implementers: FHIR Capabilities**Any FHIR capability may be 'allowed' by the system unless explicitly marked as 'SHALL NOT'. A few items are marked as MAY in the Implementation Guide to highlight their potential relevance to the use case.

This CapabilityStatement imports these CapabilityStatements [CapabilityStatement Servidor Cl Coreversion: 1.9.4)](https://hl7chile.cl/fhir/ig/clcore/1.9.4/CapabilityStatement-cl-core-server.html), [Administrador del Indice Maestro Paciente](https://interoperabilidad.minsal.cl/fhir/ig/nid/0.4.7/CapabilityStatement-MPI.IHE.PIXm.PDQm.Manager.html), [Administrador del Directorio de Proveedores de Atención Médica](https://interoperabilidad.minsal.cl/fhir/ig/nid/0.4.7/CapabilityStatement-NID.IHE.HPD.Manager.html)

### SHALL Support the Following Implementation Guides

* [https://hl7chile.cl/fhir/ig/clcore/ImplementationGuide/hl7.fhir.cl.clcore|1.9.4](https://hl7chile.cl/fhir/ig/clcore/1.9.4/index.html)
* [https://interoperabilidad.minsal.cl/fhir/ig/nid/ImplementationGuide/hl7.fhir.cl.minsal.nid](https://interoperabilidad.minsal.cl/fhir/ig/nid/0.4.7/index.html)
* [http://hl7.org/fhir/us/mcode/ImplementationGuide/hl7.fhir.us.mcode](http://hl7.org/fhir/us/mcode/STU4/index.html)

## FHIR RESTful Capabilities

### Mode: server

El Servidor Repositorio de Biopsia del Ministerio de Salud permite la gestión de solicitudes de informes de biopsia y sus resultados.

**Security**

Enable CORS: no

Security services supported:
`OAuth`

> 

OAuth2 usando el APIG del Ministerio de Salud para generar Tokens para enviar y acceder al respositorio


**Summary of System-wide Interactions**

* Supports the `transaction`interaction described as follows:

Iteracción para enviar solicitudes de un informe de biopsia y sus resultados


* Supports the `search-system`interaction described as follows:

Iteracción para realizar busquedas de un informe de biopsia y sus resultados


Summary of System-wide Operations


### Capabilities by Resource/Profile

#### Summary

The summary table lists the resources that are part of this configuration, and for each resource it lists:

* The relevant profiles (if any)
* The interactions supported by each resource (**R**ead, **S**earch, **U**pdate, and **C**reate, are always shown, while **VR**ead, **P**atch, **D**elete, **H**istory on **I**nstance, or **H**istory on **T**ype are only present if at least one of the resources has support for them.
* The required, recommended, and some optional search parameters (if any).
* The linked resources enabled for `_include`
* The other resources enabled for `_revinclude`
* The operations on the resource (if any)

| | | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [BodyStructure](#BodyStructure1-1) | Supported Profiles  [Perfil de la Morfología y Topología del Tumor](StructureDefinition-r2bo-tumor.md) | y | y | y | y | y | y | identifier, morphology, patient, location, _id | `*`,`BodyStructure:patient` | `Composition:entry`,`Observation:focus` |  |
| [Composition](#Composition1-2) | [https://hl7chile.cl/fhir/ig/clcore/StructureDefinition/DocumentoCl|1.9.4](https://hl7chile.cl/fhir/ig/clcore/1.9.4/StructureDefinition-DocumentoCl.html)**Additional supported profiles:**  [Perfil del Documento de Biopsía](StructureDefinition-r2bo-composition-biopsia.md) | y | y | y | y | y | y | date, subject, section, type, patient, identifier, period, author, entry, _id, category, status | `*`,`Composition:attester`,`Composition:author`,`Composition:entry`,`Composition:patient`,`Composition:subject` |  | `$document` |
| [DiagnosticReport](#DiagnosticReport1-3) | Supported Profiles  [Perfil del Reporte de Anatomía Patológica](StructureDefinition-r2bo-informe-biopsia.md) | y | y | y | y | y | y | code, subject, conclusion, result, based-on, patient, specimen, issued, identifier, performer, _id, category, status | `*`,`DiagnosticReport:based-on`,`DiagnosticReport:patient`,`DiagnosticReport:performer`,`DiagnosticReport:result`,`DiagnosticReport:specimen`,`DiagnosticReport:subject` | `Observation:focus` | `$graphql` |
| [Observation](#Observation1-4) | [https://hl7chile.cl/fhir/ig/clcore/StructureDefinition/CoreObservacionCL|1.9.4](https://hl7chile.cl/fhir/ig/clcore/1.9.4/StructureDefinition-CoreObservacionCL.html)**Additional supported profiles:**  [Perfil de Grupo Estadificación TNM](StructureDefinition-r2bo-estadificacion-tnm.md)  [Perfil de Origen para las Categorías T, N, M (Abstracto)](StructureDefinition-r2bo-categoria-tnm.md)  [Perfil de Origen de Todos Los Resultados](StructureDefinition-r2bo-resultados-reporte-biopsia.md) | y | y | y | y | y | y | date, subject, value-concept, focus, has-member, component-code-value-quantity, code-value-quantity, combo-code-value-concept, value-string, identifier, method, value-quantity, combo-value-quantity, code-value-concept, _id, status, combo-data-absent-reason, code, component-data-absent-reason, combo-code-value-quantity, code-value-string, based-on, patient, specimen, component-code, performer, combo-code, component-value-quantity, data-absent-reason, component-code-value-concept, component-value-concept, category, combo-value-concept | `*`,`Observation:based-on`,`Observation:derived-from`,`Observation:device`,`Observation:encounter`,`Observation:focus`,`Observation:has-member`,`Observation:part-of`,`Observation:patient`,`Observation:performer`,`Observation:specimen`,`Observation:subject` | `Composition:entry`,`DiagnosticReport:result`,`Observation:derived-from`,`Observation:focus`,`Observation:has-member` |  |
| [PractitionerRole](#PractitionerRole1-5) | [https://hl7chile.cl/fhir/ig/clcore/StructureDefinition/CoreRolClinicoCl|1.9.4](https://hl7chile.cl/fhir/ig/clcore/1.9.4/StructureDefinition-CoreRolClinicoCl.html)**Additional supported profiles:**  [Perfil de Rol Profesional](StructureDefinition-r2bo-rol-profesional-minsal.md) | y | y | y | y | y | y | role, practitioner, organization | `*`,`PractitionerRole:endpoint`,`PractitionerRole:location`,`PractitionerRole:organization`,`PractitionerRole:practitioner`,`PractitionerRole:service` | `Composition:attester`,`Composition:author`,`DiagnosticReport:performer`,`DiagnosticReport:results-interpreter`,`Observation:focus`,`Observation:performer`,`Patient:general-practitioner`,`ServiceRequest:performer`,`ServiceRequest:requester`,`Specimen:collector` |  |
| [ServiceRequest](#ServiceRequest1-6) | Supported Profiles  [Perfil de Solicitud de Informe de Anatomía Patológica](StructureDefinition-r2bo-solicitud-informe-apa.md) | y | y | y | y | y | y | code, subject, patient, specimen, requester, identifier, performer, intent, performer-type, category, status | `*`,`ServiceRequest:based-on`,`ServiceRequest:patient`,`ServiceRequest:performer`,`ServiceRequest:requester`,`ServiceRequest:specimen`,`ServiceRequest:subject` | `Composition:entry`,`DiagnosticReport:based-on`,`Observation:based-on`,`Observation:focus`,`ServiceRequest:based-on`,`ServiceRequest:replaces` |  |
| [Specimen](#Specimen1-7) | Supported Profiles  [Perfil de Muestra](StructureDefinition-r2bo-muestra-biopsia.md) | y | y | y | y | y | y | identifier, bodysite, subject, collected, type, collector, patient, status | `*`,`Specimen:collector`,`Specimen:parent`,`Specimen:patient`,`Specimen:subject` | `Composition:entry`,`DiagnosticReport:specimen`,`Observation:focus`,`Observation:specimen`,`ServiceRequest:specimen`,`Specimen:parent` |  |

-------

#### Resource Conformance: SHALL BodyStructure

Core FHIR Resource

[BodyStructure](http://hl7.org/fhir/R4/bodystructure.html)

Reference Policy

`literal`,
`logical`

Interaction summary

* Supports `create`, `search-type`, `read`, `vread`, `update`, `delete`.

Supported Profiles
[Perfil de la Morfología y Topología del Tumor](StructureDefinition-r2bo-tumor.md)

Search Parameters


 

#### Resource Conformance: SHALL Composition

Base System Profile

[CL Documentoversion: 1.9.4)](https://hl7chile.cl/fhir/ig/clcore/1.9.4/StructureDefinition-DocumentoCl.html)

Profile Conformance

**SHALL**

Reference Policy

`literal`,
`logical`

Supported Profiles
[Perfil del Documento de Biopsía](StructureDefinition-r2bo-composition-biopsia.md)

Interaction summary

* Supports `create`, `search-type`, `read`, `vread`, `update`, `delete`.

Search Parameters


 

Extended Operations


#### Resource Conformance: SHALL DiagnosticReport

Core FHIR Resource

[DiagnosticReport](http://hl7.org/fhir/R4/diagnosticreport.html)

Reference Policy

`literal`,
`logical`

Interaction summary

* Supports `create`, `search-type`, `read`, `vread`, `update`, `delete`.

Supported Profiles
[Perfil del Reporte de Anatomía Patológica](StructureDefinition-r2bo-informe-biopsia.md)

Search Parameters


 

Extended Operations


#### Resource Conformance: SHALL Observation

Base System Profile

[CL Observaciónversion: 1.9.4)](https://hl7chile.cl/fhir/ig/clcore/1.9.4/StructureDefinition-CoreObservacionCL.html)

Profile Conformance

**SHALL**

Reference Policy

`literal`,
`logical`

Supported Profiles
[Perfil de Grupo Estadificación TNM](StructureDefinition-r2bo-estadificacion-tnm.md)
[Perfil de Origen para las Categorías T, N, M (Abstracto)](StructureDefinition-r2bo-categoria-tnm.md)
[Perfil de Origen de Todos Los Resultados](StructureDefinition-r2bo-resultados-reporte-biopsia.md)

Interaction summary

* Supports `create`, `search-type`, `read`, `vread`, `update`, `delete`.

Search Parameters


 

#### Resource Conformance: SHALL PractitionerRole

Base System Profile

[CL RolClinicoversion: 1.9.4)](https://hl7chile.cl/fhir/ig/clcore/1.9.4/StructureDefinition-CoreRolClinicoCl.html)

Profile Conformance

**SHALL**

Reference Policy

`literal`,
`logical`

Supported Profiles
[Perfil de Rol Profesional](StructureDefinition-r2bo-rol-profesional-minsal.md)

Interaction summary

* Supports `create`, `search-type`, `read`, `vread`, `update`, `delete`.

Search Parameters


 

#### Resource Conformance: SHALL ServiceRequest

Core FHIR Resource

[ServiceRequest](http://hl7.org/fhir/R4/servicerequest.html)

Reference Policy

`literal`,
`logical`

Interaction summary

* Supports `create`, `search-type`, `read`, `vread`, `update`, `delete`.

Supported Profiles
[Perfil de Solicitud de Informe de Anatomía Patológica](StructureDefinition-r2bo-solicitud-informe-apa.md)

Search Parameters


 

#### Resource Conformance: SHALL Specimen

Core FHIR Resource

[Specimen](http://hl7.org/fhir/R4/specimen.html)

Reference Policy

`literal`,
`logical`

Interaction summary

* Supports `create`, `search-type`, `read`, `vread`, `update`, `delete`.

Supported Profiles
[Perfil de Muestra](StructureDefinition-r2bo-muestra-biopsia.md)

Search Parameters


 



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "r2bo-minsal-server",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "informative",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/ImplementationGuide/hl7.fhir.cl.minsal.r2bo"
          }
        ]
      }
    }
  ],
  "url" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/CapabilityStatement/r2bo-minsal-server",
  "version" : "0.1.1-draft",
  "name" : "R2BOMinsalServerCapabilityStatement",
  "title" : "CapabilityStatement Servidor del Repositorio de Biopsia del Ministerio de Salud",
  "status" : "active",
  "experimental" : true,
  "date" : "2025-03-05T15:30:00-03:00",
  "publisher" : "Unidad de Interoperabilidad - MINSAL",
  "contact" : [
    {
      "name" : "Unidad de Interoperabilidad - MINSAL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://interoperabilidad.minsal.cl"
        }
      ]
    }
  ],
  "description" : "CapabilityStatement para definir las caracteristicas mínimas del servidor para ver las interacciones posibles",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CL",
          "display" : "Chile"
        }
      ]
    }
  ],
  "kind" : "requirements",
  "imports" : [
    "https://hl7chile.cl/fhir/ig/clcore/CapabilityStatement/cl-core-server|1.9.4",
    "https://interoperabilidad.minsal.cl/fhir/ig/nid/CapabilityStatement/MPI.IHE.PIXm.PDQm.Manager",
    "https://interoperabilidad.minsal.cl/fhir/ig/nid/CapabilityStatement/NID.IHE.HPD.Manager"
  ],
  "fhirVersion" : "4.0.1",
  "format" : ["json", "xml", "application/fhir+json", "application/fhir+xml"],
  "implementationGuide" : [
    "https://hl7chile.cl/fhir/ig/clcore/ImplementationGuide/hl7.fhir.cl.clcore|1.9.4",
    "https://interoperabilidad.minsal.cl/fhir/ig/nid/ImplementationGuide/hl7.fhir.cl.minsal.nid",
    "http://hl7.org/fhir/us/mcode/ImplementationGuide/hl7.fhir.us.mcode"
  ],
  "rest" : [
    {
      "mode" : "server",
      "documentation" : "El Servidor Repositorio de Biopsia del Ministerio de Salud permite la gestión de solicitudes de informes de biopsia y sus resultados.",
      "security" : {
        "service" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/restful-security-service",
                "code" : "OAuth"
              }
            ]
          }
        ],
        "description" : "OAuth2 usando el APIG del Ministerio de Salud para generar Tokens para enviar y acceder al respositorio"
      },
      "resource" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "BodyStructure",
          "supportedProfile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-tumor"
          ],
          "interaction" : [
            {
              "code" : "create"
            },
            {
              "code" : "search-type"
            },
            {
              "code" : "read"
            },
            {
              "code" : "vread"
            },
            {
              "code" : "update"
            },
            {
              "code" : "delete"
            }
          ],
          "referencePolicy" : ["literal", "logical"],
          "searchInclude" : ["*", "BodyStructure:patient"],
          "searchRevInclude" : ["Composition:entry", "Observation:focus"],
          "searchParam" : [
            {
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/BodyStructure-identifier",
              "type" : "token",
              "documentation" : "Identificador de la Estructura Corporal"
            },
            {
              "name" : "morphology",
              "definition" : "http://hl7.org/fhir/SearchParameter/BodyStructure-morphology",
              "type" : "token",
              "documentation" : "Tipo de estructura"
            },
            {
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/BodyStructure-patient",
              "type" : "reference",
              "documentation" : "Individuo al que se refiere"
            },
            {
              "name" : "location",
              "definition" : "http://hl7.org/fhir/SearchParameter/BodyStructure-location",
              "type" : "token",
              "documentation" : "Sitio del cuerpo"
            },
            {
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token",
              "documentation" : "Id logico dentro del servidor de la estructura corporal"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Composition",
          "profile" : "https://hl7chile.cl/fhir/ig/clcore/StructureDefinition/DocumentoCl|1.9.4",
          "supportedProfile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-composition-biopsia"
          ],
          "interaction" : [
            {
              "code" : "create"
            },
            {
              "code" : "search-type"
            },
            {
              "code" : "read"
            },
            {
              "code" : "vread"
            },
            {
              "code" : "update"
            },
            {
              "code" : "delete"
            }
          ],
          "referencePolicy" : ["literal", "logical"],
          "searchInclude" : [
            "*",
            "Composition:attester",
            "Composition:author",
            "Composition:entry",
            "Composition:patient",
            "Composition:subject"
          ],
          "searchParam" : [
            {
              "name" : "date",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-date",
              "type" : "date",
              "documentation" : "Fecha de la creación del documento"
            },
            {
              "name" : "subject",
              "definition" : "http://hl7.org/fhir/SearchParameter/Composition-subject",
              "type" : "reference",
              "documentation" : "Sobre quién o qué es el documento"
            },
            {
              "name" : "section",
              "definition" : "http://hl7.org/fhir/SearchParameter/Composition-section",
              "type" : "token",
              "documentation" : "Clasificación de la sección (recomendado)"
            },
            {
              "name" : "type",
              "definition" : "http://hl7.org/fhir/SearchParameter/Composition-title",
              "type" : "string",
              "documentation" : "titulo legible para humanos"
            },
            {
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-patient",
              "type" : "reference",
              "documentation" : "Paciente asociado al documento"
            },
            {
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-identifier",
              "type" : "token",
              "documentation" : "Identificador del documento"
            },
            {
              "name" : "period",
              "definition" : "http://hl7.org/fhir/SearchParameter/Composition-period",
              "type" : "date",
              "documentation" : "El periodo de tiempo que el documento cubre (recomendado)"
            },
            {
              "name" : "author",
              "definition" : "http://hl7.org/fhir/SearchParameter/Composition-author",
              "type" : "reference",
              "documentation" : "Quien o que creo el documento"
            },
            {
              "name" : "entry",
              "definition" : "http://hl7.org/fhir/SearchParameter/Composition-entry",
              "type" : "reference",
              "documentation" : "Referencia aresursos incluidos en el documento"
            },
            {
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token",
              "documentation" : "Id logico dentro del servidor del documento"
            },
            {
              "name" : "category",
              "definition" : "http://hl7.org/fhir/SearchParameter/Composition-category",
              "type" : "token",
              "documentation" : "Categoría del documento"
            },
            {
              "name" : "status",
              "definition" : "http://hl7.org/fhir/SearchParameter/Composition-status",
              "type" : "token",
              "documentation" : "preliminary | final | amended | entered-in-error"
            }
          ],
          "operation" : [
            {
              "name" : "document",
              "definition" : "http://hl7.org/fhir/OperationDefinition/Composition-document"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "DiagnosticReport",
          "supportedProfile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-informe-biopsia"
          ],
          "interaction" : [
            {
              "code" : "create"
            },
            {
              "code" : "search-type"
            },
            {
              "code" : "read"
            },
            {
              "code" : "vread"
            },
            {
              "code" : "update"
            },
            {
              "code" : "delete"
            }
          ],
          "referencePolicy" : ["literal", "logical"],
          "searchInclude" : [
            "*",
            "DiagnosticReport:based-on",
            "DiagnosticReport:patient",
            "DiagnosticReport:performer",
            "DiagnosticReport:result",
            "DiagnosticReport:specimen",
            "DiagnosticReport:subject"
          ],
          "searchRevInclude" : ["Observation:focus"],
          "searchParam" : [
            {
              "name" : "code",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-code",
              "type" : "token",
              "documentation" : "Código de identificación del informe"
            },
            {
              "name" : "subject",
              "definition" : "http://hl7.org/fhir/SearchParameter/DiagnosticReport-subject",
              "type" : "reference",
              "documentation" : "El sujeto del informe"
            },
            {
              "name" : "conclusion",
              "definition" : "http://hl7.org/fhir/SearchParameter/DiagnosticReport-conclusion",
              "type" : "token",
              "documentation" : "Código de conclusión (interpretación/impresión) del informe"
            },
            {
              "name" : "result",
              "definition" : "http://hl7.org/fhir/SearchParameter/DiagnosticReport-result",
              "type" : "reference",
              "documentation" : "Enlace de la observaciones de los resultados"
            },
            {
              "name" : "based-on",
              "definition" : "http://hl7.org/fhir/SearchParameter/DiagnosticReport-based-on",
              "type" : "reference",
              "documentation" : "Solicitud del Informe de Anatomia Patológica"
            },
            {
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-patient",
              "type" : "reference",
              "documentation" : "Paciente asociado al informe"
            },
            {
              "name" : "specimen",
              "definition" : "http://hl7.org/fhir/SearchParameter/DiagnosticReport-specimen",
              "type" : "reference",
              "documentation" : "Detalles del Especimen"
            },
            {
              "name" : "issued",
              "definition" : "http://hl7.org/fhir/SearchParameter/DiagnosticReport-issued",
              "type" : "date",
              "documentation" : "Cuando fue creado el informe"
            },
            {
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-identifier",
              "type" : "token",
              "documentation" : "Identificador del informe"
            },
            {
              "name" : "performer",
              "definition" : "http://hl7.org/fhir/SearchParameter/DiagnosticReport-performer",
              "type" : "reference",
              "documentation" : "Quien es el responsable del informe"
            },
            {
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token",
              "documentation" : "Id logico dentro del servidor del informe"
            },
            {
              "name" : "category",
              "definition" : "http://hl7.org/fhir/SearchParameter/DiagnosticReport-category",
              "type" : "token",
              "documentation" : "Cual es la categoria del informe, por defecto es PAT"
            },
            {
              "name" : "status",
              "definition" : "http://hl7.org/fhir/SearchParameter/DiagnosticReport-status",
              "type" : "token",
              "documentation" : "El estado del Reporte"
            }
          ],
          "operation" : [
            {
              "name" : "graphql",
              "definition" : "http://hl7.org/fhir/OperationDefinition/Resource-graphql",
              "documentation" : "Operación para extraer los datos del repositorio de biopsia en formato GraphQL"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Observation",
          "profile" : "https://hl7chile.cl/fhir/ig/clcore/StructureDefinition/CoreObservacionCL|1.9.4",
          "supportedProfile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-estadificacion-tnm",
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-categoria-tnm",
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-resultados-reporte-biopsia"
          ],
          "interaction" : [
            {
              "code" : "create"
            },
            {
              "code" : "search-type"
            },
            {
              "code" : "read"
            },
            {
              "code" : "vread"
            },
            {
              "code" : "update"
            },
            {
              "code" : "delete"
            }
          ],
          "referencePolicy" : ["literal", "logical"],
          "searchInclude" : [
            "*",
            "Observation:based-on",
            "Observation:derived-from",
            "Observation:device",
            "Observation:encounter",
            "Observation:focus",
            "Observation:has-member",
            "Observation:part-of",
            "Observation:patient",
            "Observation:performer",
            "Observation:specimen",
            "Observation:subject"
          ],
          "searchRevInclude" : [
            "Composition:entry",
            "DiagnosticReport:result",
            "Observation:derived-from",
            "Observation:focus",
            "Observation:has-member"
          ],
          "searchParam" : [
            {
              "name" : "date",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-date",
              "type" : "date",
              "documentation" : "Fecha de la observación"
            },
            {
              "name" : "subject",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-subject",
              "type" : "reference",
              "documentation" : "El sujeto de la observación"
            },
            {
              "name" : "value-concept",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-value-concept",
              "type" : "token",
              "documentation" : "El valor de la observación, si el valor es un concepto codificado"
            },
            {
              "name" : "focus",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-focus",
              "type" : "reference",
              "documentation" : "El objeto de la observación"
            },
            {
              "name" : "has-member",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-has-member",
              "type" : "reference",
              "documentation" : "Recursos relacionados son miembros de la observación"
            },
            {
              "name" : "component-code-value-quantity",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-component-code-value-quantity",
              "type" : "composite",
              "documentation" : "Par entre el código del componente y el valor de la cantidad del componente"
            },
            {
              "name" : "code-value-quantity",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-code-value-quantity",
              "type" : "composite",
              "documentation" : "Par entre el código y el valor de la cantidad"
            },
            {
              "name" : "combo-code-value-concept",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-combo-code-value-concept",
              "type" : "composite",
              "documentation" : "Par en el parametro de código y valor codificado, incluyendo en componentes"
            },
            {
              "name" : "value-string",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-value-string",
              "type" : "string",
              "documentation" : "El valor de la observación, si el valor es un string, y también busca en CodeableConcept.text"
            },
            {
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-identifier",
              "type" : "token",
              "documentation" : "Identificador único de la observación"
            },
            {
              "name" : "method",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-method",
              "type" : "token",
              "documentation" : "El método usado para la observación"
            },
            {
              "name" : "value-quantity",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-value-quantity",
              "type" : "quantity",
              "documentation" : "El valor de la observación, si el valor es una cantidad, o un SampledData (solo busca en los límites de los valores en los datos muestreados)"
            },
            {
              "name" : "combo-value-quantity",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-combo-value-quantity",
              "type" : "quantity",
              "documentation" : "El valor o el valor del componente de la observación, si el valor es una cantidad, o un SampledData (solo busca en los límites de los valores en los datos muestreados)"
            },
            {
              "name" : "code-value-concept",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-code-value-concept",
              "type" : "composite",
              "documentation" : "Par en el parametro de código y valor codificado"
            },
            {
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token",
              "documentation" : "Id lógico del recurso"
            },
            {
              "name" : "status",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-status",
              "type" : "token",
              "documentation" : "El estado de la observación"
            },
            {
              "name" : "combo-data-absent-reason",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-combo-data-absent-reason",
              "type" : "token",
              "documentation" : "La razón por la que el valor esperado en el elemento Observation.component.value[x] está ausente"
            },
            {
              "name" : "code",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-code",
              "type" : "token",
              "documentation" : "El código de identificación de la observación"
            },
            {
              "name" : "component-data-absent-reason",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-component-data-absent-reason",
              "type" : "token",
              "documentation" : "La razón por la que el valor esperado en el elemento Observation.component.value[x] está ausente"
            },
            {
              "name" : "combo-code-value-quantity",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-combo-code-value-quantity",
              "type" : "composite",
              "documentation" : "Par en el parametro de código y valor codificado, incluyendo en componentes"
            },
            {
              "name" : "code-value-string",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-code-value-string",
              "type" : "composite",
              "documentation" : "Par en el parametro de código y valor codificado, incluyendo en componentes"
            },
            {
              "name" : "based-on",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-based-on",
              "type" : "reference",
              "documentation" : "Recurso que origina la observación"
            },
            {
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-patient",
              "type" : "reference",
              "documentation" : "El paciente asociado a la observación"
            },
            {
              "name" : "specimen",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-specimen",
              "type" : "reference",
              "documentation" : "El especimen asociado a la observación"
            },
            {
              "name" : "component-code",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-component-code",
              "type" : "token",
              "documentation" : "El código del componente de la observación"
            },
            {
              "name" : "performer",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-performer",
              "type" : "reference",
              "documentation" : "El individuo u organización que realizó la observación"
            },
            {
              "name" : "combo-code",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-combo-code",
              "type" : "token",
              "documentation" : "El código de la observación, incluyendo en componentes"
            },
            {
              "name" : "component-value-quantity",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-component-value-quantity",
              "type" : "quantity",
              "documentation" : "El valor del componente de la observación, si el valor es una cantidad, o un SampledData (solo busca en los límites de los valores en los datos muestreados)"
            },
            {
              "name" : "data-absent-reason",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-data-absent-reason",
              "type" : "token",
              "documentation" : "La razón de por qué el valor esperado en el elemento Observation.value[x] está ausente"
            },
            {
              "name" : "component-code-value-concept",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-component-code-value-concept",
              "type" : "composite",
              "documentation" : "Par en el parametro de código y valor codificado de los componentes"
            },
            {
              "name" : "component-value-concept",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-component-value-concept",
              "type" : "token",
              "documentation" : "El valor del componente de la observación, si el valor es un concepto codificado"
            },
            {
              "name" : "category",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-category",
              "type" : "token",
              "documentation" : "La clasificación del tipo de observación"
            },
            {
              "name" : "combo-value-concept",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-combo-value-concept",
              "type" : "token",
              "documentation" : "El valor de la observación, si el valor es un concepto codificado, incluyendo en componentes"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "PractitionerRole",
          "profile" : "https://hl7chile.cl/fhir/ig/clcore/StructureDefinition/CoreRolClinicoCl|1.9.4",
          "supportedProfile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-rol-profesional-minsal"
          ],
          "interaction" : [
            {
              "code" : "create"
            },
            {
              "code" : "search-type"
            },
            {
              "code" : "read"
            },
            {
              "code" : "vread"
            },
            {
              "code" : "update"
            },
            {
              "code" : "delete"
            }
          ],
          "referencePolicy" : ["literal", "logical"],
          "searchInclude" : [
            "*",
            "PractitionerRole:endpoint",
            "PractitionerRole:location",
            "PractitionerRole:organization",
            "PractitionerRole:practitioner",
            "PractitionerRole:service"
          ],
          "searchRevInclude" : [
            "Composition:attester",
            "Composition:author",
            "DiagnosticReport:performer",
            "DiagnosticReport:results-interpreter",
            "Observation:focus",
            "Observation:performer",
            "Patient:general-practitioner",
            "ServiceRequest:performer",
            "ServiceRequest:requester",
            "Specimen:collector"
          ],
          "searchParam" : [
            {
              "name" : "role",
              "definition" : "http://hl7.org/fhir/SearchParameter/PractitionerRole-role",
              "type" : "token",
              "documentation" : "El rol que cumple el profesional en el establecimiento de salud"
            },
            {
              "name" : "practitioner",
              "definition" : "http://hl7.org/fhir/SearchParameter/PractitionerRole-practitioner",
              "type" : "reference",
              "documentation" : "El profesional que cumple el rol"
            },
            {
              "name" : "organization",
              "definition" : "http://hl7.org/fhir/SearchParameter/PractitionerRole-organization",
              "type" : "reference",
              "documentation" : "La identidad de la organización que representa el profesional"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "ServiceRequest",
          "supportedProfile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-solicitud-informe-apa"
          ],
          "interaction" : [
            {
              "code" : "create"
            },
            {
              "code" : "search-type"
            },
            {
              "code" : "read"
            },
            {
              "code" : "vread"
            },
            {
              "code" : "update"
            },
            {
              "code" : "delete"
            }
          ],
          "referencePolicy" : ["literal", "logical"],
          "searchInclude" : [
            "*",
            "ServiceRequest:based-on",
            "ServiceRequest:patient",
            "ServiceRequest:performer",
            "ServiceRequest:requester",
            "ServiceRequest:specimen",
            "ServiceRequest:subject"
          ],
          "searchRevInclude" : [
            "Composition:entry",
            "DiagnosticReport:based-on",
            "Observation:based-on",
            "Observation:focus",
            "ServiceRequest:based-on",
            "ServiceRequest:replaces"
          ],
          "searchParam" : [
            {
              "name" : "code",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-code",
              "type" : "token",
              "documentation" : "Código de solicitud"
            },
            {
              "name" : "subject",
              "definition" : "http://hl7.org/fhir/SearchParameter/ServiceRequest-subject",
              "type" : "reference",
              "documentation" : "Búsqueda por sujeto"
            },
            {
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-patient",
              "type" : "reference",
              "documentation" : "Paciente asociado a la solicitud"
            },
            {
              "name" : "specimen",
              "definition" : "http://hl7.org/fhir/SearchParameter/ServiceRequest-specimen",
              "type" : "reference",
              "documentation" : "Muestra que sera analizada"
            },
            {
              "name" : "requester",
              "definition" : "http://hl7.org/fhir/SearchParameter/ServiceRequest-requester",
              "type" : "reference",
              "documentation" : "Quien solicita el servicio"
            },
            {
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-identifier",
              "type" : "token",
              "documentation" : "Identificador único de la solicitud"
            },
            {
              "name" : "performer",
              "definition" : "http://hl7.org/fhir/SearchParameter/ServiceRequest-performer",
              "type" : "reference",
              "documentation" : "Responsable de realizar el servicio"
            },
            {
              "name" : "intent",
              "definition" : "http://hl7.org/fhir/SearchParameter/ServiceRequest-intent",
              "type" : "token",
              "documentation" : "proposal | plan | directive | order | original-order | reflex-order | filler-order | instance-order | option"
            },
            {
              "name" : "performer-type",
              "definition" : "http://hl7.org/fhir/SearchParameter/ServiceRequest-performer-type",
              "type" : "token",
              "documentation" : "Performer role"
            },
            {
              "name" : "category",
              "definition" : "http://hl7.org/fhir/SearchParameter/ServiceRequest-category",
              "type" : "token",
              "documentation" : "Clasificación del servicio"
            },
            {
              "name" : "status",
              "definition" : "http://hl7.org/fhir/SearchParameter/ServiceRequest-status",
              "type" : "token",
              "documentation" : "draft | active | on-hold | revoked | completed | entered-in-error | unknown"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Specimen",
          "supportedProfile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-muestra-biopsia"
          ],
          "interaction" : [
            {
              "code" : "create"
            },
            {
              "code" : "search-type"
            },
            {
              "code" : "read"
            },
            {
              "code" : "vread"
            },
            {
              "code" : "update"
            },
            {
              "code" : "delete"
            }
          ],
          "referencePolicy" : ["literal", "logical"],
          "searchInclude" : [
            "*",
            "Specimen:collector",
            "Specimen:parent",
            "Specimen:patient",
            "Specimen:subject"
          ],
          "searchRevInclude" : [
            "Composition:entry",
            "DiagnosticReport:specimen",
            "Observation:focus",
            "Observation:specimen",
            "ServiceRequest:specimen",
            "Specimen:parent"
          ],
          "searchParam" : [
            {
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/Specimen-identifier",
              "type" : "token",
              "documentation" : "Identificador único asociado a la muestra"
            },
            {
              "name" : "bodysite",
              "definition" : "http://hl7.org/fhir/SearchParameter/Specimen-bodysite",
              "type" : "token",
              "documentation" : "EL código de la ubicación anatómica de la muestra"
            },
            {
              "name" : "subject",
              "definition" : "http://hl7.org/fhir/SearchParameter/Specimen-subject",
              "type" : "reference",
              "documentation" : "El sujeto de la muestra"
            },
            {
              "name" : "collected",
              "definition" : "http://hl7.org/fhir/SearchParameter/Specimen-collected",
              "type" : "date",
              "documentation" : "La fecha de cuando fue recolectada la muestra"
            },
            {
              "name" : "type",
              "definition" : "http://hl7.org/fhir/SearchParameter/Specimen-type",
              "type" : "token",
              "documentation" : "Tipo de muestra"
            },
            {
              "name" : "collector",
              "definition" : "http://hl7.org/fhir/SearchParameter/Specimen-collector",
              "type" : "reference",
              "documentation" : "Quien Recolecto la muestra"
            },
            {
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/Specimen-patient",
              "type" : "reference",
              "documentation" : "EL paciente asociado a la muestra"
            },
            {
              "name" : "status",
              "definition" : "http://hl7.org/fhir/SearchParameter/Specimen-status",
              "type" : "token",
              "documentation" : "available | unavailable | unsatisfactory | entered-in-error"
            }
          ]
        }
      ],
      "interaction" : [
        {
          "code" : "transaction",
          "documentation" : "Iteracción para enviar solicitudes de un informe de biopsia y sus resultados"
        },
        {
          "code" : "search-system",
          "documentation" : "Iteracción para realizar busquedas de un informe de biopsia y sus resultados"
        }
      ],
      "operation" : [
        {
          "name" : "graphql",
          "definition" : "http://hl7.org/fhir/OperationDefinition/Resource-graphql",
          "documentation" : "Operación para extraer los datos del repositorio de biopsia en formato GraphQL"
        }
      ]
    }
  ]
}

```
