# CapabilityStatement Cliente de Origen de Informes del Repositorio de Biopsia del Ministerio de Salud - Repositorio de Reportes de Biopsias Oncológicas v0.1.1-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CapabilityStatement Cliente de Origen de Informes del Repositorio de Biopsia del Ministerio de Salud**

## CapabilityStatement: CapabilityStatement Cliente de Origen de Informes del Repositorio de Biopsia del Ministerio de Salud (Experimental) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://interoperabilidad.minsal.cl/fhir/ig/r2bo/CapabilityStatement/r2bo-minsal-cliente-informe | *Version*:0.1.1-draft | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:R2BOMinsalSourceInformeCapabilityStatement |

 
CapabilityStatement para definir las caracteristicas mínimas del cliente que realiza la creación de informes de anatomía patológica y sus resultados. 

 [Raw OpenAPI-Swagger Definition file](r2bo-minsal-cliente-informe.openapi.json) | [Download](r2bo-minsal-cliente-informe.openapi.json) 

## CapabilityStatement Cliente de Origen de Informes del Repositorio de Biopsia del Ministerio de Salud

* Implementation Guide Version: 0.1.1-draft 
* FHIR Version: 4.0.1 
* Supported Formats: `json`, `xml`, `application/fhir+json`, `application/fhir+xml`
* Published on: 2025-03-05 15:30:00-0300 
* Published by: Unidad de Interoperabilidad - MINSAL 

> **Note to Implementers: FHIR Capabilities**Any FHIR capability may be 'allowed' by the system unless explicitly marked as 'SHALL NOT'. A few items are marked as MAY in the Implementation Guide to highlight their potential relevance to the use case.

This CapabilityStatement imports these CapabilityStatements [Indice Maestro Paciente: "Cliente de Origen PIXm"](https://interoperabilidad.minsal.cl/fhir/ig/nid/0.4.7/CapabilityStatement-MPI.IHE.PIXm.Origen.html), [Origen del Directorio de Proveedores de Atención Médica](https://interoperabilidad.minsal.cl/fhir/ig/nid/0.4.7/CapabilityStatement-NID.IHE.HPD.Source.html)

### SHALL Support the Following Implementation Guides

* [https://hl7chile.cl/fhir/ig/clcore/ImplementationGuide/hl7.fhir.cl.clcore|1.9.4](https://hl7chile.cl/fhir/ig/clcore/1.9.4/index.html)
* [https://interoperabilidad.minsal.cl/fhir/ig/nid/ImplementationGuide/hl7.fhir.cl.minsal.nid](https://interoperabilidad.minsal.cl/fhir/ig/nid/0.4.7/index.html)
* [http://hl7.org/fhir/us/mcode/ImplementationGuide/hl7.fhir.us.mcode](http://hl7.org/fhir/us/mcode/STU4/index.html)

## FHIR RESTful Capabilities

### Mode: client

Este Cliente del Repositorio de Biopsia del Ministerio de Salud permite la creación de informes de anatomía patológica y sus resultados.

**Security**

Enable CORS: no

Security services supported:
`OAuth`

> 

OAuth2 usando el APIG del Ministerio de Salud para generar Tokens para enviar y acceder al respositorio


**Summary of System-wide Interactions**

* Supports the `transaction`interaction described as follows:

Iteracción para enviar solicitudes de un informe de biopsia y sus resultados


### Capabilities by Resource/Profile

#### Summary

The summary table lists the resources that are part of this configuration, and for each resource it lists:

* The relevant profiles (if any)
* The interactions supported by each resource (**R**ead, **S**earch, **U**pdate, and **C**reate, are always shown, while **VR**ead, **P**atch, **D**elete, **H**istory on **I**nstance, or **H**istory on **T**ype are only present if at least one of the resources has support for them.
* The required, recommended, and some optional search parameters (if any).
* The linked resources enabled for `_include`
* The other resources enabled for `_revinclude`
* The operations on the resource (if any)

| | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [BodyStructure](#BodyStructure1-1) | Supported Profiles  [Perfil de la Morfología y Topología del Tumor](StructureDefinition-r2bo-tumor.md) |  |  | y | y |  |  |  |  |
| [Composition](#Composition1-2) | [https://hl7chile.cl/fhir/ig/clcore/StructureDefinition/DocumentoCl|1.9.4](https://hl7chile.cl/fhir/ig/clcore/1.9.4/StructureDefinition-DocumentoCl.html)**Additional supported profiles:**  [Perfil del Documento de Biopsía](StructureDefinition-r2bo-composition-biopsia.md) |  |  | y | y |  |  |  |  |
| [DiagnosticReport](#DiagnosticReport1-3) | Supported Profiles  [Perfil del Reporte de Anatomía Patológica](StructureDefinition-r2bo-informe-biopsia.md) |  |  | y | y |  |  |  |  |
| [Observation](#Observation1-4) | [https://hl7chile.cl/fhir/ig/clcore/StructureDefinition/CoreObservacionCL|1.9.4](https://hl7chile.cl/fhir/ig/clcore/1.9.4/StructureDefinition-CoreObservacionCL.html)**Additional supported profiles:**  [Perfil de Grupo Estadificación TNM](StructureDefinition-r2bo-estadificacion-tnm.md)  [Perfil de Origen para las Categorías T, N, M (Abstracto)](StructureDefinition-r2bo-categoria-tnm.md)  [Perfil de Origen de Todos Los Resultados](StructureDefinition-r2bo-resultados-reporte-biopsia.md) |  |  | y | y |  |  |  |  |
| [PractitionerRole](#PractitionerRole1-5) | [https://hl7chile.cl/fhir/ig/clcore/StructureDefinition/CoreRolClinicoCl|1.9.4](https://hl7chile.cl/fhir/ig/clcore/1.9.4/StructureDefinition-CoreRolClinicoCl.html)**Additional supported profiles:**  [Perfil de Rol Profesional](StructureDefinition-r2bo-rol-profesional-minsal.md) |  |  | y | y | practitioner, organization |  |  |  |
| [ServiceRequest](#ServiceRequest1-6) | Supported Profiles  [Perfil de Solicitud de Informe de Anatomía Patológica](StructureDefinition-r2bo-solicitud-informe-apa.md) |  |  | y | y | identifier |  |  |  |
| [Specimen](#Specimen1-7) | Supported Profiles  [Perfil de Muestra](StructureDefinition-r2bo-muestra-biopsia.md) |  |  | y | y | identifier |  |  |  |

-------

#### Resource Conformance: SHALL BodyStructure

Core FHIR Resource

[BodyStructure](http://hl7.org/fhir/R4/bodystructure.html)

Reference Policy

`literal`,
`logical`

Interaction summary

* Supports `create`, `update`.

Supported Profiles
[Perfil de la Morfología y Topología del Tumor](StructureDefinition-r2bo-tumor.md)

#### Resource Conformance: SHALL Composition

Base System Profile

[CL Documentoversion: 1.9.4)](https://hl7chile.cl/fhir/ig/clcore/1.9.4/StructureDefinition-DocumentoCl.html)

Profile Conformance

**SHALL**

Reference Policy

`literal`,
`logical`

Supported Profiles
[Perfil del Documento de Biopsía](StructureDefinition-r2bo-composition-biopsia.md)

Interaction summary

* Supports `create`, `update`.

#### Resource Conformance: SHALL DiagnosticReport

Core FHIR Resource

[DiagnosticReport](http://hl7.org/fhir/R4/diagnosticreport.html)

Reference Policy

`literal`,
`logical`

Interaction summary

* Supports `create`, `update`.

Supported Profiles
[Perfil del Reporte de Anatomía Patológica](StructureDefinition-r2bo-informe-biopsia.md)

#### Resource Conformance: SHALL Observation

Base System Profile

[CL Observaciónversion: 1.9.4)](https://hl7chile.cl/fhir/ig/clcore/1.9.4/StructureDefinition-CoreObservacionCL.html)

Profile Conformance

**SHALL**

Reference Policy

`literal`,
`logical`

Supported Profiles
[Perfil de Grupo Estadificación TNM](StructureDefinition-r2bo-estadificacion-tnm.md)
[Perfil de Origen para las Categorías T, N, M (Abstracto)](StructureDefinition-r2bo-categoria-tnm.md)
[Perfil de Origen de Todos Los Resultados](StructureDefinition-r2bo-resultados-reporte-biopsia.md)

Interaction summary

* Supports `create`, `update`.

#### Resource Conformance: SHALL PractitionerRole

Base System Profile

[CL RolClinicoversion: 1.9.4)](https://hl7chile.cl/fhir/ig/clcore/1.9.4/StructureDefinition-CoreRolClinicoCl.html)

Profile Conformance

**SHALL**

Reference Policy

`literal`,
`logical`

Supported Profiles
[Perfil de Rol Profesional](StructureDefinition-r2bo-rol-profesional-minsal.md)

Interaction summary

* Supports `create`, `update`.

Search Parameters


 

#### Resource Conformance: SHALL ServiceRequest

Core FHIR Resource

[ServiceRequest](http://hl7.org/fhir/R4/servicerequest.html)

Reference Policy

`literal`,
`logical`

Interaction summary

* Supports `create`, `update`.

Supported Profiles
[Perfil de Solicitud de Informe de Anatomía Patológica](StructureDefinition-r2bo-solicitud-informe-apa.md)

Search Parameters


 

#### Resource Conformance: SHALL Specimen

Core FHIR Resource

[Specimen](http://hl7.org/fhir/R4/specimen.html)

Reference Policy

`literal`,
`logical`

Interaction summary

* Supports `create`, `update`.

Supported Profiles
[Perfil de Muestra](StructureDefinition-r2bo-muestra-biopsia.md)

Search Parameters


 



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "r2bo-minsal-cliente-informe",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "informative",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/ImplementationGuide/hl7.fhir.cl.minsal.r2bo"
          }
        ]
      }
    }
  ],
  "url" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/CapabilityStatement/r2bo-minsal-cliente-informe",
  "version" : "0.1.1-draft",
  "name" : "R2BOMinsalSourceInformeCapabilityStatement",
  "title" : "CapabilityStatement Cliente de Origen de Informes del Repositorio de Biopsia del Ministerio de Salud",
  "status" : "active",
  "experimental" : true,
  "date" : "2025-03-05T15:30:00-03:00",
  "publisher" : "Unidad de Interoperabilidad - MINSAL",
  "contact" : [
    {
      "name" : "Unidad de Interoperabilidad - MINSAL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://interoperabilidad.minsal.cl"
        }
      ]
    }
  ],
  "description" : "CapabilityStatement para definir las caracteristicas mínimas del cliente que realiza la creación de informes de anatomía patológica y sus resultados.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CL",
          "display" : "Chile"
        }
      ]
    }
  ],
  "kind" : "requirements",
  "imports" : [
    "https://interoperabilidad.minsal.cl/fhir/ig/nid/CapabilityStatement/MPI.IHE.PIXm.Origen",
    "https://interoperabilidad.minsal.cl/fhir/ig/nid/CapabilityStatement/NID.IHE.HPD.Source"
  ],
  "fhirVersion" : "4.0.1",
  "format" : ["json", "xml", "application/fhir+json", "application/fhir+xml"],
  "implementationGuide" : [
    "https://hl7chile.cl/fhir/ig/clcore/ImplementationGuide/hl7.fhir.cl.clcore|1.9.4",
    "https://interoperabilidad.minsal.cl/fhir/ig/nid/ImplementationGuide/hl7.fhir.cl.minsal.nid",
    "http://hl7.org/fhir/us/mcode/ImplementationGuide/hl7.fhir.us.mcode"
  ],
  "rest" : [
    {
      "mode" : "client",
      "documentation" : "Este Cliente del Repositorio de Biopsia del Ministerio de Salud permite la creación de informes de anatomía patológica y sus resultados.",
      "security" : {
        "service" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/restful-security-service",
                "code" : "OAuth"
              }
            ]
          }
        ],
        "description" : "OAuth2 usando el APIG del Ministerio de Salud para generar Tokens para enviar y acceder al respositorio"
      },
      "resource" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "BodyStructure",
          "supportedProfile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-tumor"
          ],
          "interaction" : [
            {
              "code" : "create"
            },
            {
              "code" : "update"
            }
          ],
          "referencePolicy" : ["literal", "logical"]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Composition",
          "profile" : "https://hl7chile.cl/fhir/ig/clcore/StructureDefinition/DocumentoCl|1.9.4",
          "supportedProfile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-composition-biopsia"
          ],
          "interaction" : [
            {
              "code" : "create"
            },
            {
              "code" : "update"
            }
          ],
          "referencePolicy" : ["literal", "logical"]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "DiagnosticReport",
          "supportedProfile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-informe-biopsia"
          ],
          "interaction" : [
            {
              "code" : "create"
            },
            {
              "code" : "update"
            }
          ],
          "referencePolicy" : ["literal", "logical"]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Observation",
          "profile" : "https://hl7chile.cl/fhir/ig/clcore/StructureDefinition/CoreObservacionCL|1.9.4",
          "supportedProfile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-estadificacion-tnm",
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-categoria-tnm",
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-resultados-reporte-biopsia"
          ],
          "interaction" : [
            {
              "code" : "create"
            },
            {
              "code" : "update"
            }
          ],
          "referencePolicy" : ["literal", "logical"]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "PractitionerRole",
          "profile" : "https://hl7chile.cl/fhir/ig/clcore/StructureDefinition/CoreRolClinicoCl|1.9.4",
          "supportedProfile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-rol-profesional-minsal"
          ],
          "interaction" : [
            {
              "code" : "create"
            },
            {
              "code" : "update"
            }
          ],
          "referencePolicy" : ["literal", "logical"],
          "searchParam" : [
            {
              "name" : "practitioner",
              "definition" : "http://hl7.org/fhir/SearchParameter/PractitionerRole-practitioner",
              "type" : "reference",
              "documentation" : "El profesional que cumple el rol"
            },
            {
              "name" : "organization",
              "definition" : "http://hl7.org/fhir/SearchParameter/PractitionerRole-organization",
              "type" : "reference",
              "documentation" : "La identidad de la organización que representa el profesional"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "ServiceRequest",
          "supportedProfile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-solicitud-informe-apa"
          ],
          "interaction" : [
            {
              "code" : "create"
            },
            {
              "code" : "update"
            }
          ],
          "referencePolicy" : ["literal", "logical"],
          "searchParam" : [
            {
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-identifier",
              "type" : "token",
              "documentation" : "Identificador único de la solicitud"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Specimen",
          "supportedProfile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-muestra-biopsia"
          ],
          "interaction" : [
            {
              "code" : "create"
            },
            {
              "code" : "update"
            }
          ],
          "referencePolicy" : ["literal", "logical"],
          "searchParam" : [
            {
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/Specimen-identifier",
              "type" : "token",
              "documentation" : "Identificador único asociado a la muestra"
            }
          ]
        }
      ],
      "interaction" : [
        {
          "code" : "transaction",
          "documentation" : "Iteracción para enviar solicitudes de un informe de biopsia y sus resultados"
        }
      ]
    }
  ]
}

```
