# Ejemplo de Enviar un Informe de Anatomía Patológica - Repositorio de Reportes de Biopsias Oncológicas v0.1.1-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Ejemplo de Enviar un Informe de Anatomía Patológica**

## Example Bundle: Ejemplo de Enviar un Informe de Anatomía Patológica

Profile: [Perfil de Bundle para Generar Informe](StructureDefinition-r2bo-bundle-generar-informe.md)

Bundle r2bo-generar-informe-bundle-ejemplo of type transaction

-------

Entry 1 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/ServiceRequest/r2bo-solicitud-informe-apa-ej

Resource ServiceRequest:

> 

version: 2

Profile: [Perfil de Solicitud de Informe de Anatomía Patológica](StructureDefinition-r2bo-solicitud-informe-apa.md)

**identifier**: 111111101**status**: Completed**intent**: Order**priority**: Routine**code**: No display for ServiceRequest.code (concept: Pathologist report)**subject**:[Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))](Patient-paciente-requiere-examen.md)**requester**:[PractitionerRole MÉDICO CIRUJANO](PractitionerRole-ProfesionalHospital.md)**performer**:[Organization Hospital Dr. Hernán Henríquez Aravena (Temuco)](Organization-hospital-collector.md)**specimen**:[Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma](Specimen-r2bo-specimen-example.md)

Request:

```
PUT ServiceRequest?identifier=111111101

```

-------

Entry 2 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Patient/paciente-requiere-examen

Resource Patient:

> 

Profile: [MINSAL Paciente](https://interoperabilidad.minsal.cl/fhir/ig/nid/0.4.7/StructureDefinition-MINSALPaciente.html)

Javiera Castilla (official) Female, DoB: 1995-12-12 ( RUN: 16182522-0 (use: official, ))
-------

Request:

```
POST Patient
If-None-Exist = Patient?identifier=16182522-0

```

-------

Entry 3 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/PractitionerRole/ProfesionalHospital

Resource PractitionerRole:

> 

Profile: [Perfil de Rol Profesional](StructureDefinition-r2bo-rol-profesional-minsal.md)

**practitioner**:[Practitioner Juan Perez](Practitioner-profesional-hospital-collector.md)**organization**:[Organization Hospital Dr. Hernán Henríquez Aravena (Temuco)](Organization-hospital-collector.md)**code**:MÉDICO CIRUJANO**location**:[Location Medicina General](Location-r2bo-localizacion-MedicinaGeneral.md)

Request:

```
POST PractitionerRole
If-None-Exist = PractitionerRole?practitioner.identifier=5135329-3&organization.identifier=121109

```

-------

Entry 4 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/PractitionerRole/r2bo-anatopatologo-hospital

Resource PractitionerRole:

> 

Profile: [Perfil de Rol Profesional](StructureDefinition-r2bo-rol-profesional-minsal.md)

**practitioner**:[Practitioner Patricia Gutierrez](Practitioner-profesional-hospital-anatopatologo.md)**organization**:[Organization Hospital Dr. Hernán Henríquez Aravena (Temuco)](Organization-hospital-collector.md)**code**:MÉDICO CIRUJANO**specialty**:ANATOMÍA PATOLÓGICA

Request:

```
POST PractitionerRole
If-None-Exist = PractitionerRole?practitioner.identifier=19283789-2&organization.identifier=121109

```

-------

Entry 5 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Location/r2bo-localizacion-MedicinaGeneral

Resource Location:

> 

Profile: [Servicio Solicitante del Informe](StructureDefinition-r2bo-servicio-solicitante.md)

**name**: Medicina General

Request:

```
POST Location
If-None-Exist = Location?name=Medicina General

```

-------

Entry 6 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Practitioner/profesional-hospital-collector

Resource Practitioner:

> 

Profile: [Prestador Profesional](https://interoperabilidad.minsal.cl/fhir/ig/nid/0.4.7/StructureDefinition-MINSALPrestadorProfesional.html)

**identifier**: RUN/5135329-3 (use: official, )**name**: Juan Perez**birthDate**: 1991-05-18

### Qualifications

| | | |
| :--- | :--- | :--- |
| - | **Identifier** | **Code** |
| * | cert | MÉDICO CIRUJANO |


Request:

```
POST Practitioner
If-None-Exist = Practitioner?identifier=5135329-3

```

-------

Entry 7 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Practitioner/profesional-hospital-anatopatologo

Resource Practitioner:

> 

Profile: [Prestador Profesional](https://interoperabilidad.minsal.cl/fhir/ig/nid/0.4.7/StructureDefinition-MINSALPrestadorProfesional.html)

**identifier**: RUN/19283789-2 (use: official, )**name**: Patricia Gutierrez**gender**: Female**birthDate**: 1983-11-18
> **qualification****identifier**: cert**code**:MÉDICO CIRUJANO

> **qualification****identifier**: esp**code**:MEDICINA INTERNA

> **qualification****identifier**: subesp**code**:ANATOMÍA PATOLÓGICA

Request:

```
POST Practitioner
If-None-Exist = Practitioner?identifier=19283789-2

```

-------

Entry 8 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Organization/hospital-collector

Resource Organization:

> 

Profile: [Prestador Institucional](https://interoperabilidad.minsal.cl/fhir/ig/nid/0.4.7/StructureDefinition-MINSALPrestadorOrganizacional.html)

**identifier**: 121109**name**: Hospital Dr. Hernán Henríquez Aravena (Temuco)

Request:

```
POST Organization
If-None-Exist = Organization?identifier=121109

```

-------

Entry 9 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Specimen/r2bo-specimen-example

Resource Specimen:

> 

Profile: [Perfil de Muestra](StructureDefinition-r2bo-muestra-biopsia.md)

**identifier**: 110101101**status**: Available**type**:Tissue**subject**:[Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))](Patient-paciente-requiere-examen.md)**receivedTime**: 2021-06-01 00:00:00+0000

### Collections

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| - | **Collector** | **Collected[x]** | **Method** | **BodySite** |
| * | [PractitionerRole MÉDICO CIRUJANO](PractitionerRole-ProfesionalHospital.md) | 2021-06-01 10:00:00+0000 | Biopsy of breast | No display for Specimen.collection.bodySite (concept: Structure of breast) |

**note**:
> 

Resección completa de tejido mamario, posible carcinoma



Request:

```
PUT Specimen?identifier=110101101

```

-------

Entry 10 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Composition/r2bo-documento-biopsia-ex

Resource Composition:

> 

Profile: [Perfil del Documento de Biopsía](StructureDefinition-r2bo-composition-biopsia.md)

**Extensión De Referencia al Reporte**:[Diagnostic Report for 'Breast Pathology biopsy report' for '->Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))'](DiagnosticReport-r2bo-informe-biopsia-ex.md)**identifier**: r2bo-2020-0001**status**: Final**type**:Informe de Biopsia de Mama**category**:Pathology (gross & histopath, not surgical)**date**: 2021-08-01 10:00:00-0400**author**:[PractitionerRole MÉDICO CIRUJANO](PractitionerRole-r2bo-anatopatologo-hospital.md)**title**: Informe de Biopsia de Mama

Request:

```
POST Composition

```

-------

Entry 11 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/DiagnosticReport/r2bo-informe-biopsia-ex

Resource DiagnosticReport:

> 

Profile: [Perfil del Reporte de Anatomía Patológica](StructureDefinition-r2bo-informe-biopsia.md)

## Informe de Biopsia de Mama (Pathology (gross & histopath, not surgical) ) 

| | |
| :--- | :--- |
| Subject | Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, )) |
| Reported | 2021-08-01 10:00:00-0400 |
| Performer | [PractitionerRole MÉDICO CIRUJANO](PractitionerRole-r2bo-anatopatologo-hospital.md) |
| Identifier | r2bo-2020-0001 |

**Report Details**

* **Code**: [Pathology report microscopic observation in Specimen](Observation-r2bo-observacion-microscopica-ex.md)
  * **Value**: Se observa tejido mamario con células epiteliales y estromales, con signos de malignidad con metastasis en ganglios linfáticos
  * **Flags**: Final
  * **When For**: 2021-06-01 12:00:00-0400
* **Code**: [Macroscopic observation [Interpretation] in Specimen Narrative](Observation-r2bo-observacion-macroscopica-ex.md)
  * **Value**: Muestra de biopsia de tejido mamario, de 2x2x1 cm, de color blanco, consistencia firme, bordes irregulares, sin lesiones visibles a simple vista
  * **Flags**: Final
  * **When For**: 2021-06-01 12:00:00-0400
* **Code**: [Pathologic TNM stage grouping](Observation-r2bo-estadificacion-tnm-ex.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2021-06-01 12:00:00-0400
* **Code**: [Lymph nodes with metastasis [#] in Cancer specimen](Observation-r2bo-observacion-ganglios-linfaticos-ex.md)
  * **Value**: true
  * **Flags**: Final
  * **When For**: 2021-06-01 12:00:00-0400
* **Code**: [Presence of direct invasion by primary malignant neoplasm to nerve](Observation-r2bo-observacion-infiltracion-perineural-ex.md)
  * **Value**: Perineural invasion by tumour not identified
  * **Flags**: Final
  * **When For**: 2021-06-01 12:00:00-0400
* **Code**: [Status of peritumoral lymphocyte response](Observation-r2bo-observacion-infiltracion-peritumoral-ex.md)
  * **Value**: Marked peritumoral lymphocytic response
  * **Flags**: Final
  * **When For**: 2021-06-01 12:00:00-0400
* **Code**: [Lymphatic.small vessel.invasion [Identifier] in Specimen by CAP cancer protocols](Observation-r2bo-observacion-invasion-linfatica-ex.md)
  * **Value**: Present
  * **Flags**: Final
  * **When For**: 2021-06-01 12:00:00-0400
* **Code**: [Venous.large vessel.invasion [Identifier] in Specimen by CAP cancer protocols](Observation-r2bo-observacion-invasion-vascular-ex.md)
  * **Value**: Present
  * **Flags**: Final
  * **When For**: 2021-06-01 12:00:00-0400
* **Code**: [Surgical margin observable](Observation-r2bo-observacion-margen-quirurgico-ex.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2021-06-01 12:00:00-0400
* **Code**: [Multiple tumors reported as single primary Cancer](Observation-r2bo-observacion-centricidad-ex.md)
  * **Value**: true
  * **Flags**: Final
  * **When For**: 2021-06-01 12:00:00-0400
* **Code**: [Status of specimen involvement by multifocal invasion](Observation-r2bo-observacion-multifocalidad-ex.md)
  * **Value**: true
  * **Flags**: Final
  * **When For**: 2021-06-01 12:00:00-0400
* **Code**: [Percentage of tumour involved by necrosis](Observation-r2bo-observacion-porcentaje-necrosis-ex.md)
  * **Value**: 5 %(Details: UCUM code% = 'percent')
  * **Flags**: Final
  * **When For**: 2021-06-01 12:00:00-0400
* **Code**: [Tumor response to neoadjuvant therapy](Observation-r2bo-observacion-post-tratamiento-neoadjuvancia-ex.md)
  * **Value**: El tratamiento entregado no ha sido efectivo para reducir el tamaño del tumor, por lo que se recomienda un nuevo tratamiento.
  * **Flags**: Final
  * **When For**: 2021-06-01 12:00:00-0400
* **Code**: [Size Tumor](Observation-r2bo-tamano-tumor-ex.md)
  * **Value**: 
  * **Flags**: Final
  * **When For**: 2021-06-01 12:00:00-0400

Carcinoma ductal infiltrante de mama, grado histológico 2, estadio pT2N2M1, con márgenes quirúrgicos positivos y con evidencia de necrosis tumoral

**Coded Conclusions:**
* Carcinoma ductal infiltrante
* Mama

Request:

```
POST DiagnosticReport

```

-------

Entry 12 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-observacion-microscopica-ex

Resource Observation:

> 

Profile: [Perfil de Observación Microscópica](StructureDefinition-r2bo-observacion-microscopica.md)

**basedOn**:[ServiceRequest Pathologist report](ServiceRequest-r2bo-solicitud-informe-apa-ej.md)**status**: Final**category**:Laboratory**code**:Pathology report microscopic observation in Specimen**subject**:[Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))](Patient-paciente-requiere-examen.md)**effective**: 2021-06-01 12:00:00-0400**performer**:[PractitionerRole MÉDICO CIRUJANO](PractitionerRole-r2bo-anatopatologo-hospital.md)**value**: Se observa tejido mamario con células epiteliales y estromales, con signos de malignidad con metastasis en ganglios linfáticos**specimen**:[Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma](Specimen-r2bo-specimen-example.md)

Request:

```
POST Observation

```

-------

Entry 13 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/BodyStructure/r2bo-tumor-ex

Resource BodyStructure:

> 

Profile: [Perfil de la Morfología y Topología del Tumor](StructureDefinition-r2bo-tumor.md)

**morphology**:Carcinoma ductal infiltrante**patient**:[Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))](Patient-paciente-requiere-examen.md)

Request:

```
POST BodyStructure

```

-------

Entry 14 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-observacion-macroscopica-ex

Resource Observation:

> 

Profile: [Perfil de Observación Macroscópica](StructureDefinition-r2bo-observacion-macroscopica.md)

**basedOn**:[ServiceRequest Pathologist report](ServiceRequest-r2bo-solicitud-informe-apa-ej.md)**status**: Final**category**:Laboratory**code**:Macroscopic observation [Interpretation] in Specimen Narrative**subject**:[Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))](Patient-paciente-requiere-examen.md)**effective**: 2021-06-01 12:00:00-0400**performer**:[PractitionerRole MÉDICO CIRUJANO](PractitionerRole-r2bo-anatopatologo-hospital.md)**value**: Muestra de biopsia de tejido mamario, de 2x2x1 cm, de color blanco, consistencia firme, bordes irregulares, sin lesiones visibles a simple vista**specimen**:[Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma](Specimen-r2bo-specimen-example.md)

Request:

```
POST Observation

```

-------

Entry 15 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-estadificacion-tnm-ex

Resource Observation:

> 

Profile: [Perfil de Grupo Estadificación TNM](StructureDefinition-r2bo-estadificacion-tnm.md)

**basedOn**:[ServiceRequest Pathologist report](ServiceRequest-r2bo-solicitud-informe-apa-ej.md)**status**: Final**category**:Laboratory**code**:Pathologic TNM stage grouping**subject**:[Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))](Patient-paciente-requiere-examen.md)**effective**: 2021-06-01 12:00:00-0400**performer**:[PractitionerRole MÉDICO CIRUJANO](PractitionerRole-r2bo-anatopatologo-hospital.md)**specimen**:[Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma](Specimen-r2bo-specimen-example.md)**hasMember**:
* [Observation pT category](Observation-r2bo-tnm-categoria-tumor-primario-ex.md)
* [Observation pN category](Observation-r2bo-tnm-categoria-nodo-regional-ex.md)
* [Observation pM category](Observation-r2bo-tnm-categoria-metastasis-distantel-ex.md)

Request:

```
POST Observation

```

-------

Entry 16 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-tnm-categoria-tumor-primario-ex

Resource Observation:

> 

Profile: [Perfil de Categoria TNM Tumor Primario](StructureDefinition-r2bo-tnm-categoria-tumor-primario.md)

**basedOn**:[ServiceRequest Pathologist report](ServiceRequest-r2bo-solicitud-informe-apa-ej.md)**status**: Final**category**:Laboratory**code**:pT category**subject**:[Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))](Patient-paciente-requiere-examen.md)**effective**: 2021-06-01 12:00:00-0400**performer**:[PractitionerRole MÉDICO CIRUJANO](PractitionerRole-r2bo-anatopatologo-hospital.md)**value**:pT2 (AJCC)**specimen**:[Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma](Specimen-r2bo-specimen-example.md)

Request:

```
POST Observation

```

-------

Entry 17 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-tnm-categoria-nodo-regional-ex

Resource Observation:

> 

Profile: [Perfil de Categoria TNM Nodos Regional](StructureDefinition-r2bo-tnm-categoria-nodo-regional.md)

**basedOn**:[ServiceRequest Pathologist report](ServiceRequest-r2bo-solicitud-informe-apa-ej.md)**status**: Final**category**:Laboratory**code**:pN category**subject**:[Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))](Patient-paciente-requiere-examen.md)**effective**: 2021-06-01 12:00:00-0400**performer**:[PractitionerRole MÉDICO CIRUJANO](PractitionerRole-r2bo-anatopatologo-hospital.md)**value**:pN2 (AJCC)**specimen**:[Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma](Specimen-r2bo-specimen-example.md)

Request:

```
POST Observation

```

-------

Entry 18 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-tnm-categoria-metastasis-distantel-ex

Resource Observation:

> 

Profile: [Perfil de Categoria TNM de Metástasis Distante](StructureDefinition-r2bo-tnm-categoria-metastasis-distante.md)

**basedOn**:[ServiceRequest Pathologist report](ServiceRequest-r2bo-solicitud-informe-apa-ej.md)**status**: Final**category**:Laboratory**code**:pM category**subject**:[Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))](Patient-paciente-requiere-examen.md)**effective**: 2021-06-01 12:00:00-0400**performer**:[PractitionerRole MÉDICO CIRUJANO](PractitionerRole-r2bo-anatopatologo-hospital.md)**value**:pM1 (AJCC)**specimen**:[Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma](Specimen-r2bo-specimen-example.md)

Request:

```
POST Observation

```

-------

Entry 19 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-observacion-infiltracion-perineural-ex

Resource Observation:

> 

Profile: [Perfil de Observación Infiltración Perineural](StructureDefinition-r2bo-observacion-infiltracion-perineural.md)

**basedOn**:[ServiceRequest Pathologist report](ServiceRequest-r2bo-solicitud-informe-apa-ej.md)**status**: Final**category**:Laboratory**code**:Presence of direct invasion by primary malignant neoplasm to nerve**subject**:[Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))](Patient-paciente-requiere-examen.md)**effective**: 2021-06-01 12:00:00-0400**performer**:[PractitionerRole MÉDICO CIRUJANO](PractitionerRole-r2bo-anatopatologo-hospital.md)**value**:Perineural invasion by tumour not identified**specimen**:[Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma](Specimen-r2bo-specimen-example.md)

Request:

```
POST Observation

```

-------

Entry 20 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-observacion-ganglios-linfaticos-ex

Resource Observation:

> 

Profile: [Perfil de Observación Ganglios Linfáticos](StructureDefinition-r2bo-observacion-ganglios-linfaticos.md)

**basedOn**:[ServiceRequest Pathologist report](ServiceRequest-r2bo-solicitud-informe-apa-ej.md)**status**: Final**category**:Laboratory**code**:Lymph nodes with metastasis [#] in Cancer specimen**subject**:[Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))](Patient-paciente-requiere-examen.md)**effective**: 2021-06-01 12:00:00-0400**performer**:[PractitionerRole MÉDICO CIRUJANO](PractitionerRole-r2bo-anatopatologo-hospital.md)**value**: true**specimen**:[Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma](Specimen-r2bo-specimen-example.md)

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Number | 4 |


Request:

```
POST Observation

```

-------

Entry 21 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-observacion-infiltracion-peritumoral-ex

Resource Observation:

> 

Profile: [Perfil de Observación Infiltración Peritumoral](StructureDefinition-r2bo-observacion-infiltracion-peritumoral.md)

**basedOn**:[ServiceRequest Pathologist report](ServiceRequest-r2bo-solicitud-informe-apa-ej.md)**status**: Final**category**:Laboratory**code**:Status of peritumoral lymphocyte response**subject**:[Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))](Patient-paciente-requiere-examen.md)**effective**: 2021-06-01 12:00:00-0400**performer**:[PractitionerRole MÉDICO CIRUJANO](PractitionerRole-r2bo-anatopatologo-hospital.md)**value**:Marked peritumoral lymphocytic response**specimen**:[Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma](Specimen-r2bo-specimen-example.md)

Request:

```
POST Observation

```

-------

Entry 22 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-observacion-invasion-linfatica-ex

Resource Observation:

> 

Profile: [Perfil de Observación Invasión Linfatica](StructureDefinition-r2bo-observacion-invasion-linfatica.md)

**basedOn**:[ServiceRequest Pathologist report](ServiceRequest-r2bo-solicitud-informe-apa-ej.md)**status**: Final**category**:Laboratory**code**:Lymphatic.small vessel.invasion [Identifier] in Specimen by CAP cancer protocols**subject**:[Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))](Patient-paciente-requiere-examen.md)**effective**: 2021-06-01 12:00:00-0400**performer**:[PractitionerRole MÉDICO CIRUJANO](PractitionerRole-r2bo-anatopatologo-hospital.md)**value**:Present**specimen**:[Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma](Specimen-r2bo-specimen-example.md)

Request:

```
POST Observation

```

-------

Entry 23 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-observacion-invasion-vascular-ex

Resource Observation:

> 

Profile: [Perfil de Observación Invasión Vascular](StructureDefinition-r2bo-observacion-invasion-vascular.md)

**basedOn**:[ServiceRequest Pathologist report](ServiceRequest-r2bo-solicitud-informe-apa-ej.md)**status**: Final**category**:Laboratory**code**:Venous.large vessel.invasion [Identifier] in Specimen by CAP cancer protocols**subject**:[Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))](Patient-paciente-requiere-examen.md)**effective**: 2021-06-01 12:00:00-0400**performer**:[PractitionerRole MÉDICO CIRUJANO](PractitionerRole-r2bo-anatopatologo-hospital.md)**value**:Present**specimen**:[Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma](Specimen-r2bo-specimen-example.md)

Request:

```
POST Observation

```

-------

Entry 24 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-observacion-margen-quirurgico-ex

Resource Observation:

> 

Profile: [Perfil de Observación Margen Quirúrgico](StructureDefinition-r2bo-observacion-margen-quirurgico.md)

**basedOn**:[ServiceRequest Pathologist report](ServiceRequest-r2bo-solicitud-informe-apa-ej.md)**status**: Final**category**:Laboratory**code**:Surgical margin observable**subject**:[Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))](Patient-paciente-requiere-examen.md)**effective**: 2021-06-01 12:00:00-0400**performer**:[PractitionerRole MÉDICO CIRUJANO](PractitionerRole-r2bo-anatopatologo-hospital.md)**specimen**:[Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma](Specimen-r2bo-specimen-example.md)
> **component****code**:Surgical margin site involved by tumour**value**:Positive

> **component****code**:Distance of tumor from closest margin**value**: 1.5 Millimeter(Details: UCUM codemm = 'millimeter')

Request:

```
POST Observation

```

-------

Entry 25 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-observacion-centricidad-ex

Resource Observation:

> 

Profile: [Perfil de Observación Multicentricidad](StructureDefinition-r2bo-observacion-multicentricidad.md)

**basedOn**:[ServiceRequest Pathologist report](ServiceRequest-r2bo-solicitud-informe-apa-ej.md)**status**: Final**category**:Laboratory**code**:Multiple tumors reported as single primary Cancer**subject**:[Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))](Patient-paciente-requiere-examen.md)**effective**: 2021-06-01 12:00:00-0400**performer**:[PractitionerRole MÉDICO CIRUJANO](PractitionerRole-r2bo-anatopatologo-hospital.md)**value**: true**specimen**:[Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma](Specimen-r2bo-specimen-example.md)

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Number | 2 |


Request:

```
POST Observation

```

-------

Entry 26 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-observacion-multifocalidad-ex

Resource Observation:

> 

Profile: [Perfil de Observación Focalidad](StructureDefinition-r2bo-observacion-focalidad.md)

**basedOn**:[ServiceRequest Pathologist report](ServiceRequest-r2bo-solicitud-informe-apa-ej.md)**status**: Final**category**:Laboratory**code**:Status of specimen involvement by multifocal invasion**subject**:[Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))](Patient-paciente-requiere-examen.md)**effective**: 2021-06-01 12:00:00-0400**performer**:[PractitionerRole MÉDICO CIRUJANO](PractitionerRole-r2bo-anatopatologo-hospital.md)**value**: true**specimen**:[Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma](Specimen-r2bo-specimen-example.md)

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Number | 2 |


Request:

```
POST Observation

```

-------

Entry 27 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-observacion-porcentaje-necrosis-ex

Resource Observation:

> 

Profile: [Perfil de Observación Porcentaje Necrosis](StructureDefinition-r2bo-observacion-porcentaje-necrosis.md)

**basedOn**:[ServiceRequest Pathologist report](ServiceRequest-r2bo-solicitud-informe-apa-ej.md)**status**: Final**category**:Laboratory**code**:Percentage of tumour involved by necrosis**subject**:[Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))](Patient-paciente-requiere-examen.md)**effective**: 2021-06-01 12:00:00-0400**performer**:[PractitionerRole MÉDICO CIRUJANO](PractitionerRole-r2bo-anatopatologo-hospital.md)**value**: 5 %(Details: UCUM code% = 'percent')**specimen**:[Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma](Specimen-r2bo-specimen-example.md)

Request:

```
POST Observation

```

-------

Entry 28 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-observacion-post-tratamiento-neoadjuvancia-ex

Resource Observation:

> 

Profile: [Perfil de Observación Evaluación Post Neoadyuvancia](StructureDefinition-r2bo-observacion-post-tratamiento-neoadjuvancia.md)

**basedOn**:[ServiceRequest Pathologist report](ServiceRequest-r2bo-solicitud-informe-apa-ej.md)**status**: Final**category**:Laboratory**code**:Tumor response to neoadjuvant therapy**subject**:[Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))](Patient-paciente-requiere-examen.md)**effective**: 2021-06-01 12:00:00-0400**performer**:[PractitionerRole MÉDICO CIRUJANO](PractitionerRole-r2bo-anatopatologo-hospital.md)**value**: El tratamiento entregado no ha sido efectivo para reducir el tamaño del tumor, por lo que se recomienda un nuevo tratamiento.**specimen**:[Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma](Specimen-r2bo-specimen-example.md)

Request:

```
POST Observation

```

-------

Entry 29 - fullUrl = https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-tamano-tumor-ex

Resource Observation:

> 

Profile: [Perfil de Tamaño del Tumor](StructureDefinition-r2bo-tamano-tumor.md)

**basedOn**:[ServiceRequest Pathologist report](ServiceRequest-r2bo-solicitud-informe-apa-ej.md)**status**: Final**category**:Laboratory**code**:Size Tumor**subject**:[Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))](Patient-paciente-requiere-examen.md)**effective**: 2021-06-01 12:00:00-0400**performer**:[PractitionerRole MÉDICO CIRUJANO](PractitionerRole-r2bo-anatopatologo-hospital.md)**specimen**:[Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma](Specimen-r2bo-specimen-example.md)
> **component****code**:Size.maximum dimension in Tumor**value**: 1.5 cm(Details: UCUM codecm = 'centimeter')

> **component****code**:Size additional dimension in Tumor**value**: 1.2 cm(Details: UCUM codecm = 'centimeter')

> **component****code**:Size additional dimension in Tumor**value**: 0.7 cm(Details: UCUM codecm = 'centimeter')

Request:

```
POST Observation

```



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "r2bo-generar-informe-bundle-ejemplo",
  "meta" : {
    "profile" : [
      "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-bundle-generar-informe"
    ]
  },
  "type" : "transaction",
  "entry" : [
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/ServiceRequest/r2bo-solicitud-informe-apa-ej",
      "resource" : {
        "resourceType" : "ServiceRequest",
        "id" : "r2bo-solicitud-informe-apa-ej",
        "meta" : {
          "versionId" : "2",
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-solicitud-informe-apa"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ServiceRequest_r2bo-solicitud-informe-apa-ej\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ServiceRequest r2bo-solicitud-informe-apa-ej</b></p><a name=\"r2bo-solicitud-informe-apa-ej\"> </a><a name=\"hcr2bo-solicitud-informe-apa-ej\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 2</p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-r2bo-solicitud-informe-apa.html\">Perfil de Solicitud de Informe de Anatomía Patológica</a></p></div><p><b>identifier</b>: 111111101</p><p><b>status</b>: Completed</p><p><b>intent</b>: Order</p><p><b>priority</b>: Routine</p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 116784002}\">Informe de Biopsia</span></p><p><b>subject</b>: <a href=\"Patient-paciente-requiere-examen.html\">Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))</a></p><p><b>requester</b>: <a href=\"PractitionerRole-ProfesionalHospital.html\">PractitionerRole MÉDICO CIRUJANO</a></p><p><b>performer</b>: <a href=\"Organization-hospital-collector.html\">Organization Hospital Dr. Hernán Henríquez Aravena (Temuco)</a></p><p><b>locationCode</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-RoleCode HLAB}\">hospital laboratory</span></p><p><b>reasonCode</b>: <span title=\"Codes:{http://snomed.info/sct 269497004}, {http://hl7.org/fhir/sid/icd-10 D48.6}\">Neoplasm of uncertain behaviour of breast</span></p><p><b>specimen</b>: <a href=\"Specimen-r2bo-specimen-example.html\">Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma</a></p></div>"
        },
        "identifier" : [
          {
            "value" : "111111101"
          }
        ],
        "status" : "completed",
        "intent" : "order",
        "priority" : "routine",
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "116784002"
            }
          ],
          "text" : "Informe de Biopsia"
        },
        "subject" : {
          "reference" : "Patient/paciente-requiere-examen"
        },
        "requester" : {
          "reference" : "PractitionerRole/ProfesionalHospital"
        },
        "performer" : [
          {
            "reference" : "Organization/hospital-collector"
          }
        ],
        "locationCode" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
                "code" : "HLAB",
                "display" : "hospital laboratory"
              }
            ]
          }
        ],
        "reasonCode" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "269497004"
              },
              {
                "system" : "http://hl7.org/fhir/sid/icd-10",
                "version" : "2019-covid-expanded",
                "code" : "D48.6"
              }
            ]
          }
        ],
        "specimen" : [
          {
            "reference" : "Specimen/r2bo-specimen-example"
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "ServiceRequest?identifier=111111101"
      }
    },
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Patient/paciente-requiere-examen",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "paciente-requiere-examen",
        "meta" : {
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/nid/StructureDefinition/MINSALPaciente"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_paciente-requiere-examen\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient paciente-requiere-examen</b></p><a name=\"paciente-requiere-examen\"> </a><a name=\"hcpaciente-requiere-examen\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://interoperabilidad.minsal.cl/fhir/ig/nid/0.4.7/StructureDefinition-MINSALPaciente.html\">MINSAL Paciente</a></p></div><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Record is active\">Active:</td><td>true</td><td style=\"background-color: #f3f5da\" title=\"Known status of Patient\">Deceased:</td><td>false</td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Known Marital status of Patient\">Marital Status:</td><td colspan=\"3\"><span title=\"Codes:{https://interoperabilidad.minsal.cl/fhir/ig/nid/CodeSystem/CSEstadoCivil 01}\">Soltero(a)</span></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Other Id (see the one above)\">Other Id:</td><td colspan=\"3\">RUN/16182522-0 (use: official, )</td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Ways to contact the Patient\">Contact Detail</td><td colspan=\"3\"><ul><li><a href=\"tel:+56912387678\">+56912387678</a></li><li>Avenida Las Torres 3456, Departamento 702 null null null (home)</li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Sexo Biologico del paciente\"><a href=\"https://hl7chile.cl/fhir/ig/clcore/1.9.4/StructureDefinition-SexoBiologico.html\">Sexo Biologico del paciente</a></td><td colspan=\"3\"><span title=\"Codes:{http://hl7.org/fhir/administrative-gender female}\">Femenina</span></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"País de origen del paciente\"><a href=\"https://interoperabilidad.minsal.cl/fhir/ig/nid/0.4.7/StructureDefinition-PaisOrigenMPI.html\">País de origen del paciente</a></td><td colspan=\"3\"><span title=\"Codes:{https://hl7chile.cl/fhir/ig/clcore/CodeSystem/CodPais 858}\">Uruguay</span></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Extensión para describir si el paciente pertenece algún pueblo originario\">Pueblos Originarios:</td><td colspan=\"3\"><ul><li>pertenece: false</li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Esta extensión incluye códigos de países\"><a href=\"https://hl7chile.cl/fhir/ig/clcore/1.9.4/StructureDefinition-CodigoPaises.html\">Código de Países</a></td><td colspan=\"3\"><span title=\"Codes:{https://hl7chile.cl/fhir/ig/clcore/CodeSystem/CodPais 152}\">Chile</span></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Religión\"><a href=\"https://interoperabilidad.minsal.cl/fhir/ig/nid/0.4.7/StructureDefinition-Religion.html\">Religión</a></td><td colspan=\"3\"><span title=\"Codes:{https://interoperabilidad.minsal.cl/fhir/ig/nid/CodeSystem/CSReligion 9}\">Ninguna, ateo, agnóstico</span></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Identidad De Género\"><a href=\"https://hl7chile.cl/fhir/ig/clcore/1.9.4/StructureDefinition-IdentidadDeGenero.html\">Identidad De Género</a></td><td colspan=\"3\"><span title=\"Codes:{https://hl7chile.cl/fhir/ig/clcore/CodeSystem/CSIdentidaddeGenero 2}\">Femenina</span></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Pueblos Afrodescendiente\"><a href=\"https://interoperabilidad.minsal.cl/fhir/ig/nid/0.4.7/StructureDefinition-PueblosAfrodescendiente.html\">Pueblos Afrodescendiente</a></td><td colspan=\"3\">false</td></tr></table></div>"
        },
        "extension" : [
          {
            "url" : "https://hl7chile.cl/fhir/ig/clcore/StructureDefinition/IdentidadDeGenero",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://hl7chile.cl/fhir/ig/clcore/CodeSystem/CSIdentidaddeGenero",
                  "code" : "2",
                  "display" : "Femenina"
                }
              ]
            }
          },
          {
            "url" : "https://hl7chile.cl/fhir/ig/clcore/StructureDefinition/SexoBiologico",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/administrative-gender",
                  "code" : "female",
                  "display" : "Female"
                }
              ],
              "text" : "Femenina"
            }
          },
          {
            "url" : "https://hl7chile.cl/fhir/ig/clcore/StructureDefinition/CodigoPaises",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://hl7chile.cl/fhir/ig/clcore/CodeSystem/CodPais",
                  "code" : "152",
                  "display" : "Chile"
                }
              ]
            }
          },
          {
            "url" : "https://interoperabilidad.minsal.cl/fhir/ig/nid/StructureDefinition/PaisOrigenMPI",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://hl7chile.cl/fhir/ig/clcore/CodeSystem/CodPais",
                  "code" : "858",
                  "display" : "Uruguay"
                }
              ]
            }
          },
          {
            "url" : "https://interoperabilidad.minsal.cl/fhir/ig/nid/StructureDefinition/Religion",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://interoperabilidad.minsal.cl/fhir/ig/nid/CodeSystem/CSReligion",
                  "code" : "9",
                  "display" : "Ninguna, ateo, agnóstico"
                }
              ]
            }
          },
          {
            "url" : "https://interoperabilidad.minsal.cl/fhir/ig/nid/StructureDefinition/PueblosAfrodescendiente",
            "valueBoolean" : false
          },
          {
            "extension" : [
              {
                "url" : "pertenece",
                "valueBoolean" : false
              }
            ],
            "url" : "https://interoperabilidad.minsal.cl/fhir/ig/nid/StructureDefinition/PueblosOriginariosMPI"
          }
        ],
        "identifier" : [
          {
            "use" : "official",
            "type" : {
              "extension" : [
                {
                  "url" : "https://hl7chile.cl/fhir/ig/clcore/StructureDefinition/CodigoPaises",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://hl7chile.cl/fhir/ig/clcore/CodeSystem/CodPais",
                        "code" : "152",
                        "display" : "Chile"
                      }
                    ]
                  }
                }
              ],
              "coding" : [
                {
                  "system" : "https://hl7chile.cl/fhir/ig/clcore/CodeSystem/CSTipoIdentificador",
                  "code" : "01",
                  "display" : "RUN"
                }
              ]
            },
            "system" : "urn:oid:2.16.840.1.113883.2.22.1.152.787300",
            "value" : "16182522-0"
          },
          {
            "use" : "official",
            "type" : {
              "extension" : [
                {
                  "url" : "https://hl7chile.cl/fhir/ig/clcore/StructureDefinition/CodigoPaises",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://hl7chile.cl/fhir/ig/clcore/CodeSystem/CodPais",
                        "code" : "152",
                        "display" : "Chile"
                      }
                    ]
                  }
                }
              ],
              "coding" : [
                {
                  "system" : "https://hl7chile.cl/fhir/ig/clcore/CodeSystem/CSTipoIdentificador",
                  "code" : "05",
                  "display" : "PPN"
                }
              ]
            },
            "system" : "urn:oid:2.16.840.1.113883.2.22.0.2.102100.50.10",
            "value" : "ACL123456789876"
          }
        ],
        "active" : true,
        "name" : [
          {
            "use" : "official",
            "family" : "Castilla",
            "_family" : {
              "extension" : [
                {
                  "url" : "https://hl7chile.cl/fhir/ig/clcore/StructureDefinition/SegundoApellido",
                  "valueString" : "Muñoz"
                }
              ]
            },
            "given" : ["Javiera"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+56912387678",
            "use" : "mobile"
          }
        ],
        "gender" : "female",
        "birthDate" : "1995-12-12",
        "deceasedBoolean" : false,
        "address" : [
          {
            "extension" : [
              {
                "extension" : [
                  {
                    "url" : "latitude",
                    "valueDecimal" : -33.4265
                  },
                  {
                    "url" : "longitude",
                    "valueDecimal" : -70.56652
                  }
                ],
                "url" : "http://hl7.org/fhir/StructureDefinition/geolocation"
              },
              {
                "url" : "https://interoperabilidad.minsal.cl/fhir/ig/nid/StructureDefinition/SituacionCalle",
                "valueBoolean" : false
              }
            ],
            "use" : "home",
            "line" : ["Avenida Las Torres 3456, Departamento 702"],
            "_city" : {
              "extension" : [
                {
                  "url" : "https://hl7chile.cl/fhir/ig/clcore/StructureDefinition/ComunasCl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://hl7chile.cl/fhir/ig/clcore/CodeSystem/CSCodComunasCL",
                        "code" : "13118",
                        "display" : "Macul"
                      }
                    ]
                  }
                }
              ]
            },
            "_district" : {
              "extension" : [
                {
                  "url" : "https://hl7chile.cl/fhir/ig/clcore/StructureDefinition/ProvinciasCl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://hl7chile.cl/fhir/ig/clcore/CodeSystem/CSCodProvinciasCL",
                        "code" : "131",
                        "display" : "Santiago"
                      }
                    ]
                  }
                }
              ]
            },
            "_state" : {
              "extension" : [
                {
                  "url" : "https://hl7chile.cl/fhir/ig/clcore/StructureDefinition/RegionesCl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://hl7chile.cl/fhir/ig/clcore/CodeSystem/CSCodRegionCL",
                        "code" : "13",
                        "display" : "Metropolitana de Santiago"
                      }
                    ]
                  }
                }
              ]
            },
            "_country" : {
              "extension" : [
                {
                  "url" : "https://hl7chile.cl/fhir/ig/clcore/StructureDefinition/CodigoPaises",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://hl7chile.cl/fhir/ig/clcore/CodeSystem/CodPais",
                        "code" : "152",
                        "display" : "Chile"
                      }
                    ]
                  }
                }
              ]
            }
          }
        ],
        "maritalStatus" : {
          "coding" : [
            {
              "system" : "https://interoperabilidad.minsal.cl/fhir/ig/nid/CodeSystem/CSEstadoCivil",
              "code" : "01",
              "display" : "Soltero(a)"
            }
          ]
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Patient",
        "ifNoneExist" : "Patient?identifier=16182522-0"
      }
    },
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/PractitionerRole/ProfesionalHospital",
      "resource" : {
        "resourceType" : "PractitionerRole",
        "id" : "ProfesionalHospital",
        "meta" : {
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-rol-profesional-minsal"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"PractitionerRole_ProfesionalHospital\"> </a><p class=\"res-header-id\"><b>Generated Narrative: PractitionerRole ProfesionalHospital</b></p><a name=\"ProfesionalHospital\"> </a><a name=\"hcProfesionalHospital\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-r2bo-rol-profesional-minsal.html\">Perfil de Rol Profesional</a></p></div><p><b>practitioner</b>: <a href=\"Practitioner-profesional-hospital-collector.html\">Practitioner Juan Perez </a></p><p><b>organization</b>: <a href=\"Organization-hospital-collector.html\">Organization Hospital Dr. Hernán Henríquez Aravena (Temuco)</a></p><p><b>code</b>: <span title=\"Codes:{https://interoperabilidad.minsal.cl/fhir/ig/nid/CodeSystem/CSTituloProfesional 1}\">MÉDICO CIRUJANO</span></p><p><b>location</b>: <a href=\"Location-r2bo-localizacion-MedicinaGeneral.html\">Location Medicina General</a></p></div>"
        },
        "practitioner" : {
          "reference" : "Practitioner/profesional-hospital-collector"
        },
        "organization" : {
          "reference" : "Organization/hospital-collector"
        },
        "code" : [
          {
            "coding" : [
              {
                "system" : "https://interoperabilidad.minsal.cl/fhir/ig/nid/CodeSystem/CSTituloProfesional",
                "code" : "1",
                "display" : "MÉDICO CIRUJANO"
              }
            ]
          }
        ],
        "location" : [
          {
            "reference" : "Location/r2bo-localizacion-MedicinaGeneral"
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "PractitionerRole",
        "ifNoneExist" : "PractitionerRole?practitioner.identifier=5135329-3&organization.identifier=121109"
      }
    },
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/PractitionerRole/r2bo-anatopatologo-hospital",
      "resource" : {
        "resourceType" : "PractitionerRole",
        "id" : "r2bo-anatopatologo-hospital",
        "meta" : {
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-rol-profesional-minsal"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"PractitionerRole_r2bo-anatopatologo-hospital\"> </a><p class=\"res-header-id\"><b>Generated Narrative: PractitionerRole r2bo-anatopatologo-hospital</b></p><a name=\"r2bo-anatopatologo-hospital\"> </a><a name=\"hcr2bo-anatopatologo-hospital\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-r2bo-rol-profesional-minsal.html\">Perfil de Rol Profesional</a></p></div><p><b>practitioner</b>: <a href=\"Practitioner-profesional-hospital-anatopatologo.html\">Practitioner Patricia Gutierrez </a></p><p><b>organization</b>: <a href=\"Organization-hospital-collector.html\">Organization Hospital Dr. Hernán Henríquez Aravena (Temuco)</a></p><p><b>code</b>: <span title=\"Codes:{https://interoperabilidad.minsal.cl/fhir/ig/nid/CodeSystem/CSTituloProfesional 1}\">MÉDICO CIRUJANO</span></p><p><b>specialty</b>: <span title=\"Codes:{https://interoperabilidad.minsal.cl/fhir/ig/nid/CodeSystem/CSEspecialidadMed 1}\">ANATOMÍA PATOLÓGICA</span></p></div>"
        },
        "practitioner" : {
          "reference" : "Practitioner/profesional-hospital-anatopatologo"
        },
        "organization" : {
          "reference" : "Organization/hospital-collector"
        },
        "code" : [
          {
            "coding" : [
              {
                "system" : "https://interoperabilidad.minsal.cl/fhir/ig/nid/CodeSystem/CSTituloProfesional",
                "code" : "1",
                "display" : "MÉDICO CIRUJANO"
              }
            ]
          }
        ],
        "specialty" : [
          {
            "coding" : [
              {
                "system" : "https://interoperabilidad.minsal.cl/fhir/ig/nid/CodeSystem/CSEspecialidadMed",
                "code" : "1",
                "display" : "ANATOMÍA PATOLÓGICA"
              }
            ]
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "PractitionerRole",
        "ifNoneExist" : "PractitionerRole?practitioner.identifier=19283789-2&organization.identifier=121109"
      }
    },
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Location/r2bo-localizacion-MedicinaGeneral",
      "resource" : {
        "resourceType" : "Location",
        "id" : "r2bo-localizacion-MedicinaGeneral",
        "meta" : {
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-servicio-solicitante"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Location_r2bo-localizacion-MedicinaGeneral\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Location r2bo-localizacion-MedicinaGeneral</b></p><a name=\"r2bo-localizacion-MedicinaGeneral\"> </a><a name=\"hcr2bo-localizacion-MedicinaGeneral\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-r2bo-servicio-solicitante.html\">Servicio Solicitante del Informe</a></p></div><p><b>name</b>: Medicina General</p></div>"
        },
        "name" : "Medicina General"
      },
      "request" : {
        "method" : "POST",
        "url" : "Location",
        "ifNoneExist" : "Location?name=Medicina General"
      }
    },
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Practitioner/profesional-hospital-collector",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "profesional-hospital-collector",
        "meta" : {
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/nid/StructureDefinition/MINSALPrestadorProfesional"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_profesional-hospital-collector\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner profesional-hospital-collector</b></p><a name=\"profesional-hospital-collector\"> </a><a name=\"hcprofesional-hospital-collector\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://interoperabilidad.minsal.cl/fhir/ig/nid/0.4.7/StructureDefinition-MINSALPrestadorProfesional.html\">Prestador Profesional</a></p></div><p><b>identifier</b>: RUN/5135329-3 (use: official, )</p><p><b>name</b>: Juan Perez </p><p><b>birthDate</b>: 1991-05-18</p><h3>Qualifications</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Identifier</b></td><td><b>Code</b></td></tr><tr><td style=\"display: none\">*</td><td>cert</td><td><span title=\"Codes:{https://interoperabilidad.minsal.cl/fhir/ig/nid/CodeSystem/CSTituloProfesional 1}\">MÉDICO CIRUJANO</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "type" : {
              "coding" : [
                {
                  "system" : "https://hl7chile.cl/fhir/ig/clcore/CodeSystem/CSTipoIdentificador",
                  "code" : "01",
                  "display" : "RUN"
                }
              ]
            },
            "value" : "5135329-3"
          }
        ],
        "name" : [
          {
            "family" : "Perez",
            "_family" : {
              "extension" : [
                {
                  "url" : "https://hl7chile.cl/fhir/ig/clcore/StructureDefinition/SegundoApellido",
                  "valueString" : "Perez"
                }
              ]
            },
            "given" : ["Juan"]
          }
        ],
        "birthDate" : "1991-05-18",
        "qualification" : [
          {
            "identifier" : [
              {
                "value" : "cert"
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "https://interoperabilidad.minsal.cl/fhir/ig/nid/CodeSystem/CSTituloProfesional",
                  "code" : "1",
                  "display" : "MÉDICO CIRUJANO"
                }
              ],
              "text" : "MÉDICO CIRUJANO"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Practitioner",
        "ifNoneExist" : "Practitioner?identifier=5135329-3"
      }
    },
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Practitioner/profesional-hospital-anatopatologo",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "profesional-hospital-anatopatologo",
        "meta" : {
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/nid/StructureDefinition/MINSALPrestadorProfesional"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_profesional-hospital-anatopatologo\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner profesional-hospital-anatopatologo</b></p><a name=\"profesional-hospital-anatopatologo\"> </a><a name=\"hcprofesional-hospital-anatopatologo\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://interoperabilidad.minsal.cl/fhir/ig/nid/0.4.7/StructureDefinition-MINSALPrestadorProfesional.html\">Prestador Profesional</a></p></div><p><b>identifier</b>: RUN/19283789-2 (use: official, )</p><p><b>name</b>: Patricia Gutierrez </p><p><b>gender</b>: Female</p><p><b>birthDate</b>: 1983-11-18</p><blockquote><p><b>qualification</b></p><p><b>identifier</b>: cert</p><p><b>code</b>: <span title=\"Codes:{https://interoperabilidad.minsal.cl/fhir/ig/nid/CodeSystem/CSTituloProfesional 1}\">MÉDICO CIRUJANO</span></p></blockquote><blockquote><p><b>qualification</b></p><p><b>identifier</b>: esp</p><p><b>code</b>: <span title=\"Codes:{https://interoperabilidad.minsal.cl/fhir/ig/nid/CodeSystem/CSEspecialidadMed 30}\">MEDICINA INTERNA</span></p></blockquote><blockquote><p><b>qualification</b></p><p><b>identifier</b>: subesp</p><p><b>code</b>: <span title=\"Codes:{https://interoperabilidad.minsal.cl/fhir/ig/nid/CodeSystem/CSEspecialidadMed 1}\">ANATOMÍA PATOLÓGICA</span></p></blockquote></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "type" : {
              "coding" : [
                {
                  "system" : "https://hl7chile.cl/fhir/ig/clcore/CodeSystem/CSTipoIdentificador",
                  "code" : "01",
                  "display" : "RUN"
                }
              ]
            },
            "value" : "19283789-2"
          }
        ],
        "name" : [
          {
            "family" : "Gutierrez",
            "given" : ["Patricia"]
          }
        ],
        "gender" : "female",
        "birthDate" : "1983-11-18",
        "qualification" : [
          {
            "identifier" : [
              {
                "value" : "cert"
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "https://interoperabilidad.minsal.cl/fhir/ig/nid/CodeSystem/CSTituloProfesional",
                  "code" : "1",
                  "display" : "MÉDICO CIRUJANO"
                }
              ],
              "text" : "MÉDICO CIRUJANO"
            }
          },
          {
            "identifier" : [
              {
                "value" : "esp"
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "https://interoperabilidad.minsal.cl/fhir/ig/nid/CodeSystem/CSEspecialidadMed",
                  "code" : "30",
                  "display" : "MEDICINA INTERNA"
                }
              ],
              "text" : "MEDICINA INTERNA"
            }
          },
          {
            "identifier" : [
              {
                "value" : "subesp"
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "https://interoperabilidad.minsal.cl/fhir/ig/nid/CodeSystem/CSEspecialidadMed",
                  "code" : "1",
                  "display" : "ANATOMÍA PATOLÓGICA"
                }
              ],
              "text" : "ANATOMÍA PATOLÓGICA"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Practitioner",
        "ifNoneExist" : "Practitioner?identifier=19283789-2"
      }
    },
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Organization/hospital-collector",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "hospital-collector",
        "meta" : {
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/nid/StructureDefinition/MINSALPrestadorOrganizacional"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_hospital-collector\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization hospital-collector</b></p><a name=\"hospital-collector\"> </a><a name=\"hchospital-collector\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://interoperabilidad.minsal.cl/fhir/ig/nid/0.4.7/StructureDefinition-MINSALPrestadorOrganizacional.html\">Prestador Institucional</a></p></div><p><b>identifier</b>: 121109</p><p><b>name</b>: Hospital Dr. Hernán Henríquez Aravena (Temuco)</p></div>"
        },
        "identifier" : [
          {
            "value" : "121109"
          }
        ],
        "name" : "Hospital Dr. Hernán Henríquez Aravena (Temuco)"
      },
      "request" : {
        "method" : "POST",
        "url" : "Organization",
        "ifNoneExist" : "Organization?identifier=121109"
      }
    },
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Specimen/r2bo-specimen-example",
      "resource" : {
        "resourceType" : "Specimen",
        "id" : "r2bo-specimen-example",
        "meta" : {
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-muestra-biopsia"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Specimen_r2bo-specimen-example\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Specimen r2bo-specimen-example</b></p><a name=\"r2bo-specimen-example\"> </a><a name=\"hcr2bo-specimen-example\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-r2bo-muestra-biopsia.html\">Perfil de Muestra</a></p></div><p><b>identifier</b>: 110101101</p><p><b>status</b>: Available</p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0487 TISS}\">Tissue</span></p><p><b>subject</b>: <a href=\"Patient-paciente-requiere-examen.html\">Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))</a></p><p><b>receivedTime</b>: 2021-06-01 00:00:00+0000</p><h3>Collections</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Collector</b></td><td><b>Collected[x]</b></td><td><b>Method</b></td><td><b>BodySite</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"PractitionerRole-ProfesionalHospital.html\">PractitionerRole MÉDICO CIRUJANO</a></td><td>2021-06-01 10:00:00+0000</td><td><span title=\"Codes:{http://snomed.info/sct 122548005}\">Biopsy of breast</span></td><td><span title=\"Codes:{http://snomed.info/sct 76752008}\">Structure of breast</span></td></tr></table><p><b>note</b>: </p><blockquote><div><p>Resección completa de tejido mamario, posible carcinoma</p>\n</div></blockquote></div>"
        },
        "identifier" : [
          {
            "value" : "110101101"
          }
        ],
        "status" : "available",
        "type" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0487",
              "code" : "TISS",
              "display" : "Tissue"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/paciente-requiere-examen"
        },
        "receivedTime" : "2021-06-01T00:00:00Z",
        "collection" : {
          "collector" : {
            "reference" : "PractitionerRole/ProfesionalHospital"
          },
          "collectedDateTime" : "2021-06-01T10:00:00Z",
          "method" : {
            "extension" : [
              {
                "url" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-extension-tipo-procedimientos-biopsias",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://snomed.info/sct",
                      "code" : "8889005"
                    }
                  ]
                }
              }
            ],
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "122548005"
              }
            ]
          },
          "bodySite" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-laterality-qualifier",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://snomed.info/sct",
                      "code" : "7771000"
                    }
                  ]
                }
              }
            ],
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "76752008"
              }
            ]
          }
        },
        "note" : [
          {
            "text" : "Resección completa de tejido mamario, posible carcinoma"
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "Specimen?identifier=110101101"
      }
    },
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Composition/r2bo-documento-biopsia-ex",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "r2bo-documento-biopsia-ex",
        "meta" : {
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-composition-biopsia"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Composition_r2bo-documento-biopsia-ex\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Composition r2bo-documento-biopsia-ex</b></p><a name=\"r2bo-documento-biopsia-ex\"> </a><a name=\"hcr2bo-documento-biopsia-ex\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-r2bo-composition-biopsia.html\">Perfil del Documento de Biopsía</a></p></div><p><b>Extensión De Referencia al Reporte</b>: <a href=\"DiagnosticReport-r2bo-informe-biopsia-ex.html\">Diagnostic Report for 'Breast Pathology biopsy report' for '-&gt;Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))'</a></p><p><b>identifier</b>: r2bo-2020-0001</p><p><b>status</b>: Final</p><p><b>type</b>: <span title=\"Codes:{http://loinc.org 66110-8}\">Informe de Biopsia de Mama</span></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 PAT}\">Pathology (gross &amp; histopath, not surgical)</span></p><p><b>date</b>: 2021-08-01 10:00:00-0400</p><p><b>author</b>: <a href=\"PractitionerRole-r2bo-anatopatologo-hospital.html\">PractitionerRole MÉDICO CIRUJANO</a></p><p><b>title</b>: Informe de Biopsia de Mama</p></div>"
        },
        "extension" : [
          {
            "url" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-extension-referencia-diagnosticReport",
            "valueReference" : {
              "reference" : "DiagnosticReport/r2bo-informe-biopsia-ex"
            }
          }
        ],
        "identifier" : {
          "value" : "r2bo-2020-0001"
        },
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "66110-8"
            }
          ],
          "text" : "Informe de Biopsia de Mama"
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "PAT",
                "display" : "Pathology (gross & histopath, not surgical)"
              }
            ]
          }
        ],
        "subject" : {
          "reference" : "Patient/paciente-requiere-examen"
        },
        "date" : "2021-08-01T10:00:00-04:00",
        "author" : [
          {
            "reference" : "PractitionerRole/r2bo-anatopatologo-hospital"
          }
        ],
        "title" : "Informe de Biopsia de Mama",
        "section" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "22636-5"
                }
              ],
              "text" : "Solicitud de Biopsia"
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Solicitud de Biopsia</div>"
            },
            "entry" : [
              {
                "reference" : "ServiceRequest/r2bo-solicitud-informe-apa-ej"
              }
            ]
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "22633-2"
                }
              ],
              "text" : "Muestra de Biopsia"
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Muestra de Biopsia</div>"
            },
            "entry" : [
              {
                "reference" : "Specimen/r2bo-specimen-example"
              }
            ]
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "22634-0"
                }
              ],
              "text" : "Macroscopia de Biopsia"
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Macroscopia de Biopsia</div>"
            },
            "entry" : [
              {
                "reference" : "Observation/r2bo-observacion-macroscopica-ex"
              }
            ]
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "22635-7"
                }
              ],
              "text" : "Microscopia de Biopsia"
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Microscopia de Biopsia</div>"
            },
            "entry" : [
              {
                "reference" : "Observation/r2bo-observacion-microscopica-ex"
              }
            ]
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "33746-9"
                }
              ],
              "text" : "Hallazgos de Biopsia"
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Hallazgos de Biopsia</div>"
            },
            "entry" : [
              {
                "reference" : "Observation/r2bo-observacion-ganglios-linfaticos-ex"
              },
              {
                "reference" : "Observation/r2bo-observacion-infiltracion-perineural-ex"
              },
              {
                "reference" : "Observation/r2bo-observacion-infiltracion-peritumoral-ex"
              },
              {
                "reference" : "Observation/r2bo-observacion-invasion-linfatica-ex"
              },
              {
                "reference" : "Observation/r2bo-observacion-invasion-vascular-ex"
              },
              {
                "reference" : "Observation/r2bo-observacion-margen-quirurgico-ex"
              },
              {
                "reference" : "Observation/r2bo-observacion-centricidad-ex"
              },
              {
                "reference" : "Observation/r2bo-observacion-multifocalidad-ex"
              },
              {
                "reference" : "Observation/r2bo-observacion-porcentaje-necrosis-ex"
              },
              {
                "reference" : "Observation/r2bo-observacion-post-tratamiento-neoadjuvancia-ex"
              },
              {
                "reference" : "Observation/r2bo-tamano-tumor-ex"
              },
              {
                "reference" : "Observation/r2bo-estadificacion-tnm-ex"
              }
            ]
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "22637-3"
                }
              ],
              "text" : "Conclusiones de Biopsia"
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Conclusiones de Biopsia</div>"
            },
            "entry" : [
              {
                "reference" : "BodyStructure/r2bo-tumor-ex"
              }
            ]
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "22638-1"
                }
              ],
              "text" : "Notas del Informe de Biopsia"
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Notas del Informe de Biopsia:</p><p>Carcinoma ductal infiltrante de mama, grado histológico 2, estadio pT2N2M1, con márgenes quirúrgicos positivos y con evidencia de necrosis tumoral</p></div>"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Composition"
      }
    },
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/DiagnosticReport/r2bo-informe-biopsia-ex",
      "resource" : {
        "resourceType" : "DiagnosticReport",
        "id" : "r2bo-informe-biopsia-ex",
        "meta" : {
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-informe-biopsia"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"DiagnosticReport_r2bo-informe-biopsia-ex\"> </a><p class=\"res-header-id\"><b>Generated Narrative: DiagnosticReport r2bo-informe-biopsia-ex</b></p><a name=\"r2bo-informe-biopsia-ex\"> </a><a name=\"hcr2bo-informe-biopsia-ex\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-r2bo-informe-biopsia.html\">Perfil del Reporte de Anatomía Patológica</a></p></div><h2><span title=\"Codes:{http://loinc.org 66110-8}\">Informe de Biopsia de Mama</span> (<span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 PAT}\">Pathology (gross &amp; histopath, not surgical)</span>) </h2><table class=\"grid\"><tr><td>Subject</td><td>Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))</td></tr><tr><td>Reported</td><td>2021-08-01 10:00:00-0400</td></tr><tr><td>Performer</td><td> <a href=\"PractitionerRole-r2bo-anatopatologo-hospital.html\">PractitionerRole MÉDICO CIRUJANO</a></td></tr><tr><td>Identifier</td><td> r2bo-2020-0001</td></tr></table><p><b>Report Details</b></p><table class=\"grid\"><tr><td><b>Code</b></td><td><b>Value</b></td><td><b>Flags</b></td><td><b>When For</b></td></tr><tr><td><a href=\"Observation-r2bo-observacion-microscopica-ex.html\"><span title=\"Codes:{http://loinc.org 102034-6}\">Pathology report microscopic observation in Specimen</span></a></td><td>Se observa tejido mamario con células epiteliales y estromales, con signos de malignidad con metastasis en ganglios linfáticos</td><td>Final</td><td>2021-06-01 12:00:00-0400</td></tr><tr><td><a href=\"Observation-r2bo-observacion-macroscopica-ex.html\"><span title=\"Codes:{http://loinc.org 74574-5}\">Macroscopic observation [Interpretation] in Specimen Narrative</span></a></td><td>Muestra de biopsia de tejido mamario, de 2x2x1 cm, de color blanco, consistencia firme, bordes irregulares, sin lesiones visibles a simple vista</td><td>Final</td><td>2021-06-01 12:00:00-0400</td></tr><tr><td><a href=\"Observation-r2bo-estadificacion-tnm-ex.html\"><span title=\"Codes:{http://snomed.info/sct 399588009}\">Pathologic TNM stage grouping</span></a></td><td/><td>Final</td><td>2021-06-01 12:00:00-0400</td></tr><tr><td><a href=\"Observation-r2bo-observacion-ganglios-linfaticos-ex.html\"><span title=\"Codes:{http://loinc.org 92831-7}\">Lymph nodes with metastasis [#] in Cancer specimen</span></a></td><td>true</td><td>Final</td><td>2021-06-01 12:00:00-0400</td></tr><tr><td><a href=\"Observation-r2bo-observacion-infiltracion-perineural-ex.html\"><span title=\"Codes:{http://snomed.info/sct 371513001}\">Presence of direct invasion by primary malignant neoplasm to nerve</span></a></td><td><span title=\"Codes:{http://snomed.info/sct 385001000}\">Perineural invasion by tumour not identified</span></td><td>Final</td><td>2021-06-01 12:00:00-0400</td></tr><tr><td><a href=\"Observation-r2bo-observacion-infiltracion-peritumoral-ex.html\"><span title=\"Codes:{http://snomed.info/sct 371509008}\">Status of peritumoral lymphocyte response</span></a></td><td><span title=\"Codes:{http://snomed.info/sct 369762001}\">Marked peritumoral lymphocytic response</span></td><td>Final</td><td>2021-06-01 12:00:00-0400</td></tr><tr><td><a href=\"Observation-r2bo-observacion-invasion-linfatica-ex.html\"><span title=\"Codes:{http://loinc.org 33739-4}\">Lymphatic.small vessel.invasion [Identifier] in Specimen by CAP cancer protocols</span></a></td><td><span title=\"Codes:{http://snomed.info/sct 52101004}\">Present</span></td><td>Final</td><td>2021-06-01 12:00:00-0400</td></tr><tr><td><a href=\"Observation-r2bo-observacion-invasion-vascular-ex.html\"><span title=\"Codes:{http://loinc.org 33740-2}\">Venous.large vessel.invasion [Identifier] in Specimen by CAP cancer protocols</span></a></td><td><span title=\"Codes:{http://snomed.info/sct 52101004}\">Present</span></td><td>Final</td><td>2021-06-01 12:00:00-0400</td></tr><tr><td><a href=\"Observation-r2bo-observacion-margen-quirurgico-ex.html\"><span title=\"Codes:{http://snomed.info/sct 396631001}\">Surgical margin observable</span></a></td><td/><td>Final</td><td>2021-06-01 12:00:00-0400</td></tr><tr><td><a href=\"Observation-r2bo-observacion-centricidad-ex.html\"><span title=\"Codes:{http://loinc.org 42030-7}\">Multiple tumors reported as single primary Cancer</span></a></td><td>true</td><td>Final</td><td>2021-06-01 12:00:00-0400</td></tr><tr><td><a href=\"Observation-r2bo-observacion-multifocalidad-ex.html\"><span title=\"Codes:{http://snomed.info/sct 444696007}\">Status of specimen involvement by multifocal invasion</span></a></td><td>true</td><td>Final</td><td>2021-06-01 12:00:00-0400</td></tr><tr><td><a href=\"Observation-r2bo-observacion-porcentaje-necrosis-ex.html\"><span title=\"Codes:{http://snomed.info/sct 405921002}\">Percentage of tumour involved by necrosis</span></a></td><td>5 %<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code% = 'percent')</span></td><td>Final</td><td>2021-06-01 12:00:00-0400</td></tr><tr><td><a href=\"Observation-r2bo-observacion-post-tratamiento-neoadjuvancia-ex.html\"><span title=\"Codes:{http://loinc.org 84891-1}\">Tumor response to neoadjuvant therapy</span></a></td><td>El tratamiento entregado no ha sido efectivo para reducir el tamaño del tumor, por lo que se recomienda un nuevo tratamiento.</td><td>Final</td><td>2021-06-01 12:00:00-0400</td></tr><tr><td><a href=\"Observation-r2bo-tamano-tumor-ex.html\"><span title=\"Codes:{http://loinc.org 21889-1}\">Size Tumor</span></a></td><td/><td>Final</td><td>2021-06-01 12:00:00-0400</td></tr></table><p>Carcinoma ductal infiltrante de mama, grado histológico 2, estadio pT2N2M1, con márgenes quirúrgicos positivos y con evidencia de necrosis tumoral</p><p><b>Coded Conclusions:</b></p><ul><li><span title=\"Codes:{http://snomed.info/sct 82711006}, {http://terminology.hl7.org/CodeSystem/icd-o-3 8500/3}\">Carcinoma ductal infiltrante</span></li><li><span title=\"Codes:{http://snomed.info/sct 76752008}, {http://terminology.hl7.org/CodeSystem/icd-o-3 C50.9}\">Mama</span></li></ul></div>"
        },
        "extension" : [
          {
            "url" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-extension-referencia-composition",
            "valueReference" : {
              "reference" : "Composition/r2bo-documento-biopsia-ex"
            }
          }
        ],
        "identifier" : [
          {
            "value" : "r2bo-2020-0001"
          }
        ],
        "basedOn" : [
          {
            "reference" : "ServiceRequest/r2bo-solicitud-informe-apa-ej"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "PAT",
                "display" : "Pathology (gross & histopath, not surgical)"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "66110-8"
            }
          ],
          "text" : "Informe de Biopsia de Mama"
        },
        "subject" : {
          "reference" : "Patient/paciente-requiere-examen"
        },
        "issued" : "2021-08-01T10:00:00-04:00",
        "performer" : [
          {
            "reference" : "PractitionerRole/r2bo-anatopatologo-hospital"
          }
        ],
        "specimen" : [
          {
            "reference" : "Specimen/r2bo-specimen-example"
          }
        ],
        "result" : [
          {
            "reference" : "Observation/r2bo-observacion-microscopica-ex"
          },
          {
            "reference" : "Observation/r2bo-observacion-macroscopica-ex"
          },
          {
            "reference" : "Observation/r2bo-estadificacion-tnm-ex"
          },
          {
            "reference" : "Observation/r2bo-observacion-ganglios-linfaticos-ex"
          },
          {
            "reference" : "Observation/r2bo-observacion-infiltracion-perineural-ex"
          },
          {
            "reference" : "Observation/r2bo-observacion-infiltracion-peritumoral-ex"
          },
          {
            "reference" : "Observation/r2bo-observacion-invasion-linfatica-ex"
          },
          {
            "reference" : "Observation/r2bo-observacion-invasion-vascular-ex"
          },
          {
            "reference" : "Observation/r2bo-observacion-margen-quirurgico-ex"
          },
          {
            "reference" : "Observation/r2bo-observacion-centricidad-ex"
          },
          {
            "reference" : "Observation/r2bo-observacion-multifocalidad-ex"
          },
          {
            "reference" : "Observation/r2bo-observacion-porcentaje-necrosis-ex"
          },
          {
            "reference" : "Observation/r2bo-observacion-post-tratamiento-neoadjuvancia-ex"
          },
          {
            "reference" : "Observation/r2bo-tamano-tumor-ex"
          }
        ],
        "conclusion" : "Carcinoma ductal infiltrante de mama, grado histológico 2, estadio pT2N2M1, con márgenes quirúrgicos positivos y con evidencia de necrosis tumoral",
        "conclusionCode" : [
          {
            "id" : "Morfologico",
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "82711006"
              },
              {
                "system" : "http://terminology.hl7.org/CodeSystem/icd-o-3",
                "code" : "8500/3"
              }
            ],
            "text" : "Carcinoma ductal infiltrante"
          },
          {
            "id" : "Topografico",
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "76752008"
              },
              {
                "system" : "http://terminology.hl7.org/CodeSystem/icd-o-3",
                "code" : "C50.9"
              }
            ],
            "text" : "Mama"
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "DiagnosticReport"
      }
    },
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-observacion-microscopica-ex",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "r2bo-observacion-microscopica-ex",
        "meta" : {
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-observacion-microscopica"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_r2bo-observacion-microscopica-ex\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation r2bo-observacion-microscopica-ex</b></p><a name=\"r2bo-observacion-microscopica-ex\"> </a><a name=\"hcr2bo-observacion-microscopica-ex\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-r2bo-observacion-microscopica.html\">Perfil de Observación Microscópica</a></p></div><p><b>basedOn</b>: <a href=\"ServiceRequest-r2bo-solicitud-informe-apa-ej.html\">ServiceRequest Pathologist report</a></p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 102034-6}\">Pathology report microscopic observation in Specimen</span></p><p><b>subject</b>: <a href=\"Patient-paciente-requiere-examen.html\">Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))</a></p><p><b>effective</b>: 2021-06-01 12:00:00-0400</p><p><b>performer</b>: <a href=\"PractitionerRole-r2bo-anatopatologo-hospital.html\">PractitionerRole MÉDICO CIRUJANO</a></p><p><b>value</b>: Se observa tejido mamario con células epiteliales y estromales, con signos de malignidad con metastasis en ganglios linfáticos</p><p><b>specimen</b>: <a href=\"Specimen-r2bo-specimen-example.html\">Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma</a></p></div>"
        },
        "basedOn" : [
          {
            "reference" : "ServiceRequest/r2bo-solicitud-informe-apa-ej"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "102034-6"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/paciente-requiere-examen"
        },
        "effectiveDateTime" : "2021-06-01T12:00:00-04:00",
        "performer" : [
          {
            "reference" : "PractitionerRole/r2bo-anatopatologo-hospital"
          }
        ],
        "valueString" : "Se observa tejido mamario con células epiteliales y estromales, con signos de malignidad con metastasis en ganglios linfáticos",
        "specimen" : {
          "reference" : "Specimen/r2bo-specimen-example"
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/BodyStructure/r2bo-tumor-ex",
      "resource" : {
        "resourceType" : "BodyStructure",
        "id" : "r2bo-tumor-ex",
        "meta" : {
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-tumor"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"BodyStructure_r2bo-tumor-ex\"> </a><p class=\"res-header-id\"><b>Generated Narrative: BodyStructure r2bo-tumor-ex</b></p><a name=\"r2bo-tumor-ex\"> </a><a name=\"hcr2bo-tumor-ex\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-r2bo-tumor.html\">Perfil de la Morfología y Topología del Tumor</a></p></div><p><b>morphology</b>: <span title=\"Codes:{http://snomed.info/sct 82711006}, {http://terminology.hl7.org/CodeSystem/icd-o-3 8500/3}\">Carcinoma ductal infiltrante</span></p><p><b>location</b>: <span title=\"Codes:{http://snomed.info/sct 76752008}, {http://terminology.hl7.org/CodeSystem/icd-o-3 C50.9}\">Mama</span></p><p><b>patient</b>: <a href=\"Patient-paciente-requiere-examen.html\">Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))</a></p></div>"
        },
        "morphology" : {
          "id" : "Morfologico",
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "82711006"
            },
            {
              "system" : "http://terminology.hl7.org/CodeSystem/icd-o-3",
              "code" : "8500/3"
            }
          ],
          "text" : "Carcinoma ductal infiltrante"
        },
        "location" : {
          "id" : "Topografico",
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "76752008"
            },
            {
              "system" : "http://terminology.hl7.org/CodeSystem/icd-o-3",
              "code" : "C50.9"
            }
          ],
          "text" : "Mama"
        },
        "patient" : {
          "reference" : "Patient/paciente-requiere-examen"
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "BodyStructure"
      }
    },
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-observacion-macroscopica-ex",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "r2bo-observacion-macroscopica-ex",
        "meta" : {
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-observacion-macroscopica"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_r2bo-observacion-macroscopica-ex\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation r2bo-observacion-macroscopica-ex</b></p><a name=\"r2bo-observacion-macroscopica-ex\"> </a><a name=\"hcr2bo-observacion-macroscopica-ex\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-r2bo-observacion-macroscopica.html\">Perfil de Observación Macroscópica</a></p></div><p><b>basedOn</b>: <a href=\"ServiceRequest-r2bo-solicitud-informe-apa-ej.html\">ServiceRequest Pathologist report</a></p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 74574-5}\">Macroscopic observation [Interpretation] in Specimen Narrative</span></p><p><b>subject</b>: <a href=\"Patient-paciente-requiere-examen.html\">Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))</a></p><p><b>effective</b>: 2021-06-01 12:00:00-0400</p><p><b>performer</b>: <a href=\"PractitionerRole-r2bo-anatopatologo-hospital.html\">PractitionerRole MÉDICO CIRUJANO</a></p><p><b>value</b>: Muestra de biopsia de tejido mamario, de 2x2x1 cm, de color blanco, consistencia firme, bordes irregulares, sin lesiones visibles a simple vista</p><p><b>specimen</b>: <a href=\"Specimen-r2bo-specimen-example.html\">Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma</a></p></div>"
        },
        "basedOn" : [
          {
            "reference" : "ServiceRequest/r2bo-solicitud-informe-apa-ej"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "74574-5"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/paciente-requiere-examen"
        },
        "effectiveDateTime" : "2021-06-01T12:00:00-04:00",
        "performer" : [
          {
            "reference" : "PractitionerRole/r2bo-anatopatologo-hospital"
          }
        ],
        "valueString" : "Muestra de biopsia de tejido mamario, de 2x2x1 cm, de color blanco, consistencia firme, bordes irregulares, sin lesiones visibles a simple vista",
        "specimen" : {
          "reference" : "Specimen/r2bo-specimen-example"
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-estadificacion-tnm-ex",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "r2bo-estadificacion-tnm-ex",
        "meta" : {
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-estadificacion-tnm"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_r2bo-estadificacion-tnm-ex\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation r2bo-estadificacion-tnm-ex</b></p><a name=\"r2bo-estadificacion-tnm-ex\"> </a><a name=\"hcr2bo-estadificacion-tnm-ex\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-r2bo-estadificacion-tnm.html\">Perfil de Grupo Estadificación TNM</a></p></div><p><b>basedOn</b>: <a href=\"ServiceRequest-r2bo-solicitud-informe-apa-ej.html\">ServiceRequest Pathologist report</a></p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 399588009}\">Pathologic TNM stage grouping</span></p><p><b>subject</b>: <a href=\"Patient-paciente-requiere-examen.html\">Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))</a></p><p><b>effective</b>: 2021-06-01 12:00:00-0400</p><p><b>performer</b>: <a href=\"PractitionerRole-r2bo-anatopatologo-hospital.html\">PractitionerRole MÉDICO CIRUJANO</a></p><p><b>specimen</b>: <a href=\"Specimen-r2bo-specimen-example.html\">Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma</a></p><p><b>hasMember</b>: </p><ul><li><a href=\"Observation-r2bo-tnm-categoria-tumor-primario-ex.html\">Observation pT category</a></li><li><a href=\"Observation-r2bo-tnm-categoria-nodo-regional-ex.html\">Observation pN category</a></li><li><a href=\"Observation-r2bo-tnm-categoria-metastasis-distantel-ex.html\">Observation pM category</a></li></ul></div>"
        },
        "basedOn" : [
          {
            "reference" : "ServiceRequest/r2bo-solicitud-informe-apa-ej"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "399588009"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/paciente-requiere-examen"
        },
        "effectiveDateTime" : "2021-06-01T12:00:00-04:00",
        "performer" : [
          {
            "reference" : "PractitionerRole/r2bo-anatopatologo-hospital"
          }
        ],
        "specimen" : {
          "reference" : "Specimen/r2bo-specimen-example"
        },
        "hasMember" : [
          {
            "reference" : "Observation/r2bo-tnm-categoria-tumor-primario-ex"
          },
          {
            "reference" : "Observation/r2bo-tnm-categoria-nodo-regional-ex"
          },
          {
            "reference" : "Observation/r2bo-tnm-categoria-metastasis-distantel-ex"
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-tnm-categoria-tumor-primario-ex",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "r2bo-tnm-categoria-tumor-primario-ex",
        "meta" : {
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-tnm-categoria-tumor-primario"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_r2bo-tnm-categoria-tumor-primario-ex\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation r2bo-tnm-categoria-tumor-primario-ex</b></p><a name=\"r2bo-tnm-categoria-tumor-primario-ex\"> </a><a name=\"hcr2bo-tnm-categoria-tumor-primario-ex\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-r2bo-tnm-categoria-tumor-primario.html\">Perfil de Categoria TNM Tumor Primario</a></p></div><p><b>basedOn</b>: <a href=\"ServiceRequest-r2bo-solicitud-informe-apa-ej.html\">ServiceRequest Pathologist report</a></p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 384625004}\">pT category</span></p><p><b>subject</b>: <a href=\"Patient-paciente-requiere-examen.html\">Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))</a></p><p><b>effective</b>: 2021-06-01 12:00:00-0400</p><p><b>performer</b>: <a href=\"PractitionerRole-r2bo-anatopatologo-hospital.html\">PractitionerRole MÉDICO CIRUJANO</a></p><p><b>value</b>: <span title=\"Codes:{http://snomed.info/sct 1229852009}\">pT2 (AJCC)</span></p><p><b>specimen</b>: <a href=\"Specimen-r2bo-specimen-example.html\">Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma</a></p></div>"
        },
        "basedOn" : [
          {
            "reference" : "ServiceRequest/r2bo-solicitud-informe-apa-ej"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "384625004"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/paciente-requiere-examen"
        },
        "effectiveDateTime" : "2021-06-01T12:00:00-04:00",
        "performer" : [
          {
            "reference" : "PractitionerRole/r2bo-anatopatologo-hospital"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1229852009"
            }
          ]
        },
        "specimen" : {
          "reference" : "Specimen/r2bo-specimen-example"
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-tnm-categoria-nodo-regional-ex",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "r2bo-tnm-categoria-nodo-regional-ex",
        "meta" : {
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-tnm-categoria-nodo-regional"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_r2bo-tnm-categoria-nodo-regional-ex\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation r2bo-tnm-categoria-nodo-regional-ex</b></p><a name=\"r2bo-tnm-categoria-nodo-regional-ex\"> </a><a name=\"hcr2bo-tnm-categoria-nodo-regional-ex\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-r2bo-tnm-categoria-nodo-regional.html\">Perfil de Categoria TNM Nodos Regional</a></p></div><p><b>basedOn</b>: <a href=\"ServiceRequest-r2bo-solicitud-informe-apa-ej.html\">ServiceRequest Pathologist report</a></p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 371494008}\">pN category</span></p><p><b>subject</b>: <a href=\"Patient-paciente-requiere-examen.html\">Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))</a></p><p><b>effective</b>: 2021-06-01 12:00:00-0400</p><p><b>performer</b>: <a href=\"PractitionerRole-r2bo-anatopatologo-hospital.html\">PractitionerRole MÉDICO CIRUJANO</a></p><p><b>value</b>: <span title=\"Codes:{http://snomed.info/sct 1229957002}\">pN2 (AJCC)</span></p><p><b>specimen</b>: <a href=\"Specimen-r2bo-specimen-example.html\">Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma</a></p></div>"
        },
        "basedOn" : [
          {
            "reference" : "ServiceRequest/r2bo-solicitud-informe-apa-ej"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "371494008"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/paciente-requiere-examen"
        },
        "effectiveDateTime" : "2021-06-01T12:00:00-04:00",
        "performer" : [
          {
            "reference" : "PractitionerRole/r2bo-anatopatologo-hospital"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1229957002"
            }
          ]
        },
        "specimen" : {
          "reference" : "Specimen/r2bo-specimen-example"
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-tnm-categoria-metastasis-distantel-ex",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "r2bo-tnm-categoria-metastasis-distantel-ex",
        "meta" : {
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-tnm-categoria-metastasis-distante"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_r2bo-tnm-categoria-metastasis-distantel-ex\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation r2bo-tnm-categoria-metastasis-distantel-ex</b></p><a name=\"r2bo-tnm-categoria-metastasis-distantel-ex\"> </a><a name=\"hcr2bo-tnm-categoria-metastasis-distantel-ex\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-r2bo-tnm-categoria-metastasis-distante.html\">Perfil de Categoria TNM de Metástasis Distante</a></p></div><p><b>basedOn</b>: <a href=\"ServiceRequest-r2bo-solicitud-informe-apa-ej.html\">ServiceRequest Pathologist report</a></p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 371497001}\">pM category</span></p><p><b>subject</b>: <a href=\"Patient-paciente-requiere-examen.html\">Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))</a></p><p><b>effective</b>: 2021-06-01 12:00:00-0400</p><p><b>performer</b>: <a href=\"PractitionerRole-r2bo-anatopatologo-hospital.html\">PractitionerRole MÉDICO CIRUJANO</a></p><p><b>value</b>: <span title=\"Codes:{http://snomed.info/sct 1229916009}\">pM1 (AJCC)</span></p><p><b>specimen</b>: <a href=\"Specimen-r2bo-specimen-example.html\">Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma</a></p></div>"
        },
        "basedOn" : [
          {
            "reference" : "ServiceRequest/r2bo-solicitud-informe-apa-ej"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "371497001"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/paciente-requiere-examen"
        },
        "effectiveDateTime" : "2021-06-01T12:00:00-04:00",
        "performer" : [
          {
            "reference" : "PractitionerRole/r2bo-anatopatologo-hospital"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1229916009"
            }
          ]
        },
        "specimen" : {
          "reference" : "Specimen/r2bo-specimen-example"
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-observacion-infiltracion-perineural-ex",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "r2bo-observacion-infiltracion-perineural-ex",
        "meta" : {
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-observacion-infiltracion-perineural"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_r2bo-observacion-infiltracion-perineural-ex\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation r2bo-observacion-infiltracion-perineural-ex</b></p><a name=\"r2bo-observacion-infiltracion-perineural-ex\"> </a><a name=\"hcr2bo-observacion-infiltracion-perineural-ex\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-r2bo-observacion-infiltracion-perineural.html\">Perfil de Observación Infiltración Perineural</a></p></div><p><b>basedOn</b>: <a href=\"ServiceRequest-r2bo-solicitud-informe-apa-ej.html\">ServiceRequest Pathologist report</a></p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 371513001}\">Presence of direct invasion by primary malignant neoplasm to nerve</span></p><p><b>subject</b>: <a href=\"Patient-paciente-requiere-examen.html\">Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))</a></p><p><b>effective</b>: 2021-06-01 12:00:00-0400</p><p><b>performer</b>: <a href=\"PractitionerRole-r2bo-anatopatologo-hospital.html\">PractitionerRole MÉDICO CIRUJANO</a></p><p><b>value</b>: <span title=\"Codes:{http://snomed.info/sct 385001000}\">Perineural invasion by tumour not identified</span></p><p><b>specimen</b>: <a href=\"Specimen-r2bo-specimen-example.html\">Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma</a></p></div>"
        },
        "basedOn" : [
          {
            "reference" : "ServiceRequest/r2bo-solicitud-informe-apa-ej"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "371513001"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/paciente-requiere-examen"
        },
        "effectiveDateTime" : "2021-06-01T12:00:00-04:00",
        "performer" : [
          {
            "reference" : "PractitionerRole/r2bo-anatopatologo-hospital"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "385001000"
            }
          ]
        },
        "specimen" : {
          "reference" : "Specimen/r2bo-specimen-example"
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-observacion-ganglios-linfaticos-ex",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "r2bo-observacion-ganglios-linfaticos-ex",
        "meta" : {
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-observacion-ganglios-linfaticos"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_r2bo-observacion-ganglios-linfaticos-ex\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation r2bo-observacion-ganglios-linfaticos-ex</b></p><a name=\"r2bo-observacion-ganglios-linfaticos-ex\"> </a><a name=\"hcr2bo-observacion-ganglios-linfaticos-ex\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-r2bo-observacion-ganglios-linfaticos.html\">Perfil de Observación Ganglios Linfáticos</a></p></div><p><b>basedOn</b>: <a href=\"ServiceRequest-r2bo-solicitud-informe-apa-ej.html\">ServiceRequest Pathologist report</a></p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 92831-7}\">Lymph nodes with metastasis [#] in Cancer specimen</span></p><p><b>subject</b>: <a href=\"Patient-paciente-requiere-examen.html\">Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))</a></p><p><b>effective</b>: 2021-06-01 12:00:00-0400</p><p><b>performer</b>: <a href=\"PractitionerRole-r2bo-anatopatologo-hospital.html\">PractitionerRole MÉDICO CIRUJANO</a></p><p><b>value</b>: true</p><p><b>specimen</b>: <a href=\"Specimen-r2bo-specimen-example.html\">Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma</a></p><h3>Components</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://snomed.info/sct 410680006}\">Number</span></td><td>4</td></tr></table></div>"
        },
        "basedOn" : [
          {
            "reference" : "ServiceRequest/r2bo-solicitud-informe-apa-ej"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "92831-7"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/paciente-requiere-examen"
        },
        "effectiveDateTime" : "2021-06-01T12:00:00-04:00",
        "performer" : [
          {
            "reference" : "PractitionerRole/r2bo-anatopatologo-hospital"
          }
        ],
        "valueBoolean" : true,
        "specimen" : {
          "reference" : "Specimen/r2bo-specimen-example"
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "410680006"
                }
              ]
            },
            "valueInteger" : 4
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-observacion-infiltracion-peritumoral-ex",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "r2bo-observacion-infiltracion-peritumoral-ex",
        "meta" : {
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-observacion-infiltracion-peritumoral"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_r2bo-observacion-infiltracion-peritumoral-ex\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation r2bo-observacion-infiltracion-peritumoral-ex</b></p><a name=\"r2bo-observacion-infiltracion-peritumoral-ex\"> </a><a name=\"hcr2bo-observacion-infiltracion-peritumoral-ex\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-r2bo-observacion-infiltracion-peritumoral.html\">Perfil de Observación Infiltración Peritumoral</a></p></div><p><b>basedOn</b>: <a href=\"ServiceRequest-r2bo-solicitud-informe-apa-ej.html\">ServiceRequest Pathologist report</a></p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 371509008}\">Status of peritumoral lymphocyte response</span></p><p><b>subject</b>: <a href=\"Patient-paciente-requiere-examen.html\">Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))</a></p><p><b>effective</b>: 2021-06-01 12:00:00-0400</p><p><b>performer</b>: <a href=\"PractitionerRole-r2bo-anatopatologo-hospital.html\">PractitionerRole MÉDICO CIRUJANO</a></p><p><b>value</b>: <span title=\"Codes:{http://snomed.info/sct 369762001}\">Marked peritumoral lymphocytic response</span></p><p><b>specimen</b>: <a href=\"Specimen-r2bo-specimen-example.html\">Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma</a></p></div>"
        },
        "basedOn" : [
          {
            "reference" : "ServiceRequest/r2bo-solicitud-informe-apa-ej"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "371509008"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/paciente-requiere-examen"
        },
        "effectiveDateTime" : "2021-06-01T12:00:00-04:00",
        "performer" : [
          {
            "reference" : "PractitionerRole/r2bo-anatopatologo-hospital"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "369762001"
            }
          ]
        },
        "specimen" : {
          "reference" : "Specimen/r2bo-specimen-example"
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-observacion-invasion-linfatica-ex",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "r2bo-observacion-invasion-linfatica-ex",
        "meta" : {
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-observacion-invasion-linfatica"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_r2bo-observacion-invasion-linfatica-ex\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation r2bo-observacion-invasion-linfatica-ex</b></p><a name=\"r2bo-observacion-invasion-linfatica-ex\"> </a><a name=\"hcr2bo-observacion-invasion-linfatica-ex\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-r2bo-observacion-invasion-linfatica.html\">Perfil de Observación Invasión Linfatica</a></p></div><p><b>basedOn</b>: <a href=\"ServiceRequest-r2bo-solicitud-informe-apa-ej.html\">ServiceRequest Pathologist report</a></p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 33739-4}\">Lymphatic.small vessel.invasion [Identifier] in Specimen by CAP cancer protocols</span></p><p><b>subject</b>: <a href=\"Patient-paciente-requiere-examen.html\">Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))</a></p><p><b>effective</b>: 2021-06-01 12:00:00-0400</p><p><b>performer</b>: <a href=\"PractitionerRole-r2bo-anatopatologo-hospital.html\">PractitionerRole MÉDICO CIRUJANO</a></p><p><b>value</b>: <span title=\"Codes:{http://snomed.info/sct 52101004}\">Present</span></p><p><b>specimen</b>: <a href=\"Specimen-r2bo-specimen-example.html\">Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma</a></p></div>"
        },
        "basedOn" : [
          {
            "reference" : "ServiceRequest/r2bo-solicitud-informe-apa-ej"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "33739-4"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/paciente-requiere-examen"
        },
        "effectiveDateTime" : "2021-06-01T12:00:00-04:00",
        "performer" : [
          {
            "reference" : "PractitionerRole/r2bo-anatopatologo-hospital"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "52101004"
            }
          ]
        },
        "specimen" : {
          "reference" : "Specimen/r2bo-specimen-example"
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-observacion-invasion-vascular-ex",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "r2bo-observacion-invasion-vascular-ex",
        "meta" : {
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-observacion-invasion-vascular"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_r2bo-observacion-invasion-vascular-ex\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation r2bo-observacion-invasion-vascular-ex</b></p><a name=\"r2bo-observacion-invasion-vascular-ex\"> </a><a name=\"hcr2bo-observacion-invasion-vascular-ex\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-r2bo-observacion-invasion-vascular.html\">Perfil de Observación Invasión Vascular</a></p></div><p><b>basedOn</b>: <a href=\"ServiceRequest-r2bo-solicitud-informe-apa-ej.html\">ServiceRequest Pathologist report</a></p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 33740-2}\">Venous.large vessel.invasion [Identifier] in Specimen by CAP cancer protocols</span></p><p><b>subject</b>: <a href=\"Patient-paciente-requiere-examen.html\">Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))</a></p><p><b>effective</b>: 2021-06-01 12:00:00-0400</p><p><b>performer</b>: <a href=\"PractitionerRole-r2bo-anatopatologo-hospital.html\">PractitionerRole MÉDICO CIRUJANO</a></p><p><b>value</b>: <span title=\"Codes:{http://snomed.info/sct 52101004}\">Present</span></p><p><b>specimen</b>: <a href=\"Specimen-r2bo-specimen-example.html\">Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma</a></p></div>"
        },
        "basedOn" : [
          {
            "reference" : "ServiceRequest/r2bo-solicitud-informe-apa-ej"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "33740-2"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/paciente-requiere-examen"
        },
        "effectiveDateTime" : "2021-06-01T12:00:00-04:00",
        "performer" : [
          {
            "reference" : "PractitionerRole/r2bo-anatopatologo-hospital"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "52101004"
            }
          ]
        },
        "specimen" : {
          "reference" : "Specimen/r2bo-specimen-example"
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-observacion-margen-quirurgico-ex",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "r2bo-observacion-margen-quirurgico-ex",
        "meta" : {
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-observacion-margen-quirurgico"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_r2bo-observacion-margen-quirurgico-ex\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation r2bo-observacion-margen-quirurgico-ex</b></p><a name=\"r2bo-observacion-margen-quirurgico-ex\"> </a><a name=\"hcr2bo-observacion-margen-quirurgico-ex\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-r2bo-observacion-margen-quirurgico.html\">Perfil de Observación Margen Quirúrgico</a></p></div><p><b>basedOn</b>: <a href=\"ServiceRequest-r2bo-solicitud-informe-apa-ej.html\">ServiceRequest Pathologist report</a></p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 396631001}\">Surgical margin observable</span></p><p><b>subject</b>: <a href=\"Patient-paciente-requiere-examen.html\">Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))</a></p><p><b>effective</b>: 2021-06-01 12:00:00-0400</p><p><b>performer</b>: <a href=\"PractitionerRole-r2bo-anatopatologo-hospital.html\">PractitionerRole MÉDICO CIRUJANO</a></p><p><b>specimen</b>: <a href=\"Specimen-r2bo-specimen-example.html\">Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma</a></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 396324006}\">Surgical margin site involved by tumour</span></p><p><b>value</b>: <span title=\"Codes:{http://snomed.info/sct 10828004}\">Positive</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 33737-8}\">Distance of tumor from closest margin</span></p><p><b>value</b>: 1.5 Millimeter<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemm = 'millimeter')</span></p></blockquote></div>"
        },
        "basedOn" : [
          {
            "reference" : "ServiceRequest/r2bo-solicitud-informe-apa-ej"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "396631001"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/paciente-requiere-examen"
        },
        "effectiveDateTime" : "2021-06-01T12:00:00-04:00",
        "performer" : [
          {
            "reference" : "PractitionerRole/r2bo-anatopatologo-hospital"
          }
        ],
        "specimen" : {
          "reference" : "Specimen/r2bo-specimen-example"
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "396324006"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "10828004"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "33737-8"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 1.5,
              "unit" : "Millimeter",
              "system" : "http://unitsofmeasure.org",
              "code" : "mm"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-observacion-centricidad-ex",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "r2bo-observacion-centricidad-ex",
        "meta" : {
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-observacion-multicentricidad"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_r2bo-observacion-centricidad-ex\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation r2bo-observacion-centricidad-ex</b></p><a name=\"r2bo-observacion-centricidad-ex\"> </a><a name=\"hcr2bo-observacion-centricidad-ex\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-r2bo-observacion-multicentricidad.html\">Perfil de Observación Multicentricidad</a></p></div><p><b>basedOn</b>: <a href=\"ServiceRequest-r2bo-solicitud-informe-apa-ej.html\">ServiceRequest Pathologist report</a></p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 42030-7}\">Multiple tumors reported as single primary Cancer</span></p><p><b>subject</b>: <a href=\"Patient-paciente-requiere-examen.html\">Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))</a></p><p><b>effective</b>: 2021-06-01 12:00:00-0400</p><p><b>performer</b>: <a href=\"PractitionerRole-r2bo-anatopatologo-hospital.html\">PractitionerRole MÉDICO CIRUJANO</a></p><p><b>value</b>: true</p><p><b>specimen</b>: <a href=\"Specimen-r2bo-specimen-example.html\">Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma</a></p><h3>Components</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://snomed.info/sct 410680006}\">Number</span></td><td>2</td></tr></table></div>"
        },
        "basedOn" : [
          {
            "reference" : "ServiceRequest/r2bo-solicitud-informe-apa-ej"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "42030-7"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/paciente-requiere-examen"
        },
        "effectiveDateTime" : "2021-06-01T12:00:00-04:00",
        "performer" : [
          {
            "reference" : "PractitionerRole/r2bo-anatopatologo-hospital"
          }
        ],
        "valueBoolean" : true,
        "specimen" : {
          "reference" : "Specimen/r2bo-specimen-example"
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "410680006"
                }
              ]
            },
            "valueInteger" : 2
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-observacion-multifocalidad-ex",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "r2bo-observacion-multifocalidad-ex",
        "meta" : {
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-observacion-focalidad"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_r2bo-observacion-multifocalidad-ex\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation r2bo-observacion-multifocalidad-ex</b></p><a name=\"r2bo-observacion-multifocalidad-ex\"> </a><a name=\"hcr2bo-observacion-multifocalidad-ex\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-r2bo-observacion-focalidad.html\">Perfil de Observación Focalidad</a></p></div><p><b>basedOn</b>: <a href=\"ServiceRequest-r2bo-solicitud-informe-apa-ej.html\">ServiceRequest Pathologist report</a></p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 444696007}\">Status of specimen involvement by multifocal invasion</span></p><p><b>subject</b>: <a href=\"Patient-paciente-requiere-examen.html\">Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))</a></p><p><b>effective</b>: 2021-06-01 12:00:00-0400</p><p><b>performer</b>: <a href=\"PractitionerRole-r2bo-anatopatologo-hospital.html\">PractitionerRole MÉDICO CIRUJANO</a></p><p><b>value</b>: true</p><p><b>specimen</b>: <a href=\"Specimen-r2bo-specimen-example.html\">Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma</a></p><h3>Components</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://snomed.info/sct 410680006}\">Number</span></td><td>2</td></tr></table></div>"
        },
        "basedOn" : [
          {
            "reference" : "ServiceRequest/r2bo-solicitud-informe-apa-ej"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "444696007"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/paciente-requiere-examen"
        },
        "effectiveDateTime" : "2021-06-01T12:00:00-04:00",
        "performer" : [
          {
            "reference" : "PractitionerRole/r2bo-anatopatologo-hospital"
          }
        ],
        "valueBoolean" : true,
        "specimen" : {
          "reference" : "Specimen/r2bo-specimen-example"
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "410680006"
                }
              ]
            },
            "valueInteger" : 2
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-observacion-porcentaje-necrosis-ex",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "r2bo-observacion-porcentaje-necrosis-ex",
        "meta" : {
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-observacion-porcentaje-necrosis"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_r2bo-observacion-porcentaje-necrosis-ex\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation r2bo-observacion-porcentaje-necrosis-ex</b></p><a name=\"r2bo-observacion-porcentaje-necrosis-ex\"> </a><a name=\"hcr2bo-observacion-porcentaje-necrosis-ex\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-r2bo-observacion-porcentaje-necrosis.html\">Perfil de Observación Porcentaje Necrosis</a></p></div><p><b>basedOn</b>: <a href=\"ServiceRequest-r2bo-solicitud-informe-apa-ej.html\">ServiceRequest Pathologist report</a></p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 405921002}\">Percentage of tumour involved by necrosis</span></p><p><b>subject</b>: <a href=\"Patient-paciente-requiere-examen.html\">Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))</a></p><p><b>effective</b>: 2021-06-01 12:00:00-0400</p><p><b>performer</b>: <a href=\"PractitionerRole-r2bo-anatopatologo-hospital.html\">PractitionerRole MÉDICO CIRUJANO</a></p><p><b>value</b>: 5 %<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code% = 'percent')</span></p><p><b>specimen</b>: <a href=\"Specimen-r2bo-specimen-example.html\">Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma</a></p></div>"
        },
        "basedOn" : [
          {
            "reference" : "ServiceRequest/r2bo-solicitud-informe-apa-ej"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "405921002"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/paciente-requiere-examen"
        },
        "effectiveDateTime" : "2021-06-01T12:00:00-04:00",
        "performer" : [
          {
            "reference" : "PractitionerRole/r2bo-anatopatologo-hospital"
          }
        ],
        "valueQuantity" : {
          "value" : 5,
          "unit" : "%",
          "system" : "http://unitsofmeasure.org",
          "code" : "%"
        },
        "specimen" : {
          "reference" : "Specimen/r2bo-specimen-example"
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-observacion-post-tratamiento-neoadjuvancia-ex",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "r2bo-observacion-post-tratamiento-neoadjuvancia-ex",
        "meta" : {
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-observacion-post-tratamiento-neoadjuvancia"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_r2bo-observacion-post-tratamiento-neoadjuvancia-ex\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation r2bo-observacion-post-tratamiento-neoadjuvancia-ex</b></p><a name=\"r2bo-observacion-post-tratamiento-neoadjuvancia-ex\"> </a><a name=\"hcr2bo-observacion-post-tratamiento-neoadjuvancia-ex\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-r2bo-observacion-post-tratamiento-neoadjuvancia.html\">Perfil de Observación Evaluación Post Neoadyuvancia</a></p></div><p><b>basedOn</b>: <a href=\"ServiceRequest-r2bo-solicitud-informe-apa-ej.html\">ServiceRequest Pathologist report</a></p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 84891-1}\">Tumor response to neoadjuvant therapy</span></p><p><b>subject</b>: <a href=\"Patient-paciente-requiere-examen.html\">Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))</a></p><p><b>effective</b>: 2021-06-01 12:00:00-0400</p><p><b>performer</b>: <a href=\"PractitionerRole-r2bo-anatopatologo-hospital.html\">PractitionerRole MÉDICO CIRUJANO</a></p><p><b>value</b>: El tratamiento entregado no ha sido efectivo para reducir el tamaño del tumor, por lo que se recomienda un nuevo tratamiento.</p><p><b>specimen</b>: <a href=\"Specimen-r2bo-specimen-example.html\">Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma</a></p></div>"
        },
        "basedOn" : [
          {
            "reference" : "ServiceRequest/r2bo-solicitud-informe-apa-ej"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "84891-1"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/paciente-requiere-examen"
        },
        "effectiveDateTime" : "2021-06-01T12:00:00-04:00",
        "performer" : [
          {
            "reference" : "PractitionerRole/r2bo-anatopatologo-hospital"
          }
        ],
        "valueString" : "El tratamiento entregado no ha sido efectivo para reducir el tamaño del tumor, por lo que se recomienda un nuevo tratamiento.",
        "specimen" : {
          "reference" : "Specimen/r2bo-specimen-example"
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/Observation/r2bo-tamano-tumor-ex",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "r2bo-tamano-tumor-ex",
        "meta" : {
          "profile" : [
            "https://interoperabilidad.minsal.cl/fhir/ig/r2bo/StructureDefinition/r2bo-tamano-tumor"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_r2bo-tamano-tumor-ex\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation r2bo-tamano-tumor-ex</b></p><a name=\"r2bo-tamano-tumor-ex\"> </a><a name=\"hcr2bo-tamano-tumor-ex\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-r2bo-tamano-tumor.html\">Perfil de Tamaño del Tumor</a></p></div><p><b>basedOn</b>: <a href=\"ServiceRequest-r2bo-solicitud-informe-apa-ej.html\">ServiceRequest Pathologist report</a></p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 21889-1}\">Size Tumor</span></p><p><b>subject</b>: <a href=\"Patient-paciente-requiere-examen.html\">Javiera Castilla (official) Female, DoB: 1995-12-12 ( PPN: ACL123456789876 (use: official, ))</a></p><p><b>effective</b>: 2021-06-01 12:00:00-0400</p><p><b>performer</b>: <a href=\"PractitionerRole-r2bo-anatopatologo-hospital.html\">PractitionerRole MÉDICO CIRUJANO</a></p><p><b>specimen</b>: <a href=\"Specimen-r2bo-specimen-example.html\">Specimen: identifier = 110101101; status = available; type = Tissue; receivedTime = 2021-06-01 00:00:00+0000; note = Resección completa de tejido mamario, posible carcinoma</a></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 33728-7}\">Size.maximum dimension in Tumor</span></p><p><b>value</b>: 1.5 cm<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codecm = 'centimeter')</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 33729-5}\">Size additional dimension in Tumor</span></p><p><b>value</b>: 1.2 cm<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codecm = 'centimeter')</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 33729-5}\">Size additional dimension in Tumor</span></p><p><b>value</b>: 0.7 cm<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codecm = 'centimeter')</span></p></blockquote></div>"
        },
        "basedOn" : [
          {
            "reference" : "ServiceRequest/r2bo-solicitud-informe-apa-ej"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "21889-1"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/paciente-requiere-examen"
        },
        "effectiveDateTime" : "2021-06-01T12:00:00-04:00",
        "performer" : [
          {
            "reference" : "PractitionerRole/r2bo-anatopatologo-hospital"
          }
        ],
        "specimen" : {
          "reference" : "Specimen/r2bo-specimen-example"
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "33728-7"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 1.5,
              "unit" : "cm",
              "system" : "http://unitsofmeasure.org",
              "code" : "cm"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "33729-5"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 1.2,
              "unit" : "cm",
              "system" : "http://unitsofmeasure.org",
              "code" : "cm"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "33729-5"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 0.7,
              "unit" : "cm",
              "system" : "http://unitsofmeasure.org",
              "code" : "cm"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    }
  ]
}

```
