# BBTQR - 機器手訓練實作指引 (RoboHand Training Implementation Guide) v0.1.0



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "bbt-questionnaire-response",
  "url" : "https://build.fhir.org/ig/Kimsber/Rehab-IG/StructureDefinition/bbt-questionnaire-response",
  "version" : "0.1.0",
  "name" : "BBTQR",
  "status" : "draft",
  "date" : "2025-11-24T07:10:30+00:00",
  "publisher" : "Kimsber",
  "contact" : [
    {
      "name" : "Kimsber",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/Kimsber"
        }
      ]
    }
  ],
  "description" : "Box and Block Test (BBT) 評估量表問卷回覆",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "QuestionnaireResponse",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/QuestionnaireResponse",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "QuestionnaireResponse.questionnaire",
        "path" : "QuestionnaireResponse.questionnaire",
        "min" : 1,
        "patternCanonical" : "https://build.fhir.org/ig/Kimsber/Rehab-IG/Questionnaire/BBTQuestionnaire",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.status",
        "path" : "QuestionnaireResponse.status",
        "fixedCode" : "completed",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item",
        "path" : "QuestionnaireResponse.item",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "linkId"
            }
          ],
          "rules" : "closed"
        },
        "min" : 2
      },
      {
        "id" : "QuestionnaireResponse.item:left-hand",
        "path" : "QuestionnaireResponse.item",
        "sliceName" : "left-hand",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:left-hand.linkId",
        "path" : "QuestionnaireResponse.item.linkId",
        "fixedString" : "left-hand"
      },
      {
        "id" : "QuestionnaireResponse.item:right-hand",
        "path" : "QuestionnaireResponse.item",
        "sliceName" : "right-hand",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.item:right-hand.linkId",
        "path" : "QuestionnaireResponse.item.linkId",
        "fixedString" : "right-hand"
      }
    ]
  }
}

```
