# Organization - 機器手訓練實作指引 (RoboHand Training Implementation Guide) v0.1.0



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Organization",
  "url" : "https://build.fhir.org/ig/Kimsber/Rehab-IG/StructureDefinition/Organization",
  "version" : "0.1.0",
  "name" : "Organization",
  "title" : "Organization",
  "status" : "draft",
  "date" : "2025-11-24T07:10:30+00:00",
  "publisher" : "Kimsber",
  "contact" : [
    {
      "name" : "Kimsber",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/Kimsber"
        }
      ]
    }
  ],
  "description" : "機構的標準化定義。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization"
      },
      {
        "id" : "Organization.identifier",
        "path" : "Organization.identifier",
        "short" : "機構識別碼",
        "definition" : "跨多個系統中識別此機構的唯一編號。",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Organization.active",
        "path" : "Organization.active",
        "short" : "是否啟用",
        "definition" : "此機構的紀錄是否仍在使用中。",
        "min" : 1
      },
      {
        "id" : "Organization.name",
        "path" : "Organization.name",
        "short" : "機構名稱",
        "definition" : "機構使用的正式名稱。",
        "min" : 1
      },
      {
        "id" : "Organization.address",
        "path" : "Organization.address",
        "short" : "機構地址",
        "definition" : "機構的實體地址，包含縣市、區域、街道等資訊。",
        "min" : 1,
        "max" : "1"
      }
    ]
  }
}

```
