# Goal - 機器手訓練實作指引 (RoboHand Training Implementation Guide) v0.1.0



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Goal",
  "url" : "https://build.fhir.org/ig/Kimsber/Rehab-IG/StructureDefinition/Goal",
  "version" : "0.1.0",
  "name" : "Goal",
  "title" : "Goal",
  "status" : "draft",
  "date" : "2025-11-24T07:10:30+00:00",
  "publisher" : "Kimsber",
  "contact" : [
    {
      "name" : "Kimsber",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/Kimsber"
        }
      ]
    }
  ],
  "description" : "目標的標準化定義。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Goal",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Goal-twcore",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Goal",
        "path" : "Goal"
      },
      {
        "id" : "Goal.lifecycleStatus",
        "path" : "Goal.lifecycleStatus",
        "short" : "目標的狀態",
        "definition" : "反映目標目前所處的狀態，例如提案中、執行中、完成、取消等。"
      },
      {
        "id" : "Goal.category",
        "path" : "Goal.category",
        "short" : "目標類型",
        "definition" : "用於分組或分類目標的代碼，例如治療、飲食、行為等。"
      },
      {
        "id" : "Goal.description",
        "path" : "Goal.description",
        "short" : "目標內容說明",
        "definition" : "一段描述此目標的文字或代碼。"
      },
      {
        "id" : "Goal.subject",
        "path" : "Goal.subject",
        "short" : "目標所屬對象",
        "definition" : "此目標所針對的對象，例如病人或特定團體。"
      }
    ]
  }
}

```
