# Care Plan - 機器手訓練實作指引 (RoboHand Training Implementation Guide) v0.1.0



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CarePlan",
  "url" : "https://build.fhir.org/ig/Kimsber/Rehab-IG/StructureDefinition/CarePlan",
  "version" : "0.1.0",
  "name" : "CarePlan",
  "title" : "Care Plan",
  "status" : "draft",
  "date" : "2025-11-24T07:10:30+00:00",
  "publisher" : "Kimsber",
  "contact" : [
    {
      "name" : "Kimsber",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/Kimsber"
        }
      ]
    }
  ],
  "description" : "照護計畫",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "CarePlan",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CarePlan-twcore",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "CarePlan",
        "path" : "CarePlan"
      },
      {
        "id" : "CarePlan.status",
        "path" : "CarePlan.status",
        "short" : "狀態代碼，表示照護計畫的流轉狀態",
        "definition" : "此欄位表示該照護計畫是否處於啟用、草稿、完成等狀態；必填。"
      },
      {
        "id" : "CarePlan.intent",
        "path" : "CarePlan.intent",
        "short" : "照護計畫的執行意圖 (如提案, 規劃, 指令, 選項)",
        "definition" : "標示這個照護計劃現在是提案、正式計畫、指令還是僅供參考的選項。"
      },
      {
        "id" : "CarePlan.category",
        "path" : "CarePlan.category",
        "definition" : "計畫的類型，例如：營養及飲食指導、惡化徵兆偵測及必要處理等。"
      },
      {
        "id" : "CarePlan.description",
        "path" : "CarePlan.description",
        "short" : "計畫摘要說明",
        "definition" : "本欄位用於簡要描述照護計畫的性質與目標，提供整體計畫的概要說明。"
      },
      {
        "id" : "CarePlan.subject",
        "path" : "CarePlan.subject",
        "definition" : "指向台灣機器手訓練 Patient 資源，用於標記本照護計畫所屬的病患或病患群體。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://build.fhir.org/ig/Kimsber/Rehab-IG/StructureDefinition/Patient"
            ]
          }
        ]
      }
    ]
  }
}

```
