# Fugl-Meyer上肢感覺評估問卷 - 機器手訓練實作指引 (RoboHand Training Implementation Guide) v0.1.0



## Resource Content

```json
{
  "resourceType" : "Questionnaire",
  "id" : "FMAUESensoryQuestionnaireInstance",
  "meta" : {
    "profile" : [
      "https://build.fhir.org/ig/Kimsber/Rehab-IG/StructureDefinition/SPACQuestionnaire"
    ]
  },
  "url" : "https://build.fhir.org/ig/Kimsber/Rehab-IG/Questionnaire/FMAUESensoryQuestionnaireInstance",
  "version" : "0.1.0",
  "name" : "FMAUESensoryQuestionnaire",
  "title" : "Fugl-Meyer上肢感覺評估問卷",
  "status" : "active",
  "subjectType" : ["Patient"],
  "date" : "2025-10-01",
  "publisher" : "Kimsber",
  "contact" : [
    {
      "name" : "Kimsber",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/Kimsber"
        }
      ]
    }
  ],
  "description" : "衛福部Fugl-Meyer上肢感覺評估問卷，總分26分",
  "purpose" : "提供標準化的上肢感覺評估工具，用於中風復健評估",
  "item" : [
    {
      "linkId" : "assessment-phase-fmaue-sensory",
      "text" : "請選擇評估階段",
      "type" : "choice",
      "required" : true,
      "answerOption" : [
        {
          "valueString" : "初評"
        },
        {
          "valueString" : "期中"
        },
        {
          "valueString" : "延展"
        },
        {
          "valueString" : "結案"
        }
      ]
    },
    {
      "linkId" : "assessment-side-fmaue-sensory",
      "text" : "請選擇評估側",
      "type" : "choice",
      "required" : true,
      "answerOption" : [
        {
          "valueCoding" : {
            "system" : "http://snomed.info/sct",
            "code" : "24028007",
            "display" : "Right"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://snomed.info/sct",
            "code" : "7771000",
            "display" : "Left"
          }
        }
      ]
    },
    {
      "linkId" : "A-light-touch",
      "text" : "A.輕觸覺檢測",
      "type" : "group",
      "required" : true,
      "item" : [
        {
          "linkId" : "A-I-upper-arm",
          "text" : "上臂輕觸覺",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            }
          ]
        },
        {
          "linkId" : "A-I-forearm",
          "text" : "前臂輕觸覺",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            }
          ]
        },
        {
          "linkId" : "A-I-hand",
          "text" : "手部輕觸覺",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            }
          ]
        }
      ]
    },
    {
      "linkId" : "B-temperature",
      "text" : "B.溫度覺檢測",
      "type" : "group",
      "required" : true,
      "item" : [
        {
          "linkId" : "B-I-upper-arm",
          "text" : "上臂溫度覺",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            }
          ]
        },
        {
          "linkId" : "B-I-forearm",
          "text" : "前臂溫度覺",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            }
          ]
        },
        {
          "linkId" : "B-I-hand",
          "text" : "手部溫度覺",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            }
          ]
        }
      ]
    },
    {
      "linkId" : "C-tactile-localization",
      "text" : "C.觸覺定位檢測",
      "type" : "group",
      "required" : true,
      "item" : [
        {
          "linkId" : "C-I-upper-arm",
          "text" : "上臂觸覺定位",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            }
          ]
        },
        {
          "linkId" : "C-I-forearm",
          "text" : "前臂觸覺定位",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            }
          ]
        },
        {
          "linkId" : "C-I-hand",
          "text" : "手部觸覺定位",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            }
          ]
        }
      ]
    },
    {
      "linkId" : "D-position-sense",
      "text" : "D.位置覺檢測",
      "type" : "group",
      "required" : true,
      "item" : [
        {
          "linkId" : "D-I-shoulder",
          "text" : "肩關節位置覺",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            }
          ]
        },
        {
          "linkId" : "D-I-elbow",
          "text" : "肘關節位置覺",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            }
          ]
        },
        {
          "linkId" : "D-I-wrist",
          "text" : "腕關節位置覺",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            }
          ]
        },
        {
          "linkId" : "D-I-thumb",
          "text" : "拇指位置覺",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            }
          ]
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
          "valueExpression" : {
            "language" : "text/fhirpath",
            "expression" : "%resource.item.descendants().where(type='choice').answer.valueInteger.sum()"
          }
        },
        {
          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationExtract",
          "valueBoolean" : true
        }
      ],
      "linkId" : "E-total-score-FMAUESensory",
      "text" : "E.FMAUE感覺總分",
      "type" : "integer",
      "readOnly" : true
    }
  ]
}

```
