# Fugl-Meyer上肢動作評估問卷 - 機器手訓練實作指引 (RoboHand Training Implementation Guide) v0.1.0



## Resource Content

```json
{
  "resourceType" : "Questionnaire",
  "id" : "FMAUEMotorQuestionnaireInstance",
  "meta" : {
    "profile" : [
      "https://build.fhir.org/ig/Kimsber/Rehab-IG/StructureDefinition/SPACQuestionnaire"
    ]
  },
  "url" : "https://build.fhir.org/ig/Kimsber/Rehab-IG/Questionnaire/FMAUEMotorQuestionnaireInstance",
  "version" : "0.1.0",
  "name" : "FMAUEMotorQuestionnaire",
  "title" : "Fugl-Meyer上肢動作評估問卷",
  "status" : "active",
  "subjectType" : ["Patient"],
  "date" : "2025-10-01",
  "publisher" : "Kimsber",
  "contact" : [
    {
      "name" : "Kimsber",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/Kimsber"
        }
      ]
    }
  ],
  "description" : "衛福部Fugl-Meyer上肢動作評估問卷，總分66分",
  "purpose" : "提供標準化的上肢動作功能評估工具，用於中風復健評估",
  "item" : [
    {
      "linkId" : "assessment-phase-fmaue-motion",
      "text" : "請選擇評估階段",
      "type" : "choice",
      "required" : true,
      "answerOption" : [
        {
          "valueString" : "初評"
        },
        {
          "valueString" : "期中"
        },
        {
          "valueString" : "延展"
        },
        {
          "valueString" : "結案"
        }
      ]
    },
    {
      "linkId" : "assessment-side-fmaue-motion",
      "text" : "請選擇患側",
      "type" : "choice",
      "required" : true,
      "answerOption" : [
        {
          "valueCoding" : {
            "system" : "http://snomed.info/sct",
            "code" : "24028007",
            "display" : "Right"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://snomed.info/sct",
            "code" : "7771000",
            "display" : "Left"
          }
        }
      ]
    },
    {
      "linkId" : "A-shoulder-elbow-forearm",
      "text" : "A.肩部/肘部/前臂",
      "type" : "group",
      "required" : true,
      "item" : [
        {
          "linkId" : "A-I-FMAUEMotion",
          "text" : "I.反射反應",
          "type" : "group",
          "required" : true,
          "item" : [
            {
              "linkId" : "A-I-a-flexors",
              "text" : "二頭肌或手指屈肌",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 2
                }
              ]
            },
            {
              "linkId" : "A-I-a-extensors",
              "text" : "三頭肌",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 2
                }
              ]
            }
          ]
        },
        {
          "linkId" : "A-II-a-FMAUEMotion",
          "text" : "II.a.屈肌協同動作",
          "type" : "group",
          "required" : true,
          "item" : [
            {
              "linkId" : "A-II-a-shoulder-retraction",
              "text" : "肩部回縮",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 1
                },
                {
                  "valueInteger" : 2
                }
              ]
            },
            {
              "linkId" : "A-II-a-shoulder-elevation",
              "text" : "肩部抬高",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 1
                },
                {
                  "valueInteger" : 2
                }
              ]
            },
            {
              "linkId" : "A-II-a-shoulder-abduction",
              "text" : "肩外展",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 1
                },
                {
                  "valueInteger" : 2
                }
              ]
            },
            {
              "linkId" : "A-II-a-shoulder-outwards-rotation",
              "text" : "肩膀外旋",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 1
                },
                {
                  "valueInteger" : 2
                }
              ]
            },
            {
              "linkId" : "A-II-a-elbow-flexion",
              "text" : "手肘屈曲",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 1
                },
                {
                  "valueInteger" : 2
                }
              ]
            },
            {
              "linkId" : "A-II-a-forearm-supination",
              "text" : "前臂旋後",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 1
                },
                {
                  "valueInteger" : 2
                }
              ]
            }
          ]
        },
        {
          "linkId" : "A-II-b-FMAUEMotion",
          "text" : "II.b.伸肌協同動作",
          "type" : "group",
          "required" : true,
          "item" : [
            {
              "linkId" : "A-II-b-shoulder-add-inward-rotation",
              "text" : "肩部內旋/外旋",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 1
                },
                {
                  "valueInteger" : 2
                }
              ]
            },
            {
              "linkId" : "A-II-b-elbow-extension",
              "text" : "手肘伸展",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 1
                },
                {
                  "valueInteger" : 2
                }
              ]
            },
            {
              "linkId" : "A-II-b-forearm-pronation",
              "text" : "前臂旋前",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 1
                },
                {
                  "valueInteger" : 2
                }
              ]
            }
          ]
        },
        {
          "linkId" : "A-III-FMAUEMotion",
          "text" : "III.部份協同動作（不可代償）",
          "type" : "group",
          "required" : true,
          "item" : [
            {
              "linkId" : "A-III-hand-to-lumbar-spine",
              "text" : "手到腰椎",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 1
                },
                {
                  "valueInteger" : 2
                }
              ]
            },
            {
              "linkId" : "A-III-shoulder-flexion-0-90",
              "text" : "肩部屈曲0° - 90°",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 1
                },
                {
                  "valueInteger" : 2
                }
              ]
            },
            {
              "linkId" : "A-III-elbow-pro-supination",
              "text" : "手肘 90° 前傾/旋後",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 1
                },
                {
                  "valueInteger" : 2
                }
              ]
            }
          ]
        },
        {
          "linkId" : "A-IV-FMAUEMotion",
          "text" : "IV.自主運動",
          "type" : "group",
          "required" : true,
          "item" : [
            {
              "linkId" : "A-IV-shoulder-abduction-0-90",
              "text" : "肩外展 0° - 90°",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 1
                },
                {
                  "valueInteger" : 2
                }
              ]
            },
            {
              "linkId" : "A-IV-shoulder-flexion-90-180",
              "text" : "肩部屈曲90°-180°",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 1
                },
                {
                  "valueInteger" : 2
                }
              ]
            },
            {
              "linkId" : "A-IV-elbow-0-pronation-supination",
              "text" : "手肘 0° 前傾/旋後",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 1
                },
                {
                  "valueInteger" : 2
                }
              ]
            }
          ]
        },
        {
          "linkId" : "A-V-FMAUEMotion",
          "text" : "V.反射強度",
          "type" : "group",
          "required" : true,
          "item" : [
            {
              "linkId" : "A-V-normal-reflex-activity",
              "text" : "正常反射活動（屈肌/伸肌）",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 1
                },
                {
                  "valueInteger" : 2
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "linkId" : "B-wrist-hand",
      "text" : "B.手腕/手部",
      "type" : "group",
      "required" : true,
      "item" : [
        {
          "linkId" : "B-I-FMAUEMotion",
          "text" : "I.手腕穩定度",
          "type" : "group",
          "required" : true,
          "item" : [
            {
              "linkId" : "B-I-elbow-90-wrist-stability",
              "text" : "手肘 90° 腕部穩定性",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 1
                },
                {
                  "valueInteger" : 2
                }
              ]
            },
            {
              "linkId" : "B-I-elbow-90-wrist-flex-extension",
              "text" : "手肘 90° 腕關節屈曲/伸展",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 1
                },
                {
                  "valueInteger" : 2
                }
              ]
            },
            {
              "linkId" : "B-I-elbow-0-wrist-stability",
              "text" : "手肘 0° 腕部穩定性",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 1
                },
                {
                  "valueInteger" : 2
                }
              ]
            },
            {
              "linkId" : "B-I-elbow-0-wrist-flex-extension",
              "text" : "手肘 0° 腕部屈曲/伸展",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 1
                },
                {
                  "valueInteger" : 2
                }
              ]
            },
            {
              "linkId" : "B-I-wrist-circumduction",
              "text" : "腕部旋轉",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 1
                },
                {
                  "valueInteger" : 2
                }
              ]
            }
          ]
        },
        {
          "linkId" : "B-II-FMAUEMotion",
          "text" : "II.手指伸屈",
          "type" : "group",
          "required" : true,
          "item" : [
            {
              "linkId" : "B-II-fingers-mass-flexion",
              "text" : "手指屈曲",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 1
                },
                {
                  "valueInteger" : 2
                }
              ]
            },
            {
              "linkId" : "B-II-fingers-mass-extension",
              "text" : "手指伸展",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 1
                },
                {
                  "valueInteger" : 2
                }
              ]
            }
          ]
        },
        {
          "linkId" : "B-III-FMAUEMotion",
          "text" : "III.抓握功能",
          "type" : "group",
          "required" : true,
          "item" : [
            {
              "linkId" : "B-III-grasp-a",
              "text" : "a. MP 關節伸展，PIP 和 DIP 彎曲；測試抓握力是否抵抗阻力",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 1
                },
                {
                  "valueInteger" : 2
                }
              ]
            },
            {
              "linkId" : "B-III-grasp-b",
              "text" : "b. 指導患者將拇指內收，其他關節在 0° 位置",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 1
                },
                {
                  "valueInteger" : 2
                }
              ]
            },
            {
              "linkId" : "B-III-grasp-c",
              "text" : "c. 食指拇指肚對著，中間插一支鉛筆",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 1
                },
                {
                  "valueInteger" : 2
                }
              ]
            },
            {
              "linkId" : "B-III-grasp-d",
              "text" : "d. 患者用食指和中指的掌側表面互相抵住，抓住一個圓柱形物體（小罐子）。",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 1
                },
                {
                  "valueInteger" : 2
                }
              ]
            },
            {
              "linkId" : "B-III-grasp-e",
              "text" : "e. 球形抓握；病人抓住一個網球",
              "type" : "choice",
              "required" : true,
              "answerOption" : [
                {
                  "valueInteger" : 0
                },
                {
                  "valueInteger" : 1
                },
                {
                  "valueInteger" : 2
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "linkId" : "C-coordination-speed",
      "text" : "C.協調性/速度",
      "type" : "group",
      "required" : true,
      "item" : [
        {
          "linkId" : "C-I-finger-to-nose-tremor",
          "text" : "手指觸碰鼻子：顫抖",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            }
          ]
        },
        {
          "linkId" : "C-I-finger-to-nose-dysmetria",
          "text" : "手指觸鼻：辨距不良",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            }
          ]
        },
        {
          "linkId" : "C-I-finger-to-nose-time",
          "text" : "手指到鼻子：時間",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            }
          ]
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
          "valueExpression" : {
            "language" : "text/fhirpath",
            "expression" : "%resource.item.descendants().where(type='choice').answer.valueInteger.sum()"
          }
        },
        {
          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationExtract",
          "valueBoolean" : true
        }
      ],
      "linkId" : "D-total-score-FMAUEMotion",
      "text" : "D.FMAUE動作總分",
      "type" : "integer",
      "readOnly" : true
    }
  ]
}

```
