# fhir.rehabig#0.1.0: 機器手訓練實作指引 (RoboHand Training Implementation Guide)

## Pages

* [應用說明](index.md)
* [能力聲明](capability.md)
* [邏輯模型](logic.md)
* [安全性](security.md)
* [專門術語](terminology.md)
* [規範文件](regulation.md)
* [結構定義與範例檔下載](download.md)
* [範例](example.md)
* [查詢參數及操作定義](parameter.md)
* [Artifacts Summary](artifacts.md)
* [FHIR Profiles及Extensions](extension.md)

## Resources

### CodeSystems

* [MAS分數代碼系統](CodeSystem-mas-score.md)

### ValueSets

* [洗澡-選項](ValueSet-VSBarthelBathing.md)
* [小便控制-選項](ValueSet-VSBarthelBladder.md)
* [大便控制-選項](ValueSet-VSBarthelBowels.md)
* [穿脫衣服-選項](ValueSet-VSBarthelDressing.md)
* [進食-選項](ValueSet-VSBarthelFeeding.md)
* [個人衛生-選項](ValueSet-VSBarthelGrooming.md)
* [平地行走-選項](ValueSet-VSBarthelMobility.md)
* [上下樓梯-選項](ValueSet-VSBarthelStairs.md)
* [上廁所-選項](ValueSet-VSBarthelToiletUse.md)
* [Barthel Index 總值集](ValueSet-VSBarthelTotal.md)
* [移位-選項](ValueSet-VSBarthelTransfer.md)
* [身體部位與結構對應之Snomed CT 代碼](ValueSet-VSBodyStructure.md)
* [評估側別選項](ValueSet-assessment-side-valueset.md)
* [MAS分數值集](ValueSet-mas-score.md)

### Resource Profiles

* [ARAT上肢功能評估問卷回覆](StructureDefinition-ARATQuestionnaireResponse.md)
* [巴氏量表問卷回覆](StructureDefinition-BarthelQuestionnaireResponse.md)
* [Care Plan](StructureDefinition-CarePlan.md)
* [Encounter](StructureDefinition-Encounter.md)
* [FMAUE動作評估問卷回覆](StructureDefinition-FMAUEMotionQuestionnaireResponse.md)
* [FMAUE感覺評估問卷回覆](StructureDefinition-FMAUESensoryQuestionnaireResponse.md)
* [Goal](StructureDefinition-Goal.md)
* [IADL評估問卷回覆](StructureDefinition-IADLQuestionnaireResponse.md)
* [MAS 量表問卷回覆](StructureDefinition-MASQuestionnaireResponse.md)
* [MMSE QuestionnaireResponse (scored)](StructureDefinition-MMSEQuestionnaireResponse.md)
* [MRCQuestionnaireResponse](StructureDefinition-MRCQuestionnaireResponse.md)
* [Medication Administration](StructureDefinition-MyMedicationAdministration.md)
* [Observation Screening Assessment](StructureDefinition-ObservationScreeningAssessment.md)
* [Organization](StructureDefinition-Organization.md)
* [PACCondition](StructureDefinition-PACCondition.md)
* [Patient](StructureDefinition-Patient.md)
* [Practitioner](StructureDefinition-Practitioner.md)
* [PractitionerRole](StructureDefinition-PractitionerRole.md)
* [PACProcedure](StructureDefinition-Procedure.md)
* [Bundle-評估資料回傳](StructureDefinition-ReponseBundle.md)
* [評估問卷](StructureDefinition-SPACQuestionnaire.md)
* [評估問卷回覆](StructureDefinition-SPACQuestionnaireResponse.md)
* [WMFT上肢功能評估問卷回覆](StructureDefinition-WMFTQuestionnaireResponse.md)
* [BBTQR](StructureDefinition-bbt-questionnaire-response.md)

### CapabilityStatements

* [My FHIR Client Capability Statement](CapabilityStatement-MyFHIRClientCapabilityStatement.md)
* [My FHIR Server Capability Statement](CapabilityStatement-MyFHIRServerCapabilityStatement.md)

### ImplementationGuides

* [機器手訓練實作指引 (RoboHand Training Implementation Guide)](index.md)

### OperationDefinitions

* [Patient Everything Operation](OperationDefinition-PatientEverythingOperation.md)

### Questionnaires

* [ARAT上肢功能評評估問卷](Questionnaire-ARATQuestionnaireInstance.md)
* [BBT評估量表](Questionnaire-BBTQuestionnaire.md)
* [巴氏量表](Questionnaire-BarthelQuestionnaireInstance.md)
* [Fugl-Meyer上肢動作評估問卷](Questionnaire-FMAUEMotorQuestionnaireInstance.md)
* [Fugl-Meyer上肢感覺評估問卷](Questionnaire-FMAUESensoryQuestionnaireInstance.md)
* [IDAL評估問卷](Questionnaire-IDALQuestionnaireInstance.md)
* [MAS評估量表](Questionnaire-MASQuestionnaireInstance.md)
* [MMSE評估量表](Questionnaire-MMSEQuestionnaireInstance.md)
* [MRC 評估量表](Questionnaire-MRCQuestionnaireInstance.md)
* [WMFT上肢功能評評估問卷](Questionnaire-WMFTQuestionnaireInstance.md)

### SearchParameters

* [BundleId](SearchParameter-BundleId.md)
* [BundleIdentifier](SearchParameter-BundleIdentifier.md)
* [CarePlanCategory](SearchParameter-CarePlanCategory.md)
* [CarePlanDate](SearchParameter-CarePlanDate.md)
* [CarePlanPatient](SearchParameter-CarePlanPatient.md)
* [CarePlanStatus](SearchParameter-CarePlanStatus.md)
* [ConditionAbatementdate](SearchParameter-ConditionAbatementdate.md)
* [ConditionClinicalstatus](SearchParameter-ConditionClinicalstatus.md)
* [ConditionCode](SearchParameter-ConditionCode.md)
* [ConditionId](SearchParameter-ConditionId.md)
* [ConditionOnsetdate](SearchParameter-ConditionOnsetdate.md)
* [ConditionSeverity](SearchParameter-ConditionSeverity.md)
* [ConditionSubject](SearchParameter-ConditionSubject.md)
* [EncounterClass](SearchParameter-EncounterClass.md)
* [EncounterDate](SearchParameter-EncounterDate.md)
* [EncounterId](SearchParameter-EncounterId.md)
* [EncounterIdentifier](SearchParameter-EncounterIdentifier.md)
* [EncounterLocation](SearchParameter-EncounterLocation.md)
* [EncounterStatus](SearchParameter-EncounterStatus.md)
* [EncounterSubject](SearchParameter-EncounterSubject.md)
* [GoalDescription](SearchParameter-GoalDescription.md)
* [GoalLifecyclestatus](SearchParameter-GoalLifecyclestatus.md)
* [GoalPatient](SearchParameter-GoalPatient.md)
* [GoalTargetdate](SearchParameter-GoalTargetdate.md)
* [MedicationAdministrationCode](SearchParameter-MedicationAdministrationCode.md)
* [MedicationAdministrationContext](SearchParameter-MedicationAdministrationContext.md)
* [MedicationAdministrationDevice](SearchParameter-MedicationAdministrationDevice.md)
* [MedicationAdministrationEffectivetime](SearchParameter-MedicationAdministrationEffectivetime.md)
* [MedicationAdministrationIdentifier](SearchParameter-MedicationAdministrationIdentifier.md)
* [MedicationAdministrationMedication](SearchParameter-MedicationAdministrationMedication.md)
* [MedicationAdministrationPatient](SearchParameter-MedicationAdministrationPatient.md)
* [MedicationAdministrationPerformer](SearchParameter-MedicationAdministrationPerformer.md)
* [MedicationAdministrationReasongiven](SearchParameter-MedicationAdministrationReasongiven.md)
* [MedicationAdministrationReasonnotgiven](SearchParameter-MedicationAdministrationReasonnotgiven.md)
* [MedicationAdministrationRequest](SearchParameter-MedicationAdministrationRequest.md)
* [MedicationAdministrationStatus](SearchParameter-MedicationAdministrationStatus.md)
* [MedicationAdministrationSubject](SearchParameter-MedicationAdministrationSubject.md)
* [ObservationCategory](SearchParameter-ObservationCategory.md)
* [ObservationCode](SearchParameter-ObservationCode.md)
* [ObservationDate](SearchParameter-ObservationDate.md)
* [ObservationId](SearchParameter-ObservationId.md)
* [ObservationLastupdated](SearchParameter-ObservationLastupdated.md)
* [ObservationPatient](SearchParameter-ObservationPatient.md)
* [ObservationPerformer](SearchParameter-ObservationPerformer.md)
* [ObservationStatus](SearchParameter-ObservationStatus.md)
* [ObservationSubject](SearchParameter-ObservationSubject.md)
* [OrganizationId](SearchParameter-OrganizationId.md)
* [OrganizationIdentifier](SearchParameter-OrganizationIdentifier.md)
* [OrganizationName](SearchParameter-OrganizationName.md)
* [OrganizationType](SearchParameter-OrganizationType.md)
* [PatientBirthdate](SearchParameter-PatientBirthdate.md)
* [PatientGender](SearchParameter-PatientGender.md)
* [PatientId](SearchParameter-PatientId.md)
* [PatientIdentifier](SearchParameter-PatientIdentifier.md)
* [PatientName](SearchParameter-PatientName.md)
* [PractitionerId](SearchParameter-PractitionerId.md)
* [PractitionerIdentifier](SearchParameter-PractitionerIdentifier.md)
* [PractitionerName](SearchParameter-PractitionerName.md)
* [PractitionerRoleId](SearchParameter-PractitionerRoleId.md)
* [PractitionerRoleIdentifier](SearchParameter-PractitionerRoleIdentifier.md)
* [PractitionerRoleSpecialty](SearchParameter-PractitionerRoleSpecialty.md)
* [ProcedureCode](SearchParameter-ProcedureCode.md)
* [ProcedureDate](SearchParameter-ProcedureDate.md)
* [ProcedureId](SearchParameter-ProcedureId.md)
* [ProcedureStatus](SearchParameter-ProcedureStatus.md)
* [ProcedureSubject](SearchParameter-ProcedureSubject.md)
* [QuestionnaireIdentifier](SearchParameter-QuestionnaireIdentifier.md)
* [QuestionnaireLinkID](SearchParameter-QuestionnaireLinkID.md)
* [QuestionnaireResponseAuthored](SearchParameter-QuestionnaireResponseAuthored.md)
* [QuestionnaireResponseId](SearchParameter-QuestionnaireResponseId.md)
* [QuestionnaireResponseLinkID](SearchParameter-QuestionnaireResponseLinkID.md)
* [QuestionnaireResponsePatient](SearchParameter-QuestionnaireResponsePatient.md)
* [QuestionnaireResponseQuestionnaire](SearchParameter-QuestionnaireResponseQuestionnaire.md)
* [QuestionnaireResponseStatus](SearchParameter-QuestionnaireResponseStatus.md)
* [QuestionnaireResponseSubject](SearchParameter-QuestionnaireResponseSubject.md)
* [QuestionnaireTitle](SearchParameter-QuestionnaireTitle.md)

### Examples

* [arat-bundle-001 (Bundle)](Bundle-arat-bundle-001.md)
* [CarePlanExample (CarePlan)](CarePlan-CarePlanExample.md)
* [arat-assessment-encounter-001 (Encounter)](Encounter-arat-assessment-encounter-001.md)
* [GoalExample (Goal)](Goal-GoalExample.md)
* [MyMedicationAdministrationExample (MedicationAdministration)](MedicationAdministration-MyMedicationAdministrationExample.md)
* [PACMedicationAdministrationExample (MedicationAdministration)](MedicationAdministration-PACMedicationAdministrationExample.md)
* [ObservationScreeningAssessmentExample (Observation)](Observation-ObservationScreeningAssessmentExample.md)
* [台灣健康醫院 (Organization)](Organization-OrganizationExample.md)
* [stroke-patient-001 (Patient)](Patient-stroke-patient-001.md)
* [ot-therapist-001 (Practitioner)](Practitioner-ot-therapist-001.md)
* [PractitionerRoleExample (PractitionerRole)](PractitionerRole-PractitionerRoleExample.md)
* [ProcedureExample (Procedure)](Procedure-ProcedureExample.md)
* [BBTExample (QuestionnaireResponse)](QuestionnaireResponse-BBTExample.md)
* [BarthelIndexExample (QuestionnaireResponse)](QuestionnaireResponse-BarthelIndexExample.md)
* [FMAUEMotorQuestionnaireResponseExample (QuestionnaireResponse)](QuestionnaireResponse-FMAUEMotorQuestionnaireResponseExample.md)
* [FMAUESensoryQuestionnaireResponseExample (QuestionnaireResponse)](QuestionnaireResponse-FMAUESensoryQuestionnaireResponseExample.md)
* [IDALQuestionnaireResponseInstance (QuestionnaireResponse)](QuestionnaireResponse-IDALQuestionnaireResponseInstance.md)
* [MASQuestionnaireResponseExample (QuestionnaireResponse)](QuestionnaireResponse-MASQuestionnaireResponseExample.md)
* [MMSEQuestionnaireResponseExample (QuestionnaireResponse)](QuestionnaireResponse-MMSEQuestionnaireResponseExample.md)
* [MRCQuestionnaireResponseExample (QuestionnaireResponse)](QuestionnaireResponse-MRCQuestionnaireResponseExample.md)
* [WMFTQuestionnaireResponseExample (QuestionnaireResponse)](QuestionnaireResponse-WMFTQuestionnaireResponseExample.md)
* [arat-response-example-001 (QuestionnaireResponse)](QuestionnaireResponse-arat-response-example-001.md)
