# PACCondition - 機器手訓練實作指引 (RoboHand Training Implementation Guide) v0.1.0



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PACCondition",
  "url" : "https://build.fhir.org/ig/Kimsber/Rehab-IG/StructureDefinition/PACCondition",
  "version" : "0.1.0",
  "name" : "PACCondition",
  "title" : "PACCondition",
  "status" : "draft",
  "date" : "2025-11-24T07:10:30+00:00",
  "publisher" : "Kimsber",
  "contact" : [
    {
      "name" : "Kimsber",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/Kimsber"
        }
      ]
    }
  ],
  "description" : "進行患者上肢功能評估時的狀況資訊，應包含待評估身體部位或病徵。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Condition",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Condition-twcore",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Condition",
        "path" : "Condition"
      },
      {
        "id" : "Condition.category",
        "path" : "Condition.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
              "code" : "encounter-diagnosis"
            }
          ]
        }
      },
      {
        "id" : "Condition.bodySite",
        "path" : "Condition.bodySite",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "coding.code"
            }
          ],
          "description" : "依據需求填入評估部位或是實際患部/側，至少應填入評估部位",
          "ordered" : true,
          "rules" : "closed"
        },
        "min" : 1
      },
      {
        "id" : "Condition.bodySite:AssessmentSite",
        "path" : "Condition.bodySite",
        "sliceName" : "AssessmentSite",
        "min" : 1,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Condition.bodySite:AffectedPart",
        "path" : "Condition.bodySite",
        "sliceName" : "AffectedPart",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      }
    ]
  }
}

```
