# Encounter - 機器手訓練實作指引 (RoboHand Training Implementation Guide) v0.1.0



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Encounter",
  "url" : "https://build.fhir.org/ig/Kimsber/Rehab-IG/StructureDefinition/Encounter",
  "version" : "0.1.0",
  "name" : "Encounter",
  "title" : "Encounter",
  "status" : "draft",
  "date" : "2025-11-24T07:10:30+00:00",
  "publisher" : "Kimsber",
  "contact" : [
    {
      "name" : "Kimsber",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/Kimsber"
        }
      ]
    }
  ],
  "description" : "就醫事件的標準化定義。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Encounter",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Encounter",
        "path" : "Encounter"
      },
      {
        "id" : "Encounter.status",
        "path" : "Encounter.status",
        "short" : "狀態代碼，表示就醫事件的流轉狀態",
        "definition" : "此欄位表示該就醫事件是否處於啟用、草稿、完成等狀態；必填。"
      },
      {
        "id" : "Encounter.subject",
        "path" : "Encounter.subject",
        "min" : 1
      },
      {
        "id" : "Encounter.period",
        "path" : "Encounter.period",
        "definition" : "就醫的開始和結束時間。如果（尚）不知道，可以省略「期間」裡的結束日期時間。",
        "min" : 1
      }
    ]
  }
}

```
