# ARAT問卷回覆範例 - 機器手訓練實作指引 (RoboHand Training Implementation Guide) v0.1.0



## Resource Content

```json
{
  "resourceType" : "QuestionnaireResponse",
  "id" : "arat-response-example-001",
  "meta" : {
    "profile" : [
      "https://build.fhir.org/ig/Kimsber/Rehab-IG/StructureDefinition/ARATQuestionnaireResponse"
    ]
  },
  "questionnaire" : "https://build.fhir.org/ig/Kimsber/Rehab-IG/Questionnaire/ARATQuestionnaireInstance",
  "status" : "completed",
  "subject" : {
    "reference" : "Patient/stroke-patient-001",
    "display" : "張先生"
  },
  "authored" : "2025-10-11T14:30:00+08:00",
  "author" : {
    "reference" : "Practitioner/ot-therapist-001",
    "display" : "復健治療師 - 李小姐"
  },
  "item" : [
    {
      "linkId" : "assessment-side-arat",
      "text" : "請選擇評估側",
      "answer" : [
        {
          "valueCoding" : {
            "system" : "http://snomed.info/sct",
            "code" : "24028007",
            "display" : "Right"
          }
        }
      ]
    },
    {
      "linkId" : "A-grasp-subscale",
      "text" : "A.抓力分量表",
      "item" : [
        {
          "linkId" : "A-I-block-10cm3",
          "answer" : [
            {
              "valueInteger" : 3
            }
          ]
        },
        {
          "linkId" : "A-I-block-2.5cm3",
          "text" : "方塊積木, 2.5 立方公分",
          "answer" : [
            {
              "valueInteger" : 2
            }
          ]
        },
        {
          "linkId" : "A-I-block-5cm3",
          "text" : "方塊積木, 5 立方公分",
          "answer" : [
            {
              "valueInteger" : 3
            }
          ]
        },
        {
          "linkId" : "A-I-block-7.5cm3",
          "text" : "方塊積木, 7.5 立方公分",
          "answer" : [
            {
              "valueInteger" : 2
            }
          ]
        },
        {
          "linkId" : "A-I-cricket-ball",
          "text" : "板球",
          "answer" : [
            {
              "valueInteger" : 1
            }
          ]
        },
        {
          "linkId" : "A-I-sharpening-stone",
          "text" : "磨刀石",
          "answer" : [
            {
              "valueInteger" : 1
            }
          ]
        },
        {
          "linkId" : "A-grasp-subscale-subscore",
          "text" : "A.抓力分數",
          "answer" : [
            {
              "valueInteger" : 12
            }
          ]
        }
      ]
    },
    {
      "linkId" : "B-grip-subscale",
      "text" : "B.握力分量表",
      "item" : [
        {
          "linkId" : "B-I-pour-water-from-one-glass-to-another",
          "text" : "將水從一個杯子倒到另一個杯子",
          "answer" : [
            {
              "valueInteger" : 2
            }
          ]
        },
        {
          "linkId" : "B-I-displace-2.25-cm-alloy-tube-from-one-side-oftable-to-the-other",
          "text" : "將 2.25 公分合金管從桌子的一側移到另一側",
          "answer" : [
            {
              "valueInteger" : 3
            }
          ]
        },
        {
          "linkId" : "B-I-displace-1-cm-alloy-tube-from-one-side-of-table-to-the-other",
          "text" : "將 1 公分合金管從桌子的一側移到另一側",
          "answer" : [
            {
              "valueInteger" : 2
            }
          ]
        },
        {
          "linkId" : "B-I-put-washer-over-bolt",
          "text" : "將墊圈放在螺栓上",
          "answer" : [
            {
              "valueInteger" : 1
            }
          ]
        },
        {
          "linkId" : "B-grip-subscale-subscore",
          "text" : "B.握力分數",
          "answer" : [
            {
              "valueInteger" : 8
            }
          ]
        }
      ]
    },
    {
      "linkId" : "C-pinch-subscale",
      "text" : "C.捏取分量表",
      "item" : [
        {
          "linkId" : "C-I-ball-bearing-held-between-ring-finger-and-thumb",
          "text" : "滾珠軸承，握在無名指與大拇指之間",
          "answer" : [
            {
              "valueInteger" : 1
            }
          ]
        },
        {
          "linkId" : "C-I-marble-held-between-index-finger-and-thumb",
          "text" : "大理石，握在食指與大拇指之間",
          "answer" : [
            {
              "valueInteger" : 2
            }
          ]
        },
        {
          "linkId" : "C-I-ball-bearing-held-between-middle-finger-and-thumb",
          "text" : "滾珠軸承，握在中指與拇指之間",
          "answer" : [
            {
              "valueInteger" : 2
            }
          ]
        },
        {
          "linkId" : "C-I-ball-bearing-held-between-index-finger-and-thumb",
          "text" : "滾珠軸承，握在食指與拇指之間",
          "answer" : [
            {
              "valueInteger" : 3
            }
          ]
        },
        {
          "linkId" : "C-I-marble-held-between-ring-finger-and-thumb",
          "text" : "大理石，握在無名指和大拇指之間",
          "answer" : [
            {
              "valueInteger" : 1
            }
          ]
        },
        {
          "linkId" : "C-I-marble-held-between-middle-finger-and-thumb",
          "text" : "大理石，握在中指與大拇指之間",
          "answer" : [
            {
              "valueInteger" : 2
            }
          ]
        },
        {
          "linkId" : "C-pinch-subscale-subscore",
          "text" : "C.捏取分數",
          "answer" : [
            {
              "valueInteger" : 11
            }
          ]
        }
      ]
    },
    {
      "linkId" : "D-gross-movement-subscale",
      "text" : "D.粗大動作分量表",
      "item" : [
        {
          "linkId" : "D-I-hand-to-behind-the-head",
          "text" : "手放在腦後",
          "answer" : [
            {
              "valueInteger" : 2
            }
          ]
        },
        {
          "linkId" : "D-I-hand-to-top-of-head",
          "text" : "手放在頭頂",
          "answer" : [
            {
              "valueInteger" : 3
            }
          ]
        },
        {
          "linkId" : "D-I-hand-to-mouth",
          "text" : "手到嘴",
          "answer" : [
            {
              "valueInteger" : 3
            }
          ]
        },
        {
          "linkId" : "D-gross-movement-subscale-subscore",
          "text" : "D.粗大動作分數",
          "answer" : [
            {
              "valueInteger" : 8
            }
          ]
        }
      ]
    },
    {
      "linkId" : "E-total-score-ARAT",
      "text" : "E.ARAT總分計算",
      "answer" : [
        {
          "valueInteger" : 39
        }
      ]
    }
  ]
}

```
