# WMFT上肢功能評估問卷 - 機器手訓練實作指引 (RoboHand Training Implementation Guide) v0.1.0



## Resource Content

```json
{
  "resourceType" : "Questionnaire",
  "id" : "WMFTQuestionnaireInstance",
  "meta" : {
    "profile" : [
      "https://build.fhir.org/ig/Kimsber/Rehab-IG/StructureDefinition/SPACQuestionnaire"
    ]
  },
  "url" : "https://build.fhir.org/ig/Kimsber/Rehab-IG/Questionnaire/WMFTQuestionnaireInstance",
  "version" : "0.1.0",
  "name" : "WMFTQuestionnaire",
  "title" : "WMFT上肢功能評評估問卷",
  "status" : "active",
  "subjectType" : ["Patient"],
  "date" : "2025-11-24T07:10:30+00:00",
  "publisher" : "Kimsber",
  "contact" : [
    {
      "name" : "Kimsber",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/Kimsber"
        }
      ]
    }
  ],
  "description" : "WMFT上肢功能評評估問卷(Wolf et al., 1995; Whitall, Savin, Harris-Love, & Waller, 2006)，分左右邊各75分",
  "purpose" : "提供標準化的上肢感覺評估工具，用於中風復健評估",
  "item" : [
    {
      "linkId" : "assessment-side-wmft",
      "text" : "請選擇評估側",
      "type" : "choice",
      "required" : true,
      "answerOption" : [
        {
          "valueCoding" : {
            "system" : "http://snomed.info/sct",
            "code" : "24028007",
            "display" : "Right"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://snomed.info/sct",
            "code" : "7771000",
            "display" : "Left"
          }
        }
      ]
    },
    {
      "linkId" : "A-timed-joint-segment-movements",
      "text" : "A.定時關節分段動作評估",
      "type" : "group",
      "required" : true,
      "item" : [
        {
          "linkId" : "A-I-forearm-to-table-side",
          "text" : "透過外展肩膀將前臂放在桌子上",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            },
            {
              "valueInteger" : 4
            },
            {
              "valueInteger" : 5
            }
          ]
        },
        {
          "linkId" : "A-I-forearm-to-box-side",
          "text" : "將前臂放在一個 25.4 公分高的箱子上，透過肩部外展",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            },
            {
              "valueInteger" : 4
            },
            {
              "valueInteger" : 5
            }
          ]
        },
        {
          "linkId" : "A-I-extended-elbow-side",
          "text" : "將手肘伸向一側，越過一張 28 公分長的桌子",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            },
            {
              "valueInteger" : 4
            },
            {
              "valueInteger" : 5
            }
          ]
        },
        {
          "linkId" : "A-I-extended-elbow-to-the-side-with-1lb-weight",
          "text" : "透過伸展手肘將重量推向桌子對面的外腕關節",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            },
            {
              "valueInteger" : 4
            },
            {
              "valueInteger" : 5
            }
          ]
        },
        {
          "linkId" : "A-I-hand-to-table-front",
          "text" : "將手放在桌上",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            },
            {
              "valueInteger" : 4
            },
            {
              "valueInteger" : 5
            }
          ]
        },
        {
          "linkId" : "A-I-hand-to-box-front",
          "text" : "將手放在桌面上的盒子上",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            },
            {
              "valueInteger" : 4
            },
            {
              "valueInteger" : 5
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%TimedJointSegmentMovementScore"
              }
            },
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationExtract",
              "valueBoolean" : true
            }
          ],
          "linkId" : "A-timed-joint-segment-movements-subscore",
          "text" : "A.定時關節段運動分量表分數",
          "type" : "integer",
          "readOnly" : true
        }
      ]
    },
    {
      "linkId" : "B-timed-integrative-functional-movements",
      "text" : "B.定時整合功能動作評估",
      "type" : "group",
      "required" : true,
      "item" : [
        {
          "linkId" : "B-I-reach-and-retrieve-front",
          "text" : "透過手肘和彎曲手腕將 1 磅重的物體拉過桌子",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            },
            {
              "valueInteger" : 4
            },
            {
              "valueInteger" : 5
            }
          ]
        },
        {
          "linkId" : "B-I-lift-can-front",
          "text" : "舉起一個罐子，並用圓柱形的抓握方式將其靠近嘴唇",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            },
            {
              "valueInteger" : 4
            },
            {
              "valueInteger" : 5
            }
          ]
        },
        {
          "linkId" : "B-I-lift-pencil-front",
          "text" : "使用三爪卡盤抓握來拿起鉛筆",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            },
            {
              "valueInteger" : 4
            },
            {
              "valueInteger" : 5
            }
          ]
        },
        {
          "linkId" : "B-I-pick-up-paper-clip-front",
          "text" : "用鉗子抓取回形針",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            },
            {
              "valueInteger" : 4
            },
            {
              "valueInteger" : 5
            }
          ]
        },
        {
          "linkId" : "B-I-stack-checkers-front",
          "text" : "將棋子堆疊到中心棋子上",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            },
            {
              "valueInteger" : 4
            },
            {
              "valueInteger" : 5
            }
          ]
        },
        {
          "linkId" : "B-I-flip-3-cards-front",
          "text" : "用鉗子抓握，客戶嘗試翻轉每張卡片",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            },
            {
              "valueInteger" : 4
            },
            {
              "valueInteger" : 5
            }
          ]
        },
        {
          "linkId" : "B-I-turning-the-key-in-lock-front",
          "text" : "使用鉗子抓握並保持接觸，將鑰匙向左和向右旋轉 180 度",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            },
            {
              "valueInteger" : 4
            },
            {
              "valueInteger" : 5
            }
          ]
        },
        {
          "linkId" : "B-I-fold-towel-front",
          "text" : "抓住毛巾，縱向折疊，然後用被測試的手將毛巾再次對折",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            },
            {
              "valueInteger" : 4
            },
            {
              "valueInteger" : 5
            }
          ]
        },
        {
          "linkId" : "B-I-lift-basket-standing",
          "text" : "提起一個椅子上 3 磅重的籃子，並將其放在床頭櫃上",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            },
            {
              "valueInteger" : 4
            },
            {
              "valueInteger" : 5
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%TimedIntegrativeFunctionalMovementScore"
              }
            },
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationExtract",
              "valueBoolean" : true
            }
          ],
          "linkId" : "B-timed-integrative-functional-movements-subscore",
          "text" : "B.定時關節段運動分量表分數",
          "type" : "integer",
          "readOnly" : true
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
          "valueExpression" : {
            "language" : "text/fhirpath",
            "expression" : "%resource.item.descendants().where(type='choice').answer.valueInteger.sum()"
          }
        },
        {
          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationExtract",
          "valueBoolean" : true
        }
      ],
      "linkId" : "C-total-score-WMFT",
      "text" : "C.WMFT總分計算",
      "type" : "integer",
      "required" : true
    }
  ]
}

```
